
#ifdef WX_PRECOMP
#include "wx_pch.h"
#endif

#ifdef __BORLANDC__
#pragma hdrstop
#endif //__BORLANDC__

#include "ENMApp.h"
#include "ENMTaskTray.h"
#include "wx/image.h"
#include "wx/filename.h"

#if defined(__WXMSW__)
#include "Windows.h"
#include <shlwapi.h>
#endif
#include "ENMUtil.h"
#if defined(__WXMSW__)
#include <DCS/DCSApi.h>
#endif
#if defined(__UNIX__)
#include <sdk/DCSApi.h>
#include <X11/Xatom.h>
#include <gdk/gdkx.h>
#endif

#include "FileTar.h"
#include "DataCenter.h"
#include "SchoolSettingImporter.h"
#include "DeployThread.h"
#include <fstream>

#include "NetworkManagerDlg.h"
#include "ProfileManagerDlg.h"
#include "PolicyManager.h"

static wxString dcLogENMApp(_T("C:\\ENMApp.log"));;
bool ENMApp::m_bStartPublishTimer = false;
bool ENMApp::m_bStartBrowseTimer = false;
IMPLEMENT_APP(ENMApp)

const int ENMApp::ID_TIMER_INIT = ::wxNewId();
const int ENMApp::ID_TIMER_EXIT = ::wxNewId();
const int ENMApp::ID_NOTI_TIMER = ::wxNewId();

BEGIN_EVENT_TABLE(ENMApp, wxApp)
    EVT_TIMER(ID_TIMER_INIT, ENMApp::OnTimerInit)
    EVT_TIMER(ID_TIMER_EXIT, ENMApp::OnTimerExit)
    EVT_TIMER(ID_NOTI_TIMER, ENMApp::CloseNotification)
END_EVENT_TABLE()

/**************************************************************************************************
* Function Name : ENMApp                                                                     *
* Description  :                                                                       *
* Date   :                                                                                        *
* Parameter     :                                                                                 *
* Return Code  :                                                                                  *
* Author   :                                                                                      *
**************************************************************************************************/
ENMApp::ENMApp() : wxApp(), m_timerInit(this, ID_TIMER_INIT), m_timerExit(this, ID_TIMER_EXIT)
{
    m_taskBarIcon = NULL;
}

bool ENMApp::OnInit()
{
    wxInitAllImageHandlers();
    m_notificationtimer = NULL;
    m_notificationDlg = NULL;
    m_ifExit = false;
    m_popBalloon = false;
    if ( ENMUtil::IsGuest() )
    {
        return false;
    }

    if ( !GetLock() )
    {
        if ( IsProtocolSupported() )
        {
            ShowMainFrame();
            PopupNotification();
            m_ifExit = true;
            return true;
        }
        else
        {
            system("/usr/share/EasyNetworkManager/restart.sh");
            return false;
        }
    }
    else
    {
        m_popBalloon = true;
    }

    pthread = NULL;
    lthread = NULL;

    m_timerInit.Start(20000, wxTIMER_ONE_SHOT);
    m_timerExit.Start(3000, wxTIMER_CONTINUOUS );


//    sthread = NULL;

    //Start recieve avahi multicast
    ReBrowse();
    StartDeploy("192.168.140.17");

    m_nMeshStatus = MESHSTATUS_MESHCLOSE;

    return true;
}

int ENMApp::OnExit()
{
    if ( m_taskBarIcon != NULL )
    {
        delete m_taskBarIcon;
        m_taskBarIcon = NULL;
    }
    return wxApp::OnExit();
}

bool ENMApp::SetImage(char* image)
{
    wxIcon icon(&image);
    return m_taskBarIcon->SetIcon(icon, _T("Easy Network"));
}

ENMTaskTray* ENMApp::GetENMTaskTray()
{
    return m_taskBarIcon;
}

bool ENMApp::GetLock()
{
#if defined(__UNIX__)
    struct flock fl;
    int fdlock = 0;

    fl.l_type = F_WRLCK;
    fl.l_whence = SEEK_SET;
    fl.l_start = 0;
    fl.l_len = 1;
    string file = ENMUtil::WxStringToString(::wxGetHomeDir()) + "/.enm_lock";
    if( (fdlock = open(file.c_str(), O_WRONLY|O_CREAT, 0666)) == -1 )
        return false;

    return fcntl(fdlock, F_SETLK, &fl) != -1;
#endif
#if defined(__WXMSW__)
    const wxString name = _T("ENMApp-%s") + wxGetUserId();
    m_checker = new wxSingleInstanceChecker(name);
    return !m_checker->IsAnotherRunning();
#endif
}

bool ENMApp::ShowMainFrame()
{
#if defined(__WXMSW__)
    HWND hWnd = FindWindow(NULL, _("Network Manager"));
    if ( hWnd == NULL )
        return false;
    PostMessage(hWnd, WM_ACTIVATE, WA_ACTIVE, 0);
#endif
    return true;
}

void ENMApp::OnTimerInit(wxTimerEvent& event)
{
    if ( !InitializeDCS() )
    {
        ::wxExit();
        return;
    }
#if defined(__WXMSW__)
    DCS_SetAbortHandler(DCSAbortHandler);
#endif

    ENM_InitUserInfo userInfo;
    memcpy(userInfo.userPath.dcsString, ENMUtil::WxStringToString(ENMUtil::GetCurrentUserAppDataFolder()).c_str(), 256);
    DCS_InitUserInfo(userInfo);

#if defined(__UNIX__)
    system("killall nm-applet");
    char appName[256] = { 0 };
    readlink ("/proc/self/exe", appName, 256);
    strAppPath = wxString::FromUTF8(appName);
    strAppPath = strAppPath.SubString(0, strAppPath.Find('/', true));
#endif

#if defined(__WXMSW__)
    ShellExecute(NULL,_T("open"),_T("C:\\WINDOWS\\system32\\cmd.exe"),_T("/c   taskkill /f /im RaUI.exe"),_T(""),SW_HIDE);

//    ENMUtil::StartupWindowsFirewallService();
    TCHAR tszPath[MAX_PATH];
    GetModuleFileName(NULL,tszPath,MAX_PATH);
    PathRemoveFileSpec(tszPath);
    strAppPath = tszPath;
    strAppPath += _T("\\");
#endif

#if defined(__WXMSW__)
    m_locale.AddCatalogLookupPathPrefix(wxT("resource"));
    if (true == wxFileExists(strAppPath + wxT("resource\\resource.mo")))
    {
       m_locale.AddCatalog(wxT("resource"));
    }
#endif
#if defined(__UNIX__)
    int langCode = wxLocale::GetSystemLanguage();
    wxString resource;
    ENMUtil::GetLocaleFileName(langCode, resource);
    m_locale.AddCatalogLookupPathPrefix(wxT("/usr/share/EasyNetwork/resource"));
    wxString filePath = wxT("/usr/share/EasyNetwork/resource/") + resource + wxT(".mo");

    if (wxFileExists(filePath))
    {
        m_locale.AddCatalog(resource);
    }
    else
    {
        m_locale.AddCatalog(wxT("en"));
    }
#endif

//    wxInitAllImageHandlers();
    m_taskBarIcon = ENMTaskTray::GetInstance();
    m_taskBarIcon->init(argc == 2);

    ENMUtil::m_appPath = strAppPath;
}

bool ENMApp::InitializeDCS()
{
    return DCS_Initialize() == DCS_SUCCESS;
}

bool ENMApp::IsProtocolSupported()
{
#if defined(__UNIX__)
    Display *display = GDK_DISPLAY();
    Screen *screen = DefaultScreenOfDisplay(display);

    char name[32];
    g_snprintf(name, sizeof(name), "_NET_SYSTEM_TRAY_S%d", XScreenNumberOfScreen(screen));
    Atom atom = XInternAtom(display, name, False);
    Window manager = XGetSelectionOwner(display, atom);

    return manager != None;
#endif
#if defined(__WXMSW__)
    return true;
#endif

}

void ENMApp::ReBrowse()
{
    printf("StartListen\n");

    lthread = new ListenThread;

    if ( lthread->Create() != wxTHREAD_NO_ERROR )
    {
        wxLogError(wxT("Can't create thread!"));
    }

    if ( lthread->Run() != wxTHREAD_NO_ERROR )
    {
        wxLogError(wxT("Can't start thread!"));
    }
    printf("lthread->Run()\n");

}

void ENMApp::StartDeploy(const char *ipaddress)
{
    DeployThread *dthread = new DeployThread(ipaddress);

    if ( dthread->Create() != wxTHREAD_NO_ERROR )
    {
        wxLogError(wxT("Can't create thread!"));
    }

    if ( dthread->Run() != wxTHREAD_NO_ERROR )
    {
        wxLogError(wxT("Can't start thread!"));
    }
}

//void ENMApp::StopPublish()
//{
//    printf("Before StopPublish\n");
//    if(pthread == NULL)
//        return;
//
//    // is alive
////    if ( sthread->Create() != wxTHREAD_NO_ERROR )
////        wxLogError(wxT("Can't create thread!"));
////    if ( sthread->Run() != wxTHREAD_NO_ERROR )
////        wxLogError(wxT("Can't start thread!"));
//
//    if (pthread->IsAlive())
//    {
//        printf("before StopPublish pthread->Kill \n");
//        pthread->Kill();
//        printf("After StopPublish pthread->Kill\n");
//    }
//    if (pthread!= NULL)
//    {
//        printf("before StopPublish delete pthread \n");
//        delete pthread;
//        printf("After StopPublish delete pthread \n");
//
//        pthread = NULL;
//    }
//
//    printf("After StopPublish\n");
//
//}

//void ENMApp::StopListen()
//{
//    try
//    {
//    printf("Before StopListen\n");
//
//    if(lthread == NULL)
//    {
//        printf("lthread == NULL \n");
//        return;
//    }
//
//    printf("Before IsAlive\n");
//    if (lthread->IsAlive())
//    {
//        printf("before LeaveMulticast\n");
//        lthread->LeaveMulticast();
//        usleep(1000000);
//        printf("After LeaveMulticast\n");
//        lthread->Delete();
//        printf("fter Delete LeaveMulticast\n");
////        lthread->Kill();
////        printf("After Kill LeaveMulticast\n");
//    }
//    delete lthread;
//    lthread = NULL;
//    printf("After StopListen\n");
//    }
//    catch (...)
//    {
//        printf("Stop Listen exception!\n");
//    }
//    printf("End StopListen\n");
//}

//void ENMApp::Republish(const RepublishEvent& event)
void ENMApp::Republish()
{
    printf("Enter Republish \n");
    ENMUtil::Log(dcLogENMApp, _T("Enter Republish \n"));

    #if defined(__WXMSW__)
    wxString wxStrFileDir = wxFileName::GetTempDir() + wxFileName::GetPathSeparator();
    #endif
    #if defined(__UNIX__)
    wxString wxStrFileDir = _T("/tmp/");
    #endif
    wxString wxStrFilePath = wxStrFileDir + wxT("SchoolSettings.tar");

    if(wxFile::Exists(wxStrFilePath))
    {
        SchoolSettingImporter importer;
        wxArrayString as;
        importer.LoadSchoolSetting(wxStrFilePath, &as);

        ENMUtil::Log(dcLogENMApp, _T("Before Sleep\n"));

        wxMutexGuiEnter();
        if (DataCenter::GetInstance()->GetNetworkManagerDlgHandle()!=NULL)
        {
            DataCenter::GetInstance()->GetNetworkManagerDlgHandle()->SetNetworkProfile_NN();
    //        DataCenter::GetInstance()->GetNetworkManagerDlgHandle()->RefreshProfileList();
            printf("Refresh profile list\n");
        }
        if (DataCenter::GetInstance()->GetProfileManagerDlgHandle()!=NULL)
        {
            DataCenter::GetInstance()->GetProfileManagerDlgHandle()->RefreshProfile();
            printf("ProfileManagerDlg RefreshProfile\n");
        }
        if (DataCenter::GetInstance()->GetPolicyManager()!=NULL)
        {
            DataCenter::GetInstance()->GetPolicyManager()->ReloadPolicy();
            printf("ProfileManagerDlg ReloadPolicy\n");
        }
        wxMutexGuiLeave();
    }

    StartPublishTimer();

    return;
}

void ENMApp::OnTimerExit(wxTimerEvent& event)
{
    if(m_bStartPublishTimer == true)
    {
        if ( PublishThread::m_bExcuting == true )
        {
//            ENMUtil::Log(dcLogENMApp, _T("OnTimerExit: PublishThread::m_bExcutingExcuteFreeAvahi \n"));

            pthread->ExcuteFreeAvahi();
        }
        else
        {
            ReconnectPublish();

            ENMUtil::Log(dcLogENMApp, _T("OnTimerExit: ReconnectPublish \n"));

            m_bStartPublishTimer = false;
        }
    }

    if(m_bStartBrowseTimer == true)
    {
        if ( ListenThread::m_bExcuting == true )
        {
//            ENMUtil::Log(dcLogENMApp, _T("OnTimerExit: PublishThread::m_bExcutingExcuteFreeAvahi \n"));

            lthread->ExcuteFree();
        }
        else
        {
            ReBrowse();

            ENMUtil::Log(dcLogENMApp, _T("OnTimerExit: ReconnectPublish \n"));

            m_bStartBrowseTimer = false;
        }
    }
}
void ENMApp::StopPublish()
{
    ENMUtil::Log(dcLogENMApp, _T("enter StopPublish \n"));
    if( pthread)
    {
        ENMUtil::Log(dcLogENMApp, _T("ExcuteFreeAvahi \n"));

        pthread->ExcuteFreeAvahi();
    }

}
void ENMApp::StartPublishTimer()
{
     ENMUtil::Log(dcLogENMApp, _T(" StartPublishTimer  \n"));
     m_bStartPublishTimer = true;
}

void ENMApp::StartBrowseTimer()
{
     ENMUtil::Log(dcLogENMApp, _T(" StartPublishTimer  \n"));
     m_bStartBrowseTimer = true;
}

void ENMApp::ReconnectPublish()
{
    ENMUtil::Log(dcLogENMApp, _T("start ReconnectPublish \n"));
//
//    if (PublishThread::m_bExcuting == true)
//    {
//        pthread->ExcuteFreeAvahi();
//
//        ENMUtil::Log(dcLogENMApp, _T("m_bExcuting = true , return \n"));
//
//        Sleep(3000);
//
//        return ;
//    }

    pthread = new PublishThread;

    if ( pthread->Create() != wxTHREAD_NO_ERROR )
    {
        wxLogError(wxT("Can't create thread!"));
        return;
    }

    if ( pthread->Run() != wxTHREAD_NO_ERROR )
    {
        wxLogError(wxT("Can't start thread!"));
    }

    ENMUtil::Log(dcLogENMApp, _T("end ReconnectPublish \n"));

}

void CALLBACK DCSAbortHandler()
{
#if defined(__WXMSW__)
    DCS_Return_Code ret = DCS_Initialize();
    while ( ret != DCS_SUCCESS )
    {
         wxSleep(30);
         ret = DCS_Initialize();
    }
    DCS_SetAbortHandler(DCSAbortHandler);
#endif
}

/**************************************************************************************************
* Function Name : PopupNotification                                                                     *
* Description  :                                                                       *
* Date   :                                                                                        *
* Parameter     :                                                                                 *
* Return Code  :                                                                                  *
* Author   :                                                                                      *
**************************************************************************************************/
void ENMApp::PopupNotification()
{
    if (NULL == m_notificationDlg)
    {
        m_notificationDlg = new ENExistBalloon(NULL);
//        m_notificationDlg->PopupNotification();
        m_notificationDlg->Show(true);
    }
    if (NULL == m_notificationtimer)
    {
        m_notificationtimer = new wxTimer(this, ID_NOTI_TIMER);
    }

    m_notificationtimer->Start(3000, wxTIMER_ONE_SHOT);
}
/**************************************************************************************************
* Function Name : CloseNotificationHandler                                                                     *
* Description  :                                                                       *
* Date   :                                                                                        *
* Parameter     :                                                                                 *
* Return Code  :                                                                                  *
* Author   :                                                                                      *
**************************************************************************************************/
void ENMApp::CloseNotificationHandler()
{
   if (NULL != m_notificationDlg)
    {
        m_notificationDlg->Show(false);
        delete m_notificationDlg;
        m_notificationDlg = NULL;
    }

    if (NULL != m_notificationtimer)
    {

        m_notificationtimer->Stop();
        delete m_notificationtimer;
        m_notificationtimer = NULL;
    }
    if ( m_ifExit )
    {
        ::wxExit();
    }
}
/**************************************************************************************************
* Function Name : CloseNotification                                                                     *
* Description  :                                                                       *
* Date   :                                                                                        *
* Parameter     :                                                                                 *
* Return Code  :                                                                                  *
* Author   :                                                                                      *
**************************************************************************************************/
void ENMApp::CloseNotification(wxTimerEvent & event)
{
    CloseNotificationHandler();
}
