#ifndef WXBITMAPDIALOG_H
#define WXBITMAPDIALOG_H

#include <wx/dialog.h>
#include <wx/bitmap.h>
#include <wx/frame.h>
#include <wx/dc.h>
#include <wx/dcclient.h>

class wxBitmapDialog : public wxDialog
{
public:
    wxBitmapDialog(wxBitmap bitmap, wxWindow* parent, wxWindowID id, const wxString& title);
    wxBitmapDialog(const wxBitmap& bitmap, wxWindow* parent, const wxString& title);
    virtual ~wxBitmapDialog();

protected:
    wxBitmap m_bitmap;

private:
    void Init();

    bool m_hasShape;
    wxPoint  m_diff;

    void SetWindowShape();

    void OnMouseLeftDown(wxMouseEvent& event);
    void OnMouseLeftUp(wxMouseEvent& event);
    void OnMouseMove(wxMouseEvent& event);

    void OnEraseBackground(wxEraseEvent& event);
    void OnSize(wxSizeEvent& event);
    void OnPaint(wxPaintEvent& event);
    void OnWindowCreate(wxWindowCreateEvent& event);

    DECLARE_EVENT_TABLE()
};

#endif // WXBITMAPDIALOG_H
