#ifndef AVAHIMULTICAST_H_INCLUDED
#define AVAHIMULTICAST_H_INCLUDED

#include <wx/wx.h>
#include <assert.h>
#include <avahi-client/client.h>
#include <avahi-client/lookup.h>
#include <avahi-common/simple-watch.h>
#include <avahi-common/malloc.h>
#include <avahi-common/error.h>

class AvahiMulticast
{
    public:
        static void resolveTeacher_callback(AvahiServiceResolver *r,
                                    AVAHI_GCC_UNUSED AvahiIfIndex interface,
                                    AVAHI_GCC_UNUSED AvahiProtocol protocol,
                                    AvahiResolverEvent event,
                                    const char *name,
                                    const char *type,
                                    const char *domain,
                                    const char *host_name,
                                    const AvahiAddress *address,
                                    uint16_t port,
                                    AvahiStringList *txt,
                                    AvahiLookupResultFlags flags,
                                    AVAHI_GCC_UNUSED void* userdata);

        static void resolveStudentServer_callback(AvahiServiceResolver *r,
                                    AVAHI_GCC_UNUSED AvahiIfIndex interface,
                                    AVAHI_GCC_UNUSED AvahiProtocol protocol,
                                    AvahiResolverEvent event,
                                    const char *name,
                                    const char *type,
                                    const char *domain,
                                    const char *host_name,
                                    const AvahiAddress *address,
                                    uint16_t port,
                                    AvahiStringList *txt,
                                    AvahiLookupResultFlags flags,
                                    AVAHI_GCC_UNUSED void* userdata);

        static void browseTeacher_callback(AvahiServiceBrowser *b,
                                    AvahiIfIndex interface,
                                    AvahiProtocol protocol,
                                    AvahiBrowserEvent event,
                                    const char *name,
                                    const char *type,
                                    const char *domain,
                                    AVAHI_GCC_UNUSED AvahiLookupResultFlags flags,
                                    void* userdata);

        static void browseStudentServer_callback(AvahiServiceBrowser *b,
                                    AvahiIfIndex interface,
                                    AvahiProtocol protocol,
                                    AvahiBrowserEvent event,
                                    const char *name,
                                    const char *type,
                                    const char *domain,
                                    AVAHI_GCC_UNUSED AvahiLookupResultFlags flags,
                                    void* userdata);

        static void client_callback(AvahiClient *c, AvahiClientState state, AVAHI_GCC_UNUSED void * userdata);

        static int Browse();
        static void Free();

//        static bool Get_ip(int& length);

     private:
        static bool FindIP(const char*szList, char* szIP,char* szSeps);
        static wxString GetProfileVersion();
        static AvahiSimplePoll *m_simple_poll;

};

#endif // AVAHIMULTICAST_H_INCLUDED
