
#ifndef _AUTORUN_SETTINGS_H_
#define _AUTORUN_SETTINGS_H_

#include <wx/listbox.h>
#include <wx/button.h>
#include <wx/dialog.h>

class AutoRunSettings : public wxDialog
{
public:
    AutoRunSettings(wxWindow* parent, wxWindowID id = wxID_ANY);
    virtual ~AutoRunSettings();
    virtual void SetApplications(const wxArrayString& apps);
    virtual wxArrayString GetApplications() const;

private:
    static const long ID_LIST_APP;
    static const long ID_BTN_ADD;
    static const long ID_BTN_DELETE;
    static const long ID_BTN_OK;
    static const long ID_BTN_CANCEL;

    wxButton* m_btnDelete;
    wxButton* m_btnAdd;
    wxButton* m_btnOK;
    wxButton* m_btnCancel;
    wxListBox* m_listApp;
    wxArrayString m_arrayApps;

    void OnButtonAdd(wxCommandEvent& event);
    void OnButtonDelete(wxCommandEvent& event);
    void OnButtonOK(wxCommandEvent& event);
    void OnButtonCancel(wxCommandEvent& event);
    void OnListApplicationSelected(wxCommandEvent& event);

    void CloseDialog(int retCode = wxID_CANCEL);

    DECLARE_EVENT_TABLE()
};

#endif // _AUTORUN_SETTINGS_H_
