#ifndef _ACCESS_POINT_SORTER_H
#define _ACCESS_POINT_SORTER_H

#include <wx/wx.h>
#include "wlan.h"

class AccessPointSorter : public wxObject
{
    public:
        AccessPointSorter(int columnCount);
        virtual ~AccessPointSorter();

        void Reset();
        bool IsSortEnable(int column) const;
        bool SetSortEnable(int column, bool enable);
        bool SetSortOrder(int column, bool ascending = true);
        bool Sort(APStatus* apArray, int arraySize, int column, bool insc = true);

    private:
        bool* m_baSortEnable;
        bool* m_baSortOrder;
        int m_iColumnCount;

        int CompareStringNoCase(const char* str1, const char* str2);
};

#endif // _ACCESS_POINT_SORTER_H
