#include "AboutDialog.h"

#include <wx/bitmap.h>
#include <wx/font.h>
#include <wx/intl.h>
#include <wx/image.h>
#include <wx/string.h>

#include "ENMApp.h"
#include "pic/enm_about.xpm"

BEGIN_EVENT_TABLE(AboutDialog,wxDialog)
    EVT_BUTTON(wxID_OK, AboutDialog::OnButtonOKClick)
END_EVENT_TABLE()

AboutDialog::AboutDialog(wxWindow* parent, wxWindowID id)
{
#if defined(__WXMSW__)
    wxBitmap background(wxImage(::wxGetApp().strAppPath + _T("pic\\about_bg_with_icon.png")));
#else
    wxBitmap background(wxImage(::wxGetApp().strAppPath + _T("pic/about_bg_with_icon.png")));
#endif

	Create(parent, wxID_ANY, _("Easy Network"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE);
	SetClientSize(wxSize(350,230));
	m_bmpBackground = new wxStaticBitmap(this, wxID_ANY, background);
	m_stxModuleName = new CustomStaticText(this, wxID_ANY,_("Easy Network"), wxPoint(92,70));
	wxFont m_stxModuleNameFont(10, wxSWISS, wxFONTSTYLE_NORMAL, wxBOLD, false, wxEmptyString, wxFONTENCODING_DEFAULT);
	m_stxModuleName->SetFont(m_stxModuleNameFont);
	m_stxVersion = new CustomStaticText(this, wxID_ANY, _("Version 2.0.0.090"), wxPoint(92,90));
	m_stxCopyright = new CustomStaticText(this, wxID_ANY, _("Copyright(c) 2008 Intel Corporation."), wxPoint(92,130));
	m_stxRight = new CustomStaticText(this, wxID_ANY, _("All rights reserved."), wxPoint(92,150));
#if defined(__WXMSW__)
	m_btnOK = new wxButton(m_bmpBackground, wxID_OK, _("OK"), wxPoint(252,196), wxSize(70,25));
#endif
#if defined(__UNIX__)
    m_btnOK = new wxButton(this, wxID_OK, _("OK"), wxPoint(252,186), wxDefaultSize);
#endif
	m_btnOK->SetDefault();
	Center();

	wxIcon icon_about(enm_about_xpm);
    SetIcon(icon_about);
}

AboutDialog::~AboutDialog()
{
}

void AboutDialog::OnButtonOKClick(wxCommandEvent& event)
{
    Close();
}
