/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

#include "nmn-plug.h"

G_DEFINE_TYPE (NmnPlug, nmn_plug, GTK_TYPE_PLUG)

#define GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE ((obj), NMN_TYPE_PLUG, NmnPlugPrivate))

typedef struct {
    GSList *stack;

    gboolean disposed;
} NmnPlugPrivate;

#define PADDING 4

GtkWidget *
nmn_plug_new (void)
{
    return GTK_WIDGET (g_object_new (NMN_TYPE_PLUG, NULL));
}

void
nmn_plug_push (NmnPlug *self,
               GtkWidget *widget)
{
    GtkWidget *current_child;

    g_return_if_fail (NMN_IS_PLUG (self));
    g_return_if_fail (GTK_IS_WIDGET (widget));

    current_child = gtk_bin_get_child (GTK_BIN (self));
    if (current_child) {
        NmnPlugPrivate *priv = GET_PRIVATE (self);

        priv->stack = g_slist_prepend (priv->stack, g_object_ref (current_child));
        gtk_container_remove (GTK_CONTAINER (self), current_child);
    }

    /* FIXME: Hack to sizerequest the new child to the same size as the previous one */
    {
        GdkScreen *screen;

        screen = gtk_widget_get_screen (GTK_WIDGET (self));
        gtk_widget_set_size_request (widget,
                                     gdk_screen_get_width (screen) - 2 * PADDING,
                                     300);
    }

    gtk_container_add (GTK_CONTAINER (self), widget);
}

void
nmn_plug_pop (NmnPlug *self)
{
    GtkWidget *current_child;
    NmnPlugPrivate *priv;

    g_return_if_fail (NMN_IS_PLUG (self));

    current_child = gtk_bin_get_child (GTK_BIN (self));
    g_return_if_fail (GTK_IS_WIDGET (current_child));

    gtk_container_remove (GTK_CONTAINER (self), current_child);

    priv = GET_PRIVATE (self);

    if (priv->stack) {
        GtkWidget *w = GTK_WIDGET (priv->stack->data);

        priv->stack = g_slist_delete_link (priv->stack, priv->stack);
        gtk_container_add (GTK_CONTAINER (self), w);
        g_object_unref (w);
    }
}

static void
nmn_plug_init (NmnPlug *plug)
{
}

static void
dispose (GObject *object)
{
    NmnPlugPrivate *priv = GET_PRIVATE (object);

    if (priv->disposed)
        return;

    g_slist_foreach (priv->stack, (GFunc) g_object_unref, NULL);
    g_slist_free (priv->stack);

    priv->disposed = TRUE;

    G_OBJECT_CLASS (nmn_plug_parent_class)->dispose (object);
}

static void
nmn_plug_class_init (NmnPlugClass *class)
{
    GObjectClass *object_class = G_OBJECT_CLASS (class);

    g_type_class_add_private (object_class, sizeof (NmnPlugPrivate));

    object_class->dispose = dispose;
}
