/*
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#include "nl-wm.h"

G_DEFINE_TYPE (NlWm, nl_wm, G_TYPE_OBJECT);

#define NL_WM_GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE ((obj),\
  NL_TYPE_WM, \
  NlWmPrivate))

struct _NlWmPrivate
{
  WnckScreen *screen;

  GHashTable *table;
};

enum
{
  SHOW_DECS,
  HIDE_DECS,

  LAST_SIGNAL
};
static guint _wm_signals[LAST_SIGNAL] = { 0 };

static void
on_active_window_changed (WnckScreen *screen,
                          WnckWindow *prev_window,
                          NlWm *wm)
{
  WnckWindow *window;
  WnckWindowType type;

  window = wnck_screen_get_active_window (screen);

  if (!WNCK_IS_WINDOW (window))
    {
      g_signal_emit (wm, _wm_signals[HIDE_DECS], 0);
      return;
    }

  type = wnck_window_get_window_type (window);
  if (type == WNCK_WINDOW_DESKTOP)
    {
      WnckClassGroup *group;
      group = wnck_window_get_class_group (window);
      
      if (group && g_str_equal (wnck_class_group_get_res_class (group), "Netbook-launcher"))
        {
          g_signal_emit (wm, _wm_signals[HIDE_DECS], 0);
          wnck_screen_toggle_showing_desktop (screen, TRUE);
          return;
        }
    }

  g_signal_emit (wm, _wm_signals[SHOW_DECS], 0, window);
}

/* GObject stuff */
static void
nl_wm_class_init (NlWmClass *klass)
{
  GObjectClass        *obj_class = G_OBJECT_CLASS (klass);

  _wm_signals[SHOW_DECS] =
    g_signal_new ("show-windec",
                  G_OBJECT_CLASS_TYPE (obj_class),
                  G_SIGNAL_RUN_LAST,
                  G_STRUCT_OFFSET (NlWmClass, show_windec),
                  NULL, NULL,
                  g_cclosure_marshal_VOID__OBJECT,
                  G_TYPE_NONE,
                  1, WNCK_TYPE_WINDOW);

  _wm_signals[HIDE_DECS] =
    g_signal_new ("hide-windec",
                  G_OBJECT_CLASS_TYPE (obj_class),
                  G_SIGNAL_RUN_LAST,
                  G_STRUCT_OFFSET (NlWmClass, hide_windec),
                  NULL, NULL,
                  g_cclosure_marshal_VOID__VOID,
                  G_TYPE_NONE, 0);

  g_type_class_add_private (obj_class, sizeof (NlWmPrivate));
}

static void
nl_wm_init (NlWm *wm)
{
  NlWmPrivate *priv;

  priv = wm->priv = NL_WM_GET_PRIVATE (wm);

  priv->screen = wnck_screen_get_default ();

  g_signal_connect (priv->screen, "active-window-changed",
                    G_CALLBACK (on_active_window_changed), (gpointer)wm);
}

NlWm *
nl_wm_get_default (void)

{
  static NlWm *wm = NULL;

  if (!wm)
    wm = g_object_new (NL_TYPE_WM,
                       NULL);

  return wm;
}
