/*
 * Copyright (C) 2007 Intel Ltd
 *               2008 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <njp@o-hand.com>
 *             Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _HAVE_NL_BACKGROUND_H
#define _HAVE_NL_BACKGROUND_H

#include <glib.h>
#include <clutter/clutter.h>

G_BEGIN_DECLS

#define NL_TYPE_BACKGROUND (nl_background_get_type ())

#define NL_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
        NL_TYPE_BACKGROUND, NlBackground))

#define NL_BACKGROUND_CLASS(klass) \
        (G_TYPE_CHECK_CLASS_CAST ((klass), \
        NL_TYPE_BACKGROUND, NlBackgroundClass))

#define NL_IS_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
        NL_TYPE_BACKGROUND))

#define NL_IS_BACKGROUND_CLASS(klass) \
        (G_TYPE_CHECK_CLASS_TYPE ((klass), NL_TYPE_BACKGROUND))

#define NL_BACKGROUND_GET_CLASS(obj) \
        (G_TYPE_INSTANCE_GET_CLASS ((obj), \
        NL_TYPE_BACKGROUND, NlBackgroundClass))

typedef struct _NlBackground NlBackground;
typedef struct _NlBackgroundClass NlBackgroundClass;
typedef struct _NlBackgroundPrivate NlBackgroundPrivate;

struct _NlBackground
{
  ClutterGroup         parent; 
  
  /*< private >*/
  NlBackgroundPrivate   *priv;
};

struct _NlBackgroundClass 
{
  /*< private >*/
  ClutterGroupClass    parent_class;

  /* future padding */
  void (*_nl_background_1) (void);
  void (*_nl_background_2) (void);
  void (*_nl_background_3) (void);
  void (*_nl_background_4) (void);
};

GType nl_background_get_type (void) G_GNUC_CONST;

ClutterActor * nl_background_new (void);

void           nl_background_ensure_layout (NlBackground *background);

G_END_DECLS

#endif /* _HAVE_NL_BACKGROUND_H */
