/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

/* Generated By:JJTree&JavaCC: Do not edit this line. JavaParser.java */
package org.netbeans.modules.debugger.jpda.expr;

class JavaParser/*@bgen(jjtree)*/implements JavaParserTreeConstants, JavaParserConstants {/*@bgen(jjtree)*/
  protected JJTJavaParserState jjtree = new JJTJavaParserState();
  public static final String LANGUAGE_JAVA_1_4 = "1.4.0";
  public static final String LANGUAGE_JAVA_1_5 = "1.5.0";

  private String target_jdk;
  private boolean jdk1_5;
  private boolean generics;

  public void setTargetJDK(String target) {
     target_jdk = target;
     jdk1_5 = "1.5.0".compareTo(target_jdk) <= 0;
     generics = "1.5.0".compareTo(target_jdk) <= 0;
  }

  private boolean expressionLookahead() {
     Token tok = getToken(1);
     if (tok.kind==COMMA) {
        tok = getToken(2);
        if (!(tok.kind==RPAREN || tok.kind==RBRACE)) {
            return true;
        }
     }
     return false;
  }

   private boolean castLookahead() {
      int x = 0;
      Token tok = getToken(++x);
      if (tok.kind!=LPAREN) {
         return false;
      }
      tok = getToken(++x);
      if (tok.kind==IDENTIFIER) {
         tok = getToken(++x);
         while (true) {
            if (tok.kind==LT) {
               x = typeArguments(x);
               if (x<0) {
                  return false;
               }
               tok = getToken(x);  // load next token
            }
            if (tok.kind==LBRACKET) {
               while (tok.kind==LBRACKET) {
                  tok = getToken(++x);
                  if (tok.kind!=RBRACKET) {
                     return false;
                  }
                  tok = getToken(++x);
               }
            }
            if (tok.kind==RPAREN) {
               tok = getToken(++x);
               return castEnd(tok);
            } else if (tok.kind!=DOT) {
               return false;
            }
            tok = getToken(++x);
            if (isPrimitiveType(tok)) {
               tok = getToken(++x);
               if (tok.kind==LBRACKET) {
                  while (tok.kind==LBRACKET) {
                     tok = getToken(++x);
                     if (tok.kind!=RBRACKET) {
                        return false;
                     }
                     tok = getToken(++x);
                  }
               }
               return (tok.kind==RPAREN);
            } else if (tok.kind==IDENTIFIER) {
               tok = getToken(++x);
            }

         }
      } else if (isPrimitiveType(tok)) {
         tok = getToken(++x);
         if (tok.kind==LBRACKET) {
            while (tok.kind==LBRACKET) {
               tok = getToken(++x);
               if (tok.kind!=RBRACKET) {
                  return false;
               }
               tok = getToken(++x);
            }
         }
         return (tok.kind==RPAREN);
      }
      return false;
   }


   private boolean isPrimitiveType(Token tok) {
      return tok.kind==BOOLEAN || tok.kind==CHAR  || tok.kind==BYTE
          || tok.kind==SHORT   || tok.kind==INT   || tok.kind==LONG
          || tok.kind==FLOAT   || tok.kind==DOUBLE;
   }

   private int typeArguments(int x) {
      int level = 1;
      while (true) {
         Token tok = getToken(++x);
         if (tok.kind==GT) {
            --level;
            if (level==0) {
               return x+1;
            } else if (level < 0) {
               return -1; // this is probably a syntax error
            }
         } else if (tok.kind==RSIGNEDSHIFT) {
            level -= 2;
            if (level==0) {
               return x+1;
            } else if (level < 0) {
               return -1; // this is probably a syntax error
            }
         } else if (tok.kind==RUNSIGNEDSHIFT) {
            level -= 2;
            if (level==0) {
               return x+1;
            } else if (level < 0) {
               return -1; // this is probably a syntax error
            }
         } else if (tok.kind==LT) {
            level++;
         }

         if (tok.kind==RPAREN) {
            return -1;
         } else if (tok.kind==DOT) {
         } else if (tok.kind==HOOK || tok.kind==SUPER || tok.kind==EXTENDS || tok.kind==IDENTIFIER) {
            // do nothing
         }
      }
   }


   private boolean castEnd(Token tok) {
      return (   tok.kind==TILDE             || tok.kind==BANG            || tok.kind==LPAREN || tok.kind==IDENTIFIER
              || tok.kind==THIS              || tok.kind==SUPER           || tok.kind==NEW
              || tok.kind==INTEGER_LITERAL   || tok.kind==FLOATING_POINT_LITERAL
              || tok.kind==CHARACTER_LITERAL || tok.kind==STRING_LITERAL
              || tok.kind==TRUE              || tok.kind==FALSE           || tok.kind==NULL );
   }


  public static void main(String args[]) {
  }

/*****************************************
 * THE JAVA LANGUAGE GRAMMAR STARTS HERE *
 *****************************************/
  final public void ReferenceTypeList() throws ParseException {
 /*@bgen(jjtree) ReferenceTypeList */
    SimpleNode jjtn000 = new SimpleNode(JJTREFERENCETYPELIST);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Token tok;
    Token tok1;
    Token tok2;
    Token tok3;
    try {
      tok = jj_consume_token(LT);
    if (!jdk1_5) {
      {if (true) throw new ParseException("Generic reference types are only available in JDK 1.5 or later generics" );}
    }
      ActualTypeArgument();
      label_1:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[0] = jj_gen;
          break label_1;
        }
        tok = jj_consume_token(COMMA);
        ActualTypeArgument();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case GT:
        tok = jj_consume_token(GT);
        break;
      case RSIGNEDSHIFT:
        tok = jj_consume_token(RSIGNEDSHIFT);
                 jjtree.closeNodeScope(jjtn000, true);
                 jjtc000 = false;
      tok2=tok.next;
      tok1=Token.newToken(GT);
      tok.image=">";  tok.kind=GT;  tok.next=tok1;
      tok1.image=">"; tok1.kind=GT; tok1.next=tok2;
        break;
      case RUNSIGNEDSHIFT:
        tok = jj_consume_token(RUNSIGNEDSHIFT);
                  jjtree.closeNodeScope(jjtn000, true);
                  jjtc000 = false;
      tok3=tok.next;
      tok1=Token.newToken(GT); tok2=Token.newToken(GT);
      tok.image=">";  tok.kind=GT;  tok.next=tok1;
      tok1.image=">"; tok1.kind=GT; tok1.next=tok2;
      tok2.image=">"; tok2.kind=GT; tok2.next=tok3;
        break;
      default:
        jj_la1[1] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

  final public void ActualTypeArgument() throws ParseException {
 /*@bgen(jjtree) ActualTypeArgument */
    SimpleNode jjtn000 = new SimpleNode(JJTACTUALTYPEARGUMENT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Token tok;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case HOOK:
        // Wildcard
          tok = jj_consume_token(HOOK);
                              jjtn000.setAttribute("wildcard", tok);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case EXTENDS:
        case SUPER:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case EXTENDS:
            tok = jj_consume_token(EXTENDS);
                              jjtn000.setAttribute("token", tok);
            break;
          case SUPER:
            tok = jj_consume_token(SUPER);
                              jjtn000.setAttribute("token", tok);
            break;
          default:
            jj_la1[2] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          ReferenceType();
          break;
        default:
          jj_la1[3] = jj_gen;
          ;
        }
        break;
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case FLOAT:
      case INT:
      case LONG:
      case SHORT:
      case IDENTIFIER:
        ReferenceType();
        break;
      default:
        jj_la1[4] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

  final public void Identifier() throws ParseException {
 /*@bgen(jjtree) Identifier */
    SimpleNode jjtn000 = new SimpleNode(JJTIDENTIFIER);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Token tok;
    try {
      tok = jj_consume_token(IDENTIFIER);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.setAttribute("token", tok);
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  final public void VariableInitializer() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACE:
      ArrayInitializer();
      break;
    default:
      jj_la1[5] = jj_gen;
      if (jj_2_1(1)) {
        Expression();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void ArrayInitializer() throws ParseException {
                           /*@bgen(jjtree) ArrayInitializer */
  SimpleNode jjtn000 = new SimpleNode(JJTARRAYINITIALIZER);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(LBRACE);
      if (jj_2_3(1)) {
        VariableInitializer();
        label_2:
        while (true) {
          if (jj_2_2(2)) {
            ;
          } else {
            break label_2;
          }
          jj_consume_token(COMMA);
          VariableInitializer();
        }
      } else {
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        jj_consume_token(COMMA);
        break;
      default:
        jj_la1[6] = jj_gen;
        ;
      }
      jj_consume_token(RBRACE);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

/*
 * Type, name and expression syntax follows.
 */
  final public void Type() throws ParseException {
    if (jj_2_4(2)) {
      ReferenceType();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case FLOAT:
      case INT:
      case LONG:
      case SHORT:
        PrimitiveType();
        break;
      default:
        jj_la1[7] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void ReferenceType() throws ParseException {
 /*@bgen(jjtree) ReferenceType */
    SimpleNode jjtn000 = new SimpleNode(JJTREFERENCETYPE);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);int arrayCount = 0;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
        ClassOrInterfaceType();
        label_3:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LBRACKET:
            ;
            break;
          default:
            jj_la1[8] = jj_gen;
            break label_3;
          }
          jj_consume_token(LBRACKET);
          jj_consume_token(RBRACKET);
         arrayCount++;
        }
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        jjtn000.setAttribute("arrayCount", new Integer(arrayCount));
        break;
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case FLOAT:
      case INT:
      case LONG:
      case SHORT:
        PrimitiveType();
        label_4:
        while (true) {
          jj_consume_token(LBRACKET);
          jj_consume_token(RBRACKET);
         arrayCount++;
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LBRACKET:
            ;
            break;
          default:
            jj_la1[9] = jj_gen;
            break label_4;
          }
        }
        jjtree.closeNodeScope(jjtn000, true);
        jjtc000 = false;
        jjtn000.setAttribute("arrayCount", new Integer(arrayCount));
        break;
      default:
        jj_la1[10] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  final public void TypeArguments() throws ParseException {
 /*@bgen(jjtree) TypeArguments */
    SimpleNode jjtn000 = new SimpleNode(JJTTYPEARGUMENTS);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Token tok;
    Token tok1;
    Token tok2;
    Token tok3;
    try {
      tok = jj_consume_token(LT);
    if (!jdk1_5) {
      {if (true) throw new ParseException("Generic type arguments are only available in JDK 1.5 or later generics" );}
    }
      ActualTypeArgument();
      label_5:
      while (true) {
        if (jj_2_5(2)) {
          ;
        } else {
          break label_5;
        }
        tok = jj_consume_token(COMMA);
        ActualTypeArgument();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case GT:
        tok = jj_consume_token(GT);
        break;
      case RSIGNEDSHIFT:
        tok = jj_consume_token(RSIGNEDSHIFT);
                 jjtree.closeNodeScope(jjtn000, true);
                 jjtc000 = false;
        tok2=tok.next;
        tok1=Token.newToken(GT);
        tok.image=">";  tok.kind=GT;  tok.next=tok1;
        tok1.image=">"; tok1.kind=GT; tok1.next=tok2;
        break;
      case RUNSIGNEDSHIFT:
        tok = jj_consume_token(RUNSIGNEDSHIFT);
                  jjtree.closeNodeScope(jjtn000, true);
                  jjtc000 = false;
        tok3=tok.next;
        tok1=Token.newToken(GT); tok2=Token.newToken(GT);
        tok.image=">";  tok.kind=GT;  tok.next=tok1;
        tok1.image=">"; tok1.kind=GT; tok1.next=tok2;
        tok2.image=">"; tok2.kind=GT; tok2.next=tok3;
        break;
      default:
        jj_la1[11] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

  final public void PrimitiveType() throws ParseException {
 /*@bgen(jjtree) PrimitiveType */
    SimpleNode jjtn000 = new SimpleNode(JJTPRIMITIVETYPE);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Token tok;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BOOLEAN:
        tok = jj_consume_token(BOOLEAN);
        break;
      case CHAR:
        tok = jj_consume_token(CHAR);
        break;
      case BYTE:
        tok = jj_consume_token(BYTE);
        break;
      case SHORT:
        tok = jj_consume_token(SHORT);
        break;
      case INT:
        tok = jj_consume_token(INT);
        break;
      case LONG:
        tok = jj_consume_token(LONG);
        break;
      case FLOAT:
        tok = jj_consume_token(FLOAT);
        break;
      case DOUBLE:
        tok = jj_consume_token(DOUBLE);
        break;
      default:
        jj_la1[12] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.setAttribute("token", tok);
    } finally {
  if (jjtc000) {
    jjtree.closeNodeScope(jjtn000, true);
  }
    }
  }

  final public void ResultType() throws ParseException {
                     /*@bgen(jjtree) ResultType */
  SimpleNode jjtn000 = new SimpleNode(JJTRESULTTYPE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case VOID:
        jj_consume_token(VOID);
              jjtree.closeNodeScope(jjtn000, true);
              jjtc000 = false;
              jjtn000.setAttribute("void", "void");
        break;
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case FLOAT:
      case INT:
      case LONG:
      case SHORT:
      case IDENTIFIER:
        Type();
        break;
      default:
        jj_la1[13] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

  final public void Name() throws ParseException {
 /*@bgen(jjtree) Name */
    SimpleNode jjtn000 = new SimpleNode(JJTNAME);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Token tok;
    try {
      tok = jj_consume_token(IDENTIFIER);
    jjtn000.addAttribute("token", tok);
      label_6:
      while (true) {
        if (jj_2_6(2)) {
          ;
        } else {
          break label_6;
        }
        jj_consume_token(DOT);
        tok = jj_consume_token(IDENTIFIER);
      jjtn000.addAttribute("token", tok);
      }
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

  final public void ClassOrInterfaceType() throws ParseException {
                               /*@bgen(jjtree) ClassOrInterfaceType */
  SimpleNode jjtn000 = new SimpleNode(JJTCLASSORINTERFACETYPE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      Identifier();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LT:
        TypeArguments();
        break;
      default:
        jj_la1[14] = jj_gen;
        ;
      }
      label_7:
      while (true) {
        if (jj_2_7(2147483647)) {
          ;
        } else {
          break label_7;
        }
        jj_consume_token(DOT);
        Identifier();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LT:
          TypeArguments();
          break;
        default:
          jj_la1[15] = jj_gen;
          ;
        }
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

/*
 * Expression syntax follows.
 */
  final public SimpleNode Expression() throws ParseException {
 /*@bgen(jjtree) Expression */
  SimpleNode jjtn000 = new SimpleNode(JJTEXPRESSION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      ConditionalExpression();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ASSIGN:
      case PLUSASSIGN:
      case MINUSASSIGN:
      case STARASSIGN:
      case SLASHASSIGN:
      case ANDASSIGN:
      case ORASSIGN:
      case XORASSIGN:
      case REMASSIGN:
      case LSHIFTASSIGN:
      case RSIGNEDSHIFTASSIGN:
      case RUNSIGNEDSHIFTASSIGN:
        AssignmentOperator();
        Expression();
        break;
      default:
        jj_la1[16] = jj_gen;
        ;
      }
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
    throw new Error("Missing return statement in function");
  }

  final public void AssignmentOperator() throws ParseException {
 /*@bgen(jjtree) AssignmentOperator */
    SimpleNode jjtn000 = new SimpleNode(JJTASSIGNMENTOPERATOR);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Token tok;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ASSIGN:
        tok = jj_consume_token(ASSIGN);
        break;
      case STARASSIGN:
        tok = jj_consume_token(STARASSIGN);
        break;
      case SLASHASSIGN:
        tok = jj_consume_token(SLASHASSIGN);
        break;
      case REMASSIGN:
        tok = jj_consume_token(REMASSIGN);
        break;
      case PLUSASSIGN:
        tok = jj_consume_token(PLUSASSIGN);
        break;
      case MINUSASSIGN:
        tok = jj_consume_token(MINUSASSIGN);
        break;
      case LSHIFTASSIGN:
        tok = jj_consume_token(LSHIFTASSIGN);
        break;
      case RSIGNEDSHIFTASSIGN:
        tok = jj_consume_token(RSIGNEDSHIFTASSIGN);
        break;
      case RUNSIGNEDSHIFTASSIGN:
        tok = jj_consume_token(RUNSIGNEDSHIFTASSIGN);
        break;
      case ANDASSIGN:
        tok = jj_consume_token(ANDASSIGN);
        break;
      case XORASSIGN:
        tok = jj_consume_token(XORASSIGN);
        break;
      case ORASSIGN:
        tok = jj_consume_token(ORASSIGN);
        break;
      default:
        jj_la1[17] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000.setAttribute("operator", tok);
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

  final public void ConditionalExpression() throws ParseException {
  SimpleNode jjtn001 = new SimpleNode(JJTCONDITIONALEXPRESSION);
  boolean jjtc001 = true;
  jjtree.openNodeScope(jjtn001);
    try {
      ConditionalOrExpression();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case HOOK:
        jj_consume_token(HOOK);
        Expression();
        jj_consume_token(COLON);
        ConditionalExpression();
        break;
      default:
        jj_la1[18] = jj_gen;
        ;
      }
    } catch (Throwable jjte001) {
  if (jjtc001) {
    jjtree.clearNodeScope(jjtn001);
    jjtc001 = false;
  } else {
    jjtree.popNode();
  }
  if (jjte001 instanceof RuntimeException) {
    {if (true) throw (RuntimeException)jjte001;}
  }
  if (jjte001 instanceof ParseException) {
    {if (true) throw (ParseException)jjte001;}
  }
  {if (true) throw (Error)jjte001;}
    } finally {
  if (jjtc001) {
    jjtree.closeNodeScope(jjtn001, jjtree.nodeArity() > 1);
  }
    }
  }

  final public void ConditionalOrExpression() throws ParseException {
    Token tok;
  SimpleNode jjtn001 = new SimpleNode(JJTCONDITIONALOREXPRESSION);
  boolean jjtc001 = true;
  jjtree.openNodeScope(jjtn001);
    try {
      ConditionalAndExpression();
      label_8:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SC_OR:
          ;
          break;
        default:
          jj_la1[19] = jj_gen;
          break label_8;
        }
        tok = jj_consume_token(SC_OR);
                                  jjtn001.setAttribute("operator", tok);
        ConditionalAndExpression();
      }
    } catch (Throwable jjte001) {
  if (jjtc001) {
    jjtree.clearNodeScope(jjtn001);
    jjtc001 = false;
  } else {
    jjtree.popNode();
  }
  if (jjte001 instanceof RuntimeException) {
    {if (true) throw (RuntimeException)jjte001;}
  }
  if (jjte001 instanceof ParseException) {
    {if (true) throw (ParseException)jjte001;}
  }
  {if (true) throw (Error)jjte001;}
    } finally {
  if (jjtc001) {
    jjtree.closeNodeScope(jjtn001, jjtree.nodeArity() > 1);
  }
    }
  }

  final public void ConditionalAndExpression() throws ParseException {
    Token tok;
  SimpleNode jjtn001 = new SimpleNode(JJTCONDITIONALANDEXPRESSION);
  boolean jjtc001 = true;
  jjtree.openNodeScope(jjtn001);
    try {
      InclusiveOrExpression();
      label_9:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SC_AND:
          ;
          break;
        default:
          jj_la1[20] = jj_gen;
          break label_9;
        }
        tok = jj_consume_token(SC_AND);
                                  jjtn001.setAttribute("operator", tok);
        InclusiveOrExpression();
      }
    } catch (Throwable jjte001) {
  if (jjtc001) {
    jjtree.clearNodeScope(jjtn001);
    jjtc001 = false;
  } else {
    jjtree.popNode();
  }
  if (jjte001 instanceof RuntimeException) {
    {if (true) throw (RuntimeException)jjte001;}
  }
  if (jjte001 instanceof ParseException) {
    {if (true) throw (ParseException)jjte001;}
  }
  {if (true) throw (Error)jjte001;}
    } finally {
  if (jjtc001) {
    jjtree.closeNodeScope(jjtn001, jjtree.nodeArity() > 1);
  }
    }
  }

  final public void InclusiveOrExpression() throws ParseException {
    Token tok;
  SimpleNode jjtn001 = new SimpleNode(JJTINCLUSIVEOREXPRESSION);
  boolean jjtc001 = true;
  jjtree.openNodeScope(jjtn001);
    try {
      ExclusiveOrExpression();
      label_10:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BIT_OR:
          ;
          break;
        default:
          jj_la1[21] = jj_gen;
          break label_10;
        }
        tok = jj_consume_token(BIT_OR);
                                  jjtn001.addAttribute("operator", tok);
        ExclusiveOrExpression();
      }
    } catch (Throwable jjte001) {
  if (jjtc001) {
    jjtree.clearNodeScope(jjtn001);
    jjtc001 = false;
  } else {
    jjtree.popNode();
  }
  if (jjte001 instanceof RuntimeException) {
    {if (true) throw (RuntimeException)jjte001;}
  }
  if (jjte001 instanceof ParseException) {
    {if (true) throw (ParseException)jjte001;}
  }
  {if (true) throw (Error)jjte001;}
    } finally {
  if (jjtc001) {
    jjtree.closeNodeScope(jjtn001, jjtree.nodeArity() > 1);
  }
    }
  }

  final public void ExclusiveOrExpression() throws ParseException {
    Token tok;
  SimpleNode jjtn001 = new SimpleNode(JJTEXCLUSIVEOREXPRESSION);
  boolean jjtc001 = true;
  jjtree.openNodeScope(jjtn001);
    try {
      AndExpression();
      label_11:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case XOR:
          ;
          break;
        default:
          jj_la1[22] = jj_gen;
          break label_11;
        }
        tok = jj_consume_token(XOR);
                                  jjtn001.addAttribute("operator", tok);
        AndExpression();
      }
    } catch (Throwable jjte001) {
  if (jjtc001) {
    jjtree.clearNodeScope(jjtn001);
    jjtc001 = false;
  } else {
    jjtree.popNode();
  }
  if (jjte001 instanceof RuntimeException) {
    {if (true) throw (RuntimeException)jjte001;}
  }
  if (jjte001 instanceof ParseException) {
    {if (true) throw (ParseException)jjte001;}
  }
  {if (true) throw (Error)jjte001;}
    } finally {
  if (jjtc001) {
    jjtree.closeNodeScope(jjtn001, jjtree.nodeArity() > 1);
  }
    }
  }

  final public void AndExpression() throws ParseException {
    Token tok;
  SimpleNode jjtn001 = new SimpleNode(JJTANDEXPRESSION);
  boolean jjtc001 = true;
  jjtree.openNodeScope(jjtn001);
    try {
      EqualityExpression();
      label_12:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BIT_AND:
          ;
          break;
        default:
          jj_la1[23] = jj_gen;
          break label_12;
        }
        tok = jj_consume_token(BIT_AND);
                                  jjtn001.addAttribute("operator", tok);
        EqualityExpression();
      }
    } catch (Throwable jjte001) {
  if (jjtc001) {
    jjtree.clearNodeScope(jjtn001);
    jjtc001 = false;
  } else {
    jjtree.popNode();
  }
  if (jjte001 instanceof RuntimeException) {
    {if (true) throw (RuntimeException)jjte001;}
  }
  if (jjte001 instanceof ParseException) {
    {if (true) throw (ParseException)jjte001;}
  }
  {if (true) throw (Error)jjte001;}
    } finally {
  if (jjtc001) {
    jjtree.closeNodeScope(jjtn001, jjtree.nodeArity() > 1);
  }
    }
  }

  final public void EqualityExpression() throws ParseException {
    Token tok;
  SimpleNode jjtn001 = new SimpleNode(JJTEQUALITYEXPRESSION);
  boolean jjtc001 = true;
  jjtree.openNodeScope(jjtn001);
    try {
      InstanceOfExpression();
      label_13:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case EQ:
        case NE:
          ;
          break;
        default:
          jj_la1[24] = jj_gen;
          break label_13;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case EQ:
          tok = jj_consume_token(EQ);
          break;
        case NE:
          tok = jj_consume_token(NE);
          break;
        default:
          jj_la1[25] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                                  jjtn001.addAttribute("operator", tok);
        InstanceOfExpression();
      }
    } catch (Throwable jjte001) {
  if (jjtc001) {
    jjtree.clearNodeScope(jjtn001);
    jjtc001 = false;
  } else {
    jjtree.popNode();
  }
  if (jjte001 instanceof RuntimeException) {
    {if (true) throw (RuntimeException)jjte001;}
  }
  if (jjte001 instanceof ParseException) {
    {if (true) throw (ParseException)jjte001;}
  }
  {if (true) throw (Error)jjte001;}
    } finally {
  if (jjtc001) {
    jjtree.closeNodeScope(jjtn001, jjtree.nodeArity() > 1);
  }
    }
  }

  final public void InstanceOfExpression() throws ParseException {
  SimpleNode jjtn001 = new SimpleNode(JJTINSTANCEOFEXPRESSION);
  boolean jjtc001 = true;
  jjtree.openNodeScope(jjtn001);
    try {
      RelationalExpression();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INSTANCEOF:
        jj_consume_token(INSTANCEOF);
        ReferenceType();
        break;
      default:
        jj_la1[26] = jj_gen;
        ;
      }
    } catch (Throwable jjte001) {
  if (jjtc001) {
    jjtree.clearNodeScope(jjtn001);
    jjtc001 = false;
  } else {
    jjtree.popNode();
  }
  if (jjte001 instanceof RuntimeException) {
    {if (true) throw (RuntimeException)jjte001;}
  }
  if (jjte001 instanceof ParseException) {
    {if (true) throw (ParseException)jjte001;}
  }
  {if (true) throw (Error)jjte001;}
    } finally {
  if (jjtc001) {
    jjtree.closeNodeScope(jjtn001, jjtree.nodeArity() > 1);
  }
    }
  }

  final public void RelationalExpression() throws ParseException {
  SimpleNode jjtn001 = new SimpleNode(JJTRELATIONALEXPRESSION);
  boolean jjtc001 = true;
  jjtree.openNodeScope(jjtn001);
    try {
      ShiftExpression();
      label_14:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case GT:
        case LT:
        case LE:
        case GE:
          ;
          break;
        default:
          jj_la1[27] = jj_gen;
          break label_14;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LT:
          jj_consume_token(LT);
          break;
        case GT:
          jj_consume_token(GT);
          break;
        case LE:
          jj_consume_token(LE);
          break;
        case GE:
          jj_consume_token(GE);
          break;
        default:
          jj_la1[28] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      jjtn001.addAttribute("operator", token);
        ShiftExpression();
      }
    } catch (Throwable jjte001) {
  if (jjtc001) {
    jjtree.clearNodeScope(jjtn001);
    jjtc001 = false;
  } else {
    jjtree.popNode();
  }
  if (jjte001 instanceof RuntimeException) {
    {if (true) throw (RuntimeException)jjte001;}
  }
  if (jjte001 instanceof ParseException) {
    {if (true) throw (ParseException)jjte001;}
  }
  {if (true) throw (Error)jjte001;}
    } finally {
  if (jjtc001) {
    jjtree.closeNodeScope(jjtn001, jjtree.nodeArity() > 1);
  }
    }
  }

  final public void ShiftExpression() throws ParseException {
    Token tok;
  SimpleNode jjtn001 = new SimpleNode(JJTSHIFTEXPRESSION);
  boolean jjtc001 = true;
  jjtree.openNodeScope(jjtn001);
    try {
      AdditiveExpression();
      label_15:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LSHIFT:
        case RSIGNEDSHIFT:
        case RUNSIGNEDSHIFT:
          ;
          break;
        default:
          jj_la1[29] = jj_gen;
          break label_15;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LSHIFT:
          tok = jj_consume_token(LSHIFT);
          break;
        case RSIGNEDSHIFT:
          tok = jj_consume_token(RSIGNEDSHIFT);
          break;
        case RUNSIGNEDSHIFT:
          tok = jj_consume_token(RUNSIGNEDSHIFT);
          break;
        default:
          jj_la1[30] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jjtn001.addAttribute("operator", tok);
        AdditiveExpression();
      }
    } catch (Throwable jjte001) {
  if (jjtc001) {
    jjtree.clearNodeScope(jjtn001);
    jjtc001 = false;
  } else {
    jjtree.popNode();
  }
  if (jjte001 instanceof RuntimeException) {
    {if (true) throw (RuntimeException)jjte001;}
  }
  if (jjte001 instanceof ParseException) {
    {if (true) throw (ParseException)jjte001;}
  }
  {if (true) throw (Error)jjte001;}
    } finally {
  if (jjtc001) {
    jjtree.closeNodeScope(jjtn001, jjtree.nodeArity() > 1);
  }
    }
  }

  final public void AdditiveExpression() throws ParseException {
    Token tok;
      SimpleNode jjtn001 = new SimpleNode(JJTADDITIVEEXPRESSION);
      boolean jjtc001 = true;
      jjtree.openNodeScope(jjtn001);
    try {
      MultiplicativeExpression();
      label_16:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PLUS:
        case MINUS:
          ;
          break;
        default:
          jj_la1[31] = jj_gen;
          break label_16;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PLUS:
          tok = jj_consume_token(PLUS);
          break;
        case MINUS:
          tok = jj_consume_token(MINUS);
          break;
        default:
          jj_la1[32] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
            jjtn001.addAttribute("operator", tok);
        MultiplicativeExpression();
      }
    } catch (Throwable jjte001) {
      if (jjtc001) {
        jjtree.clearNodeScope(jjtn001);
        jjtc001 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte001 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte001;}
      }
      if (jjte001 instanceof ParseException) {
        {if (true) throw (ParseException)jjte001;}
      }
      {if (true) throw (Error)jjte001;}
    } finally {
      if (jjtc001) {
        jjtree.closeNodeScope(jjtn001, jjtree.nodeArity() > 1);
      }
    }
  }

  final public void MultiplicativeExpression() throws ParseException {
    Token tok;
  SimpleNode jjtn001 = new SimpleNode(JJTMULTIPLICATIVEEXPRESSION);
  boolean jjtc001 = true;
  jjtree.openNodeScope(jjtn001);
    try {
      UnaryExpression();
      label_17:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case STAR:
        case SLASH:
        case REM:
          ;
          break;
        default:
          jj_la1[33] = jj_gen;
          break label_17;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case STAR:
          tok = jj_consume_token(STAR);
          break;
        case SLASH:
          tok = jj_consume_token(SLASH);
          break;
        case REM:
          tok = jj_consume_token(REM);
          break;
        default:
          jj_la1[34] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jjtn001.addAttribute("operator", tok);
        UnaryExpression();
      }
    } catch (Throwable jjte001) {
  if (jjtc001) {
    jjtree.clearNodeScope(jjtn001);
    jjtc001 = false;
  } else {
    jjtree.popNode();
  }
  if (jjte001 instanceof RuntimeException) {
    {if (true) throw (RuntimeException)jjte001;}
  }
  if (jjte001 instanceof ParseException) {
    {if (true) throw (ParseException)jjte001;}
  }
  {if (true) throw (Error)jjte001;}
    } finally {
  if (jjtc001) {
    jjtree.closeNodeScope(jjtn001, jjtree.nodeArity() > 1);
  }
    }
  }

  final public void UnaryExpression() throws ParseException {
    Token tok = null;
  SimpleNode jjtn001 = new SimpleNode(JJTUNARYEXPRESSION);
  boolean jjtc001 = true;
  jjtree.openNodeScope(jjtn001);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PLUS:
          tok = jj_consume_token(PLUS);
          break;
        case MINUS:
          tok = jj_consume_token(MINUS);
          break;
        default:
          jj_la1[35] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      jjtn001.setAttribute("operator", tok);
        UnaryExpression();
        break;
      case INCR:
        PreIncrementExpression();
        break;
      case DECR:
        PreDecrementExpression();
        break;
      default:
        jj_la1[36] = jj_gen;
        if (jj_2_8(1)) {
          UnaryExpressionNotPlusMinus();
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } catch (Throwable jjte001) {
  if (jjtc001) {
    jjtree.clearNodeScope(jjtn001);
    jjtc001 = false;
  } else {
    jjtree.popNode();
  }
  if (jjte001 instanceof RuntimeException) {
    {if (true) throw (RuntimeException)jjte001;}
  }
  if (jjte001 instanceof ParseException) {
    {if (true) throw (ParseException)jjte001;}
  }
  {if (true) throw (Error)jjte001;}
    } finally {
  if (jjtc001) {
    jjtree.closeNodeScope(jjtn001,  tok != null);
  }
    }
  }

  final public void PreIncrementExpression() throws ParseException {
 /*@bgen(jjtree) PreIncrementExpression */
    SimpleNode jjtn000 = new SimpleNode(JJTPREINCREMENTEXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Token tok;
    try {
      tok = jj_consume_token(INCR);
             jjtn000.setAttribute("operator", tok);
      PrimaryExpression();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

  final public void PreDecrementExpression() throws ParseException {
 /*@bgen(jjtree) PreDecrementExpression */
    SimpleNode jjtn000 = new SimpleNode(JJTPREDECREMENTEXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Token tok;
    try {
      tok = jj_consume_token(DECR);
             jjtn000.setAttribute("operator", tok);
      PrimaryExpression();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

  final public void UnaryExpressionNotPlusMinus() throws ParseException {
    Token tok = null;
  SimpleNode jjtn001 = new SimpleNode(JJTUNARYEXPRESSIONNOTPLUSMINUS);
  boolean jjtc001 = true;
  jjtree.openNodeScope(jjtn001);
    try {
      if (castLookahead()) {
        CastExpression();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BANG:
        case TILDE:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case TILDE:
            tok = jj_consume_token(TILDE);
            break;
          case BANG:
            tok = jj_consume_token(BANG);
            break;
          default:
            jj_la1[37] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
      jjtn001.setAttribute("operator", tok);
          UnaryExpression();
          break;
        case BOOLEAN:
        case BYTE:
        case CHAR:
        case DOUBLE:
        case FALSE:
        case FLOAT:
        case INT:
        case LONG:
        case NEW:
        case NULL:
        case SHORT:
        case SUPER:
        case THIS:
        case TRUE:
        case VOID:
        case INTEGER_LITERAL:
        case FLOATING_POINT_LITERAL:
        case CHARACTER_LITERAL:
        case STRING_LITERAL:
        case IDENTIFIER:
        case LPAREN:
          PostfixExpression();
          break;
        default:
          jj_la1[38] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } catch (Throwable jjte001) {
  if (jjtc001) {
    jjtree.clearNodeScope(jjtn001);
    jjtc001 = false;
  } else {
    jjtree.popNode();
  }
  if (jjte001 instanceof RuntimeException) {
    {if (true) throw (RuntimeException)jjte001;}
  }
  if (jjte001 instanceof ParseException) {
    {if (true) throw (ParseException)jjte001;}
  }
  {if (true) throw (Error)jjte001;}
    } finally {
  if (jjtc001) {
    jjtree.closeNodeScope(jjtn001,  tok != null);
  }
    }
  }

  final public void PostfixExpression() throws ParseException {
    Token tok = null;
  SimpleNode jjtn001 = new SimpleNode(JJTPOSTFIXEXPRESSION);
  boolean jjtc001 = true;
  jjtree.openNodeScope(jjtn001);
    try {
      PrimaryExpression();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INCR:
      case DECR:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case INCR:
          tok = jj_consume_token(INCR);
          break;
        case DECR:
          tok = jj_consume_token(DECR);
          break;
        default:
          jj_la1[39] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[40] = jj_gen;
        ;
      }
    jjtree.closeNodeScope(jjtn001,  tok != null);
    jjtc001 = false;
    if (tok != null) jjtn001.setAttribute("operator", token);
    } catch (Throwable jjte001) {
  if (jjtc001) {
    jjtree.clearNodeScope(jjtn001);
    jjtc001 = false;
  } else {
    jjtree.popNode();
  }
  if (jjte001 instanceof RuntimeException) {
    {if (true) throw (RuntimeException)jjte001;}
  }
  if (jjte001 instanceof ParseException) {
    {if (true) throw (ParseException)jjte001;}
  }
  {if (true) throw (Error)jjte001;}
    } finally {
  if (jjtc001) {
    jjtree.closeNodeScope(jjtn001,  tok != null);
  }
    }
  }

  final public void CastExpression() throws ParseException {
                         /*@bgen(jjtree) CastExpression */
  SimpleNode jjtn000 = new SimpleNode(JJTCASTEXPRESSION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(LPAREN);
      Type();
      jj_consume_token(RPAREN);
      UnaryExpression();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

  final public void PrimaryExpression() throws ParseException {
  SimpleNode jjtn001 = new SimpleNode(JJTPRIMARYEXPRESSION);
  boolean jjtc001 = true;
  jjtree.openNodeScope(jjtn001);
    try {
      PrimaryPrefix();
      label_18:
      while (true) {
        if (jj_2_9(2147483647)) {
          ;
        } else {
          break label_18;
        }
        PrimarySuffix();
      }
    } catch (Throwable jjte001) {
  if (jjtc001) {
    jjtree.clearNodeScope(jjtn001);
    jjtc001 = false;
  } else {
    jjtree.popNode();
  }
  if (jjte001 instanceof RuntimeException) {
    {if (true) throw (RuntimeException)jjte001;}
  }
  if (jjte001 instanceof ParseException) {
    {if (true) throw (ParseException)jjte001;}
  }
  {if (true) throw (Error)jjte001;}
    } finally {
  if (jjtc001) {
    jjtree.closeNodeScope(jjtn001, jjtree.nodeArity() > 0);
  }
    }
  }

  final public void PrimaryPrefix() throws ParseException {
 /*@bgen(jjtree) PrimaryPrefix */
  SimpleNode jjtn000 = new SimpleNode(JJTPRIMARYPREFIX);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token tok;
  String name = "";
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FALSE:
      case NULL:
      case TRUE:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
        Literal();
        break;
      case THIS:
        tok = jj_consume_token(THIS);
               jjtree.closeNodeScope(jjtn000, true);
               jjtc000 = false;
               jjtn000.setAttribute("this", "this");
        break;
      default:
        jj_la1[42] = jj_gen;
        if (jj_2_10(2147483647)) {
          label_19:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case IDENTIFIER:
              ;
              break;
            default:
              jj_la1[41] = jj_gen;
              break label_19;
            }
            tok = jj_consume_token(IDENTIFIER);
            jj_consume_token(DOT);
        name = name + tok.image + ".";
          }
          jj_consume_token(SUPER);
          jj_consume_token(DOT);
          tok = jj_consume_token(IDENTIFIER);
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.setAttribute("qualifier", (name.length() > 0) ? name.substring(0, name.length() - 1) : "");
    name = name + "super." + tok.image;
    jjtn000.setAttribute("identifier", tok.image);
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LPAREN:
            tok = jj_consume_token(LPAREN);
            Expression();
            tok = jj_consume_token(RPAREN);
            break;
          case NEW:
            AllocationExpression();
            break;
          default:
            jj_la1[43] = jj_gen;
            if (jj_2_11(2147483647)) {
              ResultType();
              jj_consume_token(DOT);
              jj_consume_token(CLASS);
            } else {
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case IDENTIFIER:
                Name();
                break;
              default:
                jj_la1[44] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
            }
          }
        }
      }
    } catch (Throwable jjte000) {
  if (jjtc000) {
    jjtree.clearNodeScope(jjtn000);
    jjtc000 = false;
  } else {
    jjtree.popNode();
  }
  if (jjte000 instanceof RuntimeException) {
    {if (true) throw (RuntimeException)jjte000;}
  }
  if (jjte000 instanceof ParseException) {
    {if (true) throw (ParseException)jjte000;}
  }
  {if (true) throw (Error)jjte000;}
    } finally {
  if (jjtc000) {
    jjtree.closeNodeScope(jjtn000, true);
  }
    }
  }

  final public void PrimarySuffix() throws ParseException {
 /*@bgen(jjtree) PrimarySuffix */
    SimpleNode jjtn000 = new SimpleNode(JJTPRIMARYSUFFIX);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Token tok;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOT:
        tok = jj_consume_token(DOT);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case THIS:
          tok = jj_consume_token(THIS);
                      jjtree.closeNodeScope(jjtn000, true);
                      jjtc000 = false;
                      jjtn000.setAttribute("token", tok);
          break;
        case SUPER:
          tok = jj_consume_token(SUPER);
                      jjtree.closeNodeScope(jjtn000, true);
                      jjtc000 = false;
                      jjtn000.setAttribute("token", tok);
          break;
        case NEW:
          AllocationExpression();
          break;
        case IDENTIFIER:
        case LT:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LT:
            ReferenceTypeList();
            break;
          default:
            jj_la1[45] = jj_gen;
            ;
          }
          tok = jj_consume_token(IDENTIFIER);
                         jjtree.closeNodeScope(jjtn000, true);
                         jjtc000 = false;
                         jjtn000.setAttribute("token", tok);
          break;
        default:
          jj_la1[46] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      case LBRACKET:
        tok = jj_consume_token(LBRACKET);
                      jjtn000.setAttribute("token", tok);
        Expression();
        tok = jj_consume_token(RBRACKET);
        break;
      case LPAREN:
        Arguments();
        break;
      case LT:
        ReferenceTypeList();
        break;
      default:
        jj_la1[47] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

  final public void Literal() throws ParseException {
 /*@bgen(jjtree) Literal */
    SimpleNode jjtn000 = new SimpleNode(JJTLITERAL);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Token tok = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTEGER_LITERAL:
        tok = jj_consume_token(INTEGER_LITERAL);
        break;
      case FLOATING_POINT_LITERAL:
        tok = jj_consume_token(FLOATING_POINT_LITERAL);
        break;
      case CHARACTER_LITERAL:
        tok = jj_consume_token(CHARACTER_LITERAL);
        break;
      case STRING_LITERAL:
        tok = jj_consume_token(STRING_LITERAL);
        break;
      case FALSE:
      case TRUE:
        BooleanLiteral();
        break;
      case NULL:
        NullLiteral();
        break;
      default:
        jj_la1[48] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    if (tok != null) jjtn000.setAttribute("token", tok);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

  final public void BooleanLiteral() throws ParseException {
 /*@bgen(jjtree) BooleanLiteral */
    SimpleNode jjtn000 = new SimpleNode(JJTBOOLEANLITERAL);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Token tok;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        tok = jj_consume_token(TRUE);
        break;
      case FALSE:
        tok = jj_consume_token(FALSE);
        break;
      default:
        jj_la1[49] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.setAttribute("token", tok);
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

  final public void NullLiteral() throws ParseException {
                      /*@bgen(jjtree) NullLiteral */
  SimpleNode jjtn000 = new SimpleNode(JJTNULLLITERAL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(NULL);
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.setAttribute("token", token);
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

  final public void Arguments() throws ParseException {
                    /*@bgen(jjtree) Arguments */
  SimpleNode jjtn000 = new SimpleNode(JJTARGUMENTS);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(LPAREN);
      if (jj_2_12(1)) {
        ArgumentList();
      } else {
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        jj_consume_token(COMMA);
        break;
      default:
        jj_la1[50] = jj_gen;
        ;
      }
      jj_consume_token(RPAREN);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

  final public void ArgumentList() throws ParseException {
                       /*@bgen(jjtree) ArgumentList */
  SimpleNode jjtn000 = new SimpleNode(JJTARGUMENTLIST);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      Expression();
      label_20:
      while (true) {
        if (expressionLookahead()) {
          ;
        } else {
          break label_20;
        }
        jj_consume_token(COMMA);
        Expression();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

  final public void AllocationExpression() throws ParseException {
                               /*@bgen(jjtree) AllocationExpression */
  SimpleNode jjtn000 = new SimpleNode(JJTALLOCATIONEXPRESSION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(NEW);
      if (jj_2_13(2147483647)) {
        ClassOrInterfaceType();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACKET:
          ArrayDimsAndInits();
          break;
        case LPAREN:
          Arguments();
          break;
        default:
          jj_la1[51] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BOOLEAN:
        case BYTE:
        case CHAR:
        case DOUBLE:
        case FLOAT:
        case INT:
        case LONG:
        case SHORT:
          PrimitiveType();
          ArrayDimsAndInits();
          break;
        default:
          jj_la1[52] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

/*
 * The third LOOKAHEAD specification below is to parse to PrimarySuffix
 * if there is an expression between the "[...]".
 */
  final public void ArrayDimsAndInits() throws ParseException {
 /*@bgen(jjtree) ArrayDimsAndInits */
    SimpleNode jjtn000 = new SimpleNode(JJTARRAYDIMSANDINITS);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);int arrayCount = 0;
    try {
      if (jj_2_16(2)) {
        label_21:
        while (true) {
          jj_consume_token(LBRACKET);
          Expression();
          jj_consume_token(RBRACKET);
       arrayCount++;
          if (jj_2_14(2)) {
            ;
          } else {
            break label_21;
          }
        }
        label_22:
        while (true) {
          if (jj_2_15(4)) {
            ;
          } else {
            break label_22;
          }
          jj_consume_token(LBRACKET);
          jj_consume_token(RBRACKET);
       arrayCount++;
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACKET:
          label_23:
          while (true) {
            jj_consume_token(LBRACKET);
            jj_consume_token(RBRACKET);
       arrayCount++;
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case LBRACKET:
              ;
              break;
            default:
              jj_la1[53] = jj_gen;
              break label_23;
            }
          }
          ArrayInitializer();
      jjtn000.setAttribute("initializers", Boolean.TRUE);
          break;
        default:
          jj_la1[54] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.setAttribute("dimensions", new Integer(arrayCount));
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  final private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  final private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  final private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  final private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  final private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  final private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  final private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  final private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  final private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  final private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  final private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  final private boolean jj_2_13(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_13(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  final private boolean jj_2_14(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_14(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  final private boolean jj_2_15(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_15(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  final private boolean jj_2_16(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_16(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  final private boolean jj_3_3() {
    if (jj_3R_25()) return true;
    return false;
  }

  final private boolean jj_3R_100() {
    if (jj_3R_101()) return true;
    return false;
  }

  final private boolean jj_3R_93() {
    if (jj_3R_96()) return true;
    return false;
  }

  final private boolean jj_3R_92() {
    if (jj_3R_95()) return true;
    return false;
  }

  final private boolean jj_3R_33() {
    if (jj_scan_token(DOT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_48()) jj_scanpos = xsp;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  final private boolean jj_3R_56() {
    if (jj_scan_token(LBRACE)) return true;
    return false;
  }

  final private boolean jj_3R_87() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(71)) {
    jj_scanpos = xsp;
    if (jj_scan_token(75)) {
    jj_scanpos = xsp;
    if (jj_scan_token(77)) {
    jj_scanpos = xsp;
    if (jj_scan_token(78)) {
    jj_scanpos = xsp;
    if (jj_3R_92()) {
    jj_scanpos = xsp;
    if (jj_3R_93()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3_1() {
    if (jj_3R_24()) return true;
    return false;
  }

  final private boolean jj_3R_40() {
    if (jj_3R_56()) return true;
    return false;
  }

  final private boolean jj_3R_25() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_40()) {
    jj_scanpos = xsp;
    if (jj_3_1()) return true;
    }
    return false;
  }

  final private boolean jj_3R_24() {
    if (jj_3R_39()) return true;
    return false;
  }

  final private boolean jj_3R_52() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  final private boolean jj_3R_32() {
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(LT)) return true;
    return false;
  }

  final private boolean jj_3R_99() {
    if (jj_3R_100()) return true;
    return false;
  }

  final private boolean jj_3_7() {
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  final private boolean jj_3R_85() {
    if (jj_scan_token(SUPER)) return true;
    return false;
  }

  final private boolean jj_3R_44() {
    if (jj_3R_26()) return true;
    return false;
  }

  final private boolean jj_3R_84() {
    if (jj_scan_token(EXTENDS)) return true;
    return false;
  }

  final private boolean jj_3R_67() {
    if (jj_3R_66()) return true;
    return false;
  }

  final private boolean jj_3R_75() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_84()) {
    jj_scanpos = xsp;
    if (jj_3R_85()) return true;
    }
    if (jj_3R_26()) return true;
    return false;
  }

  final private boolean jj_3R_54() {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_52()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_67()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_53() {
    if (jj_3R_66()) return true;
    return false;
  }

  final private boolean jj_3R_43() {
    if (jj_scan_token(HOOK)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_75()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_38() {
    if (jj_3R_52()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_53()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_54()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3_11() {
    if (jj_3R_36()) return true;
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(CLASS)) return true;
    return false;
  }

  final private boolean jj_3R_27() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_43()) {
    jj_scanpos = xsp;
    if (jj_3R_44()) return true;
    }
    return false;
  }

  final private boolean jj_3R_98() {
    if (jj_3R_99()) return true;
    return false;
  }

  final private boolean jj_3R_31() {
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(NEW)) return true;
    return false;
  }

  final private boolean jj_3R_83() {
    if (jj_3R_90()) return true;
    return false;
  }

  final private boolean jj_3_6() {
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  final private boolean jj_3R_82() {
    if (jj_3R_36()) return true;
    return false;
  }

  final private boolean jj_3R_81() {
    if (jj_3R_89()) return true;
    return false;
  }

  final private boolean jj_3R_64() {
    if (jj_scan_token(RUNSIGNEDSHIFT)) return true;
    return false;
  }

  final private boolean jj_3R_90() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  final private boolean jj_3R_80() {
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_63() {
    if (jj_scan_token(RSIGNEDSHIFT)) return true;
    return false;
  }

  final private boolean jj_3R_35() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  final private boolean jj_3R_30() {
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(SUPER)) return true;
    return false;
  }

  final private boolean jj_3_10() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_35()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(SUPER)) return true;
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  final private boolean jj_3R_97() {
    if (jj_3R_98()) return true;
    return false;
  }

  final private boolean jj_3R_88() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  final private boolean jj_3R_62() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_27()) return true;
    return false;
  }

  final private boolean jj_3R_51() {
    if (jj_3R_65()) return true;
    return false;
  }

  final private boolean jj_3R_79() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_88()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(SUPER)) return true;
    return false;
  }

  final private boolean jj_3R_36() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_50()) {
    jj_scanpos = xsp;
    if (jj_3R_51()) return true;
    }
    return false;
  }

  final private boolean jj_3R_50() {
    if (jj_scan_token(VOID)) return true;
    return false;
  }

  final private boolean jj_3R_78() {
    if (jj_scan_token(THIS)) return true;
    return false;
  }

  final private boolean jj_3R_29() {
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(THIS)) return true;
    return false;
  }

  final private boolean jj_3_9() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_29()) {
    jj_scanpos = xsp;
    if (jj_3R_30()) {
    jj_scanpos = xsp;
    if (jj_3R_31()) {
    jj_scanpos = xsp;
    if (jj_scan_token(82)) {
    jj_scanpos = xsp;
    if (jj_scan_token(86)) {
    jj_scanpos = xsp;
    if (jj_3R_32()) {
    jj_scanpos = xsp;
    if (jj_3R_33()) {
    jj_scanpos = xsp;
    if (jj_3R_34()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_77() {
    if (jj_3R_87()) return true;
    return false;
  }

  final private boolean jj_3R_49() {
    if (jj_scan_token(LT)) return true;
    if (jj_3R_27()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_62()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(93)) {
    jj_scanpos = xsp;
    if (jj_3R_63()) {
    jj_scanpos = xsp;
    if (jj_3R_64()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_94() {
    if (jj_3R_97()) return true;
    return false;
  }

  final private boolean jj_3R_74() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_77()) {
    jj_scanpos = xsp;
    if (jj_3R_78()) {
    jj_scanpos = xsp;
    if (jj_3R_79()) {
    jj_scanpos = xsp;
    if (jj_3R_80()) {
    jj_scanpos = xsp;
    if (jj_3R_81()) {
    jj_scanpos = xsp;
    if (jj_3R_82()) {
    jj_scanpos = xsp;
    if (jj_3R_83()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_91() {
    if (jj_3R_94()) return true;
    return false;
  }

  final private boolean jj_3R_69() {
    if (jj_3R_74()) return true;
    return false;
  }

  final private boolean jj_3R_58() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(20)) {
    jj_scanpos = xsp;
    if (jj_scan_token(25)) {
    jj_scanpos = xsp;
    if (jj_scan_token(22)) {
    jj_scanpos = xsp;
    if (jj_scan_token(56)) {
    jj_scanpos = xsp;
    if (jj_scan_token(45)) {
    jj_scanpos = xsp;
    if (jj_scan_token(47)) {
    jj_scanpos = xsp;
    if (jj_scan_token(38)) {
    jj_scanpos = xsp;
    if (jj_scan_token(31)) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_60() {
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_86() {
    if (jj_3R_91()) return true;
    return false;
  }

  final private boolean jj_3R_72() {
    if (jj_scan_token(RUNSIGNEDSHIFT)) return true;
    return false;
  }

  final private boolean jj_3R_61() {
    if (jj_3R_69()) return true;
    return false;
  }

  final private boolean jj_3R_71() {
    if (jj_scan_token(RSIGNEDSHIFT)) return true;
    return false;
  }

  final private boolean jj_3_15() {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  final private boolean jj_3R_76() {
    if (jj_3R_86()) return true;
    return false;
  }

  final private boolean jj_3R_47() {
    if (jj_3R_61()) return true;
    return false;
  }

  final private boolean jj_3_14() {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_24()) return true;
    return false;
  }

  final private boolean jj_3_5() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_27()) return true;
    return false;
  }

  final private boolean jj_3_16() {
    Token xsp;
    if (jj_3_14()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_14()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_46() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(96)) {
    jj_scanpos = xsp;
    if (jj_scan_token(95)) return true;
    }
    return false;
  }

  final private boolean jj_3R_45() {
    if (jj_3R_60()) return true;
    return false;
  }

  final private boolean jj_3R_73() {
    if (jj_3R_76()) return true;
    return false;
  }

  final private boolean jj_3R_66() {
    if (jj_scan_token(LT)) return true;
    if (jj_3R_27()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_5()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(93)) {
    jj_scanpos = xsp;
    if (jj_3R_71()) {
    jj_scanpos = xsp;
    if (jj_3R_72()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_28() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = castLookahead();
    lookingAhead = false;
    if (!jj_semLA || jj_3R_45()) {
    jj_scanpos = xsp;
    if (jj_3R_46()) {
    jj_scanpos = xsp;
    if (jj_3R_47()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_106() {
    if (jj_scan_token(DECR)) return true;
    return false;
  }

  final private boolean jj_3_13() {
    if (jj_3R_38()) return true;
    return false;
  }

  final private boolean jj_3R_59() {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  final private boolean jj_3R_68() {
    if (jj_3R_73()) return true;
    return false;
  }

  final private boolean jj_3R_105() {
    if (jj_scan_token(INCR)) return true;
    return false;
  }

  final private boolean jj_3R_42() {
    if (jj_3R_58()) return true;
    Token xsp;
    if (jj_3R_59()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_59()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_57() {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  final private boolean jj_3R_34() {
    if (jj_3R_49()) return true;
    return false;
  }

  final private boolean jj_3R_89() {
    if (jj_scan_token(NEW)) return true;
    return false;
  }

  final private boolean jj_3_8() {
    if (jj_3R_28()) return true;
    return false;
  }

  final private boolean jj_3R_41() {
    if (jj_3R_38()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_57()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_26() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_41()) {
    jj_scanpos = xsp;
    if (jj_3R_42()) return true;
    }
    return false;
  }

  final private boolean jj_3R_55() {
    if (jj_3R_68()) return true;
    return false;
  }

  final private boolean jj_3R_104() {
    if (jj_3R_106()) return true;
    return false;
  }

  final private boolean jj_3R_103() {
    if (jj_3R_105()) return true;
    return false;
  }

  final private boolean jj_3R_37() {
    if (jj_3R_24()) return true;
    return false;
  }

  final private boolean jj_3R_70() {
    if (jj_3R_58()) return true;
    return false;
  }

  final private boolean jj_3_12() {
    if (jj_3R_37()) return true;
    return false;
  }

  final private boolean jj_3R_102() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(107)) {
    jj_scanpos = xsp;
    if (jj_scan_token(108)) return true;
    }
    return false;
  }

  final private boolean jj_3_4() {
    if (jj_3R_26()) return true;
    return false;
  }

  final private boolean jj_3R_101() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_102()) {
    jj_scanpos = xsp;
    if (jj_3R_103()) {
    jj_scanpos = xsp;
    if (jj_3R_104()) {
    jj_scanpos = xsp;
    if (jj_3_8()) return true;
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_65() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_4()) {
    jj_scanpos = xsp;
    if (jj_3R_70()) return true;
    }
    return false;
  }

  final private boolean jj_3R_39() {
    if (jj_3R_55()) return true;
    return false;
  }

  final private boolean jj_3R_96() {
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  final private boolean jj_3R_95() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(66)) {
    jj_scanpos = xsp;
    if (jj_scan_token(35)) return true;
    }
    return false;
  }

  final private boolean jj_3_2() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_25()) return true;
    return false;
  }

  final private boolean jj_3R_48() {
    if (jj_3R_49()) return true;
    return false;
  }

  public JavaParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[55];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static {
      jj_la1_0();
      jj_la1_1();
      jj_la1_2();
      jj_la1_3();
      jj_la1_4();
   }
   private static void jj_la1_0() {
      jj_la1_0 = new int[] {0x0,0x0,0x0,0x0,0x82500000,0x0,0x0,0x82500000,0x0,0x0,0x82500000,0x0,0x82500000,0x82500000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x82500000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x82500000,0x0,0x0,};
   }
   private static void jj_la1_1() {
      jj_la1_1 = new int[] {0x0,0x0,0x8000004,0x8000004,0x100a040,0x0,0x0,0x100a040,0x0,0x0,0x100a040,0x0,0x100a040,0x100a040,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4906a048,0x0,0x0,0x0,0x40040008,0x20000,0x0,0x0,0x48020000,0x0,0x40008,0x8,0x0,0x0,0x100a040,0x0,0x0,};
   }
   private static void jj_la1_2() {
      jj_la1_2 = new int[] {0x2000000,0x20000000,0x0,0x0,0x8000,0x100000,0x2000000,0x0,0x400000,0x400000,0x8000,0x20000000,0x0,0x8010,0x40000000,0x40000000,0x10000000,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x60000000,0x60000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x8004e894,0x0,0x0,0x8000,0x6884,0x40000,0x8000,0x40000000,0x40008000,0x44440000,0x6884,0x4,0x2000000,0x440000,0x0,0x400000,0x400000,};
   }
   private static void jj_la1_3() {
      jj_la1_3 = new int[] {0x0,0x300000,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x300000,0x0,0x0,0x0,0x0,0xffc00000,0xffc00000,0x2,0x80,0x100,0x10000,0x20000,0x8000,0x48,0x48,0x0,0x30,0x30,0x380000,0x380000,0x1800,0x1800,0x46000,0x46000,0x1800,0x1e00,0x1,0x1,0x600,0x600,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_4() {
      jj_la1_4 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[16];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  public JavaParser(java.io.InputStream stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new JavaParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 55; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 55; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public JavaParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new JavaParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 55; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 55; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public JavaParser(JavaParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 55; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(JavaParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 55; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector<int[]> jj_expentries = new java.util.Vector<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration<int[]> e = jj_expentries.elements(); e.hasMoreElements();) {
        int[] oldentry = e.nextElement();
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[130];
    for (int i = 0; i < 130; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 55; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
          if ((jj_la1_4[i] & (1<<j)) != 0) {
            la1tokens[128+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 130; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

  final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 16; i++) {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
            case 12: jj_3_13(); break;
            case 13: jj_3_14(); break;
            case 14: jj_3_15(); break;
            case 15: jj_3_16(); break;
          }
        }
        p = p.next;
      } while (p != null);
    }
    jj_rescan = false;
  }

  final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
