/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	Copyright 1998-2002 Anton Vinokurov <anton@netams.com>
***	Copyright 2002-2008 NeTAMS Development Team
***	This code is GPL v3
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: lib.h,v 1.6 2008-02-23 08:35:05 anton Exp $ */

#ifndef __LIB_H
#define __LIB_H

#ifdef SOLARIS

int daemon(int nochdir, int noclose);
int vasprintf(char **ret, const char *format, va_list ap);
int asprintf(char **str, char const *fmt, ...);
struct ether_addr *ether_aton(const char *a);
char *ether_ntoa(const struct ether_addr *n);
char *strcasestr(const char *s, const char *find);

#endif

/////////////////////////////////////////////////////////////////////////////////////////
//below obtained from flow-tools
#define FT_SO_RCV_BUFSIZE      (4*1024*1024) /* UDP recv socket buffer size */

int bigsockbuf(int fd, int dir, int size);
u_short CRC16(u_char *idx, u_char idx_size);
/////////////////////////////////////////////////////////////////////////////////////////
#define POLL_TIMEOUT	1000
#define SET_POLL(socket) struct pollfd pfd; pfd.fd=socket; pfd.events = POLLIN;
#define CHECK_POLL(service,status) { 									\
	if ((status = poll(&pfd, 1, POLL_TIMEOUT)) < 0 ) {					\
		if(errno != EINTR) aLog(D_ERR, "%s:%u poll: %s\n", 	\
			service->getName(), service->instance, strerror(errno));	\
		continue; 									\
	}										\
}

// from codeproject.com
#define ntohll(x) (((u_int64_t)(ntohl((u_int32_t)((x << 32) >> 32))) << 32) | \
                     (u_int32_t)ntohl(((u_int32_t)(x >> 32)))) //By Runner
#define htonll(x) ntohll(x)
///////////////////////////////////////////////////////////////////////////////////////// 

#define STRSTR(str1, str2)	(str1 && str2 && strstr(str1, str2))

#define STREQ(str1, str2)	(str1 && str2 && !strcasecmp(str1, str2))
#define STRNEQ(str1, str2, n)	(str1 && str2 && !strncasecmp(str1, str2, n))

#define STRARG(param, word)							\
		(param && *(&param + 1) && !strcasecmp(param, word)) ?		\
		*(&param + 1) :  NULL					

#define STRNARG(param, word, n)							\
		(param && *(&param + 1) && !strncasecmp(param, word, n)) ?	\
		*(&param + 1) :  NULL

#endif
