#!/usr/bin/perl
#
#-----------------------------------------------------------------------------
# $Id: netams_graph.cgi,v 1.15 2006-10-27 11:49:25 rav Exp $
# Contributed to NeTAMS project by A.Rudenko aka RAV (2006/09/25)
#-----------------------------------------------------------------------------

$setfile = "/tmp/graph.set";	#     (  )

use CGI;
use GD::Graph::mixed;		#  : cpan -i GD::Graph
require "config.cgi";
require "statistic.pl";		# sub

$cgi = new CGI;

my ($i,$s,@v,$unit_str,$policy_str,$year_str,$month_str,$week_str,$day_str,$error);
$error	= "";
$db 	= bdconnect();
@unit 	= @policy = @year = @month = @week = @day = ();			# global
$tmpfile= $cgi->param("file"); $tmpfile="" if ! defined $tmpfile;	#  
	if ( $tmpfile ne "" ) {
		open(F,"< $tmpfile") || error_image("File '$tmpfile' not found!!!");
		close(F);
		require $tmpfile }
	else {
		open(F,"< $setfile") || error_image("File '$setfile' not found. Run /admin/statistic.cgi");
		close(F);
		require $setfile }
$unit_str  = $cgi->param("oid");  $unit_str   = "" if ! defined $unit_str;
	if  ($unit_str ne "") 	
		{@unit = split(/\,/,$unit_str)  } else { $error.="Unit OID not set!!! " }
$policy_str= $cgi->param("policy");$policy_str = "" if ! defined $policy_str;
	if  ($policy_str ne "") 
		{@policy=split(/\,/,$policy_str)} else { @policy=pol_db(@unit) }
$error 	  .= "Policy OID not set!!!" if scalar(@policy)==0;
		error_image($error) if $error ne ""; #   OID  Policy - 
$year_str  = $cgi->param("year"); $year_str = "" if ! defined $year_str;
	if ($year_str ne "") {
		$year_str=~tr/0-9\-,//cd;
		@year=split(/\,/,$year_str);
		for ($i=0;$i<scalar(@year);$i++) {
			if ( $year[$i] ne "" ) {
				$year[$i]+=`date +%Y` if $year[$i] <= 0;$year[$i]=2001 if $year[$i] < 2001;}
			else {$year[$i] =`date +%Y`+0;}
    		}
	}
	@year	= (`date +%Y`+0) if scalar(@year)==0;												#   ,  
$week_str  = $cgi->param("week"); $week_str = "" if ! defined $week_str;
	if ($week_str ne "") {
		@v=split(/\,/,$week_str);
		for $s (@v) {
			next if $s eq "";
			$s=day2week(split(/-/,substr($s,4))) if $s =~ "d2w-";
			$s=~tr/0-9\-,//cd;
			$s+=`date +%W`+1 if $s <= 0;
			$s=1 if $s <= 0;
			push(@week,$s)
		}
	}
$day_str   = $cgi->param("day"); $day_str="" if ! defined $day_str;
	if ($day_str ne "") {
		$day_str=~tr/0-9\-,//cd;
		@v=split(/\,/,$day_str);
		for $s (@v) 
			{ next if $s eq ""; $s+=`date +%d` if $s <= 0; $s=1 if $s <= 0; push(@day,$s) }
	}
$month_str = $cgi->param("month"); $month_str = "" if ! defined $month_str;
	if ($month_str ne "") {
		$month_str=~tr/0-9\-,//cd;
		@v=split(/\,/,$month_str);
		for $s (@v) 
			{ next if $s eq ""; $s+=`date +%m` if $s <= 0; $s=1 if $s <= 0; push(@month,$s) }
	}
	@month	= (`date +%m`+0) if scalar(@day) > 0 and scalar(@month) == 0;	# day set, month not set

$inout	= $cgi->param("inout"); $inout="" 	if ! defined $inout; #  ,    $set->{in_out}
$oids	= $cgi->param("oids");  $oids="policy" 	if ! defined $oids or ( $oids ne "unit" and $oids ne "sum" );

my (@sort_data, @sort_legend, @types, $mybars);
%data 	= %count = %set = @sort_data = @sort_legend = @types = ();
$x_l	= $y_l 	 = "";			# global
$step	= $all_traff = $mybars = 0;	# global
$name_gr= "NeTAMS Graphic analisys.";	# global
if  ( $oids ne "sum" )
	{ data_oid($oids, $year[0], scalar(@month)>0?$month[0]:"", scalar(@week)>0?$week[0]:"", scalar(@day)>0?$day[0]:"") }
else	{ $x_l=data_sum()."    ".$x_l } #          $set=$settings{ }

@sort_data = ( [1..$step] );
my @str = sort {$count{$b} <=> $count{$a}} keys(%count);				#        
if (scalar(@str)==0) {error_image("No data for sets!!!") }				#     ( ) -    OID
if ($set->{types} eq 'percent') {							#     (   ,  )
	proc_graph($step, @str);
	$mybars = $set->{cumulate} = $set->{overwrite} = 1;
	$set->{show_v} 	= 0;
	$set->{types}  	= 'bars';
	$y_l		= "Percent";
}else{
	if  ( $set->{cumulate} and ($set->{types} eq 'area' or $set->{types} eq 'bars') ) {
		$set->{overwrite}=1 if $set->{types} eq 'bars'; $y_l="Cumulate " } # cumulate   area  bars,   overwrite   bars
	else{ $set->{cumulate} = $set->{overwrite} = 0}
	$y_l.= ($set->{kmgt} ne "B"?$set->{kmgt}:"") . "Bytes";
}
$y_l .= " ( Sum " . b2m($all_traff, "", 1) . " )";
for $s (@str){
	last if ( !$count{$s} and !$set->{show_zero} );					# not show legend if sum a zero
	@sort_data  = ( @sort_data, $data{$s} );
	@sort_legend= ( @sort_legend, b2m($count{$s}, "", 1) . " " . $s );
	@types	    = ( @types, $set->{types} );
}
if ( scalar(@types) == 0) { error_image("All data for sets is zero!!!") }		# all Data is zero

	$gr = GD::Graph::mixed->new( $set->{width}, $set->{hight} );
	$gr->set_title_font  (gd_font($set->{font_t}));
	$gr->set_legend_font (gd_font($set->{font_l}));
	$gr->set_values_font (gd_font($set->{font_v}));
	$gr->set_x_label_font(gd_font($set->{font_xl}));
	$gr->set_y_label_font(gd_font($set->{font_yl}));
	$gr->set_x_axis_font (gd_font($set->{font_x}));
	$gr->set_y_axis_font (gd_font($set->{font_y}));
	$gr->set(
		show_values	=>	$set->{show_v},
		values_vertical	=>	$set->{v_vert},
		long_ticks	=>	$set->{ticks},
		cumulate	=>	$set->{cumulate},
		overwrite	=>	$set->{overwrite},
		x_label 	=> 	$x_l,
		y_label 	=> 	$y_l,
		title		=>	$name_gr,
		types		=>	[@types],
		y_max_value	=>	$mybars?100:$set->{y_max_v},
		);
	$gr->set_legend( @sort_legend );
	$im = $gr->plot( \@sort_data );
	print "Content-type: image/png\n\n";
	print $im->png;
exit;

############################################################
sub data_sum {									#      
	my ($name,$k,$where,@legend,$i,$j,$st,@v);
	$name_gr .= " The period - "; $st = " Units:";
	for ( $i = scalar(@unit)-1; $i >= 0; $i-- ) {
		$name = oid_name( hex $unit[$i] ); next if $name eq "";
		push( @v, "unit_oid=" . hex($unit[$i]) );
		$st  .= $name . "(" . $unit[$i] . ")";
		$st  .= "," if $i>0;
	}
	error_image("No data for set Units!!!")  if scalar(@v) == 0;		#   OID
	$where	= "(" . join(" OR ", @v) . ") AND (";
	@v	= ();
	$st	.= " Policys:";
	for ( $i = scalar(@policy)-1; $i >= 0; $i-- ) {
		$name = oid_name(hex $policy[$i]); next if $name eq "";
		push( @v, "policy_oid=" . hex($policy[$i]) );
		$st  .= $name."(".$policy[$i].")";
		$st  .= "," if $i>0;
	}
	error_image("No data for set Policys!!!") if scalar(@v) == 0;		#   OID
	$where  .= join(" OR ",@v) . ")";
	if 	( scalar(@day) == 0 and scalar(@week) == 0 and scalar(@month) == 0 )
		{ $step = 12; $x_l = "Months of year"; $name_gr .= "year"; $set = $settings{'year_sum'};
		for ( $k = 0; $k < scalar(@year); $k++ ) {
			$legend[$k] = "Year " . $year[$k];
			db_data($where, $legend[$k], $step, $year[$k], "", "", "", $inout, $set->{kmgt});
		}
	}elsif 	( scalar(@day) == 0 and scalar(@week) == 0)
		{ $step = 31; $x_l = "Days of month "; $name_gr .= "month"; $set = $settings{'month_sum'};
		for ( $i = 0; $i < scalar(@year); $i++ ) { for ( $k = 0; $k < scalar(@month); $k++ ) {
			$legend[$k] = "Month " . $month[$k] . " Year " . $year[$i];
			db_data($where, $legend[$k], $step, $year[$i], $month[$k], "", "", $inout, $set->{kmgt});
		}	}
	}elsif 	( scalar(@week) > 0)
	 	{ $step = 7;  $x_l = "Days of week"; $name_gr .= "week"; $set = $settings{'week_sum'};
		for ( $i = 0; $i < scalar(@year); $i++ ) { for ( $k = 0; $k < scalar(@week); $k++ ) {
			$legend[$k] = "Week " . $week[$k] . sprintf(" (from %04d-%02d-%02d", dn_week($year[$i],$week[$k],1)) . ")";
			db_data($where, $legend[$k], $step, $year[$i], "", $week[$k], "", $inout, $set->{kmgt});
		}	}
	}else
		{ $step = 24; $x_l = "Hours of day"; $name_gr .= "day"; $set = $settings{'day_sum'};
		for ( $i = 0; $i < scalar(@year); $i++ ) { for ( $j = 0; $j < scalar(@month); $j++ ) { for ( $k = 0; $k < scalar(@day); $k++ ) {
	    		$legend[$k] = "Day " . $day[$k] . " Month " . $month[$j] . " Year " . $year[$i];
	    		db_data($where, $legend[$k], $step, $year[$i], $month[$j], "", $day[$k], $inout, $set->{kmgt});
		}   }	}
	}
	return $st;
}

############################################################
sub data_oid {									#      Unit  Policy
	my ($oids,$year,$month,$week,$day)=@_;
	my (@oid,$name,$k,$where,@legend,$graph,@v,$st,$wher);
	if ($oids eq "policy"){
		@oid=@policy;
		$name_gr .= " Unit ";
		for $st (@unit) {
			$name = oid_name( hex $st );
			next if $name eq "";
			$name_gr .= $name . " (" . $st . ") ";
			push(@v,"unit_oid=".hex($st));
		}
	}else{
		@oid=@unit;
		$name_gr .= " Policy ";
		for $st (@policy) {
			$name = oid_name( hex $st );
			next if $name eq "";
			$name_gr .= $name . " (" . $st . ") ";
			push(@v,"policy_oid=".hex($st));
		}
	}
	error_image("$oids not set!!!") if scalar(@v) == 0;
	$wher = " (".join(" OR ",@v).") ";

	if    	($day eq "" and $week eq "" and $month eq "")
			{$step=12;$x_l = "Months of year ".$year;$graph='year'."_".$oids}
	elsif 	($day eq "" and $week eq "")
			{$step=last_day($month,$year);$x_l = "Days of month ".$month." year ".$year;$graph='month'."_".$oids}
	elsif 	($week ne "")
			{$step=7; $x_l = "Days of week ( ".sprintf("from %04d-%02d-%02d",dn_week($year,$week,1)).sprintf(" to %04d-%02d-%02d",dn_week($year,$week,7))." )";$graph='week'."_".$oids}
	else  	{$step=24;$x_l = "Hours of day ".$day." month ".$month." year ".$year;$graph='day'."_".$oids}
	$set = $settings{$graph};
	for ( $k=scalar(@oid)-1; $k>=0; $k-- ) {
		$name  = oid_name(hex $oid[$k]);
		next if $name eq "";
		$where = $oids."_oid=".hex($oid[$k])." and ".$wher;
		$legend[$k] = $oids." ".$name." (".$oid[$k].")";
		db_data($where,$legend[$k],$step,$year,$month,$week,$day,$inout,$set->{kmgt});
	}
}

############################################################
sub proc_graph {								#     ''
	my  ( $d,@str ) = @_;
	my  ( $i,$j,$sum );
	for ( $i=0; $i<$d;$i++ ) {
		$sum = 0;
		for ( $j=0; $j<scalar(@str); $j++ ) {
			$sum += $data{$str[$j]}[$i] }
		for ( $j=0; $j<scalar(@str); $j++ ) {
			$data{$str[$j]}[$i] = sprintf( "%0.1f", $data{$str[$j]}[$i]*100/$sum ) if $sum>0 }
	}
}

############################################################
sub gd_font {
	my $font = shift;
	if    ($font eq "Tiny"	) {return GD::Font->Tiny}
	elsif ($font eq "Medium") {return GD::Font->MediumBold}
	elsif ($font eq "Large"	) {return GD::Font->Large}
	elsif ($font eq "Giant"	) {return GD::Font->Giant}
	else 			 	 	  {return GD::Font->Small}
}

############################################################
sub error_image {								#     
	my $error = shift;
	my $im	  = new GD::Image(500,15);
	$im->filledRectangle(0, 0, 499, 14, $im->colorAllocate ( 255, 255, 255));
	$im->string(gd_font("Giant"),0,0,$error,$im->colorAllocate(255,0,0));
	print "Content-type: image/png\n\n";
	print $im->png;
	exit;
}

1;

