#!/usr/bin/perl -w
#########################################################
# $Id: netams_api.pl,v 1.15 2009-02-09 19:19:24 anton Exp $ 
#########################################################

use Socket;

#--------------------------------------------------------------------------
sub netams_login {
	my ($host, $port, $user, $passwd)=@_;
	my $welcome = "";
	socket(NETAMS_SOCKET, PF_INET, SOCK_STREAM, getprotobyname('tcp'));
	my $sin = sockaddr_in($port,inet_aton($host));
	$! = 0;
	my $href = connect(NETAMS_SOCKET, $sin);
	my $old_fh = select(NETAMS_SOCKET); 
	$| = 1; 		        # don't buffer output
	select($old_fh);

	if ($!) { return "Error connecting to server at $host:$port\n"; }
	else {
		netams_waitfor("Username:");
		print NETAMS_SOCKET "$user\x0D\x0A"; 
 		netams_waitfor("Password:");
		print NETAMS_SOCKET "$passwd\x0D\x0A"; 
		netams_waitfor("\n");
		$welcome = netams_waitfor(" ");
		}

	if ( $welcome ne "\r\n# " ) {
		#print "-----$welcome";
		#shutdown (NETAMS_SOCKET, $sin);
		close(NETAMS_SOCKET);
		return "Authentication failed!";
		} 
	else 	{
		#netams_waitfor("> ");
		return 	"Welcome!";
		}
	}

#--------------------------------------------------------------------------
sub netams_read {
	my ($visible) = @_;
	my $byte = "";
	my $prev_byte2 = "";
	my $prev_byte1 = "";
	my $out_string = "";
	my $count = 0;
	while ( not ( $byte eq " " and ( $prev1_byte eq "#" or $prev1_byte eq ">" ) and ($prev2_byte eq "\n" or $prev2_byte eq ")") ) ) {
		$prev2_byte = $prev1_byte;
		$prev1_byte = $byte;
		$out_string .= $byte;
		$count = sysread(NETAMS_SOCKET, $byte, 1);
		if (!defined $count) { sleep(1); next }
		if ($count == 0) { last }
		}
	$out_string=substr($out_string,0,rindex($out_string,"\r"));
	return $out_string;
	}

#--------------------------------------------------------------------------
sub netams_waitfor {
	my $byte = "";
	my $out_string = "";
	my $count = 0;
	while ( rindex($out_string,$_[0]) < 0 ) {
		$count = sysread(NETAMS_SOCKET, $byte, 1);
		if (!defined $count) { sleep(1); next }
		if ($count == 0) { last }
		$out_string .= $byte;
		}
	return $out_string;
	}

#--------------------------------------------------------------------------
sub netams_cmd {
	print NETAMS_SOCKET "$_[0]\x0D\x0A"; 
	netams_waitfor("\n");
	return split("\r\n",netams_read());
	}

#--------------------------------------------------------------------------
sub netams_cmds {
	my $read = "";
	my $i	 = 0;
	while ( defined $_[$i] ) {
		print NETAMS_SOCKET "$_[$i]\x0D\x0A"; 
		netams_waitfor("\n");
		$read .= netams_read()."\r\n";
		$i++;
		}
	return split("\r\n", $read);
	}

#--------------------------------------------------------------------------
sub netams_send {
	print NETAMS_SOCKET "$_[0]\x0D\x0A";
	netams_waitfor("\n");
	}

#--------------------------------------------------------------------------
sub netams_readline {
	return netams_waitfor("\n");
	}

#--------------------------------------------------------------------------
sub netams_read2 {
	return netams_waitfor(":");
	}

#--------------------------------------------------------------------------
sub netams_readarray {
	return split("\r\n",netams_read());
	}

#--------------------------------------------------------------------------
sub netams_logout {
	print NETAMS_SOCKET "\x0D\x0A";
	print NETAMS_SOCKET "end\x0D\x0A";
	print NETAMS_SOCKET "exit\x0D\x0A";
	close(NETAMS_SOCKET);
	}
#--------------------------------------------------------------------------
1;
