/*
* libmux - GTK+ Moblin User Experience widgets
 * Copyright (C) 2009 Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <gtk/gtk.h>
#include <mux/mux-frame.h>
#include <mux/mux-banner.h>

int
main (int    argc,
      char **argv)
{
  GtkWidget *window;
  GtkWidget *frame, *banner;

  gtk_init (&argc, &argv);

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (window), "Mux widget test");
  g_signal_connect (window,
                    "delete-event",
                    (GCallback) gtk_main_quit,
                    NULL);

  frame = mux_frame_new ();
  gtk_container_add (GTK_CONTAINER (window), frame);

  banner = mux_banner_new ();
  mux_banner_set_text (MUX_BANNER (banner),
                       "This is a long piece of text to demonstrate what a MuxBanner looks like. "
                       "As you can see it isn't very interesting but should be visually pleasing.");
  gtk_container_add (GTK_CONTAINER (frame), banner);

  gtk_widget_show_all (window);

  gtk_main ();
}
