//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: midiport.h,v 1.9 2004/06/18 08:36:43 wschweer Exp $
//
//  (C) Copyright 1999-2004 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __MIDIPORT_H__
#define __MIDIPORT_H__

#include "globaldefs.h"

class MidiDevice;
class MidiInstrument;
class MidiCtrlValListList;
class MidiPlayEvent;
class MidiController;

//---------------------------------------------------------
//   MidiPort
//---------------------------------------------------------

class MidiPort {
      MidiCtrlValListList* _controller;
      MidiDevice* _device;
      QString _state;               // result of device open
      MidiInstrument* _instrument;
      AutomationType _automationType[MIDI_CHANNELS];

      void clearDevice();

   public:
      MidiPort();
      ~MidiPort();

      //
      // manipulate active midi controller
      //
      MidiCtrlValListList* controller() { return _controller; }
      int getCtrl(int ch, int tick, int ctrl) const;
      bool setCtrl(int ch, int tick, int ctrl, int val);
      int hwCtrlState(int ch, int ctrl) const;
      void setHwCtrlState(int ch, int ctrl, int val);
      void deleteController(int ch, int tick, int ctrl);

      bool guiVisible() const;
      bool hasGui() const;

      int portno() const;

      MidiDevice* device() const                { return _device; }
      const QString& state() const              { return _state; }
      void setState(const QString& s)           { _state = s; }
      void setMidiDevice(MidiDevice* dev);
      const QString& portname() const;
      MidiInstrument* instrument() const        { return _instrument; }
      void setInstrument(MidiInstrument* i)     { _instrument = i; }
      MidiController* midiController(int num) const;
      void addManagedController(int channel, int ctrl);

      // send events to midi device and keep track of
      // device state:
      void sendGmOn();
      void sendGsOn();
      void sendXgOn();
      void sendStart();
      void sendStop();
      void sendContinue();
      void sendSongpos(int);
      void sendClock();
      void sendSysex(const unsigned char* p, int n);
      bool sendEvent(const MidiPlayEvent&);
      AutomationType automationType(int channel) { return _automationType[channel]; }
      void setAutomationType(int channel, AutomationType t) {
            _automationType[channel] = t;
            }
      };

extern MidiPort midiPorts[MIDI_PORTS];
extern void initMidiPorts();

class QPopupMenu;
class QWidget;
extern QPopupMenu* midiPortsPopup(QWidget*);
#endif

