/*
 * This file is part of MPlayer.
 *
 * MPlayer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MPlayer is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with MPlayer; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MPLAYER_WSKEYS_H
#define MPLAYER_WSKEYS_H

#define wsPause         0xff13
#define wsUp            0xff52
#define wsDown          0xff54
#define wsLeft          0xff51
#define wsRight         0xff53
#define wsLeftCtrl      0xffe3
#define wsRightCtrl     0xffe4
#define wsLeftAlt       0xffe9
#define wsRightAlt      0xff7e
#define wsLeftShift     0xffe1
#define wsRightShift    0xffe2
#define wsEnter         0xff0d
#define wsBackSpace     0xff08
#define wsCapsLock      0xffe5
#define wsTab           0xff09
#define wsF1            0xffbe
#define wsF2            0xffbf
#define wsF3            0xffc0
#define wsF4            0xffc1
#define wsF5            0xffc2
#define wsF6            0xffc3
#define wsF7            0xffc4
#define wsF8            0xffc5
#define wsF9            0xffc6
#define wsF10           0xffc7
#define wsF11           0xffc8
#define wsF12           0xffc9
#define wsInsert        0xff63
#define wsDelete        0xffff
#define wsHome          0xff50
#define wsEnd           0xff57
#define wsPageUp        0xff55
#define wsPageDown      0xff56
#define wsNumLock       0xff7f
#define wsEscape        0xff1b
#define wsGrayEnter     0xff8d
#define wsGrayPlus      0xffab
#define wsGrayMinus     0xffad
#define wsGrayMul       0xffaa
#define wsGrayDiv       0xffaf
#define wsGrayDecimal   0xffae
#define wsGray0         0xffb0
#define wsGray1         0xffb1
#define wsGray2         0xffb2
#define wsGray3         0xffb3
#define wsGray4         0xffb4
#define wsGray5         0xffb5
#define wsGray6         0xffb6
#define wsGray7         0xffb7
#define wsGray8         0xffb8
#define wsGray9         0xffb9
#define wsGrayHome      0xff95
#define wsGrayLeft      0xff96
#define wsGrayUp        0xff97
#define wsGrayRight     0xff98
#define wsGrayDown      0xff99
#define wsGrayPgUp      0xff9a
#define wsGrayPgDn      0xff9b
#define wsGrayEnd       0xff9c
#define wsGray5Dup      0xff9d
#define wsGrayInsert    0xff9e
#define wsGrayDelete    0xff9f

#endif /* MPLAYER_WSKEYS_H */
