/* mhs: A GObject wrapper for the Mozilla Mhs API
 *
 * Copyright (C) 2009  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <glib.h>
#include <nsXPCOM.h>
#include <stdarg.h>

#include "mhs-error-private.h"

void
mhs_error_set_from_nsresult (nsresult rv, GError **error)
{
  gint code = MHS_ERROR_XUL;

  if (!error)
    return;

  /* FIXME - add more error codes */
  if (rv == NS_ERROR_NOT_AVAILABLE)
    code = MHS_ERROR_NOTAVAILABLE;

  g_set_error (error, MHS_ERROR, code, "XUL error: 0x%x", rv);
}

GQuark
mhs_error_quark (void)
{
  return g_quark_from_static_string (MHS_ERROR_QUARK_STRING);
}
