/* mhs: A GObject wrapper for the Mozilla Mhs API
 *
 * Copyright (C) 2009  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __MHS_PERMISSION_MANAGER_H__
#define __MHS_PERMISSION_MANAGER_H__

#include <glib-object.h>

G_BEGIN_DECLS

#define MHS_TYPE_PERMISSION_MANAGER             \
  (mhs_permission_manager_get_type())
#define MHS_PERMISSION_MANAGER(obj)                             \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj),                           \
                               MHS_TYPE_PERMISSION_MANAGER,     \
                               MhsPermissionManager))
#define MHS_PERMISSION_MANAGER_CLASS(klass)                     \
  (G_TYPE_CHECK_CLASS_CAST ((klass),                            \
                            MHS_TYPE_PERMISSION_MANAGER,        \
                            MhsPermissionManagerClass))
#define MHS_IS_PERMISSION_MANAGER(obj)                          \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj),                           \
                               MHS_TYPE_PERMISSION_MANAGER))
#define MHS_IS_PERMISSION_MANAGER_CLASS(klass)                  \
  (G_TYPE_CHECK_CLASS_TYPE ((klass),                            \
                            MHS_TYPE_PERMISSION_MANAGER))
#define MHS_PERMISSION_MANAGER_GET_CLASS(obj)                   \
  (G_TYPE_INSTANCE_GET_CLASS ((obj),                            \
                              MHS_TYPE_PERMISSION_MANAGER,      \
                              MhsPermissionManagerClass))

typedef struct _MhsPermissionManager         MhsPermissionManager;
typedef struct _MhsPermissionManagerClass    MhsPermissionManagerClass;
typedef struct _MhsPermissionManagerPrivate  MhsPermissionManagerPrivate;
typedef struct _MhsPermission                MhsPermission;

struct _MhsPermissionManagerClass
{
  GObjectClass parent_class;
};

struct _MhsPermissionManager
{
  GObject parent;

  MhsPermissionManagerPrivate *priv;
};

struct _MhsPermission
{
  gchar *host;
  gchar *type;
  guint32 capability;
};

GType mhs_permission_manager_get_type (void) G_GNUC_CONST;

MhsPermissionManager *mhs_permission_manager_new (void);

gboolean mhs_pm_add (MhsPermissionManager *pm,
                     const gchar *uri,
                     const gchar *type,
                     guint32 permission,
                     GError **error);

gboolean mhs_pm_remove (MhsPermissionManager *pm,
                        const gchar *host,
                        const gchar *type,
                        GError **error);

gboolean mhs_pm_remove_all (MhsPermissionManager *pm,
                            GError **error);

gboolean mhs_pm_test_permission (MhsPermissionManager *pm,
                                 const gchar *uri,
                                 const gchar *type,
                                 guint32 *result,
                                 GError **error);

gboolean mhs_pm_test_exact_permission (MhsPermissionManager *pm,
                                       const gchar *uri,
                                       const gchar *type,
                                       guint32 *result,
                                       GError **error);

gboolean mhs_pm_get_all (MhsPermissionManager *pm,
                         guint *n_permissions,
                         MhsPermission **permissions,
                         GError **error);

void mhs_pm_free_permissions (guint n_permissions,
                              MhsPermission *permissions);

G_END_DECLS

#endif /* __MHS_PERMISSION_MANAGER_H__ */
