/* mhs: A GObject wrapper for the Mozilla Mhs API
 *
 * Copyright (C) 2009  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _MHS_COOKIES_H
#define _MHS_COOKIES_H

#include <glib-object.h>

G_BEGIN_DECLS

#define MHS_TYPE_COOKIES mhs_cookies_get_type()

#define MHS_COOKIES(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
  MHS_TYPE_COOKIES, MhsCookies))

#define MHS_COOKIES_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), \
  MHS_TYPE_COOKIES, MhsCookiesClass))

#define MHS_IS_COOKIES(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
  MHS_TYPE_COOKIES))

#define MHS_IS_COOKIES_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), \
  MHS_TYPE_COOKIES))

#define MHS_COOKIES_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), \
  MHS_TYPE_COOKIES, MhsCookiesClass))

typedef struct _MhsCookies MhsCookies;
typedef struct _MhsCookiesClass MhsCookiesClass;
typedef struct _MhsCookiesPrivate MhsCookiesPrivate;

struct _MhsCookies
{
  GObject parent;

  MhsCookiesPrivate *priv;
};

struct _MhsCookiesClass
{
  GObjectClass parent_class;

  /* signals */
  void (*cookie_changed)  (MhsCookies  *self,
                           const gchar *detail,
                           const gchar *cookie);
  void (*cookie_rejected) (MhsCookies  *self,
                           const gchar *uri);
};

GType mhs_cookies_get_type (void);

MhsCookies *mhs_cookies_new (void);

gboolean mhs_cookies_get_cookie_string (MhsCookies   *self,
                                        const gchar  *uri,
                                        gchar       **cookie,
                                        GError      **error);
gboolean mhs_cookies_get_cookie_string_from_http (MhsCookies   *self,
                                                  const gchar  *uri,
                                                  const gchar  *first_uri,
                                                  gchar       **cookie,
                                                  GError      **error);
gboolean mhs_cookies_set_cookie_string (MhsCookies   *self,
                                        const gchar  *uri,
                                        const gchar  *cookie,
                                        GError      **error);
gboolean mhs_cookies_set_cookie_string_from_http (MhsCookies   *self,
                                                  const gchar  *uri,
                                                  const gchar  *first_uri,
                                                  const gchar  *cookie,
                                                  const gchar  *time,
                                                  GError      **error);
gboolean mhs_cookies_remove_all (MhsCookies   *self,
                                 GError     **error);
gboolean mhs_cookies_get_all (MhsCookies  *self,
                              GPtrArray  **cookies, // GPtrArray{GValueArray}
                              GError     **error);
gboolean mhs_cookies_remove (MhsCookies   *self,
                             const gchar  *domain,
                             const gchar  *name,
                             const gchar  *path,
                             gboolean      blocked,
                             GError      **error);
gboolean mhs_cookies_add (MhsCookies   *self,
                          const gchar  *domain,
                          const gchar  *path,
                          const gchar  *name,
                          const gchar  *value,
                          gboolean      is_secure,
                          gboolean      is_http_only,
                          gboolean      is_session,
                          gint64        expiry,
                          GError      **error);
gboolean mhs_cookies_count_cookies_from_host (MhsCookies   *self,
                                              const gchar  *host,
                                              guint        *count,
                                              GError      **error);
gboolean mhs_cookies_import_cookies (MhsCookies   *self,
                                     const gchar  *file,
                                     GError      **error);

G_END_DECLS

#endif /* _MHS_COOKIES_H */
