// Copyright 2010-2012, Google Inc.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//     * Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above
// copyright notice, this list of conditions and the following disclaimer
// in the documentation and/or other materials provided with the
// distribution.
//     * Neither the name of Google Inc. nor the names of its
// contributors may be used to endorse or promote products derived from
// this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

// This file originally comes from Boost project, licensed under Boost
// Software License.
// Boost Software License - Version 1.0 - August 17th, 2003
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
//
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.

#ifndef MOZC_BASE_SCOPED_PTR_H_
#define MOZC_BASE_SCOPED_PTR_H_

#include <assert.h>
#include <stdlib.h>
#include <cstddef>

template<class T> class scoped_ptr {
 private:
  T * ptr_;
  scoped_ptr(scoped_ptr const &);
  scoped_ptr & operator= (scoped_ptr const &);
  template<class T2> bool operator==(scoped_ptr<T2> const & p2) const;
  template<class T2> bool operator!=(scoped_ptr<T2> const & p2) const;

 public:
  typedef T element_type;
  explicit scoped_ptr(T * p = NULL): ptr_(p) {}
  ~scoped_ptr() {
    enum { type_must_be_complete = sizeof(T) };
    delete ptr_;
  }
  T & operator*() const {
    assert(ptr_ != NULL);
    return *ptr_;
  }
  T * operator->() const  {
    assert(ptr_ != NULL);
    return ptr_;
  }
  T * get() const { return ptr_; }
  void reset(T * p = NULL) {
    if (p != ptr_) {
      enum { type_must_be_complete = sizeof(T) };
      delete ptr_;
      ptr_ = p;
    }
  }
  void swap(scoped_ptr & p2) {
    T* tmp = ptr_;
    ptr_ = p2.ptr_;
    p2.ptr_ = tmp;
  }
  T * release() {
    T* ret = ptr_;
    ptr_ = NULL;
    return ret;
  }
  bool operator==(T * p) const { return ptr_ == p; }
  bool operator!=(T * p) const { return ptr_ != p; }
};

template<class T> void swap(scoped_ptr<T> & p1, scoped_ptr<T> & p2) {
  p1.swap(p2);
}

template<class T> bool operator==(T * p1, const scoped_ptr<T> & p2) {
  return p1 == p2.get();
}

template<class T> bool operator!=(T * p1, const scoped_ptr<T> & p2) {
  return p1 != p2.get();
}

template<class T> class scoped_array {
 private:
  T * ptr_;
  scoped_array(scoped_array const &);
  scoped_array & operator= (scoped_array const &);
  template<class T2> bool operator==(scoped_array<T2> const & p2) const;
  template<class T2> bool operator!=(scoped_array<T2> const & p2) const;

 public:
  typedef T element_type;
  explicit scoped_array(T * p = NULL): ptr_(p) {}
  ~scoped_array() {
    enum { type_must_be_complete = sizeof(T) };
    delete[] ptr_;
  }
  void reset(T* p = NULL) {
    if (p != ptr_) {
      enum { type_must_be_complete = sizeof(T) };
      delete[] ptr_;
      ptr_ = p;
    }
  }
  T * get() const {
    return ptr_;
  }
  T & operator[](std::ptrdiff_t i) const {
    assert(i >= 0);
    assert(ptr_ != NULL);
    return ptr_[i];
  }
  void swap(scoped_array& p2) {
    T* tmp = ptr_;
    ptr_ = p2.ptr_;
    p2.ptr_ = tmp;
  }
  T * release() {
    T* ret = ptr_;
    ptr_ = NULL;
    return ret;
  }
  bool operator==(T * p) const { return ptr_ == p; }
  bool operator!=(T * p) const { return ptr_ != p; }
};

template<class T> void swap(scoped_array<T> & p1, scoped_array<T> & p2) {
  p1.swap(p2);
}

template<class T> bool operator==(T * p1, const scoped_array<T> & p2) {
  return p1 == p2.get();
}

template<class T> bool operator!=(T * p1, const scoped_array<T> & p2) {
  return p1 != p2.get();
}
#endif  // MOZC_BASE_SCOPED_PTR_H_
