//
// Tests for System.Web.UI.WebControls.SelectedDatesCollection.cs
//
// Author:
//	Jordi Mas i Hernandez (jordi@ximian.com)
//

//
// Copyright (C) 2005 Novell, Inc (http://www.novell.com)
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
//
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

using System.Web.UI.WebControls;
using NUnit.Framework;
using System;
using System.Collections;
using System.Web;
using System.Web.UI;
using System.Globalization;
	

namespace MonoTests.System.Web.UI.WebControls
{
	[TestFixture]
	public class SelectedDatesCollectionTest {


		[Test]
		public void SelectedDatesCollectionTest_DefaultValues ()
		{
			ArrayList list = new ArrayList ();
			SelectedDatesCollection s = new SelectedDatesCollection (list);			

			Assert.AreEqual (0, s.Count, "A1");
			Assert.AreEqual (false, s.IsReadOnly, "A2");
			Assert.AreEqual (false, s.IsSynchronized, "A3");
			Assert.AreEqual (s, s.SyncRoot, "A4");
		}


		//
		// Methods
		//
		[Test]
		public void AddMethod ()
		{
			ArrayList list = new ArrayList ();
			SelectedDatesCollection s = new SelectedDatesCollection (list);			
			
			s.Add (DateTime.Today);
			Assert.AreEqual (true, s.Contains (DateTime.Today), "A1");
			Assert.AreEqual (1, s.Count, "A2");
			
			s.Add (DateTime.Today);	// Duplicates are not inserted
			Assert.AreEqual (1, s.Count, "A2");
		}

		//
		// Methods
		//
		[Test]
		public void ClearMethod ()
		{
			ArrayList list = new ArrayList ();
			SelectedDatesCollection s = new SelectedDatesCollection (list);			
			
			s.Add (DateTime.Today);
			s.Clear ();
			Assert.AreEqual (0, s.Count, "A1");
		}


		[Test]
		public void SelectRangeMethod ()
		{
			ArrayList list = new ArrayList ();
			SelectedDatesCollection s = new SelectedDatesCollection (list);			
			
			s.Add (DateTime.Today);
			s.Add (DateTime.Today);
			// Internally clears the list
			s.SelectRange (new DateTime (2000, 1, 1), new DateTime (2001, 1, 1));

			Assert.AreEqual (367, s.Count, "A1");
		}

		[Test]
		public void RemoveMethod ()
		{
			ArrayList list = new ArrayList ();
			SelectedDatesCollection s = new SelectedDatesCollection (list);			
			
			s.Add (DateTime.Today);
			s.Remove (DateTime.Today);
			Assert.AreEqual (0, s.Count, "A1");
		}

	}
}



