/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib;

import CH.ifa.draw.contrib.PolygonFigure;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.standard.AbstractTool;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class PolygonTool
extends AbstractTool {
    private PolygonFigure fPolygon;
    private int fLastX;
    private int fLastY;

    public PolygonTool(DrawingView drawingView) {
        super(drawingView);
    }

    public void activate() {
        super.activate();
        this.fPolygon = null;
    }

    public void deactivate() {
        super.deactivate();
        if (this.fPolygon != null) {
            this.fPolygon.smoothPoints();
            if (this.fPolygon.pointCount() < 3 || this.fPolygon.size().width < 4 || this.fPolygon.size().height < 4) {
                this.drawing().remove(this.fPolygon);
            }
        }
        this.fPolygon = null;
    }

    private void addPoint(int n, int n2) {
        if (this.fPolygon == null) {
            this.fPolygon = new PolygonFigure(n, n2);
            this.view().add(this.fPolygon);
            this.fPolygon.addPoint(n, n2);
        } else if (this.fLastX != n || this.fLastY != n2) {
            this.fPolygon.addPoint(n, n2);
        }
        this.fLastX = n;
        this.fLastY = n2;
    }

    public void mouseDown(MouseEvent mouseEvent, int n, int n2) {
        n = mouseEvent.getX();
        n2 = mouseEvent.getY();
        if (mouseEvent.getClickCount() >= 2) {
            if (this.fPolygon != null) {
                this.fPolygon.smoothPoints();
                this.editor().toolDone();
            }
            this.fPolygon = null;
        } else {
            this.addPoint(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void keyDown(KeyEvent keyEvent, int n) {
        System.out.println("Key " + n);
        if (n == 27) {
            if (this.fPolygon != null) {
                this.fPolygon.smoothPoints();
                this.editor().toolDone();
            }
            this.fPolygon = null;
        }
    }

    public void mouseMove(MouseEvent mouseEvent, int n, int n2) {
        if (this.fPolygon != null && this.fPolygon.pointCount() > 1) {
            this.fPolygon.setPointAt(new Point(n, n2), this.fPolygon.pointCount() - 1);
            this.view().checkDamage();
        }
    }

    public void mouseDrag(MouseEvent mouseEvent, int n, int n2) {
        n = mouseEvent.getX();
        n2 = mouseEvent.getY();
        this.addPoint(n, n2);
    }

    public void mouseUp(MouseEvent mouseEvent, int n, int n2) {
    }
}

