/*
 * Moblin-Web-Browser: The web browser for Moblin
 * Copyright (c) 2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef _MWB_FAVICON_LOADER_H
#define _MWB_FAVICON_LOADER_H

#include <nsIProtocolHandler.h>
#include <mhs/mhs.h>

// {980e23b0-dc9d-4dc0-80f9-77beb53ea0f8}
#define MWB_FAVICON_LOADER_CID \
  { 0x980e23b0, 0xdc9d, 0x4dc0, \
      { 0x80, 0xf9, 0x77, 0xbe, 0xb5, 0x3e, 0xa0, 0xf8 } }

class MwbFaviconLoader : public nsIProtocolHandler
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIPROTOCOLHANDLER

  MwbFaviconLoader ();
  ~MwbFaviconLoader ();

  static MwbFaviconLoader *GetSingleton (void);

private:
  static MwbFaviconLoader *favicon_loader;

  MhsHistory *history;

  gchar *default_favicon;
  gsize default_favicon_length;

  friend class MwbFaviconClosure;
};

#endif /* _MWB_FAVICON_LOADER_H */
