/*
 * Moblin-Web-Browser: The web browser for Moblin
 * Copyright (c) 2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <gdk-pixbuf/gdk-pixbuf.h>
#include "mwb-utils.h"

gboolean
mwb_utils_focus_on_click_cb (ClutterActor       *actor,
                             ClutterButtonEvent *event,
                             gpointer            swallow_event)
{
  clutter_actor_grab_key_focus (actor);
  return GPOINTER_TO_INT (swallow_event);
}

inline void
mwb_utils_table_add (NbtkTable    *table,
                     ClutterActor *child,
                     gint          row,
                     gint          col,
                     gboolean      x_expand,
                     gboolean      x_fill,
                     gboolean      y_expand,
                     gboolean      y_fill)
{
  nbtk_table_add_actor_with_properties (table, child, row, col,
                                        "x-expand", x_expand,
                                        "x-fill", x_fill,
                                        "y-expand", y_expand,
                                        "y-fill", y_fill,
                                        NULL);
}

CoglHandle
mwb_utils_image_to_texture (const guint8 *data,
                            guint data_len,
                            GError **error)
{
  GdkPixbuf *pixbuf;
  GInputStream *input_stream
    = g_memory_input_stream_new_from_data (data, data_len, NULL);
  ClutterActor *texture = COGL_INVALID_HANDLE;

  if ((pixbuf = gdk_pixbuf_new_from_stream_at_scale (input_stream,
                                                     16, 16,
                                                     TRUE,
                                                     NULL,
                                                     error)))
    {
      texture = cogl_texture_new_from_data (gdk_pixbuf_get_width (pixbuf),
                                            gdk_pixbuf_get_height (pixbuf),
                                            0,
                                            gdk_pixbuf_get_has_alpha (pixbuf)
                                            ? COGL_PIXEL_FORMAT_RGBA_8888
                                            : COGL_PIXEL_FORMAT_RGB_888,
                                            COGL_PIXEL_FORMAT_ANY,
                                            gdk_pixbuf_get_rowstride (pixbuf),
                                            gdk_pixbuf_get_pixels (pixbuf));

      g_object_unref (pixbuf);
    }

  g_object_unref (input_stream);

  return texture;
}

gboolean
mwb_utils_actor_has_focus (ClutterActor *actor)
{
  ClutterActor *stage = clutter_actor_get_stage (actor);

  if (stage && (clutter_stage_get_key_focus (CLUTTER_STAGE (stage)) == actor))
    return TRUE;
  else
    return FALSE;
}

