/*
 * Moblin-Web-Browser: The web browser for Moblin
 * Copyright (c) 2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef _MWB_POPUP_H
#define _MWB_POPUP_H

#include <glib-object.h>
#include <clutter/clutter.h>
#include <nbtk/nbtk.h>
#include "mwb-action.h"

G_BEGIN_DECLS

#define MWB_TYPE_POPUP mwb_popup_get_type()

#define MWB_POPUP(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
  MWB_TYPE_POPUP, MwbPopup))

#define MWB_POPUP_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), \
  MWB_TYPE_POPUP, MwbPopupClass))

#define MWB_IS_POPUP(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
  MWB_TYPE_POPUP))

#define MWB_IS_POPUP_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), \
  MWB_TYPE_POPUP))

#define MWB_POPUP_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), \
  MWB_TYPE_POPUP, MwbPopupClass))

typedef struct _MwbPopup MwbPopup;
typedef struct _MwbPopupClass MwbPopupClass;
typedef struct _MwbPopupPrivate MwbPopupPrivate;

struct _MwbPopup
{
  NbtkWidget parent;

  MwbPopupPrivate *priv;
};

struct _MwbPopupClass
{
  NbtkWidgetClass parent_class;

  void (*action_activated) (MwbPopup *popup, MwbAction *action);
};

GType mwb_popup_get_type (void);

NbtkWidget *mwb_popup_new (void);

void mwb_popup_add_action (MwbPopup  *popup,
                           MwbAction *action);

void mwb_popup_remove_action (MwbPopup  *popup,
                              MwbAction *action);

void mwb_popup_clear (MwbPopup *popup);

void mwb_popup_show (MwbPopup *popup);

void mwb_popup_hide (MwbPopup *popup);

gboolean mwb_popup_is_visible (MwbPopup *popup);

G_END_DECLS

#endif /* _MWB_POPUP_H */
