/*
 * Moblin-Web-Browser: The web browser for Moblin
 * Copyright (c) 2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef _MWB_TOOLBAR_H
#define _MWB_TOOLBAR_H

#include <glib-object.h>
#include <clutter/clutter.h>
#include <nbtk/nbtk.h>
#include "mwb-radical-bar.h"

G_BEGIN_DECLS

#define MWB_TYPE_TOOLBAR mwb_toolbar_get_type()

#define MWB_TOOLBAR(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
  MWB_TYPE_TOOLBAR, MwbToolbar))

#define MWB_TOOLBAR_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), \
  MWB_TYPE_TOOLBAR, MwbToolbarClass))

#define MWB_IS_TOOLBAR(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
  MWB_TYPE_TOOLBAR))

#define MWB_IS_TOOLBAR_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), \
  MWB_TYPE_TOOLBAR))

#define MWB_TOOLBAR_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), \
  MWB_TYPE_TOOLBAR, MwbToolbarClass))

typedef struct _MwbToolbarPrivate MwbToolbarPrivate;

typedef struct {
  NbtkTable parent;

  MwbToolbarPrivate *priv;
} MwbToolbar;

typedef struct {
  NbtkTableClass parent_class;

  void (* travel)   (MwbToolbar *toolbar, gint direction);
  void (* settings) (MwbToolbar *toolbar);
  void (* quit)     (MwbToolbar *toolbar);
} MwbToolbarClass;

GType mwb_toolbar_get_type (void);

NbtkWidget* mwb_toolbar_new (void);

MwbRadicalBar *mwb_toolbar_get_radical_bar (MwbToolbar *toolbar);

void mwb_toolbar_set_can_go_back (MwbToolbar *toolbar, gboolean enable);
void mwb_toolbar_set_can_go_forward (MwbToolbar *toolbar, gboolean enable);

G_END_DECLS

#endif /* _MWB_TOOLBAR_H */

