/*
 * Copyright © 2009 Jerome Glisse <glisse@freedesktop.org>
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
 */
#ifndef EG_STATES_H
#define EG_STATES_H

static const struct radeon_register EG_names_CONFIG[] = {
	{0x00008C00, 0, 0, "SQ_CONFIG"},
	{0x00009100, 0, 0, "SPI_CONFIG_CNTL"},
	{0x0000913C, 0, 0, "SPI_CONFIG_CNTL_1"},
	{0x00008C04, 0, 0, "SQ_GPR_RESOURCE_MGMT_1"},
	{0x00008C08, 0, 0, "SQ_GPR_RESOURCE_MGMT_2"},
	{0x00008C0C, 0, 0, "SQ_GPR_RESOURCE_MGMT_3"},
	{0x00008C18, 0, 0, "SQ_THREAD_RESOURCE_MGMT_1"},
	{0x00008C1C, 0, 0, "SQ_THREAD_RESOURCE_MGMT_2"},
	{0x00008C20, 0, 0, "SQ_STACK_RESOURCE_MGMT_1"},
	{0x00008C24, 0, 0, "SQ_STACK_RESOURCE_MGMT_2"},
	{0x00008C28, 0, 0, "SQ_STACK_RESOURCE_MGMT_3"},
	{0x00008D8C, 0, 0, "SQ_DYN_GPR_CNTL_PS_FLUSH_REQ"},
	{0x00008A14, 0, 0, "PA_CL_ENHANCE"},
	{0x00028838, 0, 0, "SQ_DYN_GPR_RESOURCE_LIMIT_1"},
	{0x000288EC, 0, 0, "SQ_LDS_ALLOC_PS"},
	{0x00028350, 0, 0, "SX_MISC"},
	{0x00028900, 0, 0, "SQ_ESGS_RING_ITEMSIZE"},
	{0x00028904, 0, 0, "SQ_GSVS_RING_ITEMSIZE"},
	{0x00028908, 0, 0, "SQ_ESTMP_RING_ITEMSIZE"},
	{0x0002890C, 0, 0, "SQ_GSTMP_RING_ITEMSIZE"},
	{0x00028910, 0, 0, "SQ_VSTMP_RING_ITEMSIZE"},
	{0x00028914, 0, 0, "SQ_PSTMP_RING_ITEMSIZE"},
	{0x0002891C, 0, 0, "SQ_GS_VERT_ITEMSIZE"},
	{0x00028920, 0, 0, "SQ_GS_VERT_ITEMSIZE_1"},
	{0x00028924, 0, 0, "SQ_GS_VERT_ITEMSIZE_2"},
	{0x00028928, 0, 0, "SQ_GS_VERT_ITEMSIZE_3"},
	{0x00028A10, 0, 0, "VGT_OUTPUT_PATH_CNTL"},
	{0x00028A14, 0, 0, "VGT_HOS_CNTL"},
	{0x00028A18, 0, 0, "VGT_HOS_MAX_TESS_LEVEL"},
	{0x00028A1C, 0, 0, "VGT_HOS_MIN_TESS_LEVEL"},
	{0x00028A20, 0, 0, "VGT_HOS_REUSE_DEPTH"},
	{0x00028A24, 0, 0, "VGT_GROUP_PRIM_TYPE"},
	{0x00028A28, 0, 0, "VGT_GROUP_FIRST_DECR"},
	{0x00028A2C, 0, 0, "VGT_GROUP_DECR"},
	{0x00028A30, 0, 0, "VGT_GROUP_VECT_0_CNTL"},
	{0x00028A34, 0, 0, "VGT_GROUP_VECT_1_CNTL"},
	{0x00028A38, 0, 0, "VGT_GROUP_VECT_0_FMT_CNTL"},
	{0x00028A3C, 0, 0, "VGT_GROUP_VECT_1_FMT_CNTL"},
	{0x00028A40, 0, 0, "VGT_GS_MODE"},
	{0x00028A48, 0, 0, "PA_SC_MODE_CNTL_0"},
	{0x00028A4C, 0, 0, "PA_SC_MODE_CNTL_1"},
	{0x00028AB4, 0, 0, "VGT_REUSE_OFF"},
	{0x00028AB8, 0, 0, "VGT_VTX_CNT_EN"},
	{0x00028B54, 0, 0, "VGT_SHADER_STAGES_EN"},
	{0x00028B94, 0, 0, "VGT_STRMOUT_CONFIG"},
	{0x00028B98, 0, 0, "VGT_STRMOUT_BUFFER_CONFIG"},
};

static const struct radeon_register EG_names_CB_CNTL[] = {
	{0x00028238, 0, 0, "CB_TARGET_MASK"},
	{0x0002823C, 0, 0, "CB_SHADER_MASK"},
	{0x00028808, 0, 0, "CB_COLOR_CONTROL"},
	{0x00028C04, 0, 0, "PA_SC_AA_CONFIG"},
	{0x00028C1C, 0, 0, "PA_SC_AA_SAMPLE_LOCS_MCTX"},
	{0x00028C3C, 0, 0, "PA_SC_AA_MASK"},
};

static const struct radeon_register EG_names_RASTERIZER[] = {
	{0x000286D4, 0, 0, "SPI_INTERP_CONTROL_0"},
	{0x00028810, 0, 0, "PA_CL_CLIP_CNTL"},
	{0x00028814, 0, 0, "PA_SU_SC_MODE_CNTL"},
	{0x0002881C, 0, 0, "PA_CL_VS_OUT_CNTL"},
	{0x00028820, 0, 0, "PA_CL_NANINF_CNTL"},
	{0x00028A00, 0, 0, "PA_SU_POINT_SIZE"},
	{0x00028A04, 0, 0, "PA_SU_POINT_MINMAX"},
	{0x00028A08, 0, 0, "PA_SU_LINE_CNTL"},
	{0x00028A48, 0, 0, "PA_SC_MPASS_PS_CNTL"},
	{0x00028C00, 0, 0, "PA_SC_LINE_CNTL"},
	{0x00028C08, 0, 0, "PA_SU_VTX_CNTL"},
	{0x00028C0C, 0, 0, "PA_CL_GB_VERT_CLIP_ADJ"},
	{0x00028C10, 0, 0, "PA_CL_GB_VERT_DISC_ADJ"},
	{0x00028C14, 0, 0, "PA_CL_GB_HORZ_CLIP_ADJ"},
	{0x00028C18, 0, 0, "PA_CL_GB_HORZ_DISC_ADJ"},
	{0x00028B78, 0, 0, "PA_SU_POLY_OFFSET_DB_FMT_CNTL"},
	{0x00028B7C, 0, 0, "PA_SU_POLY_OFFSET_CLAMP"},
	{0x00028B80, 0, 0, "PA_SU_POLY_OFFSET_FRONT_SCALE"},
	{0x00028B84, 0, 0, "PA_SU_POLY_OFFSET_FRONT_OFFSET"},
	{0x00028B88, 0, 0, "PA_SU_POLY_OFFSET_BACK_SCALE"},
	{0x00028B8C, 0, 0, "PA_SU_POLY_OFFSET_BACK_OFFSET"},
};

/* Viewport states are same as r600 */
static const struct radeon_register EG_names_VIEWPORT[] = {
	{0x000282D0, 0, 0, "PA_SC_VPORT_ZMIN_0"},
	{0x000282D4, 0, 0, "PA_SC_VPORT_ZMAX_0"},
	{0x0002843C, 0, 0, "PA_CL_VPORT_XSCALE_0"},
	{0x00028444, 0, 0, "PA_CL_VPORT_YSCALE_0"},
	{0x0002844C, 0, 0, "PA_CL_VPORT_ZSCALE_0"},
	{0x00028440, 0, 0, "PA_CL_VPORT_XOFFSET_0"},
	{0x00028448, 0, 0, "PA_CL_VPORT_YOFFSET_0"},
	{0x00028450, 0, 0, "PA_CL_VPORT_ZOFFSET_0"},
	{0x00028818, 0, 0, "PA_CL_VTE_CNTL"},
};

/* scissor is same as R600 */
static const struct radeon_register EG_names_SCISSOR[] = {
	{0x00028030, 0, 0, "PA_SC_SCREEN_SCISSOR_TL"},
	{0x00028034, 0, 0, "PA_SC_SCREEN_SCISSOR_BR"},
	{0x00028200, 0, 0, "PA_SC_WINDOW_OFFSET"},
	{0x00028204, 0, 0, "PA_SC_WINDOW_SCISSOR_TL"},
	{0x00028208, 0, 0, "PA_SC_WINDOW_SCISSOR_BR"},
	{0x0002820C, 0, 0, "PA_SC_CLIPRECT_RULE"},
	{0x00028210, 0, 0, "PA_SC_CLIPRECT_0_TL"},
	{0x00028214, 0, 0, "PA_SC_CLIPRECT_0_BR"},
	{0x00028218, 0, 0, "PA_SC_CLIPRECT_1_TL"},
	{0x0002821C, 0, 0, "PA_SC_CLIPRECT_1_BR"},
	{0x00028220, 0, 0, "PA_SC_CLIPRECT_2_TL"},
	{0x00028224, 0, 0, "PA_SC_CLIPRECT_2_BR"},
	{0x00028228, 0, 0, "PA_SC_CLIPRECT_3_TL"},
	{0x0002822C, 0, 0, "PA_SC_CLIPRECT_3_BR"},
	{0x00028230, 0, 0, "PA_SC_EDGERULE"},
	{0x00028240, 0, 0, "PA_SC_GENERIC_SCISSOR_TL"},
	{0x00028244, 0, 0, "PA_SC_GENERIC_SCISSOR_BR"},
	{0x00028250, 0, 0, "PA_SC_VPORT_SCISSOR_0_TL"},
	{0x00028254, 0, 0, "PA_SC_VPORT_SCISSOR_0_BR"},
	{0x00028234, 0, 0, "PA_SU_HARDWARE_SCREEN_OFFSET"},
};

/* same as r700 i.e. no blend control */
static const struct radeon_register EG_names_BLEND[] = {
	{0x00028414, 0, 0, "CB_BLEND_RED"},
	{0x00028418, 0, 0, "CB_BLEND_GREEN"},
	{0x0002841C, 0, 0, "CB_BLEND_BLUE"},
	{0x00028420, 0, 0, "CB_BLEND_ALPHA"},
	{0x00028780, 0, 0, "CB_BLEND0_CONTROL"},
	{0x00028784, 0, 0, "CB_BLEND1_CONTROL"},
	{0x00028788, 0, 0, "CB_BLEND2_CONTROL"},
	{0x0002878C, 0, 0, "CB_BLEND3_CONTROL"},
	{0x00028790, 0, 0, "CB_BLEND4_CONTROL"},
	{0x00028794, 0, 0, "CB_BLEND5_CONTROL"},
	{0x00028798, 0, 0, "CB_BLEND6_CONTROL"},
	{0x0002879C, 0, 0, "CB_BLEND7_CONTROL"},
};

/* different */
static const struct radeon_register EG_names_DSA[] = {
	{0x00028028, 0, 0, "DB_STENCIL_CLEAR"},
	{0x0002802C, 0, 0, "DB_DEPTH_CLEAR"},
	{0x00028410, 0, 0, "SX_ALPHA_TEST_CONTROL"},
	{0x00028430, 0, 0, "DB_STENCILREFMASK"},
	{0x00028434, 0, 0, "DB_STENCILREFMASK_BF"},
	{0x00028438, 0, 0, "SX_ALPHA_REF"},
	{0x000286DC, 0, 0, "SPI_FOG_CNTL"},
	{0x00028800, 0, 0, "DB_DEPTH_CONTROL"},
	{0x0002880C, 0, 0, "DB_SHADER_CONTROL"},
	{0x00028000, 0, 0, "DB_RENDER_CONTROL"},
	{0x0002800C, 0, 0, "DB_RENDER_OVERRIDE"},
	{0x00028010, 0, 0, "DB_RENDER_OVERRIDE2"},
	{0x00028AC0, 0, 0, "DB_SRESULTS_COMPARE_STATE0"},
	{0x00028AC4, 0, 0, "DB_SRESULTS_COMPARE_STATE1"},
	{0x00028AC8, 0, 0, "DB_PRELOAD_CONTROL"},
	{0x00028B70, 0, 0, "DB_ALPHA_TO_MASK"},
};

/* different */
static const struct radeon_register EG_names_VS_SHADER[] = {
	{0x00028380, 0, 0, "SQ_VTX_SEMANTIC_0"},
	{0x00028384, 0, 0, "SQ_VTX_SEMANTIC_1"},
	{0x00028388, 0, 0, "SQ_VTX_SEMANTIC_2"},
	{0x0002838C, 0, 0, "SQ_VTX_SEMANTIC_3"},
	{0x00028390, 0, 0, "SQ_VTX_SEMANTIC_4"},
	{0x00028394, 0, 0, "SQ_VTX_SEMANTIC_5"},
	{0x00028398, 0, 0, "SQ_VTX_SEMANTIC_6"},
	{0x0002839C, 0, 0, "SQ_VTX_SEMANTIC_7"},
	{0x000283A0, 0, 0, "SQ_VTX_SEMANTIC_8"},
	{0x000283A4, 0, 0, "SQ_VTX_SEMANTIC_9"},
	{0x000283A8, 0, 0, "SQ_VTX_SEMANTIC_10"},
	{0x000283AC, 0, 0, "SQ_VTX_SEMANTIC_11"},
	{0x000283B0, 0, 0, "SQ_VTX_SEMANTIC_12"},
	{0x000283B4, 0, 0, "SQ_VTX_SEMANTIC_13"},
	{0x000283B8, 0, 0, "SQ_VTX_SEMANTIC_14"},
	{0x000283BC, 0, 0, "SQ_VTX_SEMANTIC_15"},
	{0x000283C0, 0, 0, "SQ_VTX_SEMANTIC_16"},
	{0x000283C4, 0, 0, "SQ_VTX_SEMANTIC_17"},
	{0x000283C8, 0, 0, "SQ_VTX_SEMANTIC_18"},
	{0x000283CC, 0, 0, "SQ_VTX_SEMANTIC_19"},
	{0x000283D0, 0, 0, "SQ_VTX_SEMANTIC_20"},
	{0x000283D4, 0, 0, "SQ_VTX_SEMANTIC_21"},
	{0x000283D8, 0, 0, "SQ_VTX_SEMANTIC_22"},
	{0x000283DC, 0, 0, "SQ_VTX_SEMANTIC_23"},
	{0x000283E0, 0, 0, "SQ_VTX_SEMANTIC_24"},
	{0x000283E4, 0, 0, "SQ_VTX_SEMANTIC_25"},
	{0x000283E8, 0, 0, "SQ_VTX_SEMANTIC_26"},
	{0x000283EC, 0, 0, "SQ_VTX_SEMANTIC_27"},
	{0x000283F0, 0, 0, "SQ_VTX_SEMANTIC_28"},
	{0x000283F4, 0, 0, "SQ_VTX_SEMANTIC_29"},
	{0x000283F8, 0, 0, "SQ_VTX_SEMANTIC_30"},
	{0x000283FC, 0, 0, "SQ_VTX_SEMANTIC_31"},
	{0x0002861C, 0, 0, "SPI_VS_OUT_ID_0"}, // all diff belwo
	{0x00028620, 0, 0, "SPI_VS_OUT_ID_1"},
	{0x00028624, 0, 0, "SPI_VS_OUT_ID_2"},
	{0x00028628, 0, 0, "SPI_VS_OUT_ID_3"},
	{0x0002862C, 0, 0, "SPI_VS_OUT_ID_4"},
	{0x00028630, 0, 0, "SPI_VS_OUT_ID_5"},
	{0x00028634, 0, 0, "SPI_VS_OUT_ID_6"},
	{0x00028638, 0, 0, "SPI_VS_OUT_ID_7"},
	{0x0002863C, 0, 0, "SPI_VS_OUT_ID_8"},
	{0x00028640, 0, 0, "SPI_VS_OUT_ID_9"},
	{0x000286C4, 0, 0, "SPI_VS_OUT_CONFIG"},
	{0x0002885C, 1, 0, "SQ_PGM_START_VS"}, 
	{0x00028860, 0, 0, "SQ_PGM_RESOURCES_VS"},
	{0x00028864, 0, 0, "SQ_PGM_RESOURCES_2_VS"},
	{0x000288A4, 1, 1, "SQ_PGM_START_FS"},
	{0x000288A8, 0, 0, "SQ_PGM_RESOURCES_FS"},
};

static const struct radeon_register EG_names_PS_SHADER[] = {
	{0x00028644, 0, 0, "SPI_PS_INPUT_CNTL_0"},
	{0x00028648, 0, 0, "SPI_PS_INPUT_CNTL_1"},
	{0x0002864C, 0, 0, "SPI_PS_INPUT_CNTL_2"},
	{0x00028650, 0, 0, "SPI_PS_INPUT_CNTL_3"},
	{0x00028654, 0, 0, "SPI_PS_INPUT_CNTL_4"},
	{0x00028658, 0, 0, "SPI_PS_INPUT_CNTL_5"},
	{0x0002865C, 0, 0, "SPI_PS_INPUT_CNTL_6"},
	{0x00028660, 0, 0, "SPI_PS_INPUT_CNTL_7"},
	{0x00028664, 0, 0, "SPI_PS_INPUT_CNTL_8"},
	{0x00028668, 0, 0, "SPI_PS_INPUT_CNTL_9"},
	{0x0002866C, 0, 0, "SPI_PS_INPUT_CNTL_10"},
	{0x00028670, 0, 0, "SPI_PS_INPUT_CNTL_11"},
	{0x00028674, 0, 0, "SPI_PS_INPUT_CNTL_12"},
	{0x00028678, 0, 0, "SPI_PS_INPUT_CNTL_13"},
	{0x0002867C, 0, 0, "SPI_PS_INPUT_CNTL_14"},
	{0x00028680, 0, 0, "SPI_PS_INPUT_CNTL_15"},
	{0x00028684, 0, 0, "SPI_PS_INPUT_CNTL_16"},
	{0x00028688, 0, 0, "SPI_PS_INPUT_CNTL_17"},
	{0x0002868C, 0, 0, "SPI_PS_INPUT_CNTL_18"},
	{0x00028690, 0, 0, "SPI_PS_INPUT_CNTL_19"},
	{0x00028694, 0, 0, "SPI_PS_INPUT_CNTL_20"},
	{0x00028698, 0, 0, "SPI_PS_INPUT_CNTL_21"},
	{0x0002869C, 0, 0, "SPI_PS_INPUT_CNTL_22"},
	{0x000286A0, 0, 0, "SPI_PS_INPUT_CNTL_23"},
	{0x000286A4, 0, 0, "SPI_PS_INPUT_CNTL_24"},
	{0x000286A8, 0, 0, "SPI_PS_INPUT_CNTL_25"},
	{0x000286AC, 0, 0, "SPI_PS_INPUT_CNTL_26"},
	{0x000286B0, 0, 0, "SPI_PS_INPUT_CNTL_27"},
	{0x000286B4, 0, 0, "SPI_PS_INPUT_CNTL_28"},
	{0x000286B8, 0, 0, "SPI_PS_INPUT_CNTL_29"},
	{0x000286BC, 0, 0, "SPI_PS_INPUT_CNTL_30"},
	{0x000286C0, 0, 0, "SPI_PS_INPUT_CNTL_31"},
	{0x000286C8, 0, 0, "SPI_THREAD_GROUPING"},
	{0x000286CC, 0, 0, "SPI_PS_IN_CONTROL_0"},
	{0x000286D0, 0, 0, "SPI_PS_IN_CONTROL_1"},
	{0x000286D8, 0, 0, "SPI_INPUT_Z"},
	{0x000286E0, 0, 0, "SPI_BARYC_CNTL"},
	{0x000286E4, 0, 0, "SPI_PS_IN_CONTROL_2"},
	{0x000286E8, 0, 0, "SPI_COMPUTE_INPUT_CNTL"},
	{0x00028840, 1, 0, "SQ_PGM_START_PS"}, // diff
	{0x00028844, 0, 0, "SQ_PGM_RESOURCES_PS"}, // diff
	{0x00028848, 0, 0, "SQ_PGM_RESOURCES_2_PS"}, // diff
	{0x0002884C, 0, 0, "SQ_PGM_EXPORTS_PS"}, // diff
};

/* different */
static const struct radeon_register EG_names_UCP[] = {
	{0x000285BC, 0, 0, "PA_CL_UCP0_X"},
	{0x000285C0, 0, 0, "PA_CL_UCP0_Y"},
	{0x000285C4, 0, 0, "PA_CL_UCP0_Z"},
	{0x000285C8, 0, 0, "PA_CL_UCP0_W"},
	{0x000285CC, 0, 0, "PA_CL_UCP1_X"},
	{0x000285D0, 0, 0, "PA_CL_UCP1_Y"},
	{0x000285D4, 0, 0, "PA_CL_UCP1_Z"},
	{0x000285D8, 0, 0, "PA_CL_UCP1_W"},
	{0x000285DC, 0, 0, "PA_CL_UCP2_X"},
	{0x000285E0, 0, 0, "PA_CL_UCP2_Y"},
	{0x000285E4, 0, 0, "PA_CL_UCP2_Z"},
	{0x000285E8, 0, 0, "PA_CL_UCP2_W"},
	{0x000285EC, 0, 0, "PA_CL_UCP3_X"},
	{0x000285F0, 0, 0, "PA_CL_UCP3_Y"},
	{0x000285F4, 0, 0, "PA_CL_UCP3_Z"},
	{0x000285F8, 0, 0, "PA_CL_UCP3_W"},
	{0x000285FC, 0, 0, "PA_CL_UCP4_X"},
	{0x00028600, 0, 0, "PA_CL_UCP4_Y"},
	{0x00028604, 0, 0, "PA_CL_UCP4_Z"},
	{0x00028608, 0, 0, "PA_CL_UCP4_W"},
	{0x0002860C, 0, 0, "PA_CL_UCP5_X"},
	{0x00028610, 0, 0, "PA_CL_UCP5_Y"},
	{0x00028614, 0, 0, "PA_CL_UCP5_Z"},
	{0x0002861C, 0, 0, "PA_CL_UCP5_W"},
};

static const struct radeon_register EG_names_VS_CBUF[] = {
	{0x00028180, 0, 0, "ALU_CONST_BUFFER_SIZE_VS_0"},
	{0x00028980, 1, 0, "ALU_CONST_CACHE_VS_0"},
};

static const struct radeon_register EG_names_PS_CBUF[] = {
	{0x00028140, 0, 0, "ALU_CONST_BUFFER_SIZE_PS_0"},
	{0x00028940, 1, 0, "ALU_CONST_CACHE_PS_0"},
};

static const struct radeon_register EG_names_PS_RESOURCE[] = {
	{0x00030000, 0, 0, "RESOURCE0_WORD0"},
	{0x00030004, 0, 0, "RESOURCE0_WORD1"},
	{0x00030008, 0, 0, "RESOURCE0_WORD2"},
	{0x0003000C, 0, 0, "RESOURCE0_WORD3"},
	{0x00030010, 0, 0, "RESOURCE0_WORD4"},
	{0x00030014, 0, 0, "RESOURCE0_WORD5"},
	{0x00030018, 0, 0, "RESOURCE0_WORD6"},
	{0x0003001c, 0, 0, "RESOURCE0_WORD7"},
};

static const struct radeon_register EG_names_VS_RESOURCE[] = {
	{0x00031600, 0, 0, "RESOURCE160_WORD0"},
	{0x00031604, 0, 0, "RESOURCE160_WORD1"},
	{0x00031608, 0, 0, "RESOURCE160_WORD2"},
	{0x0003160C, 0, 0, "RESOURCE160_WORD3"},
	{0x00031610, 0, 0, "RESOURCE160_WORD4"},
	{0x00031614, 0, 0, "RESOURCE160_WORD5"},
	{0x00031618, 0, 0, "RESOURCE160_WORD6"},
	{0x0003161c, 0, 0, "RESOURCE160_WORD7"},
};

static const struct radeon_register EG_names_FS_RESOURCE[] = {
	{0x0003A300, 0, 0, "RESOURCE320_WORD0"},
	{0x0003A304, 0, 0, "RESOURCE320_WORD1"},
	{0x0003A308, 0, 0, "RESOURCE320_WORD2"},
	{0x0003A30C, 0, 0, "RESOURCE320_WORD3"},
	{0x0003A310, 0, 0, "RESOURCE320_WORD4"},
	{0x0003A314, 0, 0, "RESOURCE320_WORD5"},
	{0x0003A318, 0, 0, "RESOURCE320_WORD6"},
	{0x0003A31C, 0, 0, "RESOURCE320_WORD7"},
};

static const struct radeon_register EG_names_GS_RESOURCE[] = {
	{0x0003A4C0, 0, 0, "RESOURCE336_WORD0"},
	{0x0003A4C4, 0, 0, "RESOURCE336_WORD1"},
	{0x0003A4C8, 0, 0, "RESOURCE336_WORD2"},
	{0x0003A4CC, 0, 0, "RESOURCE336_WORD3"},
	{0x0003A4D0, 0, 0, "RESOURCE336_WORD4"},
	{0x0003A4D4, 0, 0, "RESOURCE336_WORD5"},
	{0x0003A4D8, 0, 0, "RESOURCE336_WORD6"},
	{0x0003A4DC, 0, 0, "RESOURCE336_WORD7"},
};

static const struct radeon_register EG_names_PS_SAMPLER[] = {
	{0x0003C000, 0, 0, "SQ_TEX_SAMPLER_WORD0_0"},
	{0x0003C004, 0, 0, "SQ_TEX_SAMPLER_WORD1_0"},
	{0x0003C008, 0, 0, "SQ_TEX_SAMPLER_WORD2_0"},
};

static const struct radeon_register EG_names_VS_SAMPLER[] = {
	{0x0003C0D8, 0, 0, "SQ_TEX_SAMPLER_WORD0_18"},
	{0x0003C0DC, 0, 0, "SQ_TEX_SAMPLER_WORD1_18"},
	{0x0003C0E0, 0, 0, "SQ_TEX_SAMPLER_WORD2_18"},
};

static const struct radeon_register EG_names_GS_SAMPLER[] = {
	{0x0003C1B0, 0, 0, "SQ_TEX_SAMPLER_WORD0_36"},
	{0x0003C1B4, 0, 0, "SQ_TEX_SAMPLER_WORD1_36"},
	{0x0003C1B8, 0, 0, "SQ_TEX_SAMPLER_WORD2_36"},
};

static const struct radeon_register EG_names_PS_SAMPLER_BORDER[] = {
	{0x0000A400, 0, 0, "TD_PS_SAMPLER0_BORDER_RED"},
	{0x0000A404, 0, 0, "TD_PS_SAMPLER0_BORDER_GREEN"},
	{0x0000A408, 0, 0, "TD_PS_SAMPLER0_BORDER_BLUE"},
	{0x0000A40C, 0, 0, "TD_PS_SAMPLER0_BORDER_ALPHA"},
};

static const struct radeon_register EG_names_VS_SAMPLER_BORDER[] = {
	{0x0000A600, 0, 0, "TD_VS_SAMPLER0_BORDER_RED"},
	{0x0000A604, 0, 0, "TD_VS_SAMPLER0_BORDER_GREEN"},
	{0x0000A608, 0, 0, "TD_VS_SAMPLER0_BORDER_BLUE"},
	{0x0000A60C, 0, 0, "TD_VS_SAMPLER0_BORDER_ALPHA"},
};

static const struct radeon_register EG_names_GS_SAMPLER_BORDER[] = {
	{0x0000A800, 0, 0, "TD_GS_SAMPLER0_BORDER_RED"},
	{0x0000A804, 0, 0, "TD_GS_SAMPLER0_BORDER_GREEN"},
	{0x0000A808, 0, 0, "TD_GS_SAMPLER0_BORDER_BLUE"},
	{0x0000A80C, 0, 0, "TD_GS_SAMPLER0_BORDER_ALPHA"},
};

static const struct radeon_register EG_names_CB[] = {
	{0x00028C60, 1, 0, "CB_COLOR0_BASE"},
	{0x00028C64, 0, 0, "CB_COLOR0_PITCH"},
	{0x00028C68, 0, 0, "CB_COLOR0_SLICE"},
	{0x00028C6C, 0, 0, "CB_COLOR0_VIEW"},
	{0x00028C70, 1, 0, "CB_COLOR0_INFO"},
	{0x00028C74, 0, 0, "CB_COLOR0_ATTRIB"},
	{0x00028C78, 0, 0, "CB_COLOR0_DIM"},
};

/* different - TODO */
static const struct radeon_register EG_names_DB[] = {
	{0x00028014, 1, 0, "DB_HTILE_DATA_BASE"},
	{0x00028040, 1, 0, "DB_Z_INFO"},
	{0x00028044, 0, 0, "DB_STENCIL_INFO"},
	{0x00028058, 0, 0, "DB_DEPTH_SIZE"},
	{0x0002805C, 0, 0, "DB_DEPTH_SLICE"},
	{0x00028008, 0, 0, "DB_DEPTH_VIEW"},
	{0x00028ABC, 0, 0, "DB_HTILE_SURFACE"},
	{0x00028048, 1, 0, "DB_Z_READ_BASE"},
	{0x0002804C, 1, 0, "DB_STENCIL_READ_BASE"},
	{0x00028050, 1, 0, "DB_Z_WRITE_BASE"},
	{0x00028054, 1, 0, "DB_STENCIL_WRITE_BASE"},
};

static const struct radeon_register EG_names_VGT[] = {
	{0x00008958, 0, 0, "VGT_PRIMITIVE_TYPE"}, //s
	{0x00028400, 0, 0, "VGT_MAX_VTX_INDX"}, //s
	{0x00028404, 0, 0, "VGT_MIN_VTX_INDX"}, //s
	{0x00028408, 0, 0, "VGT_INDX_OFFSET"}, //s
	{0x00028A7C, 0, 0, "VGT_DMA_INDEX_TYPE"}, //s
	{0x00028A84, 0, 0, "VGT_PRIMITIVEID_EN"}, //s
	{0x00028A88, 0, 0, "VGT_DMA_NUM_INSTANCES"}, //s
	{0x00028A94, 0, 0, "VGT_MULTI_PRIM_IB_RESET_EN"}, //s
	{0x00028AA0, 0, 0, "VGT_INSTANCE_STEP_RATE_0"}, //s
	{0x00028AA4, 0, 0, "VGT_INSTANCE_STEP_RATE_1"}, //s
};

static const struct radeon_register EG_names_DRAW[] = { 
	{0x00008970, 0, 0, "VGT_NUM_INDICES"},
	{0x000287E4, 0, 0, "VGT_DMA_BASE_HI"},    //same
	{0x000287E8, 1, 0, "VGT_DMA_BASE"},       //same
	{0x000287F0, 0, 0, "VGT_DRAW_INITIATOR"}, //same
};

static const struct radeon_register EG_names_VGT_EVENT[] = {
	{0x00028A90, 1, 0, "VGT_EVENT_INITIATOR"}, //done
};

static const struct radeon_register EG_names_CB_FLUSH[] = {
};

static const struct radeon_register EG_names_DB_FLUSH[] = {
};

#endif
