#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# «manage-network-install»
#
# Ubiquity plugin for disabling NetworkManager during phase 1 install.-
#
# Copyright (C) 2012, Canonical, Ltd.
#
# Author:
#  - Christopher Townsend <Christopher.Townsend@canonical.com>

import os

from ubiquity.plugin import *
from ubiquity import misc

NAME = 'manage-network-install'
BEFORE = 'language'
WEIGHT = 10
OEM = False

class PageGtk(PluginUI):
    def __init__(self, controller, *args, **kwargs):
        self.controller = controller
        self.sleep_network()
        PluginUI.__init__(self, controller, *args, **kwargs)

    def sleep_network(self):
        misc.execute_root('nmcli', 'nm', 'sleep', 'true')

class Install(InstallPlugin):
    def wake_network(self):
        misc.execute_root('nmcli', 'nm', 'sleep', 'false')

    def install(self, target, progress, *args, **kwargs):
        self.wake_network()
