/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.openqa.selenium.server.CommandQueue;
import org.openqa.selenium.server.DefaultRemoteCommand;
import org.openqa.selenium.server.RemoteCommand;
import org.openqa.selenium.server.SingleEntryAsyncQueue;

public class CommandHolder {
    private static final Log logger = LogFactory.getLog(CommandHolder.class);
    private static final int defaultTimeout = 10;
    private static final RemoteCommand poisonCommand = new DefaultRemoteCommand("CommandHolder.POISION", "", "");
    protected static final String RETRY_CMD_STRING = "retryLast";
    protected static final RemoteCommand retryCommand = new DefaultRemoteCommand("retryLast", "", "", "");
    private final String queueId;
    private final SingleEntryAsyncQueue<RemoteCommand> queue;

    public CommandHolder(String queueId) {
        this(queueId, 10);
    }

    public CommandHolder(String queueId, int timeoutInSeconds) {
        this.queueId = queueId;
        this.queue = new SingleEntryAsyncQueue(timeoutInSeconds);
        this.queue.setPoison(poisonCommand);
    }

    public RemoteCommand getCommand() {
        logger.debug(this.hdr() + "called");
        RemoteCommand command = this.queue.pollToGetContentUntilTimeout();
        if (null == command) {
            command = retryCommand;
        } else if (this.queue.isPoison(command)) {
            command = null;
        }
        logger.debug(this.hdr() + "-> " + (null == command ? "null" : command.toString()));
        return command;
    }

    public boolean putCommand(RemoteCommand cmd) {
        logger.debug(this.hdr());
        return this.queue.putContent(cmd);
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public RemoteCommand peek() {
        return this.queue.peek();
    }

    public void poisonPollers() {
        logger.debug(this.hdr() + " poisoning pollers");
        this.queue.poisonPollers();
    }

    private String hdr() {
        return "\t" + CommandQueue.getIdentification("commandHolder", this.queueId) + " getCommand() ";
    }
}

