/***************************************************************************
 *
 * This file is covered by a dual licence. You can choose whether you
 * want to use it according to the terms of the GNU GPL version 2, or
 * under the terms of Zorp Professional Firewall System EULA located
 * on the Zorp installation CD.
 *
 * $Id: connect.h,v 1.15 2004/10/05 14:06:37 chaoron Exp $
 *
 ***************************************************************************/

#ifndef ZORP_CONNECT_H_INCLUDED
#define ZORP_CONNECT_H_INCLUDED


#include <zorp/zorplib.h>
#include <zorp/sockaddr.h>
#include <zorp/socket.h>

#ifdef __cplusplus
extern "C" {
#endif

/* z_io_connect public interface */

/*+

  Connect to the given socket address using the given local address,
  and call a given callback function if the connection is established.

  +*/
typedef struct _ZIOConnect 
{
  ZSockAddr *local;
  gint fd;
} ZIOConnect;

typedef void (*ZConnectFunc)(gint fd, GError *error, gpointer user_data);

ZIOConnect *
z_io_connect_new(const gchar *session_id,
                 ZSockAddr *local, 
                 ZSockAddr *remote,
                 guint32 sock_flags,
                 gint tos,
		 ZConnectFunc callback,
		 gpointer user_data);

ZSockAddr *z_io_connect_start_block(ZIOConnect *self);
ZSockAddr *z_io_connect_start(ZIOConnect *self);
ZSockAddr *z_io_connect_start_in_context(ZIOConnect *self, GMainContext *context);
void z_io_connect_ref(ZIOConnect *l);
void z_io_connect_unref(ZIOConnect *l);
void z_io_connect_set_timeout(ZIOConnect *l, gint timeout);
void z_io_connect_set_destroy_notify(ZIOConnect *l, GDestroyNotify notify);
void z_io_connect_cancel(ZIOConnect *l);

#ifdef __cplusplus
}
#endif
#endif
