/*
 * Copyright (c) 2015 Intel Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef _LIB_SENSOR_HUB_H_
#define _LIB_SENSOR_HUB_H_

#include "sensor_device.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef enum {
        FLAG_ANDROID_LIST = 1,
        FLAG_AWARE_LIST = 2,
} sensor_list_flag_t;

typedef struct {
        int list_size;
        int string_buffer_size;
        char * string_buffer_base;
} sensor_list_header_t;

typedef void * sensorhub_handle_t;
typedef void * session_id_t;

int sensorhub_get_sensors_list(const sensor_list_flag_t list_type, struct sensor_t const** list);
void sensorhub_release_sensors_list();
sensorhub_handle_t sensorhub_open(session_category_t category);
void sensorhub_close(sensorhub_handle_t sensorhub_handle);
int sensorhub_get_data_fd(sensorhub_handle_t sensorhub_handle);
int sensorhub_start_streaming(sensorhub_handle_t sensorhub_handle, int handle, int64_t sampling_period_us, int64_t max_report_latency_us);
int sensorhub_stop_streaming(sensorhub_handle_t sensorhub_handle, int handle);
int sensorhub_flush_streaming(sensorhub_handle_t sensorhub_handle, int handle);
int sensorhub_set_property(sensorhub_handle_t sensorhub_handle, int handle, void * property, size_t size);
size_t sensorhub_get_property(sensorhub_handle_t sensorhub_handle, int handle, void * command, size_t command_size, void ** property);

#ifdef __cplusplus
}
#endif

#endif
