/*
 * Decompiled with CFR 0.152.
 */
package httpserv;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;

class MyHandler
implements HttpHandler {
    MyHandler() {
    }

    public void handle(HttpExchange xchange) throws IOException {
        try {
            int lastIndex;
            File fileCurrent = new File(".");
            String sRequestPath = xchange.getRequestURI().getPath();
            System.out.println("requested: " + sRequestPath);
            File fileRequest = new File(new File(".").getCanonicalPath(), sRequestPath);
            if (!fileRequest.exists()) {
                throw new Exception("The file " + fileRequest.toString() + " does not exist!\n");
            }
            if (fileRequest.isDirectory()) {
                throw new Exception(fileRequest.toString() + " is a directory!\n");
            }
            byte[] data = new byte[(int)fileRequest.length()];
            FileInputStream fr = new FileInputStream(fileRequest);
            int count = fr.read(data);
            Headers h = xchange.getResponseHeaders();
            String canonicalPath = fileRequest.getCanonicalPath();
            String fileExtension = canonicalPath.substring((lastIndex = canonicalPath.lastIndexOf(".")) + 1);
            if (fileExtension.equalsIgnoreCase("crl")) {
                h.set("Content-Type", "application/pkix-crl");
            } else if (fileExtension.equalsIgnoreCase("crt") || fileExtension.equalsIgnoreCase("cer") || fileExtension.equalsIgnoreCase("der")) {
                h.set("Content-Type", "application/x-x509-ca-cert");
            }
            xchange.sendResponseHeaders(200, data.length);
            OutputStream os = xchange.getResponseBody();
            os.write(data);
            os.close();
            System.out.println("delivered: " + fileRequest.toString());
        }
        catch (Exception e) {
            xchange.sendResponseHeaders(404, e.getMessage().length());
            OutputStream os = xchange.getResponseBody();
            os.write(e.getMessage().getBytes());
            os.close();
            System.out.println("Error: " + e.getMessage());
        }
    }
}

