/*
 * Copyright (C) 2010 Canonical, Ltd.
 *
 * Authors:
 *  Olivier Tilloy <olivier.tilloy@canonical.com>
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; version 3.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 */

#ifndef QT_BAMF_MATCHER_H
#define QT_BAMF_MATCHER_H

#include <QtCore/QObject>

#include "bamf-list.h"

class OrgAyatanaBamfMatcherInterface;
class BamfView;
class BamfApplication;
class BamfWindow;

class BamfMatcher: public QObject
{
    Q_OBJECT

public:
    static BamfMatcher& get_default()
    {
        static BamfMatcher instance;
        return instance;
    }

private:
    BamfMatcher();
    BamfMatcher(BamfMatcher const&);
    void operator=(BamfMatcher const&);
    ~BamfMatcher();

    OrgAyatanaBamfMatcherInterface *m_proxy;

public:
    Q_INVOKABLE BamfApplication *active_application() const;
    Q_INVOKABLE BamfWindow *active_window() const;
    Q_INVOKABLE BamfApplication *application_for_xid(uint xid) const;
    Q_INVOKABLE bool application_is_running(const QString& application) const;
    Q_INVOKABLE BamfApplicationList *applications() const;
    Q_INVOKABLE BamfApplicationList *running_applications() const;

Q_SIGNALS:
    void ActiveApplicationChanged(BamfApplication *former, BamfApplication *current);
    void ActiveWindowChanged(BamfWindow *former, BamfWindow *current);
    void ViewClosed(BamfView *view);
    void ViewOpened(BamfView *view);

private Q_SLOTS:
    void OnActiveApplicationChanged(const QString &old_active, const QString &new_active);
    void OnActiveWindowChanged(const QString &old_active, const QString &new_active);
    void OnViewClosed(const QString &path, const QString &type);
    void OnViewOpened(const QString &path, const QString &type);
};

#endif

