/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.tests.utils.impl;

import java.lang.reflect.Method;
import org.powermock.core.MockRepository;
import org.powermock.core.spi.PowerMockTestListener;
import org.powermock.core.spi.testresult.Result;
import org.powermock.core.spi.testresult.TestMethodResult;
import org.powermock.core.spi.testresult.TestSuiteResult;
import org.powermock.core.spi.testresult.impl.TestMethodResultImpl;
import org.powermock.tests.utils.PowerMockTestNotifier;

public class PowerMockTestNotifierImpl
implements PowerMockTestNotifier {
    private static final String ERROR_MESSAGE_TEMPLATE = "Invoking the %s method on PowerMock test listener %s failed.";
    private final PowerMockTestListener[] powerMockTestListeners;

    public PowerMockTestNotifierImpl(PowerMockTestListener[] powerMockTestListenerArray) {
        this.powerMockTestListeners = powerMockTestListenerArray == null ? new PowerMockTestListener[0] : powerMockTestListenerArray;
    }

    @Override
    public void notifyAfterTestMethod(Object object, Method method, Object[] objectArray, TestMethodResult testMethodResult) {
        for (int i = 0; i < this.powerMockTestListeners.length; ++i) {
            PowerMockTestListener powerMockTestListener = this.powerMockTestListeners[i];
            try {
                powerMockTestListener.afterTestMethod(object, method, objectArray, testMethodResult);
                continue;
            }
            catch (Exception exception) {
                throw new RuntimeException(String.format(ERROR_MESSAGE_TEMPLATE, "afterTestMethod", powerMockTestListener), exception);
            }
        }
    }

    @Override
    public void notifyAfterTestSuiteEnded(Class<?> clazz, Method[] methodArray, TestSuiteResult testSuiteResult) {
        for (PowerMockTestListener powerMockTestListener : this.powerMockTestListeners) {
            try {
                powerMockTestListener.afterTestSuiteEnded(clazz, methodArray, testSuiteResult);
            }
            catch (Exception exception) {
                throw new RuntimeException(String.format(ERROR_MESSAGE_TEMPLATE, "afterTestSuiteEnded", powerMockTestListener), exception);
            }
        }
    }

    @Override
    public void notifyBeforeTestMethod(Object object, Method method, Object[] objectArray) {
        MockRepository.putAdditionalState("powermock.test.instance", object);
        MockRepository.putAdditionalState("powermock.test.method", method);
        MockRepository.putAdditionalState("powermock.test.arguments", objectArray);
        for (int i = 0; i < this.powerMockTestListeners.length; ++i) {
            PowerMockTestListener powerMockTestListener = this.powerMockTestListeners[i];
            try {
                powerMockTestListener.beforeTestMethod(object, method, objectArray);
                continue;
            }
            catch (Exception exception) {
                throw new RuntimeException(String.format(ERROR_MESSAGE_TEMPLATE, "beforeTestMethod", powerMockTestListener), exception);
            }
        }
    }

    @Override
    public void notifyBeforeTestSuiteStarted(Class<?> clazz, Method[] methodArray) {
        for (PowerMockTestListener powerMockTestListener : this.powerMockTestListeners) {
            try {
                powerMockTestListener.beforeTestSuiteStarted(clazz, methodArray);
            }
            catch (Exception exception) {
                throw new RuntimeException(String.format(ERROR_MESSAGE_TEMPLATE, "beforeTestSuiteStarted", powerMockTestListener), exception);
            }
        }
    }

    @Override
    public void notifyAfterTestMethod(boolean bl) {
        Object t = MockRepository.getAdditionalState("powermock.test.instance");
        Method method = (Method)MockRepository.getAdditionalState("powermock.test.method");
        Object[] objectArray = (Object[])MockRepository.getAdditionalState("powermock.test.arguments");
        TestMethodResultImpl testMethodResultImpl = new TestMethodResultImpl(bl ? Result.SUCCESSFUL : Result.FAILED);
        this.notifyAfterTestMethod(t, method, objectArray, testMethodResultImpl);
    }
}

