/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.support;

public class ClassLoaderUtil {
    public static <T> Class<T> loadClass(Class<T> clazz, ClassLoader classLoader) {
        return ClassLoaderUtil.loadClass(clazz.getName(), classLoader);
    }

    public static <T> Class<T> loadClass(String string) {
        return ClassLoaderUtil.loadClass(string, ClassLoaderUtil.class.getClassLoader());
    }

    public static <T> boolean hasClass(Class<T> clazz, ClassLoader classLoader) {
        try {
            ClassLoaderUtil.loadClass(clazz.getName(), classLoader);
            return true;
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException.getCause() instanceof ClassNotFoundException) {
                return false;
            }
            throw runtimeException;
        }
    }

    public static <T> Class<T> loadClass(String string, ClassLoader classLoader) {
        if (string == null) {
            throw new IllegalArgumentException("className cannot be null");
        }
        if (classLoader == null) {
            throw new IllegalArgumentException("classloader cannot be null");
        }
        try {
            return Class.forName(string, false, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }
}

