/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.internal.mockcreation;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.cglib.proxy.MethodInterceptor;
import org.mockito.internal.MockHandler;
import org.mockito.internal.MockitoInvocationHandler;
import org.mockito.internal.configuration.GlobalConfiguration;
import org.mockito.internal.creation.MethodInterceptorFilter;
import org.mockito.internal.creation.MockSettingsImpl;
import org.mockito.internal.creation.jmock.ClassImposterizer;
import org.mockito.internal.progress.ThreadSafeMockingProgress;
import org.mockito.internal.util.reflection.LenientCopyTool;
import org.powermock.api.mockito.internal.invocationcontrol.MockitoMethodInvocationControl;
import org.powermock.api.support.ClassLoaderUtil;
import org.powermock.core.ClassReplicaCreator;
import org.powermock.core.DefaultFieldValueGenerator;
import org.powermock.core.MockRepository;
import org.powermock.reflect.Whitebox;

public class MockCreator {
    public static <T> T mock(Class<T> clazz, boolean bl, boolean bl2, Object object, MockSettings mockSettings, Method ... methodArray) {
        if (clazz == null) {
            throw new IllegalArgumentException("The class to mock cannot be null");
        }
        T t = null;
        String string = MockCreator.toInstanceName(clazz);
        MockRepository.addAfterMethodRunner(new MockitoStateCleaner());
        Class<Object> clazz2 = MockCreator.isFinalJavaSystemClass(clazz) ? new ClassReplicaCreator().createClassReplica(clazz) : clazz;
        MockData<T> mockData = MockCreator.createMethodInvocationControl(string, clazz2, methodArray, bl2, object, mockSettings);
        t = mockData.getMock();
        if (MockCreator.isFinalJavaSystemClass(clazz) && !bl) {
            t = Whitebox.newInstance(clazz);
            DefaultFieldValueGenerator.fillWithDefaultValues(t);
        }
        if (bl) {
            MockRepository.putStaticMethodInvocationControl(clazz, mockData.getMethodInvocationControl());
        } else {
            MockRepository.putInstanceMethodInvocationControl(t, mockData.getMethodInvocationControl());
        }
        if (bl2) {
            new LenientCopyTool().copyToMock(object, t);
        }
        return t;
    }

    private static <T> boolean isFinalJavaSystemClass(Class<T> clazz) {
        return clazz.getName().startsWith("java.") && Modifier.isFinal(clazz.getModifiers());
    }

    private static <T> MockData<T> createMethodInvocationControl(String string, Class<T> clazz, Method[] methodArray, boolean bl, Object object, MockSettings mockSettings) {
        MockSettingsImpl mockSettingsImpl = mockSettings == null ? (MockSettingsImpl)Mockito.withSettings() : (MockSettingsImpl)mockSettings;
        if (bl) {
            mockSettingsImpl.defaultAnswer(Mockito.CALLS_REAL_METHODS);
        }
        mockSettingsImpl.initiateMockName(clazz);
        MockHandler mockHandler = new MockHandler(mockSettingsImpl);
        MethodInterceptorFilter methodInterceptorFilter = new MethodInterceptorFilter((MockitoInvocationHandler)mockHandler, mockSettingsImpl);
        Object object2 = ClassImposterizer.INSTANCE.imposterise((MethodInterceptor)methodInterceptorFilter, clazz, new Class[0]);
        MockitoMethodInvocationControl mockitoMethodInvocationControl = new MockitoMethodInvocationControl(methodInterceptorFilter, bl && object == null ? new Object() : object, object2, methodArray);
        return new MockData<Object>(mockitoMethodInvocationControl, object2);
    }

    private static String toInstanceName(Class<?> clazz) {
        String string = clazz.getSimpleName();
        if (string.length() == 0) {
            return clazz.getName();
        }
        return string.substring(0, 1).toLowerCase() + string.substring(1);
    }

    private static class MockitoStateCleaner
    implements Runnable {
        private MockitoStateCleaner() {
        }

        @Override
        public void run() {
            this.clearMockProgress();
            this.clearConfiguration();
        }

        private void clearMockProgress() {
            this.clearThreadLocalIn(ThreadSafeMockingProgress.class);
        }

        private void clearConfiguration() {
            this.clearThreadLocalIn(GlobalConfiguration.class);
        }

        private void clearThreadLocalIn(Class<?> clazz) {
            Whitebox.getInternalState(clazz, ThreadLocal.class).set(null);
            Class<?> clazz2 = ClassLoaderUtil.hasClass(clazz, ClassLoader.getSystemClassLoader()) ? ClassLoaderUtil.loadClass(clazz, ClassLoader.getSystemClassLoader()) : ClassLoaderUtil.loadClass(clazz, clazz.getClassLoader());
            Whitebox.getInternalState(clazz2, ThreadLocal.class).set(null);
        }
    }

    private static class MockData<T> {
        private final MockitoMethodInvocationControl methodInvocationControl;
        private final T mock;

        MockData(MockitoMethodInvocationControl mockitoMethodInvocationControl, T t) {
            this.methodInvocationControl = mockitoMethodInvocationControl;
            this.mock = t;
        }

        public MockitoMethodInvocationControl getMethodInvocationControl() {
            return this.methodInvocationControl;
        }

        public T getMock() {
            return this.mock;
        }
    }
}

