/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.util;

import java.util.HashMap;
import java.util.Map;

public class Primitives {
    private static Map<Class<?>, Object> wrapperReturnValues = new HashMap();
    private static Map<Class<?>, Class<?>> primitiveTypes = new HashMap();
    private static Map<Class<?>, Object> primitiveValues = new HashMap();

    public static boolean isPrimitiveWrapper(Class<?> clazz) {
        return wrapperReturnValues.containsKey(clazz);
    }

    public static <T> T primitiveWrapperOf(Class<T> clazz) {
        return (T)wrapperReturnValues.get(clazz);
    }

    public static <T> Class<T> primitiveTypeOf(Class<T> clazz) {
        return primitiveTypes.get(clazz);
    }

    public static <T> T primitiveValueOrNullFor(Class<T> clazz) {
        return (T)primitiveValues.get(clazz);
    }

    static {
        wrapperReturnValues.put(Boolean.class, Boolean.FALSE);
        wrapperReturnValues.put(Character.class, new Character('\u0000'));
        wrapperReturnValues.put(Byte.class, new Byte(0));
        wrapperReturnValues.put(Short.class, new Short(0));
        wrapperReturnValues.put(Integer.class, new Integer(0));
        wrapperReturnValues.put(Long.class, new Long(0L));
        wrapperReturnValues.put(Float.class, new Float(0.0f));
        wrapperReturnValues.put(Double.class, new Double(0.0));
        primitiveTypes.put(Boolean.class, Boolean.TYPE);
        primitiveTypes.put(Character.class, Character.TYPE);
        primitiveTypes.put(Byte.class, Byte.TYPE);
        primitiveTypes.put(Short.class, Short.TYPE);
        primitiveTypes.put(Integer.class, Integer.TYPE);
        primitiveTypes.put(Long.class, Long.TYPE);
        primitiveTypes.put(Float.class, Float.TYPE);
        primitiveTypes.put(Double.class, Double.TYPE);
        primitiveValues.put(Boolean.TYPE, false);
        primitiveValues.put(Character.TYPE, 0);
        primitiveValues.put(Byte.TYPE, 0);
        primitiveValues.put(Short.TYPE, 0);
        primitiveValues.put(Integer.TYPE, 0);
        primitiveValues.put(Long.TYPE, 0);
        primitiveValues.put(Float.TYPE, 0);
        primitiveValues.put(Double.TYPE, 0);
    }
}

