/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.util;

import org.mockito.exceptions.Reporter;
import org.mockito.internal.creation.jmock.ClassImposterizer;

public class MockCreationValidator {
    public boolean isTypeMockable(Class<?> clazz) {
        return ClassImposterizer.INSTANCE.canImposterise(clazz);
    }

    public void validateType(Class clazz) {
        if (!this.isTypeMockable(clazz)) {
            new Reporter().cannotMockFinalClass(clazz);
        }
    }

    public void validateExtraInterfaces(Class clazz, Class ... classArray) {
        if (classArray == null) {
            return;
        }
        for (Class clazz2 : classArray) {
            if (clazz != clazz2) continue;
            new Reporter().extraInterfacesCannotContainMockedType(clazz);
        }
    }

    public void validateMockedType(Class clazz, Object object) {
        if (clazz == null || object == null) {
            return;
        }
        if (!clazz.equals(object.getClass())) {
            new Reporter().mockedTypeIsInconsistentWithSpiedInstanceType(clazz, object);
        }
    }
}

