/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration.injection;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mockito.exceptions.Reporter;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.configuration.injection.MockInjectionStrategy;
import org.mockito.internal.configuration.injection.filter.FinalMockCandidateFilter;
import org.mockito.internal.configuration.injection.filter.MockCandidateFilter;
import org.mockito.internal.configuration.injection.filter.NameBasedCandidateFilter;
import org.mockito.internal.configuration.injection.filter.TypeBasedCandidateFilter;
import org.mockito.internal.util.ListUtil;
import org.mockito.internal.util.reflection.FieldInitializationReport;
import org.mockito.internal.util.reflection.FieldInitializer;

public class PropertyAndSetterInjection
extends MockInjectionStrategy {
    private final MockCandidateFilter mockCandidateFilter = new TypeBasedCandidateFilter(new NameBasedCandidateFilter(new FinalMockCandidateFilter()));
    private Comparator<Field> superTypesLast = new Comparator<Field>(){

        @Override
        public int compare(Field field, Field field2) {
            Class<?> clazz;
            Class<?> clazz2 = field.getType();
            if (clazz2.isAssignableFrom(clazz = field2.getType())) {
                return 1;
            }
            if (clazz.isAssignableFrom(clazz2)) {
                return -1;
            }
            return 0;
        }
    };
    private ListUtil.Filter<Field> notFinalOrStatic = new ListUtil.Filter<Field>(){

        @Override
        public boolean isOut(Field field) {
            return Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers());
        }
    };

    @Override
    public boolean processInjection(Field field, Object object, Set<Object> set) {
        Serializable serializable;
        FieldInitializationReport fieldInitializationReport = null;
        try {
            fieldInitializationReport = new FieldInitializer(object, field).initialize();
        }
        catch (MockitoException mockitoException) {
            if (mockitoException.getCause() instanceof InvocationTargetException) {
                serializable = mockitoException.getCause().getCause();
                new Reporter().fieldInitialisationThrewException(field, (Throwable)serializable);
            }
            new Reporter().cannotInitializeForInjectMocksAnnotation(field.getName(), mockitoException);
        }
        boolean bl = false;
        Object object2 = fieldInitializationReport.fieldInstance();
        for (serializable = fieldInitializationReport.fieldClass(); serializable != Object.class; serializable = ((Class)serializable).getSuperclass()) {
            bl |= this.injectMockCandidate((Class<?>)serializable, (Set<Object>)new HashSet<Object>(set), object2);
        }
        return bl;
    }

    private boolean injectMockCandidate(Class<?> clazz, Set<Object> set, Object object) {
        boolean bl = false;
        for (Field field : this.orderedInstanceFieldsFrom(clazz)) {
            Object object2 = this.mockCandidateFilter.filterCandidate(set, field, object).thenInject();
            if (object2 == null) continue;
            bl |= true;
            set.remove(object2);
        }
        return bl;
    }

    private List<Field> orderedInstanceFieldsFrom(Class<?> clazz) {
        List<Field> list = Arrays.asList(clazz.getDeclaredFields());
        list = ListUtil.filter(list, this.notFinalOrStatic);
        Collections.sort(list, this.superTypesLast);
        return list;
    }
}

