/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.cglib.proxy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.mockito.asm.ClassVisitor;
import org.mockito.cglib.core.AbstractClassGenerator;
import org.mockito.cglib.core.ClassesKey;
import org.mockito.cglib.core.KeyFactory;
import org.mockito.cglib.core.ReflectUtils;
import org.mockito.cglib.proxy.MixinBeanEmitter;
import org.mockito.cglib.proxy.MixinEmitter;
import org.mockito.cglib.proxy.MixinEverythingEmitter;

public abstract class Mixin {
    private static final MixinKey KEY_FACTORY = (MixinKey)((Object)KeyFactory.create(MixinKey.class, KeyFactory.CLASS_BY_NAME));
    private static final Map ROUTE_CACHE = Collections.synchronizedMap(new HashMap());
    public static final int STYLE_INTERFACES = 0;
    public static final int STYLE_BEANS = 1;
    public static final int STYLE_EVERYTHING = 2;

    public abstract Mixin newInstance(Object[] var1);

    public static Mixin create(Object[] objectArray) {
        Generator generator = new Generator();
        generator.setDelegates(objectArray);
        return generator.create();
    }

    public static Mixin create(Class[] classArray, Object[] objectArray) {
        Generator generator = new Generator();
        generator.setClasses(classArray);
        generator.setDelegates(objectArray);
        return generator.create();
    }

    public static Mixin createBean(Object[] objectArray) {
        return Mixin.createBean(null, objectArray);
    }

    public static Mixin createBean(ClassLoader classLoader, Object[] objectArray) {
        Generator generator = new Generator();
        generator.setStyle(1);
        generator.setDelegates(objectArray);
        generator.setClassLoader(classLoader);
        return generator.create();
    }

    public static Class[] getClasses(Object[] objectArray) {
        return (Class[])Mixin.route(objectArray).classes.clone();
    }

    private static Route route(Object[] objectArray) {
        Object object = ClassesKey.create(objectArray);
        Route route = (Route)ROUTE_CACHE.get(object);
        if (route == null) {
            route = new Route(objectArray);
            ROUTE_CACHE.put(object, route);
        }
        return route;
    }

    private static class Route {
        private Class[] classes;
        private int[] route;

        Route(Object[] objectArray) {
            Object object;
            Object object2;
            int n;
            HashMap<Class, Integer> hashMap = new HashMap<Class, Integer>();
            ArrayList arrayList = new ArrayList();
            for (n = 0; n < objectArray.length; ++n) {
                object2 = objectArray[n].getClass();
                arrayList.clear();
                ReflectUtils.addAllInterfaces(object2, arrayList);
                object = arrayList.iterator();
                while (object.hasNext()) {
                    Class clazz = (Class)object.next();
                    if (hashMap.containsKey(clazz)) continue;
                    hashMap.put(clazz, new Integer(n));
                }
            }
            this.classes = new Class[hashMap.size()];
            this.route = new int[hashMap.size()];
            n = 0;
            object2 = hashMap.keySet().iterator();
            while (object2.hasNext()) {
                this.classes[n] = object = (Class)object2.next();
                this.route[n] = (Integer)hashMap.get(object);
                ++n;
            }
        }
    }

    public static class Generator
    extends AbstractClassGenerator {
        private static final AbstractClassGenerator.Source SOURCE = new AbstractClassGenerator.Source(Mixin.class.getName());
        private Class[] classes;
        private Object[] delegates;
        private int style = 0;
        private int[] route;

        public Generator() {
            super(SOURCE);
        }

        @Override
        protected ClassLoader getDefaultClassLoader() {
            return this.classes[0].getClassLoader();
        }

        public void setStyle(int n) {
            switch (n) {
                case 0: 
                case 1: 
                case 2: {
                    this.style = n;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown mixin style: " + n);
                }
            }
        }

        public void setClasses(Class[] classArray) {
            this.classes = classArray;
        }

        public void setDelegates(Object[] objectArray) {
            this.delegates = objectArray;
        }

        public Mixin create() {
            if (this.classes == null && this.delegates == null) {
                throw new IllegalStateException("Either classes or delegates must be set");
            }
            switch (this.style) {
                case 0: {
                    if (this.classes != null) break;
                    Route route = Mixin.route(this.delegates);
                    this.classes = route.classes;
                    this.route = route.route;
                    break;
                }
                case 1: 
                case 2: {
                    if (this.classes == null) {
                        this.classes = ReflectUtils.getClasses(this.delegates);
                        break;
                    }
                    if (this.delegates == null) break;
                    Class[] classArray = ReflectUtils.getClasses(this.delegates);
                    if (this.classes.length != classArray.length) {
                        throw new IllegalStateException("Specified classes are incompatible with delegates");
                    }
                    for (int i = 0; i < this.classes.length; ++i) {
                        if (this.classes[i].isAssignableFrom(classArray[i])) continue;
                        throw new IllegalStateException("Specified class " + this.classes[i] + " is incompatible with delegate class " + classArray[i] + " (index " + i + ")");
                    }
                    break;
                }
            }
            this.setNamePrefix(this.classes[ReflectUtils.findPackageProtected(this.classes)].getName());
            return (Mixin)super.create(KEY_FACTORY.newInstance(this.style, ReflectUtils.getNames(this.classes), this.route));
        }

        @Override
        public void generateClass(ClassVisitor classVisitor) {
            switch (this.style) {
                case 0: {
                    new MixinEmitter(classVisitor, this.getClassName(), this.classes, this.route);
                    break;
                }
                case 1: {
                    new MixinBeanEmitter(classVisitor, this.getClassName(), this.classes);
                    break;
                }
                case 2: {
                    new MixinEverythingEmitter(classVisitor, this.getClassName(), this.classes);
                }
            }
        }

        @Override
        protected Object firstInstance(Class clazz) {
            return ((Mixin)ReflectUtils.newInstance(clazz)).newInstance(this.delegates);
        }

        @Override
        protected Object nextInstance(Object object) {
            return ((Mixin)object).newInstance(this.delegates);
        }
    }

    static interface MixinKey {
        public Object newInstance(int var1, String[] var2, int[] var3);
    }
}

