/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.cglib.beans;

import org.mockito.asm.ClassVisitor;
import org.mockito.cglib.beans.BulkBeanEmitter;
import org.mockito.cglib.core.AbstractClassGenerator;
import org.mockito.cglib.core.KeyFactory;
import org.mockito.cglib.core.ReflectUtils;

public abstract class BulkBean {
    private static final BulkBeanKey KEY_FACTORY = (BulkBeanKey)((Object)KeyFactory.create(BulkBeanKey.class));
    protected Class target;
    protected String[] getters;
    protected String[] setters;
    protected Class[] types;

    protected BulkBean() {
    }

    public abstract void getPropertyValues(Object var1, Object[] var2);

    public abstract void setPropertyValues(Object var1, Object[] var2);

    public Object[] getPropertyValues(Object object) {
        Object[] objectArray = new Object[this.getters.length];
        this.getPropertyValues(object, objectArray);
        return objectArray;
    }

    public Class[] getPropertyTypes() {
        return (Class[])this.types.clone();
    }

    public String[] getGetters() {
        return (String[])this.getters.clone();
    }

    public String[] getSetters() {
        return (String[])this.setters.clone();
    }

    public static BulkBean create(Class clazz, String[] stringArray, String[] stringArray2, Class[] classArray) {
        Generator generator = new Generator();
        generator.setTarget(clazz);
        generator.setGetters(stringArray);
        generator.setSetters(stringArray2);
        generator.setTypes(classArray);
        return generator.create();
    }

    public static class Generator
    extends AbstractClassGenerator {
        private static final AbstractClassGenerator.Source SOURCE = new AbstractClassGenerator.Source(BulkBean.class.getName());
        private Class target;
        private String[] getters;
        private String[] setters;
        private Class[] types;

        public Generator() {
            super(SOURCE);
        }

        public void setTarget(Class clazz) {
            this.target = clazz;
        }

        public void setGetters(String[] stringArray) {
            this.getters = stringArray;
        }

        public void setSetters(String[] stringArray) {
            this.setters = stringArray;
        }

        public void setTypes(Class[] classArray) {
            this.types = classArray;
        }

        @Override
        protected ClassLoader getDefaultClassLoader() {
            return this.target.getClassLoader();
        }

        public BulkBean create() {
            this.setNamePrefix(this.target.getName());
            String string = this.target.getName();
            String[] stringArray = ReflectUtils.getNames(this.types);
            Object object = KEY_FACTORY.newInstance(string, this.getters, this.setters, stringArray);
            return (BulkBean)super.create(object);
        }

        @Override
        public void generateClass(ClassVisitor classVisitor) throws Exception {
            new BulkBeanEmitter(classVisitor, this.getClassName(), this.target, this.getters, this.setters, this.types);
        }

        @Override
        protected Object firstInstance(Class clazz) {
            BulkBean bulkBean = (BulkBean)ReflectUtils.newInstance(clazz);
            bulkBean.target = this.target;
            int n = this.getters.length;
            bulkBean.getters = new String[n];
            System.arraycopy(this.getters, 0, bulkBean.getters, 0, n);
            bulkBean.setters = new String[n];
            System.arraycopy(this.setters, 0, bulkBean.setters, 0, n);
            bulkBean.types = new Class[this.types.length];
            System.arraycopy(this.types, 0, bulkBean.types, 0, this.types.length);
            return bulkBean;
        }

        @Override
        protected Object nextInstance(Object object) {
            return object;
        }
    }

    static interface BulkBeanKey {
        public Object newInstance(String var1, String[] var2, String[] var3, String[] var4);
    }
}

