/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.cglib.beans;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.mockito.asm.ClassVisitor;
import org.mockito.cglib.beans.BeanMapEmitter;
import org.mockito.cglib.core.AbstractClassGenerator;
import org.mockito.cglib.core.KeyFactory;
import org.mockito.cglib.core.ReflectUtils;

public abstract class BeanMap
implements Map {
    public static final int REQUIRE_GETTER = 1;
    public static final int REQUIRE_SETTER = 2;
    protected Object bean;

    public static BeanMap create(Object object) {
        Generator generator = new Generator();
        generator.setBean(object);
        return generator.create();
    }

    public abstract BeanMap newInstance(Object var1);

    public abstract Class getPropertyType(String var1);

    protected BeanMap() {
    }

    protected BeanMap(Object object) {
        this.setBean(object);
    }

    public Object get(Object object) {
        return this.get(this.bean, object);
    }

    public Object put(Object object, Object object2) {
        return this.put(this.bean, object, object2);
    }

    public abstract Object get(Object var1, Object var2);

    public abstract Object put(Object var1, Object var2, Object var3);

    public void setBean(Object object) {
        this.bean = object;
    }

    public Object getBean() {
        return this.bean;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.keySet().contains(object);
    }

    @Override
    public boolean containsValue(Object object) {
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            Object object2 = this.get(iterator.next());
            if ((object != null || object2 != null) && !object.equals(object2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Object remove(Object object) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map map) {
        for (Object k : map.keySet()) {
            this.put(k, map.get(k));
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (this.size() != map.size()) {
            return false;
        }
        for (Object k : this.keySet()) {
            if (!map.containsKey(k)) {
                return false;
            }
            Object object2 = this.get(k);
            Object v = map.get(k);
            if (object2 != null ? object2.equals(v) : v == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n = 0;
        for (Object k : this.keySet()) {
            Object object = this.get(k);
            n += (k == null ? 0 : k.hashCode()) ^ (object == null ? 0 : object.hashCode());
        }
        return n;
    }

    public Set entrySet() {
        HashMap hashMap = new HashMap();
        for (Object k : this.keySet()) {
            hashMap.put(k, this.get(k));
        }
        return Collections.unmodifiableMap(hashMap).entrySet();
    }

    public Collection values() {
        Set set = this.keySet();
        ArrayList<Object> arrayList = new ArrayList<Object>(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            arrayList.add(this.get(iterator.next()));
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            stringBuffer.append(k);
            stringBuffer.append('=');
            stringBuffer.append(this.get(k));
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public static class Generator
    extends AbstractClassGenerator {
        private static final AbstractClassGenerator.Source SOURCE = new AbstractClassGenerator.Source(BeanMap.class.getName());
        private static final BeanMapKey KEY_FACTORY = (BeanMapKey)((Object)KeyFactory.create(BeanMapKey.class, KeyFactory.CLASS_BY_NAME));
        private Object bean;
        private Class beanClass;
        private int require;

        public Generator() {
            super(SOURCE);
        }

        public void setBean(Object object) {
            this.bean = object;
            if (object != null) {
                this.beanClass = object.getClass();
            }
        }

        public void setBeanClass(Class clazz) {
            this.beanClass = clazz;
        }

        public void setRequire(int n) {
            this.require = n;
        }

        @Override
        protected ClassLoader getDefaultClassLoader() {
            return this.beanClass.getClassLoader();
        }

        public BeanMap create() {
            if (this.beanClass == null) {
                throw new IllegalArgumentException("Class of bean unknown");
            }
            this.setNamePrefix(this.beanClass.getName());
            return (BeanMap)super.create(KEY_FACTORY.newInstance(this.beanClass, this.require));
        }

        @Override
        public void generateClass(ClassVisitor classVisitor) throws Exception {
            new BeanMapEmitter(classVisitor, this.getClassName(), this.beanClass, this.require);
        }

        @Override
        protected Object firstInstance(Class clazz) {
            return ((BeanMap)ReflectUtils.newInstance(clazz)).newInstance(this.bean);
        }

        @Override
        protected Object nextInstance(Object object) {
            return ((BeanMap)object).newInstance(this.bean);
        }

        static interface BeanMapKey {
            public Object newInstance(Class var1, int var2);
        }
    }
}

