/* service.c generated by valac 0.9.7, the Vala compiler
 * generated from service.vala, do not modify */

/*
 * Copyright(C) 2010 Neil Jagdish Patel
 * Copyright(C) 2010 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 * Authored by Ken VaDine <ken.vandine@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <stdlib.h>
#include <string.h>
#include <dbus/dbus.h>
#include <json-glib/json-glib.h>


#define TYPE_SERVICE_INTERFACE (service_interface_get_type ())
#define SERVICE_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SERVICE_INTERFACE, ServiceInterface))
#define IS_SERVICE_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SERVICE_INTERFACE))
#define SERVICE_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_SERVICE_INTERFACE, ServiceInterfaceIface))

typedef struct _ServiceInterface ServiceInterface;
typedef struct _ServiceInterfaceIface ServiceInterfaceIface;
typedef struct _DBusObjectVTable _DBusObjectVTable;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ServiceInterfaceDBusProxy ServiceInterfaceDBusProxy;
typedef DBusGProxyClass ServiceInterfaceDBusProxyClass;

#define GWIBBER_TYPE_SERVICE (gwibber_service_get_type ())
#define GWIBBER_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GWIBBER_TYPE_SERVICE, GwibberService))
#define GWIBBER_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GWIBBER_TYPE_SERVICE, GwibberServiceClass))
#define GWIBBER_IS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GWIBBER_TYPE_SERVICE))
#define GWIBBER_IS_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GWIBBER_TYPE_SERVICE))
#define GWIBBER_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GWIBBER_TYPE_SERVICE, GwibberServiceClass))

typedef struct _GwibberService GwibberService;
typedef struct _GwibberServiceClass GwibberServiceClass;
typedef struct _GwibberServicePrivate GwibberServicePrivate;

#define GWIBBER_TYPE_UTILS (gwibber_utils_get_type ())
#define GWIBBER_UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GWIBBER_TYPE_UTILS, GwibberUtils))
#define GWIBBER_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GWIBBER_TYPE_UTILS, GwibberUtilsClass))
#define GWIBBER_IS_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GWIBBER_TYPE_UTILS))
#define GWIBBER_IS_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GWIBBER_TYPE_UTILS))
#define GWIBBER_UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GWIBBER_TYPE_UTILS, GwibberUtilsClass))

typedef struct _GwibberUtils GwibberUtils;
typedef struct _GwibberUtilsClass GwibberUtilsClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))

struct _ServiceInterfaceIface {
	GTypeInterface parent_iface;
	void (*Start) (ServiceInterface* self, GError** error);
	void (*Quit) (ServiceInterface* self, GError** error);
	void (*Refresh) (ServiceInterface* self, GError** error);
	void (*SendMessage) (ServiceInterface* self, const char* msg, GError** error);
	char* (*GetFeatures) (ServiceInterface* self, GError** error);
	char* (*GetServices) (ServiceInterface* self, GError** error);
	char* (*GetVersion) (ServiceInterface* self, GError** error);
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};

struct _ServiceInterfaceDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _GwibberService {
	GObject parent_instance;
	GwibberServicePrivate * priv;
};

struct _GwibberServiceClass {
	GObjectClass parent_class;
};

struct _GwibberServicePrivate {
	ServiceInterface* service;
	GHashTable* services_table;
	GHashTable* service_table;
	GHashTable* service_attr_table;
	GHashTable* features_table;
	GHashTable* feature_table;
	GwibberUtils* utils;
};


static gpointer gwibber_service_parent_class = NULL;

ServiceInterface* service_interface_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType service_interface_get_type (void) G_GNUC_CONST;
void service_interface_Start (ServiceInterface* self, GError** error);
void service_interface_Quit (ServiceInterface* self, GError** error);
void service_interface_Refresh (ServiceInterface* self, GError** error);
void service_interface_SendMessage (ServiceInterface* self, const char* msg, GError** error);
char* service_interface_GetFeatures (ServiceInterface* self, GError** error);
char* service_interface_GetServices (ServiceInterface* self, GError** error);
char* service_interface_GetVersion (ServiceInterface* self, GError** error);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);
void service_interface_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _service_interface_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult service_interface_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_service_interface_introspect (ServiceInterface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_service_interface_property_get_all (ServiceInterface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_service_interface_Start (ServiceInterface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_service_interface_Quit (ServiceInterface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_service_interface_Refresh (ServiceInterface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_service_interface_SendMessage (ServiceInterface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_service_interface_GetFeatures (ServiceInterface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_service_interface_GetServices (ServiceInterface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_service_interface_GetVersion (ServiceInterface* self, DBusConnection* connection, DBusMessage* message);
GType service_interface_dbus_proxy_get_type (void) G_GNUC_CONST;
DBusHandlerResult service_interface_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	SERVICE_INTERFACE_DBUS_PROXY_DUMMY_PROPERTY
};
static void service_interface_dbus_proxy_Start (ServiceInterface* self, GError** error);
static void service_interface_dbus_proxy_Quit (ServiceInterface* self, GError** error);
static void service_interface_dbus_proxy_Refresh (ServiceInterface* self, GError** error);
static void service_interface_dbus_proxy_SendMessage (ServiceInterface* self, const char* msg, GError** error);
static char* service_interface_dbus_proxy_GetFeatures (ServiceInterface* self, GError** error);
static char* service_interface_dbus_proxy_GetServices (ServiceInterface* self, GError** error);
static char* service_interface_dbus_proxy_GetVersion (ServiceInterface* self, GError** error);
static void service_interface_dbus_proxy_service_interface__interface_init (ServiceInterfaceIface* iface);
static void service_interface_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void service_interface_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType gwibber_service_get_type (void) G_GNUC_CONST;
GType gwibber_utils_get_type (void) G_GNUC_CONST;
#define GWIBBER_SERVICE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GWIBBER_TYPE_SERVICE, GwibberServicePrivate))
enum  {
	GWIBBER_SERVICE_DUMMY_PROPERTY
};
#define GWIBBER_SERVICE_service_name "com.Gwibber.Service"
#define GWIBBER_SERVICE_service_path "/com/gwibber/Service"
#define GWIBBER_SERVICE_service_iface "com.Gwibber.Service"
GwibberService* gwibber_service_new (void);
GwibberService* gwibber_service_construct (GType object_type);
void gwibber_service_service_available (GwibberService* self, gboolean is_up);
void gwibber_service_start (GwibberService* self);
void gwibber_service_quit (GwibberService* self);
void gwibber_service_refresh (GwibberService* self);
void gwibber_service_send_message (GwibberService* self, const char* message);
GHashTable* gwibber_service_services (GwibberService* self);
static void _g_hash_table_remove_all_gdestroy_notify (void* data);
static GValue* _g_value_dup (GValue* self);
GHashTable* gwibber_service_features (GwibberService* self);
char* gwibber_service_version (GwibberService* self);
GwibberUtils* gwibber_utils_new (void);
GwibberUtils* gwibber_utils_construct (GType object_type);
void gwibber_utils_setup (GwibberUtils* self, const char* name, GError** error);
static void _gwibber_service_service_available_gwibber_utils_available (GwibberUtils* _sender, gboolean up, gpointer self);
static GObject * gwibber_service_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gwibber_service_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);

static const DBusObjectPathVTable _service_interface_dbus_path_vtable = {_service_interface_dbus_unregister, service_interface_dbus_message};
static const _DBusObjectVTable _service_interface_dbus_vtable = {service_interface_dbus_register_object};


void service_interface_Start (ServiceInterface* self, GError** error) {
	SERVICE_INTERFACE_GET_INTERFACE (self)->Start (self, error);
}


void service_interface_Quit (ServiceInterface* self, GError** error) {
	SERVICE_INTERFACE_GET_INTERFACE (self)->Quit (self, error);
}


void service_interface_Refresh (ServiceInterface* self, GError** error) {
	SERVICE_INTERFACE_GET_INTERFACE (self)->Refresh (self, error);
}


void service_interface_SendMessage (ServiceInterface* self, const char* msg, GError** error) {
	SERVICE_INTERFACE_GET_INTERFACE (self)->SendMessage (self, msg, error);
}


char* service_interface_GetFeatures (ServiceInterface* self, GError** error) {
	return SERVICE_INTERFACE_GET_INTERFACE (self)->GetFeatures (self, error);
}


char* service_interface_GetServices (ServiceInterface* self, GError** error) {
	return SERVICE_INTERFACE_GET_INTERFACE (self)->GetServices (self, error);
}


char* service_interface_GetVersion (ServiceInterface* self, GError** error) {
	return SERVICE_INTERFACE_GET_INTERFACE (self)->GetVersion (self, error);
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}


void _service_interface_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_service_interface_introspect (ServiceInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"com.Gwibber.Service\">\n  <method name=\"Start\">\n  </method>\n  <method name=\"Quit\">\n  </method>\n  <method name=\"Refresh\">\n  </method>\n  <method name=\"SendMessage\">\n    <arg name=\"msg\" type=\"s\" direction=\"in\"/>\n  </method>\n  <method name=\"GetFeatures\">\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <method name=\"GetServices\">\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <method name=\"GetVersion\">\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_service_interface_property_get_all (ServiceInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0_);
	if (strcmp (interface_name, "com.Gwibber.Service") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_service_interface_Start (ServiceInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	service_interface_Start (self, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_service_interface_Quit (ServiceInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	service_interface_Quit (self, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_service_interface_Refresh (ServiceInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	service_interface_Refresh (self, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_service_interface_SendMessage (ServiceInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* msg = NULL;
	const char* _tmp1_;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp1_);
	dbus_message_iter_next (&iter);
	msg = g_strdup (_tmp1_);
	service_interface_SendMessage (self, msg, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_free0 (msg);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_service_interface_GetFeatures (ServiceInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* result;
	DBusMessage* reply;
	const char* _tmp2_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	result = service_interface_GetFeatures (self, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp2_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &_tmp2_);
	_g_free0 (result);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_service_interface_GetServices (ServiceInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* result;
	DBusMessage* reply;
	const char* _tmp3_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	result = service_interface_GetServices (self, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp3_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &_tmp3_);
	_g_free0 (result);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_service_interface_GetVersion (ServiceInterface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* result;
	DBusMessage* reply;
	const char* _tmp4_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	result = service_interface_GetVersion (self, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp4_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &_tmp4_);
	_g_free0 (result);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult service_interface_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_service_interface_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_service_interface_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "com.Gwibber.Service", "Start")) {
		result = _dbus_service_interface_Start (object, connection, message);
	} else if (dbus_message_is_method_call (message, "com.Gwibber.Service", "Quit")) {
		result = _dbus_service_interface_Quit (object, connection, message);
	} else if (dbus_message_is_method_call (message, "com.Gwibber.Service", "Refresh")) {
		result = _dbus_service_interface_Refresh (object, connection, message);
	} else if (dbus_message_is_method_call (message, "com.Gwibber.Service", "SendMessage")) {
		result = _dbus_service_interface_SendMessage (object, connection, message);
	} else if (dbus_message_is_method_call (message, "com.Gwibber.Service", "GetFeatures")) {
		result = _dbus_service_interface_GetFeatures (object, connection, message);
	} else if (dbus_message_is_method_call (message, "com.Gwibber.Service", "GetServices")) {
		result = _dbus_service_interface_GetServices (object, connection, message);
	} else if (dbus_message_is_method_call (message, "com.Gwibber.Service", "GetVersion")) {
		result = _dbus_service_interface_GetVersion (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void service_interface_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_service_interface_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
}


static void service_interface_base_init (ServiceInterfaceIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_type_set_qdata (TYPE_SERVICE_INTERFACE, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_service_interface_dbus_vtable));
	}
}


GType service_interface_get_type (void) {
	static volatile gsize service_interface_type_id__volatile = 0;
	if (g_once_init_enter (&service_interface_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ServiceInterfaceIface), (GBaseInitFunc) service_interface_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType service_interface_type_id;
		service_interface_type_id = g_type_register_static (G_TYPE_INTERFACE, "ServiceInterface", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (service_interface_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (service_interface_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &service_interface_dbus_proxy_get_type);
		g_once_init_leave (&service_interface_type_id__volatile, service_interface_type_id);
	}
	return service_interface_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (ServiceInterfaceDBusProxy, service_interface_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_SERVICE_INTERFACE, service_interface_dbus_proxy_service_interface__interface_init) );
ServiceInterface* service_interface_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	ServiceInterface* self;
	self = g_object_new (service_interface_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "com.Gwibber.Service", NULL);
	return self;
}


static GObject* service_interface_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (service_interface_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), service_interface_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


DBusHandlerResult service_interface_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void service_interface_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((ServiceInterfaceDBusProxy*) self)->disposed) {
		return;
	}
	((ServiceInterfaceDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), service_interface_dbus_proxy_filter, self);
	G_OBJECT_CLASS (service_interface_dbus_proxy_parent_class)->dispose (self);
}


static void service_interface_dbus_proxy_class_init (ServiceInterfaceDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = service_interface_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = service_interface_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = service_interface_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = service_interface_dbus_proxy_set_property;
}


static void service_interface_dbus_proxy_init (ServiceInterfaceDBusProxy* self) {
}


static void service_interface_dbus_proxy_Start (ServiceInterface* self, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	if (((ServiceInterfaceDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "com.Gwibber.Service", "Start");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp0_;
			_edomain = DBUS_GERROR;
			_tmp0_ = _dbus_error.name + 27;
			if (strcmp (_tmp0_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp0_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp0_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp0_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp0_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp0_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp0_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp0_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp0_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp0_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp0_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp0_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp0_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp0_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp0_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp0_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp0_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp0_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp0_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp0_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp0_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp0_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp0_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp0_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp0_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp0_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp0_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp0_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp0_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp0_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp0_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp0_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp0_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void service_interface_dbus_proxy_Quit (ServiceInterface* self, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	if (((ServiceInterfaceDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "com.Gwibber.Service", "Quit");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp1_;
			_edomain = DBUS_GERROR;
			_tmp1_ = _dbus_error.name + 27;
			if (strcmp (_tmp1_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp1_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp1_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp1_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp1_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp1_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp1_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp1_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp1_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp1_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp1_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp1_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp1_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp1_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp1_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp1_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp1_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp1_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp1_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp1_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp1_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp1_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp1_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp1_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp1_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp1_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp1_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp1_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp1_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp1_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp1_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp1_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp1_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void service_interface_dbus_proxy_Refresh (ServiceInterface* self, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	if (((ServiceInterfaceDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "com.Gwibber.Service", "Refresh");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp2_;
			_edomain = DBUS_GERROR;
			_tmp2_ = _dbus_error.name + 27;
			if (strcmp (_tmp2_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp2_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp2_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp2_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp2_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp2_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp2_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp2_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp2_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp2_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp2_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp2_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp2_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp2_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp2_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp2_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp2_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp2_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp2_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp2_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp2_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp2_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp2_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp2_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp2_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp2_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp2_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp2_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp2_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp2_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp2_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp2_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp2_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void service_interface_dbus_proxy_SendMessage (ServiceInterface* self, const char* msg, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp3_;
	if (((ServiceInterfaceDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "com.Gwibber.Service", "SendMessage");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp3_ = msg;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp3_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp4_;
			_edomain = DBUS_GERROR;
			_tmp4_ = _dbus_error.name + 27;
			if (strcmp (_tmp4_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp4_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp4_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp4_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp4_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp4_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp4_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp4_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp4_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp4_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp4_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp4_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp4_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp4_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp4_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp4_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp4_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp4_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp4_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp4_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp4_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp4_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp4_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp4_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp4_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp4_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp4_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp4_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp4_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp4_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp4_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp4_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp4_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static char* service_interface_dbus_proxy_GetFeatures (ServiceInterface* self, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	char* _result;
	const char* _tmp5_;
	if (((ServiceInterfaceDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "com.Gwibber.Service", "GetFeatures");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp6_;
			_edomain = DBUS_GERROR;
			_tmp6_ = _dbus_error.name + 27;
			if (strcmp (_tmp6_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp6_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp6_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp6_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp6_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp6_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp6_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp6_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp6_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp6_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp6_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp6_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp6_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp6_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp6_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp6_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp6_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp6_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp6_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp6_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp6_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp6_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp6_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp6_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp6_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp6_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp6_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp6_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp6_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp6_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp6_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp6_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp6_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "s")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "s", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp5_);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp5_);
	dbus_message_unref (_reply);
	return _result;
}


static char* service_interface_dbus_proxy_GetServices (ServiceInterface* self, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	char* _result;
	const char* _tmp7_;
	if (((ServiceInterfaceDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "com.Gwibber.Service", "GetServices");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp8_;
			_edomain = DBUS_GERROR;
			_tmp8_ = _dbus_error.name + 27;
			if (strcmp (_tmp8_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp8_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp8_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp8_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp8_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp8_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp8_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp8_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp8_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp8_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp8_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp8_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp8_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp8_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp8_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp8_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp8_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp8_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp8_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp8_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp8_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp8_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp8_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp8_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp8_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp8_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp8_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp8_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp8_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp8_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp8_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp8_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp8_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "s")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "s", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp7_);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp7_);
	dbus_message_unref (_reply);
	return _result;
}


static char* service_interface_dbus_proxy_GetVersion (ServiceInterface* self, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	char* _result;
	const char* _tmp9_;
	if (((ServiceInterfaceDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "com.Gwibber.Service", "GetVersion");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp10_;
			_edomain = DBUS_GERROR;
			_tmp10_ = _dbus_error.name + 27;
			if (strcmp (_tmp10_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp10_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp10_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp10_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp10_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp10_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp10_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp10_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp10_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp10_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp10_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp10_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp10_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp10_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp10_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp10_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp10_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp10_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp10_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp10_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp10_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp10_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp10_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp10_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp10_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp10_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp10_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp10_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp10_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp10_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp10_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp10_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp10_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "s")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "s", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp9_);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp9_);
	dbus_message_unref (_reply);
	return _result;
}


static void service_interface_dbus_proxy_service_interface__interface_init (ServiceInterfaceIface* iface) {
	iface->Start = service_interface_dbus_proxy_Start;
	iface->Quit = service_interface_dbus_proxy_Quit;
	iface->Refresh = service_interface_dbus_proxy_Refresh;
	iface->SendMessage = service_interface_dbus_proxy_SendMessage;
	iface->GetFeatures = service_interface_dbus_proxy_GetFeatures;
	iface->GetServices = service_interface_dbus_proxy_GetServices;
	iface->GetVersion = service_interface_dbus_proxy_GetVersion;
}


static void service_interface_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void service_interface_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


GwibberService* gwibber_service_construct (GType object_type) {
	GwibberService * self;
	self = (GwibberService*) g_object_new (object_type, NULL);
	return self;
}


GwibberService* gwibber_service_new (void) {
	return gwibber_service_construct (GWIBBER_TYPE_SERVICE);
}


void gwibber_service_service_available (GwibberService* self, gboolean is_up) {
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self, "is-available", is_up);
}


/**
            start:

            Tells the gwibber service to perform a refresh.
        */
void gwibber_service_start (GwibberService* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		service_interface_Start (self->priv->service, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch0_dbus_gerror;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally0;
	__catch0_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("service.vala:95: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


/**
            quit:

            Tells the gwibber service to shutdown.
        */
void gwibber_service_quit (GwibberService* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		service_interface_Quit (self->priv->service, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch1_dbus_gerror;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally1;
	__catch1_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("service.vala:109: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


/**
            refresh:

            Tells the gwibber service to perform a refresh.
        */
void gwibber_service_refresh (GwibberService* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		service_interface_Refresh (self->priv->service, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch2_dbus_gerror;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally2;
	__catch2_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("service.vala:123: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


/**
            send_message:
            @message: The message to post to Gwibber

            Posts a message to the enabled services.
        */
void gwibber_service_send_message (GwibberService* self, const char* message) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	{
		service_interface_SendMessage (self->priv->service, message, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch3_dbus_gerror;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally3;
	__catch3_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("service.vala:138: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void _g_hash_table_remove_all_gdestroy_notify (void* data) {
	g_hash_table_remove_all (data);
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


static gpointer __g_value_dup0 (gpointer self) {
	return self ? _g_value_dup (self) : NULL;
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


GHashTable* gwibber_service_services (GwibberService* self) {
	GHashTable* result = NULL;
	GHashTable* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	self->priv->services_table = (_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, _g_hash_table_remove_all_gdestroy_notify), _g_hash_table_unref0 (self->priv->services_table), _tmp0_);
	{
		char* services;
		JsonParser* parser;
		JsonObject* root_object;
		services = service_interface_GetServices (self->priv->service, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
		parser = json_parser_new ();
		{
			json_parser_load_from_data (parser, services, -1, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch5_g_error;
			}
		}
		goto __finally5;
		__catch5_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("service.vala:151: %s", e->message);
				result = NULL;
				_g_error_free0 (e);
				_g_object_unref0 (parser);
				_g_free0 (services);
				return result;
			}
		}
		__finally5:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (parser);
			_g_free0 (services);
			goto __catch4_g_error;
		}
		root_object = _json_object_ref0 (json_node_get_object (json_parser_get_root (parser)));
		{
			GList* service_collection;
			GList* service_it;
			service_collection = json_object_get_members (root_object);
			for (service_it = service_collection; service_it != NULL; service_it = service_it->next) {
				const char* service;
				service = (const char*) service_it->data;
				{
					GHashTable* _tmp1_;
					JsonObject* services_object;
					self->priv->service_table = (_tmp1_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free), _g_hash_table_unref0 (self->priv->service_table), _tmp1_);
					services_object = _json_object_ref0 (json_node_get_object (json_object_get_member (root_object, service)));
					{
						GList* member_collection;
						GList* member_it;
						member_collection = json_object_get_members (services_object);
						for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
							const char* member;
							member = (const char*) member_it->data;
							{
								GValue* value = NULL;
								if (_vala_strcmp0 (json_node_type_name (json_object_get_member (services_object, member)), "JsonArray") == 0) {
									JsonArray* service_array;
									GValue* _tmp10_ = NULL;
									service_array = _json_array_ref0 (json_node_get_array (json_parser_get_root (parser)));
									{
										gint i;
										i = 0;
										{
											gboolean _tmp2_;
											_tmp2_ = TRUE;
											while (TRUE) {
												GHashTable* _tmp3_;
												if (!_tmp2_) {
													i++;
												}
												_tmp2_ = FALSE;
												if (!(i < json_array_get_length (service_array))) {
													break;
												}
												self->priv->service_attr_table = (_tmp3_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free), _g_hash_table_unref0 (self->priv->service_attr_table), _tmp3_);
												{
													GList* service_attr_collection;
													GList* service_attr_it;
													service_attr_collection = json_object_get_members (json_node_get_object (json_array_get_element (service_array, (guint) i)));
													for (service_attr_it = service_attr_collection; service_attr_it != NULL; service_attr_it = service_attr_it->next) {
														const char* service_attr;
														service_attr = (const char*) service_attr_it->data;
														{
															if (json_node_is_null (json_object_get_member (json_node_get_object (json_array_get_element (service_array, (guint) i)), service_attr))) {
																continue;
															} else {
																if (_vala_strcmp0 (json_node_type_name (json_object_get_member (json_node_get_object (json_array_get_element (service_array, (guint) i)), service_attr)), "gboolean") == 0) {
																	GValue* _tmp4_ = NULL;
																	GValue* _tmp5_;
																	value = (_tmp5_ = (_tmp4_ = g_new0 (GValue, 1), g_value_init (_tmp4_, G_TYPE_BOOLEAN), g_value_set_boolean (_tmp4_, json_node_get_boolean (json_object_get_member (json_node_get_object (json_array_get_element (service_array, (guint) i)), service_attr))), _tmp4_), _g_free0 (value), _tmp5_);
																} else {
																	GValue _tmp6_ = {0};
																	GValue* _tmp7_;
																	GValue _tmp8_;
																	GValue _tmp9_;
																	json_node_get_value (json_object_get_member (json_node_get_object (json_array_get_element (service_array, (guint) i)), service_attr), &_tmp6_);
																	value = (_tmp7_ = __g_value_dup0 ((_tmp9_ = _tmp8_ = _tmp6_, &_tmp9_)), _g_free0 (value), _tmp7_);
																	G_IS_VALUE (&_tmp8_) ? (g_value_unset (&_tmp8_), NULL) : NULL;
																}
															}
															g_hash_table_insert (self->priv->service_attr_table, g_strdup (service_attr), __g_value_dup0 (value));
														}
													}
													_g_list_free0 (service_attr_collection);
												}
											}
										}
									}
									g_hash_table_insert (self->priv->service_table, g_strdup (member), (_tmp10_ = g_new0 (GValue, 1), g_value_init (_tmp10_, G_TYPE_HASH_TABLE), g_value_set_boxed (_tmp10_, self->priv->service_attr_table), _tmp10_));
									_json_array_unref0 (service_array);
									_g_free0 (value);
									continue;
								} else {
									if (json_node_is_null (json_object_get_member (services_object, member))) {
										_g_free0 (value);
										continue;
									} else {
										if (_vala_strcmp0 (json_node_type_name (json_object_get_member (services_object, member)), "gboolean") == 0) {
											GValue* _tmp11_ = NULL;
											GValue* _tmp12_;
											value = (_tmp12_ = (_tmp11_ = g_new0 (GValue, 1), g_value_init (_tmp11_, G_TYPE_BOOLEAN), g_value_set_boolean (_tmp11_, json_node_get_boolean (json_object_get_member (services_object, member))), _tmp11_), _g_free0 (value), _tmp12_);
										} else {
											GValue _tmp13_ = {0};
											GValue* _tmp14_;
											GValue _tmp15_;
											GValue _tmp16_;
											json_node_get_value (json_object_get_member (services_object, member), &_tmp13_);
											value = (_tmp14_ = __g_value_dup0 ((_tmp16_ = _tmp15_ = _tmp13_, &_tmp16_)), _g_free0 (value), _tmp14_);
											G_IS_VALUE (&_tmp15_) ? (g_value_unset (&_tmp15_), NULL) : NULL;
										}
									}
								}
								g_hash_table_insert (self->priv->service_table, g_strdup (member), __g_value_dup0 (value));
								_g_free0 (value);
							}
						}
						_g_list_free0 (member_collection);
					}
					g_hash_table_insert (self->priv->services_table, g_strdup (service), _g_hash_table_ref0 (self->priv->service_table));
					_json_object_unref0 (services_object);
				}
			}
			_g_list_free0 (service_collection);
		}
		result = _g_hash_table_ref0 (self->priv->services_table);
		_json_object_unref0 (root_object);
		_g_object_unref0 (parser);
		_g_free0 (services);
		return result;
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("service.vala:190: %s", e->message);
			result = NULL;
			_g_error_free0 (e);
			return result;
		}
	}
	__finally4:
	{
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


GHashTable* gwibber_service_features (GwibberService* self) {
	GHashTable* result = NULL;
	GHashTable* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	self->priv->features_table = (_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, _g_hash_table_remove_all_gdestroy_notify), _g_hash_table_unref0 (self->priv->features_table), _tmp0_);
	{
		char* features;
		JsonParser* parser;
		JsonObject* root_object;
		features = service_interface_GetFeatures (self->priv->service, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch6_dbus_gerror;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		parser = json_parser_new ();
		{
			json_parser_load_from_data (parser, features, (gssize) (-1), &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch7_g_error;
			}
		}
		goto __finally7;
		__catch7_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("service.vala:204: %s", e->message);
				result = NULL;
				_g_error_free0 (e);
				_g_object_unref0 (parser);
				_g_free0 (features);
				return result;
			}
		}
		__finally7:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (parser);
			_g_free0 (features);
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch6_dbus_gerror;
			}
			_g_object_unref0 (parser);
			_g_free0 (features);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		root_object = _json_object_ref0 (json_node_get_object (json_parser_get_root (parser)));
		{
			GList* feature_collection;
			GList* feature_it;
			feature_collection = json_object_get_members (root_object);
			for (feature_it = feature_collection; feature_it != NULL; feature_it = feature_it->next) {
				const char* feature;
				feature = (const char*) feature_it->data;
				{
					GHashTable* _tmp1_;
					JsonObject* features_object;
					self->priv->feature_table = (_tmp1_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free), _g_hash_table_unref0 (self->priv->feature_table), _tmp1_);
					features_object = _json_object_ref0 (json_node_get_object (json_object_get_member (root_object, feature)));
					{
						GList* member_collection;
						GList* member_it;
						member_collection = json_object_get_members (features_object);
						for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
							const char* member;
							member = (const char*) member_it->data;
							{
								GValue* value;
								value = NULL;
								if (json_node_is_null (json_object_get_member (features_object, member))) {
									_g_free0 (value);
									continue;
								} else {
									if (_vala_strcmp0 (json_node_type_name (json_object_get_member (features_object, member)), "gboolean") == 0) {
										GValue* _tmp2_ = NULL;
										GValue* _tmp3_;
										value = (_tmp3_ = (_tmp2_ = g_new0 (GValue, 1), g_value_init (_tmp2_, G_TYPE_BOOLEAN), g_value_set_boolean (_tmp2_, json_node_get_boolean (json_object_get_member (features_object, member))), _tmp2_), _g_free0 (value), _tmp3_);
									} else {
										GValue _tmp4_ = {0};
										GValue* _tmp5_;
										GValue _tmp6_;
										GValue _tmp7_;
										json_node_get_value (json_object_get_member (features_object, member), &_tmp4_);
										value = (_tmp5_ = __g_value_dup0 ((_tmp7_ = _tmp6_ = _tmp4_, &_tmp7_)), _g_free0 (value), _tmp5_);
										G_IS_VALUE (&_tmp6_) ? (g_value_unset (&_tmp6_), NULL) : NULL;
									}
								}
								g_hash_table_insert (self->priv->feature_table, g_strdup (member), __g_value_dup0 (value));
								_g_free0 (value);
							}
						}
						_g_list_free0 (member_collection);
					}
					g_hash_table_insert (self->priv->features_table, g_strdup (feature), _g_hash_table_ref0 (self->priv->feature_table));
					_json_object_unref0 (features_object);
				}
			}
			_g_list_free0 (feature_collection);
		}
		result = _g_hash_table_ref0 (self->priv->features_table);
		_json_object_unref0 (root_object);
		_g_object_unref0 (parser);
		_g_free0 (features);
		return result;
	}
	goto __finally6;
	__catch6_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("service.vala:226: %s", e->message);
			result = NULL;
			_g_error_free0 (e);
			return result;
		}
	}
	__finally6:
	{
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


/**
            get_version:

            Return value: the version of the Gwibber service that is running.
        */
char* gwibber_service_version (GwibberService* self) {
	char* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	{
		char* _tmp0_;
		_tmp0_ = service_interface_GetVersion (self->priv->service, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch8_dbus_gerror;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally8;
	__catch8_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("service.vala:242: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally8:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = g_strdup ("");
	return result;
}


static void _gwibber_service_service_available_gwibber_utils_available (GwibberUtils* _sender, gboolean up, gpointer self) {
	gwibber_service_service_available (self, up);
}


static GObject * gwibber_service_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GwibberService * self;
	GError * _inner_error_;
	parent_class = G_OBJECT_CLASS (gwibber_service_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GWIBBER_SERVICE (obj);
	_inner_error_ = NULL;
	{
		{
			DBusGConnection* dbus_conn;
			ServiceInterface* _tmp0_;
			GwibberUtils* _tmp1_;
			dbus_conn = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch9_g_error;
			}
			self->priv->service = (_tmp0_ = service_interface_dbus_proxy_new (dbus_conn, GWIBBER_SERVICE_service_name, GWIBBER_SERVICE_service_path), _g_object_unref0 (self->priv->service), _tmp0_);
			self->priv->utils = (_tmp1_ = gwibber_utils_new (), _g_object_unref0 (self->priv->utils), _tmp1_);
			gwibber_utils_setup (self->priv->utils, GWIBBER_SERVICE_service_name, &_inner_error_);
			if (_inner_error_ != NULL) {
				_dbus_g_connection_unref0 (dbus_conn);
				goto __catch9_g_error;
			}
			g_signal_connect_object (self->priv->utils, "available", (GCallback) _gwibber_service_service_available_gwibber_utils_available, self, 0);
			_dbus_g_connection_unref0 (dbus_conn);
		}
		goto __finally9;
		__catch9_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("service.vala:76: Unable to get Gwibber service");
				_g_error_free0 (e);
			}
		}
		__finally9:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
	}
	return obj;
}


static void gwibber_service_class_init (GwibberServiceClass * klass) {
	gwibber_service_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GwibberServicePrivate));
	G_OBJECT_CLASS (klass)->constructor = gwibber_service_constructor;
	G_OBJECT_CLASS (klass)->finalize = gwibber_service_finalize;
	/** 
	            Service::is_available:
	            @arg0: The current state
	
	            Emitted when com.Gwibber.Service availability state changes
	        */
	g_signal_new ("is_available", GWIBBER_TYPE_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
}


static void gwibber_service_instance_init (GwibberService * self) {
	self->priv = GWIBBER_SERVICE_GET_PRIVATE (self);
}


static void gwibber_service_finalize (GObject* obj) {
	GwibberService * self;
	self = GWIBBER_SERVICE (obj);
	_g_object_unref0 (self->priv->service);
	_g_hash_table_unref0 (self->priv->services_table);
	_g_hash_table_unref0 (self->priv->service_table);
	_g_hash_table_unref0 (self->priv->service_attr_table);
	_g_hash_table_unref0 (self->priv->features_table);
	_g_hash_table_unref0 (self->priv->feature_table);
	_g_object_unref0 (self->priv->utils);
	G_OBJECT_CLASS (gwibber_service_parent_class)->finalize (obj);
}


GType gwibber_service_get_type (void) {
	static volatile gsize gwibber_service_type_id__volatile = 0;
	if (g_once_init_enter (&gwibber_service_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GwibberServiceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gwibber_service_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GwibberService), 0, (GInstanceInitFunc) gwibber_service_instance_init, NULL };
		GType gwibber_service_type_id;
		gwibber_service_type_id = g_type_register_static (G_TYPE_OBJECT, "GwibberService", &g_define_type_info, 0);
		g_once_init_leave (&gwibber_service_type_id__volatile, gwibber_service_type_id);
	}
	return gwibber_service_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




