/*
 * Copyright 2009 Canonical Ltd.
 * 
 * This program is free software: you can redistribute it and/or modify it 
 * under the terms of either or both of the following licenses:
 *
 * 1) the GNU Lesser General Public License version 3, as published by the 
 * Free Software Foundation; and/or
 * 2) the GNU Lesser General Public License version 2.1, as published by 
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranties of 
 * MERCHANTABILITY, SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR 
 * PURPOSE.  See the applicable version of the GNU Lesser General Public 
 * License for more details.
 * 
 * You should have received a copy of both the GNU Lesser General Public 
 * License version 3 and version 2.1 along with this program.  If not, see 
 * <http://www.gnu.org/licenses/>
 *
 * Authored by: Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _GADGET_PROXY_H_
#define _GADGET_PROXY_H_

#include <glib.h>
#include <glib-object.h>
#include <gdk/gdk.h>

G_BEGIN_DECLS

#define GADGET_TYPE_PROXY (gadget_proxy_get_type ())

#define GADGET_PROXY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GADGET_TYPE_PROXY, GadgetProxy))

#define GADGET_PROXY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
      	GADGET_TYPE_PROXY, GadgetProxyClass))

#define GADGET_IS_PROXY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GADGET_TYPE_PROXY))

#define GADGET_PROXY_IS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GADGET_TYPE_PROXY))

#define GADGET_PROXY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
        GADGET_TYPE_PROXY, GadgetProxyClass))

typedef struct _GadgetProxy        GadgetProxy;
typedef struct _GadgetProxyClass   GadgetProxyClass;
typedef struct _GadgetProxyPrivate GadgetProxyPrivate;


enum _GadgetResizePoint
{
  GADGET_RESIZE_LEFT=0,
  GADGET_RESIZE_RIGHT,
  GADGET_RESIZE_TOP,
  GADGET_RESIZE_TOPLEFT,
  GADGET_RESIZE_TOPRIGHT,
  GADGET_RESIZE_BOTTOM,
  GADGET_RESIZE_BOTTOMLEFT,
  GADGET_RESIZE_BOTTOMRIGHT
};
typedef enum   _GadgetResizePoint  GadgetResizePoint;
 
struct _GadgetProxy
{
  GObject parent;	

  GadgetProxyPrivate *priv;
};

struct _GadgetProxyClass
{
  /*< private >*/
  GObjectClass  parent_class;

  /*< public >*/
  /* signals, not vfuncs */
  void (*queue_redraw) (GadgetProxy *self);

  void (*queue_resize) (GadgetProxy *self);

  void (*begin_resize)    (GadgetProxy       *self,
                           GadgetResizePoint  point);

  void (*begin_drag_move) (GadgetProxy    *self);

  void (*open_url)     (GadgetProxy      *self,
                        const gchar *url);

  void (*remove_me)    (GadgetProxy      *self);

    /* Events */
  void (*button_press_event) (GadgetProxy      *self,
                              GdkEventButton   *event);

  void (*button_release_event) (GadgetProxy    *self,
                                GdkEventButton *button);

  void (*enter_event)          (GadgetProxy    *self,
                                GdkEventCrossing *event);

  void (*leave_event)          (GadgetProxy      *self,
                                GdkEventCrossing *event);

  void (*key_press_event)      (GadgetProxy      *self,
                                GdkEventKey      *event);

  void (*key_release_event)    (GadgetProxy      *self,
                                GdkEventKey      *event);

  void (*scroll_event)         (GadgetProxy      *self,
                                GdkEventScroll   *event);

  void (*motion_event)         (GadgetProxy      *self,
                                GdkEventMotion   *event);

  void (*focus_in_event)       (GadgetProxy      *self);

  void (*focus_out_event)      (GadgetProxy      *self);

  /* vtable */
  GdkPixbuf * (*get_icon)      (GadgetProxy      *self);
  void        (*removed)       (GadgetProxy      *self);

  /*< private >*/
  /* padding */
  void (*_gadget_proxy_padding1) (void);
  void (*_gadget_proxy_padding2) (void);
  void (*_gadget_proxy_padding3) (void);
  void (*_gadget_proxy_padding4) (void);
  void (*_gadget_proxy_padding5) (void);
  void (*_gadget_proxy_padding6) (void);
};

GType gadget_proxy_get_type (void) G_GNUC_CONST;

const gchar * gadget_proxy_get_path   (GadgetProxy *self);

void          gadget_proxy_set_path   (GadgetProxy *self, 
                                       const gchar *path);

const gchar * gadget_proxy_get_uid    (GadgetProxy *self);

void          gadget_proxy_set_uid    (GadgetProxy *self,
                                       const gchar *uid);

const gchar * gadget_proxy_get_name   (GadgetProxy *self);

void          gadget_proxy_set_name   (GadgetProxy *self,
                                       const gchar *name);

GdkPixbuf   * gadget_proxy_get_icon   (GadgetProxy *self);

gint          gadget_proxy_get_width  (GadgetProxy *self);

void          gadget_proxy_set_width  (GadgetProxy *self,
                                       gint         width);

gint          gadget_proxy_get_height (GadgetProxy *self);

void          gadget_proxy_set_height (GadgetProxy *self,
                                       gint         height);

void          gadget_proxy_event      (GadgetProxy *self,
                                       GdkEvent    *event);

void          gadget_proxy_set_focused (GadgetProxy *self,
                                        gboolean     is_focused);

void          gadget_proxy_removed     (GadgetProxy *self);

G_END_DECLS

#endif /* _GADGET_PROXY_H_ */

