/*
 * Based on nv40_graph.c
 *  Someday this will all go away...
 */
#include "drmP.h"
#include "drm.h"
#include "nouveau_drv.h"
#include "nouveau_drm.h"

/*
 * There are 3 families :
 * NV30 is 0x10de:0x030*
 * NV31 is 0x10de:0x031*
 *
 * NV34 is 0x10de:0x032*
 *
 * NV35 is 0x10de:0x033* (NV35 and NV36 are the same)
 * NV36 is 0x10de:0x034*
 *
 * Not seen in the wild, no dumps (probably NV35) :
 * NV37 is 0x10de:0x00fc, 0x10de:0x00fd
 * NV38 is 0x10de:0x0333, 0x10de:0x00fe
 *
 */


#define NV30_31_GRCTX_SIZE (22392)
#define NV34_GRCTX_SIZE    (18140)
#define NV35_36_GRCTX_SIZE (22396)

static void nv30_31_graph_context_init(struct drm_device *dev, struct nouveau_gpuobj *ctx)
{
	struct drm_nouveau_private *dev_priv = dev->dev_private;
	int i;

	INSTANCE_WR(ctx, 0x410/4, 0x00000101);
	INSTANCE_WR(ctx, 0x424/4, 0x00000111);
	INSTANCE_WR(ctx, 0x428/4, 0x00000060);
	INSTANCE_WR(ctx, 0x444/4, 0x00000080);
	INSTANCE_WR(ctx, 0x448/4, 0xffff0000);
	INSTANCE_WR(ctx, 0x44c/4, 0x00000001);
	INSTANCE_WR(ctx, 0x460/4, 0x44400000);
	INSTANCE_WR(ctx, 0x48c/4, 0xffff0000);
	for(i = 0x4e0; i< 0x4e8; i += 4)
		INSTANCE_WR(ctx, i/4, 0x0fff0000);
	INSTANCE_WR(ctx, 0x4ec/4, 0x00011100);
	for(i = 0x508; i< 0x548; i += 4)
		INSTANCE_WR(ctx, i/4, 0x07ff0000);
	INSTANCE_WR(ctx, 0x550/4, 0x4b7fffff);
	INSTANCE_WR(ctx, 0x58c/4, 0x00000080);
	INSTANCE_WR(ctx, 0x590/4, 0x30201000);
	INSTANCE_WR(ctx, 0x594/4, 0x70605040);
	INSTANCE_WR(ctx, 0x598/4, 0xb8a89888);
	INSTANCE_WR(ctx, 0x59c/4, 0xf8e8d8c8);
	INSTANCE_WR(ctx, 0x5b0/4, 0xb0000000);
	for(i = 0x600; i< 0x640; i += 4)
		INSTANCE_WR(ctx, i/4, 0x00010588);
	for(i = 0x640; i< 0x680; i += 4)
		INSTANCE_WR(ctx, i/4, 0x00030303);
	for(i = 0x6c0; i< 0x700; i += 4)
		INSTANCE_WR(ctx, i/4, 0x0008aae4);
	for(i = 0x700; i< 0x740; i += 4)
		INSTANCE_WR(ctx, i/4, 0x01012000);
	for(i = 0x740; i< 0x780; i += 4)
		INSTANCE_WR(ctx, i/4, 0x00080008);
	INSTANCE_WR(ctx, 0x85c/4, 0x00040000);
	INSTANCE_WR(ctx, 0x860/4, 0x00010000);
	for(i = 0x864; i< 0x874; i += 4)
		INSTANCE_WR(ctx, i/4, 0x00040004);
	INSTANCE_WR(ctx, 0x1f18/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1f1c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1f20/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1f28/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1f2c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1f30/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1f38/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1f3c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1f40/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1f48/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1f4c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1f50/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1f58/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1f5c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1f60/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1f68/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1f6c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1f70/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1f78/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1f7c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1f80/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1f88/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1f8c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1f90/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1f98/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1f9c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1fa0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1fa8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1fac/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1fb0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1fb8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1fbc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1fc0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1fc8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1fcc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1fd0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1fd8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1fdc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1fe0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1fe8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1fec/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1ff0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1ff8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1ffc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2000/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2008/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x200c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2010/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2018/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x201c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2020/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2028/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x202c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2030/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2038/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x203c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2040/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2048/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x204c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2050/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2058/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x205c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2060/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2068/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x206c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2070/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2078/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x207c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2080/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2088/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x208c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2090/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2098/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x209c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x20a0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x20a8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x20ac/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x20b0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x20b8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x20bc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x20c0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x20c8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x20cc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x20d0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x20d8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x20dc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x20e0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x20e8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x20ec/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x20f0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x20f8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x20fc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2100/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2108/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x210c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2110/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2118/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x211c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2120/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2128/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x212c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2130/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2138/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x213c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2140/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2148/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x214c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2150/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2158/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x215c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2160/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2168/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x216c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2170/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2178/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x217c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2180/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2188/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x218c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2190/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2198/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x219c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x21a0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x21a8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x21ac/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x21b0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x21b8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x21bc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x21c0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x21c8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x21cc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x21d0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x21d8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x21dc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x21e0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x21e8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x21ec/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x21f0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x21f8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x21fc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2200/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2208/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x220c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2210/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2218/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x221c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2220/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2228/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x222c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2230/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2238/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x223c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2240/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2248/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x224c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2250/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2258/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x225c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2260/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2268/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x226c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2270/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2278/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x227c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2280/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2288/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x228c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2290/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2298/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x229c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x22a0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x22a8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x22ac/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x22b0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x22b8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x22bc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x22c0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x22c8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x22cc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x22d0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x22d8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x22dc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x22e0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x22e8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x22ec/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x22f0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x22f8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x22fc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2300/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2308/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x230c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2310/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2318/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x231c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2320/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2328/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x232c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2330/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2338/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x233c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2340/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2348/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x234c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2350/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2358/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x235c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2360/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2368/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x236c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2370/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2378/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x237c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2380/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2388/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x238c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2390/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2398/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x239c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x23a0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x23a8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x23ac/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x23b0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x23b8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x23bc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x23c0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x23c8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x23cc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x23d0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x23d8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x23dc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x23e0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x23e8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x23ec/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x23f0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x23f8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x23fc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2400/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2408/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x240c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2410/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2418/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x241c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2420/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2428/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x242c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2430/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2438/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x243c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2440/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2448/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x244c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2450/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2458/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x245c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2460/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2468/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x246c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2470/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2478/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x247c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2480/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2488/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x248c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2490/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2498/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x249c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x24a0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x24a8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x24ac/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x24b0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x24b8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x24bc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x24c0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x24c8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x24cc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x24d0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x24d8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x24dc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x24e0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x24e8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x24ec/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x24f0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x24f8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x24fc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2500/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2508/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x250c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2510/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2518/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x251c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2520/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2528/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x252c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2530/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2538/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x253c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2540/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2548/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x254c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2550/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2558/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x255c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2560/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2568/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x256c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2570/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2578/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x257c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2580/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2588/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x258c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2590/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2598/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x259c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x25a0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x25a8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x25ac/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x25b0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x25b8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x25bc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x25c0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x25c8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x25cc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x25d0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x25d8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x25dc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x25e0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x25e8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x25ec/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x25f0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x25f8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x25fc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2600/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2608/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x260c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2610/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2618/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x261c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2620/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2628/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x262c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2630/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2638/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x263c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2640/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2648/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x264c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2650/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2658/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x265c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2660/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2668/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x266c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2670/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2678/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x267c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2680/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2688/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x268c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2690/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2698/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x269c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x26a0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x26a8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x26ac/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x26b0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x26b8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x26bc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x26c0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x26c8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x26cc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x26d0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x26d8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x26dc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x26e0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x26e8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x26ec/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x26f0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x26f8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x26fc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2700/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2708/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x270c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2710/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2718/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x271c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2720/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2728/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x272c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2730/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2738/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x273c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2740/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2748/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x274c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2750/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2758/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x275c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2760/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2768/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x276c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2770/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2778/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x277c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2780/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2788/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x278c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2790/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2798/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x279c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x27a0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x27a8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x27ac/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x27b0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x27b8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x27bc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x27c0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x27c8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x27cc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x27d0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x27d8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x27dc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x27e0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x27e8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x27ec/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x27f0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x27f8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x27fc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2800/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2808/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x280c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2810/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2818/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x281c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2820/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2828/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x282c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2830/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2838/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x283c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2840/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2848/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x284c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2850/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2858/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x285c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2860/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2868/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x286c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2870/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2878/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x287c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2880/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2888/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x288c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2890/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2898/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x289c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x28a0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x28a8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x28ac/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x28b0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x28b8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x28bc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x28c0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x28c8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x28cc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x28d0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x28d8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x28dc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x28e0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x28e8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x28ec/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x28f0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x28f8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x28fc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2900/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2908/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x290c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2910/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2918/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x291c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2920/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2928/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x292c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2930/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2938/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x293c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2940/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2948/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x294c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2950/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2958/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x295c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2960/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2968/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x296c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2970/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2978/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x297c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2980/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2988/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x298c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2990/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2998/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x299c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x29a0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x29a8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x29ac/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x29b0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x29b8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x29bc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x29c0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x29c8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x29cc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x29d0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x29d8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x29dc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x29e0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x29e8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x29ec/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x29f0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x29f8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x29fc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2a00/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2a08/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2a0c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2a10/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2a18/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2a1c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2a20/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2a28/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2a2c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2a30/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2a38/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2a3c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2a40/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2a48/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2a4c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2a50/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2a58/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2a5c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2a60/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2a68/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2a6c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2a70/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2a78/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2a7c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2a80/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2a88/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2a8c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2a90/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2a98/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2a9c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2aa0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2aa8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2aac/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2ab0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2ab8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2abc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2ac0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2ac8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2acc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2ad0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2ad8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2adc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2ae0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2ae8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2aec/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2af0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2af8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2afc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2b00/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2b08/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2b0c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2b10/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2b18/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2b1c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2b20/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2b28/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2b2c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2b30/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2b38/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2b3c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2b40/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2b48/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2b4c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2b50/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2b58/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2b5c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2b60/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2b68/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2b6c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2b70/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2b78/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2b7c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2b80/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2b88/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2b8c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2b90/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2b98/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2b9c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2ba0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2ba8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2bac/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2bb0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2bb8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2bbc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2bc0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2bc8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2bcc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2bd0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2bd8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2bdc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2be0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2be8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2bec/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2bf0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2bf8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2bfc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2c00/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2c08/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2c0c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2c10/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2c18/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2c1c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2c20/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2c28/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2c2c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2c30/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2c38/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2c3c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2c40/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2c48/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2c4c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2c50/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2c58/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2c5c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2c60/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2c68/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2c6c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2c70/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2c78/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2c7c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2c80/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2c88/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2c8c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2c90/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2c98/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2c9c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2ca0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2ca8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2cac/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2cb0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2cb8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2cbc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2cc0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2cc8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2ccc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2cd0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2cd8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2cdc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2ce0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2ce8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2cec/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2cf0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2cf8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2cfc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2d00/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2d08/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2d0c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2d10/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2d18/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2d1c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2d20/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2d28/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2d2c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2d30/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2d38/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2d3c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2d40/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2d48/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2d4c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2d50/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2d58/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2d5c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2d60/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2d68/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2d6c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2d70/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2d78/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2d7c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2d80/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2d88/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2d8c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2d90/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2d98/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2d9c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2da0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2da8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2dac/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2db0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2db8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2dbc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2dc0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2dc8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2dcc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2dd0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2dd8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2ddc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2de0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2de8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2dec/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2df0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2df8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2dfc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2e00/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2e08/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2e0c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2e10/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2e18/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2e1c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2e20/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2e28/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2e2c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2e30/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2e38/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2e3c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2e40/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2e48/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2e4c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2e50/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2e58/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2e5c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2e60/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2e68/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2e6c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2e70/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2e78/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2e7c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2e80/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2e88/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2e8c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2e90/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2e98/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2e9c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2ea0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2ea8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2eac/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2eb0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2eb8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2ebc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2ec0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2ec8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2ecc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2ed0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2ed8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2edc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2ee0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2ee8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2eec/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2ef0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2ef8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2efc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2f00/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2f08/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2f0c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2f10/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2f18/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2f1c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2f20/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2f28/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2f2c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2f30/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2f38/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2f3c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2f40/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2f48/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2f4c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2f50/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2f58/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2f5c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2f60/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2f68/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2f6c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2f70/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2f78/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2f7c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2f80/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2f88/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2f8c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2f90/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2f98/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2f9c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2fa0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2fa8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2fac/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2fb0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2fb8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2fbc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2fc0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2fc8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2fcc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2fd0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2fd8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2fdc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2fe0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2fe8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2fec/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2ff0/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2ff8/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2ffc/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x3000/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x3008/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x300c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x3010/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x3018/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x301c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x3020/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x3028/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x302c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x3030/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x3038/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x303c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x3040/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x3048/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x304c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x3050/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x3058/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x305c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x3060/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x3068/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x306c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x3070/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x3078/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x307c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x3080/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x3088/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x308c/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x3090/4, 0x000c001b);
	for(i = 0x30b8; i< 0x30c8; i += 4)
		INSTANCE_WR(ctx, i/4, 0x0000ffff);
	INSTANCE_WR(ctx, 0x344c/4, 0x3f800000);
	INSTANCE_WR(ctx, 0x3808/4, 0x3f800000);
	INSTANCE_WR(ctx, 0x381c/4, 0x3f800000);
	INSTANCE_WR(ctx, 0x3848/4, 0x40000000);
	INSTANCE_WR(ctx, 0x384c/4, 0x3f800000);
	INSTANCE_WR(ctx, 0x3850/4, 0x3f000000);
	INSTANCE_WR(ctx, 0x3858/4, 0x40000000);
	INSTANCE_WR(ctx, 0x385c/4, 0x3f800000);
	INSTANCE_WR(ctx, 0x3864/4, 0xbf800000);
	INSTANCE_WR(ctx, 0x386c/4, 0xbf800000);
}

static void nv34_graph_context_init(struct drm_device *dev, struct nouveau_gpuobj *ctx)
{
	struct drm_nouveau_private *dev_priv = dev->dev_private;
	int i;

	INSTANCE_WR(ctx, 0x40c/4, 0x01000101);
	INSTANCE_WR(ctx, 0x420/4, 0x00000111);
	INSTANCE_WR(ctx, 0x424/4, 0x00000060);
	INSTANCE_WR(ctx, 0x440/4, 0x00000080);
	INSTANCE_WR(ctx, 0x444/4, 0xffff0000);
	INSTANCE_WR(ctx, 0x448/4, 0x00000001);
	INSTANCE_WR(ctx, 0x45c/4, 0x44400000);
	INSTANCE_WR(ctx, 0x480/4, 0xffff0000);
	for(i = 0x4d4; i< 0x4dc; i += 4)
		INSTANCE_WR(ctx, i/4, 0x0fff0000);
	INSTANCE_WR(ctx, 0x4e0/4, 0x00011100);
	for(i = 0x4fc; i< 0x53c; i += 4)
		INSTANCE_WR(ctx, i/4, 0x07ff0000);
	INSTANCE_WR(ctx, 0x544/4, 0x4b7fffff);
	INSTANCE_WR(ctx, 0x57c/4, 0x00000080);
	INSTANCE_WR(ctx, 0x580/4, 0x30201000);
	INSTANCE_WR(ctx, 0x584/4, 0x70605040);
	INSTANCE_WR(ctx, 0x588/4, 0xb8a89888);
	INSTANCE_WR(ctx, 0x58c/4, 0xf8e8d8c8);
	INSTANCE_WR(ctx, 0x5a0/4, 0xb0000000);
	for(i = 0x5f0; i< 0x630; i += 4)
		INSTANCE_WR(ctx, i/4, 0x00010588);
	for(i = 0x630; i< 0x670; i += 4)
		INSTANCE_WR(ctx, i/4, 0x00030303);
	for(i = 0x6b0; i< 0x6f0; i += 4)
		INSTANCE_WR(ctx, i/4, 0x0008aae4);
	for(i = 0x6f0; i< 0x730; i += 4)
		INSTANCE_WR(ctx, i/4, 0x01012000);
	for(i = 0x730; i< 0x770; i += 4)
		INSTANCE_WR(ctx, i/4, 0x00080008);
	INSTANCE_WR(ctx, 0x850/4, 0x00040000);
	INSTANCE_WR(ctx, 0x854/4, 0x00010000);
	for(i = 0x858; i< 0x868; i += 4)
		INSTANCE_WR(ctx, i/4, 0x00040004);
	INSTANCE_WR(ctx, 0x15ac/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x15b0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x15b4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x15bc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x15c0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x15c4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x15cc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x15d0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x15d4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x15dc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x15e0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x15e4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x15ec/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x15f0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x15f4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x15fc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1600/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1604/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x160c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1610/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1614/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x161c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1620/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1624/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x162c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1630/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1634/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x163c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1640/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1644/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x164c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1650/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1654/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x165c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1660/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1664/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x166c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1670/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1674/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x167c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1680/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1684/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x168c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1690/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1694/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x169c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x16a0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x16a4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x16ac/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x16b0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x16b4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x16bc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x16c0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x16c4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x16cc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x16d0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x16d4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x16dc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x16e0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x16e4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x16ec/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x16f0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x16f4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x16fc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1700/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1704/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x170c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1710/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1714/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x171c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1720/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1724/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x172c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1730/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1734/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x173c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1740/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1744/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x174c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1750/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1754/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x175c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1760/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1764/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x176c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1770/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1774/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x177c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1780/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1784/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x178c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1790/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1794/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x179c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x17a0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x17a4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x17ac/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x17b0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x17b4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x17bc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x17c0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x17c4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x17cc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x17d0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x17d4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x17dc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x17e0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x17e4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x17ec/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x17f0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x17f4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x17fc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1800/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1804/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x180c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1810/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1814/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x181c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1820/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1824/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x182c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1830/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1834/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x183c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1840/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1844/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x184c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1850/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1854/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x185c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1860/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1864/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x186c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1870/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1874/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x187c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1880/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1884/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x188c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1890/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1894/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x189c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x18a0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x18a4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x18ac/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x18b0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x18b4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x18bc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x18c0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x18c4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x18cc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x18d0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x18d4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x18dc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x18e0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x18e4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x18ec/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x18f0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x18f4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x18fc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1900/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1904/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x190c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1910/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1914/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x191c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1920/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1924/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x192c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1930/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1934/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x193c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1940/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1944/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x194c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1950/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1954/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x195c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1960/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1964/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x196c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1970/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1974/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x197c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1980/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1984/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x198c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1990/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1994/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x199c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x19a0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x19a4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x19ac/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x19b0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x19b4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x19bc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x19c0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x19c4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x19cc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x19d0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x19d4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x19dc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x19e0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x19e4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x19ec/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x19f0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x19f4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x19fc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1a00/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1a04/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1a0c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1a10/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1a14/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1a1c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1a20/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1a24/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1a2c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1a30/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1a34/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1a3c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1a40/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1a44/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1a4c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1a50/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1a54/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1a5c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1a60/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1a64/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1a6c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1a70/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1a74/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1a7c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1a80/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1a84/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1a8c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1a90/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1a94/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1a9c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1aa0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1aa4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1aac/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1ab0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1ab4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1abc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1ac0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1ac4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1acc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1ad0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1ad4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1adc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1ae0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1ae4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1aec/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1af0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1af4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1afc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1b00/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1b04/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1b0c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1b10/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1b14/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1b1c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1b20/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1b24/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1b2c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1b30/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1b34/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1b3c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1b40/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1b44/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1b4c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1b50/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1b54/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1b5c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1b60/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1b64/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1b6c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1b70/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1b74/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1b7c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1b80/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1b84/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1b8c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1b90/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1b94/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1b9c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1ba0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1ba4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1bac/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1bb0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1bb4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1bbc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1bc0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1bc4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1bcc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1bd0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1bd4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1bdc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1be0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1be4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1bec/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1bf0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1bf4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1bfc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1c00/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1c04/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1c0c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1c10/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1c14/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1c1c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1c20/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1c24/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1c2c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1c30/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1c34/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1c3c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1c40/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1c44/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1c4c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1c50/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1c54/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1c5c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1c60/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1c64/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1c6c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1c70/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1c74/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1c7c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1c80/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1c84/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1c8c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1c90/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1c94/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1c9c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1ca0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1ca4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1cac/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1cb0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1cb4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1cbc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1cc0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1cc4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1ccc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1cd0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1cd4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1cdc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1ce0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1ce4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1cec/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1cf0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1cf4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1cfc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1d00/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1d04/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1d0c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1d10/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1d14/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1d1c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1d20/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1d24/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1d2c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1d30/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1d34/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1d3c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1d40/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1d44/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1d4c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1d50/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1d54/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1d5c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1d60/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1d64/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1d6c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1d70/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1d74/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1d7c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1d80/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1d84/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1d8c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1d90/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1d94/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1d9c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1da0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1da4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1dac/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1db0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1db4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1dbc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1dc0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1dc4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1dcc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1dd0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1dd4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1ddc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1de0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1de4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1dec/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1df0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1df4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1dfc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1e00/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1e04/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1e0c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1e10/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1e14/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1e1c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1e20/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1e24/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1e2c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1e30/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1e34/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1e3c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1e40/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1e44/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1e4c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1e50/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1e54/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1e5c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1e60/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1e64/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1e6c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1e70/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1e74/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1e7c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1e80/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1e84/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1e8c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1e90/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1e94/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1e9c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1ea0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1ea4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1eac/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1eb0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1eb4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1ebc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1ec0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1ec4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1ecc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1ed0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1ed4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1edc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1ee0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1ee4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1eec/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1ef0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1ef4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1efc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1f00/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1f04/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1f0c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1f10/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1f14/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1f1c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1f20/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1f24/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1f2c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1f30/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1f34/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1f3c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1f40/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1f44/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1f4c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1f50/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1f54/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1f5c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1f60/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1f64/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1f6c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1f70/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1f74/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1f7c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1f80/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1f84/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1f8c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1f90/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1f94/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1f9c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1fa0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1fa4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1fac/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1fb0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1fb4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1fbc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1fc0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1fc4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1fcc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1fd0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1fd4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1fdc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1fe0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1fe4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1fec/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1ff0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1ff4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1ffc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2000/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2004/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x200c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2010/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2014/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x201c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2020/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2024/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x202c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2030/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2034/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x203c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2040/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2044/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x204c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2050/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2054/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x205c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2060/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2064/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x206c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2070/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2074/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x207c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2080/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2084/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x208c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2090/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2094/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x209c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x20a0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x20a4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x20ac/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x20b0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x20b4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x20bc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x20c0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x20c4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x20cc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x20d0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x20d4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x20dc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x20e0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x20e4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x20ec/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x20f0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x20f4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x20fc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2100/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2104/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x210c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2110/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2114/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x211c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2120/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2124/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x212c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2130/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2134/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x213c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2140/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2144/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x214c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2150/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2154/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x215c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2160/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2164/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x216c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2170/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2174/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x217c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2180/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2184/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x218c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2190/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2194/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x219c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x21a0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x21a4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x21ac/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x21b0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x21b4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x21bc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x21c0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x21c4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x21cc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x21d0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x21d4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x21dc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x21e0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x21e4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x21ec/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x21f0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x21f4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x21fc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2200/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2204/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x220c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2210/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2214/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x221c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2220/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2224/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x222c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2230/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2234/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x223c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2240/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2244/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x224c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2250/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2254/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x225c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2260/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2264/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x226c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2270/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2274/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x227c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2280/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2284/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x228c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2290/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2294/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x229c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x22a0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x22a4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x22ac/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x22b0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x22b4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x22bc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x22c0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x22c4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x22cc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x22d0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x22d4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x22dc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x22e0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x22e4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x22ec/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x22f0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x22f4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x22fc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2300/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2304/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x230c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2310/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2314/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x231c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2320/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2324/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x232c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2330/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2334/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x233c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2340/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2344/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x234c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2350/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2354/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x235c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2360/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2364/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x236c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2370/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2374/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x237c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2380/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2384/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x238c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2390/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2394/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x239c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x23a0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x23a4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x23ac/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x23b0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x23b4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x23bc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x23c0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x23c4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x23cc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x23d0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x23d4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x23dc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x23e0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x23e4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x23ec/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x23f0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x23f4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x23fc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2400/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2404/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x240c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2410/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2414/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x241c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2420/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2424/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x242c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2430/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2434/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x243c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2440/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2444/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x244c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2450/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2454/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x245c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2460/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2464/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x246c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2470/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2474/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x247c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2480/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2484/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x248c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2490/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2494/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x249c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x24a0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x24a4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x24ac/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x24b0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x24b4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x24bc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x24c0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x24c4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x24cc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x24d0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x24d4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x24dc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x24e0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x24e4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x24ec/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x24f0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x24f4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x24fc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2500/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2504/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x250c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2510/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2514/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x251c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2520/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2524/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x252c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2530/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2534/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x253c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2540/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2544/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x254c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2550/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2554/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x255c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2560/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2564/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x256c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2570/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2574/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x257c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2580/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2584/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x258c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2590/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2594/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x259c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x25a0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x25a4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x25ac/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x25b0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x25b4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x25bc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x25c0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x25c4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x25cc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x25d0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x25d4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x25dc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x25e0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x25e4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x25ec/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x25f0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x25f4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x25fc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2600/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2604/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x260c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2610/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2614/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x261c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2620/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2624/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x262c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2630/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2634/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x263c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2640/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2644/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x264c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2650/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2654/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x265c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2660/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2664/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x266c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2670/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2674/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x267c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2680/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2684/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x268c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2690/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2694/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x269c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x26a0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x26a4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x26ac/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x26b0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x26b4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x26bc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x26c0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x26c4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x26cc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x26d0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x26d4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x26dc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x26e0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x26e4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x26ec/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x26f0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x26f4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x26fc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2700/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2704/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x270c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2710/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2714/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x271c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2720/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2724/4, 0x000c001b);
	for(i = 0x274c; i< 0x275c; i += 4)
		INSTANCE_WR(ctx, i/4, 0x0000ffff);
	INSTANCE_WR(ctx, 0x2ae0/4, 0x3f800000);
	INSTANCE_WR(ctx, 0x2e9c/4, 0x3f800000);
	INSTANCE_WR(ctx, 0x2eb0/4, 0x3f800000);
	INSTANCE_WR(ctx, 0x2edc/4, 0x40000000);
	INSTANCE_WR(ctx, 0x2ee0/4, 0x3f800000);
	INSTANCE_WR(ctx, 0x2ee4/4, 0x3f000000);
	INSTANCE_WR(ctx, 0x2eec/4, 0x40000000);
	INSTANCE_WR(ctx, 0x2ef0/4, 0x3f800000);
	INSTANCE_WR(ctx, 0x2ef8/4, 0xbf800000);
	INSTANCE_WR(ctx, 0x2f00/4, 0xbf800000);
}

static void nv35_36_graph_context_init(struct drm_device *dev, struct nouveau_gpuobj *ctx)
{
	struct drm_nouveau_private *dev_priv = dev->dev_private;
	int i;

	INSTANCE_WR(ctx, 0x40c/4, 0x00000101);
	INSTANCE_WR(ctx, 0x420/4, 0x00000111);
	INSTANCE_WR(ctx, 0x424/4, 0x00000060);
	INSTANCE_WR(ctx, 0x440/4, 0x00000080);
	INSTANCE_WR(ctx, 0x444/4, 0xffff0000);
	INSTANCE_WR(ctx, 0x448/4, 0x00000001);
	INSTANCE_WR(ctx, 0x45c/4, 0x44400000);
	INSTANCE_WR(ctx, 0x488/4, 0xffff0000);
	for(i = 0x4dc; i< 0x4e4; i += 4)
		INSTANCE_WR(ctx, i/4, 0x0fff0000);
	INSTANCE_WR(ctx, 0x4e8/4, 0x00011100);
	for(i = 0x504; i< 0x544; i += 4)
		INSTANCE_WR(ctx, i/4, 0x07ff0000);
	INSTANCE_WR(ctx, 0x54c/4, 0x4b7fffff);
	INSTANCE_WR(ctx, 0x588/4, 0x00000080);
	INSTANCE_WR(ctx, 0x58c/4, 0x30201000);
	INSTANCE_WR(ctx, 0x590/4, 0x70605040);
	INSTANCE_WR(ctx, 0x594/4, 0xb8a89888);
	INSTANCE_WR(ctx, 0x598/4, 0xf8e8d8c8);
	INSTANCE_WR(ctx, 0x5ac/4, 0xb0000000);
	for(i = 0x604; i< 0x644; i += 4)
		INSTANCE_WR(ctx, i/4, 0x00010588);
	for(i = 0x644; i< 0x684; i += 4)
		INSTANCE_WR(ctx, i/4, 0x00030303);
	for(i = 0x6c4; i< 0x704; i += 4)
		INSTANCE_WR(ctx, i/4, 0x0008aae4);
	for(i = 0x704; i< 0x744; i += 4)
		INSTANCE_WR(ctx, i/4, 0x01012000);
	for(i = 0x744; i< 0x784; i += 4)
		INSTANCE_WR(ctx, i/4, 0x00080008);
	INSTANCE_WR(ctx, 0x860/4, 0x00040000);
	INSTANCE_WR(ctx, 0x864/4, 0x00010000);
	for(i = 0x868; i< 0x878; i += 4)
		INSTANCE_WR(ctx, i/4, 0x00040004);
	INSTANCE_WR(ctx, 0x1f1c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1f20/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1f24/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1f2c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1f30/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1f34/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1f3c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1f40/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1f44/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1f4c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1f50/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1f54/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1f5c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1f60/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1f64/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1f6c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1f70/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1f74/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1f7c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1f80/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1f84/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1f8c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1f90/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1f94/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1f9c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1fa0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1fa4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1fac/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1fb0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1fb4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1fbc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1fc0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1fc4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1fcc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1fd0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1fd4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1fdc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1fe0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1fe4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1fec/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x1ff0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x1ff4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x1ffc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2000/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2004/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x200c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2010/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2014/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x201c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2020/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2024/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x202c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2030/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2034/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x203c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2040/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2044/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x204c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2050/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2054/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x205c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2060/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2064/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x206c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2070/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2074/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x207c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2080/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2084/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x208c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2090/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2094/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x209c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x20a0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x20a4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x20ac/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x20b0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x20b4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x20bc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x20c0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x20c4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x20cc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x20d0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x20d4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x20dc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x20e0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x20e4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x20ec/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x20f0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x20f4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x20fc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2100/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2104/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x210c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2110/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2114/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x211c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2120/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2124/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x212c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2130/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2134/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x213c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2140/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2144/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x214c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2150/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2154/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x215c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2160/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2164/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x216c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2170/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2174/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x217c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2180/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2184/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x218c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2190/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2194/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x219c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x21a0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x21a4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x21ac/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x21b0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x21b4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x21bc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x21c0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x21c4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x21cc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x21d0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x21d4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x21dc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x21e0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x21e4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x21ec/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x21f0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x21f4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x21fc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2200/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2204/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x220c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2210/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2214/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x221c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2220/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2224/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x222c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2230/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2234/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x223c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2240/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2244/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x224c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2250/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2254/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x225c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2260/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2264/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x226c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2270/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2274/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x227c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2280/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2284/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x228c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2290/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2294/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x229c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x22a0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x22a4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x22ac/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x22b0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x22b4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x22bc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x22c0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x22c4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x22cc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x22d0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x22d4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x22dc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x22e0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x22e4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x22ec/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x22f0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x22f4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x22fc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2300/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2304/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x230c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2310/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2314/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x231c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2320/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2324/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x232c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2330/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2334/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x233c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2340/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2344/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x234c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2350/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2354/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x235c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2360/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2364/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x236c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2370/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2374/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x237c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2380/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2384/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x238c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2390/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2394/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x239c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x23a0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x23a4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x23ac/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x23b0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x23b4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x23bc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x23c0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x23c4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x23cc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x23d0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x23d4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x23dc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x23e0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x23e4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x23ec/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x23f0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x23f4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x23fc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2400/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2404/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x240c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2410/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2414/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x241c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2420/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2424/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x242c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2430/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2434/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x243c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2440/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2444/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x244c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2450/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2454/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x245c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2460/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2464/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x246c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2470/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2474/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x247c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2480/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2484/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x248c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2490/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2494/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x249c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x24a0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x24a4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x24ac/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x24b0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x24b4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x24bc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x24c0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x24c4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x24cc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x24d0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x24d4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x24dc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x24e0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x24e4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x24ec/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x24f0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x24f4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x24fc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2500/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2504/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x250c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2510/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2514/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x251c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2520/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2524/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x252c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2530/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2534/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x253c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2540/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2544/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x254c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2550/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2554/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x255c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2560/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2564/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x256c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2570/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2574/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x257c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2580/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2584/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x258c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2590/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2594/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x259c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x25a0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x25a4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x25ac/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x25b0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x25b4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x25bc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x25c0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x25c4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x25cc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x25d0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x25d4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x25dc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x25e0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x25e4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x25ec/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x25f0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x25f4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x25fc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2600/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2604/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x260c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2610/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2614/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x261c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2620/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2624/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x262c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2630/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2634/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x263c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2640/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2644/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x264c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2650/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2654/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x265c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2660/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2664/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x266c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2670/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2674/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x267c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2680/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2684/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x268c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2690/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2694/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x269c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x26a0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x26a4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x26ac/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x26b0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x26b4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x26bc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x26c0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x26c4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x26cc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x26d0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x26d4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x26dc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x26e0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x26e4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x26ec/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x26f0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x26f4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x26fc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2700/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2704/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x270c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2710/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2714/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x271c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2720/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2724/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x272c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2730/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2734/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x273c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2740/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2744/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x274c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2750/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2754/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x275c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2760/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2764/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x276c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2770/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2774/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x277c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2780/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2784/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x278c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2790/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2794/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x279c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x27a0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x27a4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x27ac/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x27b0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x27b4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x27bc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x27c0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x27c4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x27cc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x27d0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x27d4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x27dc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x27e0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x27e4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x27ec/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x27f0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x27f4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x27fc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2800/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2804/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x280c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2810/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2814/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x281c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2820/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2824/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x282c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2830/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2834/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x283c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2840/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2844/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x284c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2850/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2854/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x285c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2860/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2864/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x286c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2870/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2874/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x287c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2880/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2884/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x288c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2890/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2894/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x289c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x28a0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x28a4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x28ac/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x28b0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x28b4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x28bc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x28c0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x28c4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x28cc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x28d0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x28d4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x28dc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x28e0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x28e4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x28ec/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x28f0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x28f4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x28fc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2900/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2904/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x290c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2910/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2914/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x291c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2920/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2924/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x292c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2930/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2934/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x293c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2940/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2944/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x294c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2950/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2954/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x295c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2960/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2964/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x296c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2970/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2974/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x297c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2980/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2984/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x298c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2990/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2994/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x299c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x29a0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x29a4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x29ac/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x29b0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x29b4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x29bc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x29c0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x29c4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x29cc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x29d0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x29d4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x29dc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x29e0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x29e4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x29ec/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x29f0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x29f4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x29fc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2a00/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2a04/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2a0c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2a10/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2a14/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2a1c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2a20/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2a24/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2a2c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2a30/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2a34/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2a3c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2a40/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2a44/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2a4c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2a50/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2a54/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2a5c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2a60/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2a64/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2a6c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2a70/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2a74/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2a7c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2a80/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2a84/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2a8c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2a90/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2a94/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2a9c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2aa0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2aa4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2aac/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2ab0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2ab4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2abc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2ac0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2ac4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2acc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2ad0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2ad4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2adc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2ae0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2ae4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2aec/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2af0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2af4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2afc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2b00/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2b04/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2b0c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2b10/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2b14/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2b1c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2b20/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2b24/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2b2c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2b30/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2b34/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2b3c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2b40/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2b44/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2b4c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2b50/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2b54/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2b5c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2b60/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2b64/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2b6c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2b70/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2b74/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2b7c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2b80/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2b84/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2b8c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2b90/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2b94/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2b9c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2ba0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2ba4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2bac/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2bb0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2bb4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2bbc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2bc0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2bc4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2bcc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2bd0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2bd4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2bdc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2be0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2be4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2bec/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2bf0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2bf4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2bfc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2c00/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2c04/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2c0c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2c10/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2c14/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2c1c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2c20/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2c24/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2c2c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2c30/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2c34/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2c3c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2c40/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2c44/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2c4c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2c50/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2c54/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2c5c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2c60/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2c64/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2c6c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2c70/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2c74/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2c7c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2c80/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2c84/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2c8c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2c90/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2c94/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2c9c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2ca0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2ca4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2cac/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2cb0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2cb4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2cbc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2cc0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2cc4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2ccc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2cd0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2cd4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2cdc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2ce0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2ce4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2cec/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2cf0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2cf4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2cfc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2d00/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2d04/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2d0c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2d10/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2d14/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2d1c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2d20/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2d24/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2d2c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2d30/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2d34/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2d3c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2d40/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2d44/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2d4c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2d50/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2d54/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2d5c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2d60/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2d64/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2d6c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2d70/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2d74/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2d7c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2d80/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2d84/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2d8c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2d90/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2d94/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2d9c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2da0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2da4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2dac/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2db0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2db4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2dbc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2dc0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2dc4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2dcc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2dd0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2dd4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2ddc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2de0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2de4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2dec/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2df0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2df4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2dfc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2e00/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2e04/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2e0c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2e10/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2e14/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2e1c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2e20/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2e24/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2e2c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2e30/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2e34/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2e3c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2e40/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2e44/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2e4c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2e50/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2e54/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2e5c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2e60/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2e64/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2e6c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2e70/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2e74/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2e7c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2e80/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2e84/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2e8c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2e90/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2e94/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2e9c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2ea0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2ea4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2eac/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2eb0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2eb4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2ebc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2ec0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2ec4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2ecc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2ed0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2ed4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2edc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2ee0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2ee4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2eec/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2ef0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2ef4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2efc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2f00/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2f04/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2f0c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2f10/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2f14/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2f1c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2f20/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2f24/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2f2c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2f30/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2f34/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2f3c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2f40/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2f44/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2f4c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2f50/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2f54/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2f5c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2f60/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2f64/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2f6c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2f70/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2f74/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2f7c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2f80/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2f84/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2f8c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2f90/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2f94/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2f9c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2fa0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2fa4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2fac/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2fb0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2fb4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2fbc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2fc0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2fc4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2fcc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2fd0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2fd4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2fdc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2fe0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2fe4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2fec/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x2ff0/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x2ff4/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x2ffc/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x3000/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x3004/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x300c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x3010/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x3014/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x301c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x3020/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x3024/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x302c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x3030/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x3034/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x303c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x3040/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x3044/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x304c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x3050/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x3054/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x305c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x3060/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x3064/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x306c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x3070/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x3074/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x307c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x3080/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x3084/4, 0x000c001b);
	INSTANCE_WR(ctx, 0x308c/4, 0x10700ff9);
	INSTANCE_WR(ctx, 0x3090/4, 0x0436086c);
	INSTANCE_WR(ctx, 0x3094/4, 0x000c001b);
	for(i = 0x30bc; i< 0x30cc; i += 4)
		INSTANCE_WR(ctx, i/4, 0x0000ffff);
	INSTANCE_WR(ctx, 0x3450/4, 0x3f800000);
	INSTANCE_WR(ctx, 0x380c/4, 0x3f800000);
	INSTANCE_WR(ctx, 0x3820/4, 0x3f800000);
	INSTANCE_WR(ctx, 0x384c/4, 0x40000000);
	INSTANCE_WR(ctx, 0x3850/4, 0x3f800000);
	INSTANCE_WR(ctx, 0x3854/4, 0x3f000000);
	INSTANCE_WR(ctx, 0x385c/4, 0x40000000);
	INSTANCE_WR(ctx, 0x3860/4, 0x3f800000);
	INSTANCE_WR(ctx, 0x3868/4, 0xbf800000);
	INSTANCE_WR(ctx, 0x3870/4, 0xbf800000);}

int nv30_graph_create_context(struct nouveau_channel *chan)
{
	struct drm_device *dev = chan->dev;
	struct drm_nouveau_private *dev_priv = dev->dev_private;
	void (*ctx_init)(struct drm_device *, struct nouveau_gpuobj *);
	unsigned int ctx_size;
	int ret;

	switch (dev_priv->chipset) {
	case 0x30:
	case 0x31:
		ctx_size = NV30_31_GRCTX_SIZE;
		ctx_init = nv30_31_graph_context_init;
		break;
	case 0x34:
		ctx_size = NV34_GRCTX_SIZE;
		ctx_init = nv34_graph_context_init;
		break;
	case 0x35:
	case 0x36:
		ctx_size = NV35_36_GRCTX_SIZE;
		ctx_init = nv35_36_graph_context_init;
		break;
	default:
		ctx_size = 0;
		ctx_init = nv35_36_graph_context_init;
		DRM_ERROR("Please contact the devs if you want your NV%x card to work\n",dev_priv->chipset);
		break;
	}

	if ((ret = nouveau_gpuobj_new_ref(dev, chan, NULL, 0, ctx_size, 16,
					  NVOBJ_FLAG_ZERO_ALLOC,
					  &chan->ramin_grctx)))
		return ret;

	/* Initialise default context values */
	ctx_init(dev, chan->ramin_grctx->gpuobj);

	INSTANCE_WR(chan->ramin_grctx->gpuobj, 0x28/4, (chan->id<<24)|0x1); /* CTX_USER */
	INSTANCE_WR(dev_priv->ctx_table->gpuobj, chan->id,
			chan->ramin_grctx->instance >> 4);

	return 0;
}

void nv30_graph_destroy_context(struct nouveau_channel *chan)
{
	struct drm_device *dev = chan->dev;
	struct drm_nouveau_private *dev_priv = dev->dev_private;

	if (chan->ramin_grctx)
		nouveau_gpuobj_ref_del(dev, &chan->ramin_grctx);

	INSTANCE_WR(dev_priv->ctx_table->gpuobj, chan->id, 0);
}

static int
nouveau_graph_wait_idle(struct drm_device *dev)
{
	struct drm_nouveau_private *dev_priv = dev->dev_private;
	int tv = 1000;

	while (tv--) {
		if (NV_READ(0x400700) == 0)
			break;
	}

	if (NV_READ(0x400700)) {
		DRM_ERROR("timeout!\n");
		return -EBUSY;
	}
	return 0;
}

int nv30_graph_load_context(struct nouveau_channel *chan)
{
	struct drm_device *dev = chan->dev;
	struct drm_nouveau_private *dev_priv = dev->dev_private;
	uint32_t inst;

	if (!chan->ramin_grctx)
		return -EINVAL;
	inst = chan->ramin_grctx->instance >> 4;

	NV_WRITE(NV20_PGRAPH_CHANNEL_CTX_POINTER, inst);
	NV_WRITE(NV20_PGRAPH_CHANNEL_CTX_XFER,
		 NV20_PGRAPH_CHANNEL_CTX_XFER_LOAD);

	return nouveau_graph_wait_idle(dev);
}

int nv30_graph_save_context(struct nouveau_channel *chan)
{
	struct drm_device *dev = chan->dev;
	struct drm_nouveau_private *dev_priv = dev->dev_private;
	uint32_t inst;

	if (!chan->ramin_grctx)
		return -EINVAL;
	inst = chan->ramin_grctx->instance >> 4;

	NV_WRITE(NV20_PGRAPH_CHANNEL_CTX_POINTER, inst);
	NV_WRITE(NV20_PGRAPH_CHANNEL_CTX_XFER,
		 NV20_PGRAPH_CHANNEL_CTX_XFER_SAVE);

	return nouveau_graph_wait_idle(dev);
}

int nv30_graph_init(struct drm_device *dev)
{
	struct drm_nouveau_private *dev_priv = dev->dev_private;
	uint32_t vramsz, tmp;
	int ret, i;

	NV_WRITE(NV03_PMC_ENABLE, NV_READ(NV03_PMC_ENABLE) &
			~NV_PMC_ENABLE_PGRAPH);
	NV_WRITE(NV03_PMC_ENABLE, NV_READ(NV03_PMC_ENABLE) |
			 NV_PMC_ENABLE_PGRAPH);

        /* Create Context Pointer Table */
        dev_priv->ctx_table_size = 32 * 4;
	if ((ret = nouveau_gpuobj_new_ref(dev, NULL, NULL, 0,
					  dev_priv->ctx_table_size, 16,
					  NVOBJ_FLAG_ZERO_ALLOC,
					  &dev_priv->ctx_table)))
		return ret;

        NV_WRITE(NV10_PGRAPH_CHANNEL_CTX_TABLE,
		 dev_priv->ctx_table->instance >> 4);

	NV_WRITE(NV03_PGRAPH_INTR   , 0xFFFFFFFF);
	NV_WRITE(NV03_PGRAPH_INTR_EN, 0xFFFFFFFF);

	NV_WRITE(NV04_PGRAPH_DEBUG_0, 0xFFFFFFFF);
	NV_WRITE(NV04_PGRAPH_DEBUG_0, 0x00000000);
	NV_WRITE(NV04_PGRAPH_DEBUG_1, 0x401287c0);
	NV_WRITE(0x400890, 0x01b463ff);
	NV_WRITE(NV04_PGRAPH_DEBUG_3, 0xf3de0471);
	NV_WRITE(NV10_PGRAPH_DEBUG_4, 0x00008000);
	NV_WRITE(NV04_PGRAPH_LIMIT_VIOL_PIX, 0xf04bdff6);
	NV_WRITE(0x400B80, 0x1003d888);
	NV_WRITE(0x400098, 0x00000000);
	NV_WRITE(0x40009C, 0x0005ad00);
	NV_WRITE(0x400B88, 0x62ff00ff); // suspiciously like PGRAPH_DEBUG_2
	NV_WRITE(0x4000a0, 0x00000000);
	NV_WRITE(0x4000a4, 0x00000008);
	NV_WRITE(0x4008a8, 0xb784a400);
	NV_WRITE(0x400ba0, 0x002f8685);
	NV_WRITE(0x400ba4, 0x00231f3f);
	NV_WRITE(0x4008a4, 0x40000020);
	NV_WRITE(0x400B84, 0x0c000000);
	NV_WRITE(NV04_PGRAPH_DEBUG_2, 0x62ff0f7f);
	NV_WRITE(0x4000c0, 0x00000016);
	NV_WRITE(0x400780, 0x000014e4);

	/* copy tile info from PFB */
	for (i=0; i<NV10_PFB_TILE__SIZE; i++) {
		NV_WRITE(NV10_PGRAPH_TILE(i), NV_READ(NV10_PFB_TILE(i)));
		NV_WRITE(NV10_PGRAPH_TLIMIT(i), NV_READ(NV10_PFB_TLIMIT(i)));
		NV_WRITE(NV10_PGRAPH_TSIZE(i), NV_READ(NV10_PFB_TSIZE(i)));
		NV_WRITE(NV10_PGRAPH_TSTATUS(i), NV_READ(NV10_PFB_TSTATUS(i)));
	}

	NV_WRITE(NV10_PGRAPH_CTX_CONTROL, 0x10010100);
	NV_WRITE(NV10_PGRAPH_STATE      , 0xFFFFFFFF);
	NV_WRITE(NV04_PGRAPH_FIFO       , 0x00000001);

	/* begin RAM config */
	vramsz = drm_get_resource_len(dev, 0) - 1;
	NV_WRITE(0x4009A4, NV_READ(NV04_PFB_CFG0));
	NV_WRITE(0x4009A8, NV_READ(NV04_PFB_CFG1));
	NV_WRITE(0x400750, 0x00EA0000);
	NV_WRITE(0x400754, NV_READ(NV04_PFB_CFG0));
	NV_WRITE(0x400750, 0x00EA0004);
	NV_WRITE(0x400754, NV_READ(NV04_PFB_CFG1));
	NV_WRITE(0x400820, 0);
	NV_WRITE(0x400824, 0);
	NV_WRITE(0x400864, vramsz-1);
	NV_WRITE(0x400868, vramsz-1);

	NV_WRITE(0x400B20, 0x00000000);
	NV_WRITE(0x400B04, 0xFFFFFFFF);

	/* per-context state, doesn't belong here */
	tmp = NV_READ(NV10_PGRAPH_SURFACE) & 0x0007ff00;
	NV_WRITE(NV10_PGRAPH_SURFACE, tmp);
	tmp = NV_READ(NV10_PGRAPH_SURFACE) | 0x00020100;
	NV_WRITE(NV10_PGRAPH_SURFACE, tmp);

	NV_WRITE(NV03_PGRAPH_ABS_UCLIP_XMIN, 0);
	NV_WRITE(NV03_PGRAPH_ABS_UCLIP_YMIN, 0);
	NV_WRITE(NV03_PGRAPH_ABS_UCLIP_XMAX, 0x7fff);
	NV_WRITE(NV03_PGRAPH_ABS_UCLIP_YMAX, 0x7fff);

	return 0;
}

void nv30_graph_takedown(struct drm_device *dev)
{
	struct drm_nouveau_private *dev_priv = dev->dev_private;

	nouveau_gpuobj_ref_del(dev, &dev_priv->ctx_table);
}

