#ifndef __COMPAT_SEMAPHORE_H__
#   define __COMPAT_SEMAPHORE_H__


#include <asm/semaphore.h>


/*
* The init_MUTEX_LOCKED() API appeared in 2.2.18, and is also in
* 2.2.17-21mdk --hpreg
*/

#if LINUX_VERSION_CODE < KERNEL_VERSION(2, 2, 18)
   #ifndef init_MUTEX_LOCKED
      #define init_MUTEX_LOCKED(_sem) *(_sem) = MUTEX_LOCKED
   #endif
   #ifndef DECLARE_MUTEX
      #define DECLARE_MUTEX(name) struct semaphore name = MUTEX
   #endif
   #ifndef DECLARE_MUTEX_LOCKED
      #define DECLARE_MUTEX_LOCKED(name) struct semaphore name = MUTEX_LOCKED
   #endif
#endif


#endif /* __COMPAT_SEMAPHORE_H__ */
