/*
 *	dove_ac97avng.c  --  SoC audio for Dove Avengers MID board
 *
 *	Marvell Orion Alsa SOC Sound driver
 *
 *	Author: Brian Hsu
 *	Copyright (C) 2009 Marvell Ltd.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */

#include <linux/module.h>
#include <linux/moduleparam.h>
#include <linux/device.h>

#include <sound/core.h>
#include <sound/pcm.h>
#include <sound/soc.h>
#include <sound/soc-dapm.h>

#include <asm/mach-types.h>
//#include <asm/arch/pxa-regs.h>
//#include <asm/arch/hardware.h>

#include "../codecs/rt5610.h"
#include "../pxa/pxa2xx-pcm.h"
#include "../pxa/pxa2xx-ac97.h"

static struct platform_device *dove_ac97_snd_device;

static struct snd_soc_dai_link dove_ac97_dai[] = {
	{
	 .name = "AC97",
	 .stream_name = "AC97 HiFi",
	 .cpu_dai = &pxa_ac97_dai[PXA2XX_DAI_AC97_HIFI],
	 .codec_dai = &rt5610_dai,
	 },
};

static struct snd_soc_card dove = {
	.name = "Dove",
	.platform = &pxa2xx_soc_platform,
	.dai_link = dove_ac97_dai,
	.num_links = ARRAY_SIZE(dove_ac97_dai),
};

static struct snd_soc_device dove_ac97_snd_devdata = {
	.card = &dove,
	.codec_dev = &soc_codec_dev_rt5610,
};

static int __init dove_ac97_snd_init(void)
{
	int ret = 0;

	dove_ac97_snd_device = platform_device_alloc("soc-audio", 0);
	if (!dove_ac97_snd_device)
		return -ENOMEM;

	platform_set_drvdata(dove_ac97_snd_device, &dove_ac97_snd_devdata);
	dove_ac97_snd_devdata.dev = &dove_ac97_snd_device->dev;
	ret = platform_device_add(dove_ac97_snd_device);

	if (ret)
		platform_device_put(dove_ac97_snd_device);

	return ret;

}

static void __exit dove_ac97_snd_exit(void)
{
	platform_device_unregister(dove_ac97_snd_device);
}

module_init(dove_ac97_snd_init);
module_exit(dove_ac97_snd_exit);

/* Module information */
MODULE_AUTHOR(" Brian Hsu <bhsu@marvell.com>");
MODULE_DESCRIPTION("ALSA SoC Dove-AC97");
MODULE_LICENSE("GPL");
