# The following targets are for the maintainer only! do no run if you don't
# know what they do.

.PHONY: printenv updateconfigs printchanges insertchanges startnewrelease diffupstream help

help:
	@echo "These are the targets in addition to the normal $(DEBIAN) ones:"
	@echo
	@echo "  printenv        : Print some variables used in the build"
	@echo
	@echo "  updateconfigs   : Update debian/config/*"
	@echo
	@echo "  editconfigs     : Update debian/config/* interactively"
	@echo
	@echo "  printchanges    : Print the current changelog entries (from git)"
	@echo
	@echo "  insertchanges   : Insert current changelog entries (from git)"
	@echo
	@echo "  startnewrelease : Start a new changelog set"
	@echo
	@echo "  diffupstream    : Diff stock kernel code against upstream (git)"
	@echo
	@echo "  help            : If you are kernel hacking, you need the professional"
	@echo "                    version of this"
	@echo
	@echo "Environment variables:"
	@echo
	@echo "  NOKERNLOG       : Do not add upstream kernel commits to changelog"
	@echo "  CONCURRENCY_LEVEL=X"
	@echo "                  : Use -jX for kernel compile"
	@echo "  PRINTSHAS       : Include SHAs for commits in changelog"

ARCH_CONFIGS=i386 amd64 armel lpia

updateconfigs:
	dh_testdir
	@for arch in $(ARCH_CONFIGS); do	\
		$(SHELL) $(DEBIAN)/scripts/misc/oldconfig $$arch;		\
	done
	rm -rf build

editconfigs:
	dh_testdir
	@for arch in $(ARCH_CONFIGS); do	\
		$(SHELL) $(DEBIAN)/scripts/misc/doconfig $$arch;		\
	done
	rm -rf build

printenv:
	dh_testdir
	@echo "src package name  = $(src_pkg_name)"
	@echo "release           = $(release)"
	@echo "revisions         = $(revisions)"
	@echo "revision          = $(revision)"
	@echo "uploadnum         = $(uploadnum)"
	@echo "prev_revisions    = $(prev_revisions)"
	@echo "prev_revision     = $(prev_revision)"
	@echo "abinum            = $(abinum)"
	@echo "gitver            = $(gitver)"
	@echo "flavours          = $(flavours)"
	@echo "skipabi           = $(skipabi)"
	@echo "skipmodule        = $(skipmodule)"
	@echo "skipdbg           = $(skipdbg)"
	@echo "ubuntu_log_opts   = $(ubuntu_log_opts)"
ifneq ($(SUBLEVEL),)
	@echo "SUBLEVEL          = $(SUBLEVEL)"
endif
	@echo "CONCURRENCY_LEVEL = $(CONCURRENCY_LEVEL)"
	@echo "bin package name  = $(bin_pkg_name)"

printchanges:
	@git log Ubuntu-$(release)-$(prev_revision)..HEAD | \
		perl -w -f $(DEBIAN)/scripts/misc/git-ubuntu-log $(ubuntu_log_opts)

insertchanges:
	@perl -w -f $(DEBIAN)/scripts/misc/insert-changes.pl $(DEBIAN)

diffupstream:
	@git diff-tree -p refs/remotes/linux-2.6/master..HEAD $(shell ls | grep -vE '^(ubuntu|$(DEBIAN)|\.git.*)')

startnewrelease:
	dh_testdir
	@nextminor=$(shell expr `echo $(revision) | awk -F. '{print $$2}'` + 1); \
	now="$(shell date -R)"; \
	echo "Creating new changelog set for $(abi_release).$$nextminor..."; \
	echo -e "$(src_pkg_name) ($(abi_release).$$nextminor) UNRELEASED; urgency=low\n" > $(DEBIAN)/changelog.new; \
	echo "  CHANGELOG: Do not edit directly. Autogenerated at release." >> \
		$(DEBIAN)/changelog.new; \
	echo "  CHANGELOG: Use the printchanges target to see the curent changes." \
		>> $(DEBIAN)/changelog.new; \
	echo "  CHANGELOG: Use the insertchanges target to create the final log." \
		>> $(DEBIAN)/changelog.new; \
	echo -e "\n -- $$DEBFULLNAME <$$DEBEMAIL>  $$now\n" >> \
		$(DEBIAN)/changelog.new ; \
	cat $(DEBIAN)/changelog >> $(DEBIAN)/changelog.new; \
	mv $(DEBIAN)/changelog.new $(DEBIAN)/changelog

