/*
 * STMP DIGCTL Register Definitions
 *
 * Copyright 2008-2009 Freescale Semiconductor
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

#ifndef __ARCH_ARM___DIGCTL_H
#define __ARCH_ARM___DIGCTL_H  1

#include <mach/stmp3xxx_regs.h>

#define REGS_DIGCTL_BASE (REGS_BASE + 0x1c000)
#define REGS_DIGCTL_BASE_PHYS (0x8001C000)
#define REGS_DIGCTL_SIZE 0x00002000
HW_REGISTER(HW_DIGCTL_CTRL, REGS_DIGCTL_BASE, 0x00000000)
#define HW_DIGCTL_CTRL_ADDR (REGS_DIGCTL_BASE + 0x00000000)
#define BM_DIGCTL_CTRL_XTAL24M_GATE 0x40000000
#define BM_DIGCTL_CTRL_TRAP_IRQ 0x20000000
#define BM_DIGCTL_CTRL_CACHE_BIST_TMODE 0x04000000
#define BM_DIGCTL_CTRL_LCD_BIST_CLKEN 0x02000000
#define BM_DIGCTL_CTRL_LCD_BIST_START 0x01000000
#define BM_DIGCTL_CTRL_DCP_BIST_CLKEN 0x00800000
#define BM_DIGCTL_CTRL_DCP_BIST_START 0x00400000
#define BM_DIGCTL_CTRL_ARM_BIST_CLKEN 0x00200000
#define BM_DIGCTL_CTRL_USB_TESTMODE 0x00100000
#define BM_DIGCTL_CTRL_ANALOG_TESTMODE 0x00080000
#define BM_DIGCTL_CTRL_DIGITAL_TESTMODE 0x00040000
#define BM_DIGCTL_CTRL_ARM_BIST_START 0x00020000
#define BM_DIGCTL_CTRL_UART_LOOPBACK 0x00010000
#define BV_DIGCTL_CTRL_UART_LOOPBACK__NORMAL 0x0
#define BV_DIGCTL_CTRL_UART_LOOPBACK__LOOPIT 0x1
#define BM_DIGCTL_CTRL_SAIF_LOOPBACK 0x00008000
#define BV_DIGCTL_CTRL_SAIF_LOOPBACK__NORMAL 0x0
#define BV_DIGCTL_CTRL_SAIF_LOOPBACK__LOOPIT 0x1
#define BP_DIGCTL_CTRL_SAIF_CLKMUX_SEL      13
#define BM_DIGCTL_CTRL_SAIF_CLKMUX_SEL 0x00006000
#define BF_DIGCTL_CTRL_SAIF_CLKMUX_SEL(v)  \
	(((v) << 13) & BM_DIGCTL_CTRL_SAIF_CLKMUX_SEL)
#define BV_DIGCTL_CTRL_SAIF_CLKMUX_SEL__MBL_CLK_OUT	 0x0
#define BV_DIGCTL_CTRL_SAIF_CLKMUX_SEL__BL_CLK_OUT	  0x1
#define BV_DIGCTL_CTRL_SAIF_CLKMUX_SEL__M_CLK_OUT_BL_CLK_IN 0x2
#define BV_DIGCTL_CTRL_SAIF_CLKMUX_SEL__BL_CLK_IN	   0x3
#define BM_DIGCTL_CTRL_SAIF_CLKMST_SEL 0x00001000
#define BV_DIGCTL_CTRL_SAIF_CLKMST_SEL__SAIF1_MST 0x0
#define BV_DIGCTL_CTRL_SAIF_CLKMST_SEL__SAIF2_MST 0x1
#define BM_DIGCTL_CTRL_SAIF_ALT_BITCLK_SEL 0x00000800
#define BM_DIGCTL_CTRL_SY_ENDIAN 0x00000200
#define BM_DIGCTL_CTRL_SY_SFTRST 0x00000100
#define BM_DIGCTL_CTRL_SY_CLKGATE 0x00000080
#define BM_DIGCTL_CTRL_USE_SERIAL_JTAG 0x00000040
#define BV_DIGCTL_CTRL_USE_SERIAL_JTAG__OLD_JTAG    0x0
#define BV_DIGCTL_CTRL_USE_SERIAL_JTAG__SERIAL_JTAG 0x1
#define BM_DIGCTL_CTRL_TRAP_IN_RANGE 0x00000020
#define BM_DIGCTL_CTRL_TRAP_ENABLE 0x00000010
#define BM_DIGCTL_CTRL_DEBUG_DISABLE 0x00000008
#define BM_DIGCTL_CTRL_USB_CLKGATE 0x00000004
#define BV_DIGCTL_CTRL_USB_CLKGATE__RUN     0x0
#define BV_DIGCTL_CTRL_USB_CLKGATE__NO_CLKS 0x1
#define BM_DIGCTL_CTRL_JTAG_SHIELD 0x00000002
#define BV_DIGCTL_CTRL_JTAG_SHIELD__NORMAL     0x0
#define BV_DIGCTL_CTRL_JTAG_SHIELD__SHIELDS_UP 0x1
#define BM_DIGCTL_CTRL_LATCH_ENTROPY 0x00000001
HW_REGISTER(HW_DIGCTL_STATUS, REGS_DIGCTL_BASE, 0x00000010)
#define HW_DIGCTL_STATUS_ADDR (REGS_DIGCTL_BASE + 0x00000010)
#define BM_DIGCTL_STATUS_USB_HS_PRESENT 0x80000000
#define BM_DIGCTL_STATUS_USB_OTG_PRESENT 0x40000000
#define BM_DIGCTL_STATUS_USB_HOST_PRESENT 0x20000000
#define BM_DIGCTL_STATUS_USB_DEVICE_PRESENT 0x10000000
#define BM_DIGCTL_STATUS_DCP_BIST_FAIL 0x00000400
#define BM_DIGCTL_STATUS_DCP_BIST_PASS 0x00000200
#define BM_DIGCTL_STATUS_DCP_BIST_DONE 0x00000100
#define BM_DIGCTL_STATUS_LCD_BIST_FAIL 0x00000080
#define BM_DIGCTL_STATUS_LCD_BIST_PASS 0x00000040
#define BM_DIGCTL_STATUS_LCD_BIST_DONE 0x00000020
#define BM_DIGCTL_STATUS_JTAG_IN_USE 0x00000010
#define BP_DIGCTL_STATUS_PACKAGE_TYPE      1
#define BM_DIGCTL_STATUS_PACKAGE_TYPE 0x0000000E
#define BF_DIGCTL_STATUS_PACKAGE_TYPE(v)  \
	(((v) << 1) & BM_DIGCTL_STATUS_PACKAGE_TYPE)
#define BM_DIGCTL_STATUS_WRITTEN 0x00000001
HW_REGISTER(HW_DIGCTL_HCLKCOUNT, REGS_DIGCTL_BASE, 0x00000020)
#define HW_DIGCTL_HCLKCOUNT_ADDR (REGS_DIGCTL_BASE + 0x00000020)
#define BP_DIGCTL_HCLKCOUNT_COUNT      0
#define BM_DIGCTL_HCLKCOUNT_COUNT 0xFFFFFFFF
#define BF_DIGCTL_HCLKCOUNT_COUNT(v)   (v)
HW_REGISTER(HW_DIGCTL_RAMCTRL, REGS_DIGCTL_BASE, 0x00000030)
#define HW_DIGCTL_RAMCTRL_ADDR (REGS_DIGCTL_BASE + 0x00000030)
#define BP_DIGCTL_RAMCTRL_SPEED_SELECT      8
#define BM_DIGCTL_RAMCTRL_SPEED_SELECT 0x00000F00
#define BF_DIGCTL_RAMCTRL_SPEED_SELECT(v)  \
	(((v) << 8) & BM_DIGCTL_RAMCTRL_SPEED_SELECT)
#define BM_DIGCTL_RAMCTRL_RAM_REPAIR_EN 0x00000001
HW_REGISTER(HW_DIGCTL_RAMREPAIR, REGS_DIGCTL_BASE, 0x00000040)
#define HW_DIGCTL_RAMREPAIR_ADDR (REGS_DIGCTL_BASE + 0x00000040)
#define BP_DIGCTL_RAMREPAIR_ADDR      0
#define BM_DIGCTL_RAMREPAIR_ADDR 0x0000FFFF
#define BF_DIGCTL_RAMREPAIR_ADDR(v)  \
	(((v) << 0) & BM_DIGCTL_RAMREPAIR_ADDR)
HW_REGISTER(HW_DIGCTL_ROMCTRL, REGS_DIGCTL_BASE, 0x00000050)
#define HW_DIGCTL_ROMCTRL_ADDR (REGS_DIGCTL_BASE + 0x00000050)
#define BP_DIGCTL_ROMCTRL_RD_MARGIN      0
#define BM_DIGCTL_ROMCTRL_RD_MARGIN 0x0000000F
#define BF_DIGCTL_ROMCTRL_RD_MARGIN(v)  \
	(((v) << 0) & BM_DIGCTL_ROMCTRL_RD_MARGIN)
HW_REGISTER_0(HW_DIGCTL_WRITEONCE, REGS_DIGCTL_BASE, 0x00000060)
#define HW_DIGCTL_WRITEONCE_ADDR (REGS_DIGCTL_BASE + 0x00000060)
#define BP_DIGCTL_WRITEONCE_BITS      0
#define BM_DIGCTL_WRITEONCE_BITS 0xFFFFFFFF
#define BF_DIGCTL_WRITEONCE_BITS(v)   (v)
HW_REGISTER_0(HW_DIGCTL_ENTROPY, REGS_DIGCTL_BASE, 0x00000090)
#define HW_DIGCTL_ENTROPY_ADDR (REGS_DIGCTL_BASE + 0x00000090)
#define BP_DIGCTL_ENTROPY_VALUE      0
#define BM_DIGCTL_ENTROPY_VALUE 0xFFFFFFFF
#define BF_DIGCTL_ENTROPY_VALUE(v)   (v)
HW_REGISTER_0(HW_DIGCTL_ENTROPY_LATCHED, REGS_DIGCTL_BASE, 0x000000a0)
#define HW_DIGCTL_ENTROPY_LATCHED_ADDR (REGS_DIGCTL_BASE + 0x000000a0)
#define BP_DIGCTL_ENTROPY_LATCHED_VALUE      0
#define BM_DIGCTL_ENTROPY_LATCHED_VALUE 0xFFFFFFFF
#define BF_DIGCTL_ENTROPY_LATCHED_VALUE(v)   (v)
HW_REGISTER(HW_DIGCTL_SJTAGDBG, REGS_DIGCTL_BASE, 0x000000b0)
#define HW_DIGCTL_SJTAGDBG_ADDR (REGS_DIGCTL_BASE + 0x000000b0)
#define BP_DIGCTL_SJTAGDBG_SJTAG_STATE      16
#define BM_DIGCTL_SJTAGDBG_SJTAG_STATE 0x07FF0000
#define BF_DIGCTL_SJTAGDBG_SJTAG_STATE(v)  \
	(((v) << 16) & BM_DIGCTL_SJTAGDBG_SJTAG_STATE)
#define BM_DIGCTL_SJTAGDBG_SJTAG_TDO 0x00000400
#define BM_DIGCTL_SJTAGDBG_SJTAG_TDI 0x00000200
#define BM_DIGCTL_SJTAGDBG_SJTAG_MODE 0x00000100
#define BP_DIGCTL_SJTAGDBG_DELAYED_ACTIVE      4
#define BM_DIGCTL_SJTAGDBG_DELAYED_ACTIVE 0x000000F0
#define BF_DIGCTL_SJTAGDBG_DELAYED_ACTIVE(v)  \
	(((v) << 4) & BM_DIGCTL_SJTAGDBG_DELAYED_ACTIVE)
#define BM_DIGCTL_SJTAGDBG_ACTIVE 0x00000008
#define BM_DIGCTL_SJTAGDBG_SJTAG_PIN_STATE 0x00000004
#define BM_DIGCTL_SJTAGDBG_SJTAG_DEBUG_DATA 0x00000002
#define BM_DIGCTL_SJTAGDBG_SJTAG_DEBUG_OE 0x00000001
HW_REGISTER(HW_DIGCTL_MICROSECONDS, REGS_DIGCTL_BASE, 0x000000c0)
#define HW_DIGCTL_MICROSECONDS_ADDR (REGS_DIGCTL_BASE + 0x000000c0)
#define BP_DIGCTL_MICROSECONDS_VALUE      0
#define BM_DIGCTL_MICROSECONDS_VALUE 0xFFFFFFFF
#define BF_DIGCTL_MICROSECONDS_VALUE(v)   (v)
HW_REGISTER_0(HW_DIGCTL_DBGRD, REGS_DIGCTL_BASE, 0x000000d0)
#define HW_DIGCTL_DBGRD_ADDR (REGS_DIGCTL_BASE + 0x000000d0)
#define BP_DIGCTL_DBGRD_COMPLEMENT      0
#define BM_DIGCTL_DBGRD_COMPLEMENT 0xFFFFFFFF
#define BF_DIGCTL_DBGRD_COMPLEMENT(v)   (v)
HW_REGISTER_0(HW_DIGCTL_DBG, REGS_DIGCTL_BASE, 0x000000e0)
#define HW_DIGCTL_DBG_ADDR (REGS_DIGCTL_BASE + 0x000000e0)
#define BP_DIGCTL_DBG_VALUE      0
#define BM_DIGCTL_DBG_VALUE 0xFFFFFFFF
#define BF_DIGCTL_DBG_VALUE(v)   (v)
HW_REGISTER(HW_DIGCTL_OCRAM_BIST_CSR, REGS_DIGCTL_BASE, 0x000000f0)
#define HW_DIGCTL_OCRAM_BIST_CSR_ADDR (REGS_DIGCTL_BASE + 0x000000f0)
#define BM_DIGCTL_OCRAM_BIST_CSR_BIST_DEBUG_MODE 0x00000400
#define BM_DIGCTL_OCRAM_BIST_CSR_BIST_DATA_CHANGE 0x00000200
#define BM_DIGCTL_OCRAM_BIST_CSR_BIST_CLKEN 0x00000100
#define BM_DIGCTL_OCRAM_BIST_CSR_FAIL 0x00000008
#define BM_DIGCTL_OCRAM_BIST_CSR_PASS 0x00000004
#define BM_DIGCTL_OCRAM_BIST_CSR_DONE 0x00000002
#define BM_DIGCTL_OCRAM_BIST_CSR_START 0x00000001
HW_REGISTER(HW_DIGCTL_OCRAM_STATUS0, REGS_DIGCTL_BASE, 0x00000110)
#define HW_DIGCTL_OCRAM_STATUS0_ADDR (REGS_DIGCTL_BASE + 0x00000110)
#define BP_DIGCTL_OCRAM_STATUS0_FAILDATA00      0
#define BM_DIGCTL_OCRAM_STATUS0_FAILDATA00 0xFFFFFFFF
#define BF_DIGCTL_OCRAM_STATUS0_FAILDATA00(v)   (v)
HW_REGISTER(HW_DIGCTL_OCRAM_STATUS1, REGS_DIGCTL_BASE, 0x00000120)
#define HW_DIGCTL_OCRAM_STATUS1_ADDR (REGS_DIGCTL_BASE + 0x00000120)
#define BP_DIGCTL_OCRAM_STATUS1_FAILDATA01      0
#define BM_DIGCTL_OCRAM_STATUS1_FAILDATA01 0xFFFFFFFF
#define BF_DIGCTL_OCRAM_STATUS1_FAILDATA01(v)   (v)
HW_REGISTER(HW_DIGCTL_OCRAM_STATUS2, REGS_DIGCTL_BASE, 0x00000130)
#define HW_DIGCTL_OCRAM_STATUS2_ADDR (REGS_DIGCTL_BASE + 0x00000130)
#define BP_DIGCTL_OCRAM_STATUS2_FAILDATA10      0
#define BM_DIGCTL_OCRAM_STATUS2_FAILDATA10 0xFFFFFFFF
#define BF_DIGCTL_OCRAM_STATUS2_FAILDATA10(v)   (v)
HW_REGISTER(HW_DIGCTL_OCRAM_STATUS3, REGS_DIGCTL_BASE, 0x00000140)
#define HW_DIGCTL_OCRAM_STATUS3_ADDR (REGS_DIGCTL_BASE + 0x00000140)
#define BP_DIGCTL_OCRAM_STATUS3_FAILDATA11      0
#define BM_DIGCTL_OCRAM_STATUS3_FAILDATA11 0xFFFFFFFF
#define BF_DIGCTL_OCRAM_STATUS3_FAILDATA11(v)   (v)
HW_REGISTER(HW_DIGCTL_OCRAM_STATUS4, REGS_DIGCTL_BASE, 0x00000150)
#define HW_DIGCTL_OCRAM_STATUS4_ADDR (REGS_DIGCTL_BASE + 0x00000150)
#define BP_DIGCTL_OCRAM_STATUS4_FAILDATA20      0
#define BM_DIGCTL_OCRAM_STATUS4_FAILDATA20 0xFFFFFFFF
#define BF_DIGCTL_OCRAM_STATUS4_FAILDATA20(v)   (v)
HW_REGISTER(HW_DIGCTL_OCRAM_STATUS5, REGS_DIGCTL_BASE, 0x00000160)
#define HW_DIGCTL_OCRAM_STATUS5_ADDR (REGS_DIGCTL_BASE + 0x00000160)
#define BP_DIGCTL_OCRAM_STATUS5_FAILDATA21      0
#define BM_DIGCTL_OCRAM_STATUS5_FAILDATA21 0xFFFFFFFF
#define BF_DIGCTL_OCRAM_STATUS5_FAILDATA21(v)   (v)
HW_REGISTER(HW_DIGCTL_OCRAM_STATUS6, REGS_DIGCTL_BASE, 0x00000170)
#define HW_DIGCTL_OCRAM_STATUS6_ADDR (REGS_DIGCTL_BASE + 0x00000170)
#define BP_DIGCTL_OCRAM_STATUS6_FAILDATA30      0
#define BM_DIGCTL_OCRAM_STATUS6_FAILDATA30 0xFFFFFFFF
#define BF_DIGCTL_OCRAM_STATUS6_FAILDATA30(v)   (v)
HW_REGISTER(HW_DIGCTL_OCRAM_STATUS7, REGS_DIGCTL_BASE, 0x00000180)
#define HW_DIGCTL_OCRAM_STATUS7_ADDR (REGS_DIGCTL_BASE + 0x00000180)
#define BP_DIGCTL_OCRAM_STATUS7_FAILDATA31      0
#define BM_DIGCTL_OCRAM_STATUS7_FAILDATA31 0xFFFFFFFF
#define BF_DIGCTL_OCRAM_STATUS7_FAILDATA31(v)   (v)
HW_REGISTER(HW_DIGCTL_OCRAM_STATUS8, REGS_DIGCTL_BASE, 0x00000190)
#define HW_DIGCTL_OCRAM_STATUS8_ADDR (REGS_DIGCTL_BASE + 0x00000190)
#define BP_DIGCTL_OCRAM_STATUS8_FAILADDR01      16
#define BM_DIGCTL_OCRAM_STATUS8_FAILADDR01 0x1FFF0000
#define BF_DIGCTL_OCRAM_STATUS8_FAILADDR01(v)  \
	(((v) << 16) & BM_DIGCTL_OCRAM_STATUS8_FAILADDR01)
#define BP_DIGCTL_OCRAM_STATUS8_FAILADDR00      0
#define BM_DIGCTL_OCRAM_STATUS8_FAILADDR00 0x00001FFF
#define BF_DIGCTL_OCRAM_STATUS8_FAILADDR00(v)  \
	(((v) << 0) & BM_DIGCTL_OCRAM_STATUS8_FAILADDR00)
HW_REGISTER(HW_DIGCTL_OCRAM_STATUS9, REGS_DIGCTL_BASE, 0x000001a0)
#define HW_DIGCTL_OCRAM_STATUS9_ADDR (REGS_DIGCTL_BASE + 0x000001a0)
#define BP_DIGCTL_OCRAM_STATUS9_FAILADDR11      16
#define BM_DIGCTL_OCRAM_STATUS9_FAILADDR11 0x1FFF0000
#define BF_DIGCTL_OCRAM_STATUS9_FAILADDR11(v)  \
	(((v) << 16) & BM_DIGCTL_OCRAM_STATUS9_FAILADDR11)
#define BP_DIGCTL_OCRAM_STATUS9_FAILADDR10      0
#define BM_DIGCTL_OCRAM_STATUS9_FAILADDR10 0x00001FFF
#define BF_DIGCTL_OCRAM_STATUS9_FAILADDR10(v)  \
	(((v) << 0) & BM_DIGCTL_OCRAM_STATUS9_FAILADDR10)
HW_REGISTER(HW_DIGCTL_OCRAM_STATUS10, REGS_DIGCTL_BASE, 0x000001b0)
#define HW_DIGCTL_OCRAM_STATUS10_ADDR (REGS_DIGCTL_BASE + 0x000001b0)
#define BP_DIGCTL_OCRAM_STATUS10_FAILADDR21      16
#define BM_DIGCTL_OCRAM_STATUS10_FAILADDR21 0x1FFF0000
#define BF_DIGCTL_OCRAM_STATUS10_FAILADDR21(v)  \
	(((v) << 16) & BM_DIGCTL_OCRAM_STATUS10_FAILADDR21)
#define BP_DIGCTL_OCRAM_STATUS10_FAILADDR20      0
#define BM_DIGCTL_OCRAM_STATUS10_FAILADDR20 0x00001FFF
#define BF_DIGCTL_OCRAM_STATUS10_FAILADDR20(v)  \
	(((v) << 0) & BM_DIGCTL_OCRAM_STATUS10_FAILADDR20)
HW_REGISTER(HW_DIGCTL_OCRAM_STATUS11, REGS_DIGCTL_BASE, 0x000001c0)
#define HW_DIGCTL_OCRAM_STATUS11_ADDR (REGS_DIGCTL_BASE + 0x000001c0)
#define BP_DIGCTL_OCRAM_STATUS11_FAILADDR31      16
#define BM_DIGCTL_OCRAM_STATUS11_FAILADDR31 0x1FFF0000
#define BF_DIGCTL_OCRAM_STATUS11_FAILADDR31(v)  \
	(((v) << 16) & BM_DIGCTL_OCRAM_STATUS11_FAILADDR31)
#define BP_DIGCTL_OCRAM_STATUS11_FAILADDR30      0
#define BM_DIGCTL_OCRAM_STATUS11_FAILADDR30 0x00001FFF
#define BF_DIGCTL_OCRAM_STATUS11_FAILADDR30(v)  \
	(((v) << 0) & BM_DIGCTL_OCRAM_STATUS11_FAILADDR30)
HW_REGISTER(HW_DIGCTL_OCRAM_STATUS12, REGS_DIGCTL_BASE, 0x000001d0)
#define HW_DIGCTL_OCRAM_STATUS12_ADDR (REGS_DIGCTL_BASE + 0x000001d0)
#define BP_DIGCTL_OCRAM_STATUS12_FAILSTATE11      24
#define BM_DIGCTL_OCRAM_STATUS12_FAILSTATE11 0x0F000000
#define BF_DIGCTL_OCRAM_STATUS12_FAILSTATE11(v)  \
	(((v) << 24) & BM_DIGCTL_OCRAM_STATUS12_FAILSTATE11)
#define BP_DIGCTL_OCRAM_STATUS12_FAILSTATE10      16
#define BM_DIGCTL_OCRAM_STATUS12_FAILSTATE10 0x000F0000
#define BF_DIGCTL_OCRAM_STATUS12_FAILSTATE10(v)  \
	(((v) << 16) & BM_DIGCTL_OCRAM_STATUS12_FAILSTATE10)
#define BP_DIGCTL_OCRAM_STATUS12_FAILSTATE01      8
#define BM_DIGCTL_OCRAM_STATUS12_FAILSTATE01 0x00000F00
#define BF_DIGCTL_OCRAM_STATUS12_FAILSTATE01(v)  \
	(((v) << 8) & BM_DIGCTL_OCRAM_STATUS12_FAILSTATE01)
#define BP_DIGCTL_OCRAM_STATUS12_FAILSTATE00      0
#define BM_DIGCTL_OCRAM_STATUS12_FAILSTATE00 0x0000000F
#define BF_DIGCTL_OCRAM_STATUS12_FAILSTATE00(v)  \
	(((v) << 0) & BM_DIGCTL_OCRAM_STATUS12_FAILSTATE00)
HW_REGISTER(HW_DIGCTL_OCRAM_STATUS13, REGS_DIGCTL_BASE, 0x000001e0)
#define HW_DIGCTL_OCRAM_STATUS13_ADDR (REGS_DIGCTL_BASE + 0x000001e0)
#define BP_DIGCTL_OCRAM_STATUS13_FAILSTATE31      24
#define BM_DIGCTL_OCRAM_STATUS13_FAILSTATE31 0x0F000000
#define BF_DIGCTL_OCRAM_STATUS13_FAILSTATE31(v)  \
	(((v) << 24) & BM_DIGCTL_OCRAM_STATUS13_FAILSTATE31)
#define BP_DIGCTL_OCRAM_STATUS13_FAILSTATE30      16
#define BM_DIGCTL_OCRAM_STATUS13_FAILSTATE30 0x000F0000
#define BF_DIGCTL_OCRAM_STATUS13_FAILSTATE30(v)  \
	(((v) << 16) & BM_DIGCTL_OCRAM_STATUS13_FAILSTATE30)
#define BP_DIGCTL_OCRAM_STATUS13_FAILSTATE21      8
#define BM_DIGCTL_OCRAM_STATUS13_FAILSTATE21 0x00000F00
#define BF_DIGCTL_OCRAM_STATUS13_FAILSTATE21(v)  \
	(((v) << 8) & BM_DIGCTL_OCRAM_STATUS13_FAILSTATE21)
#define BP_DIGCTL_OCRAM_STATUS13_FAILSTATE20      0
#define BM_DIGCTL_OCRAM_STATUS13_FAILSTATE20 0x0000000F
#define BF_DIGCTL_OCRAM_STATUS13_FAILSTATE20(v)  \
	(((v) << 0) & BM_DIGCTL_OCRAM_STATUS13_FAILSTATE20)
HW_REGISTER_0(HW_DIGCTL_SCRATCH0, REGS_DIGCTL_BASE, 0x00000290)
#define HW_DIGCTL_SCRATCH0_ADDR (REGS_DIGCTL_BASE + 0x00000290)
#define BP_DIGCTL_SCRATCH0_PTR      0
#define BM_DIGCTL_SCRATCH0_PTR 0xFFFFFFFF
#define BF_DIGCTL_SCRATCH0_PTR(v)   (v)
HW_REGISTER_0(HW_DIGCTL_SCRATCH1, REGS_DIGCTL_BASE, 0x000002a0)
#define HW_DIGCTL_SCRATCH1_ADDR (REGS_DIGCTL_BASE + 0x000002a0)
#define BP_DIGCTL_SCRATCH1_PTR      0
#define BM_DIGCTL_SCRATCH1_PTR 0xFFFFFFFF
#define BF_DIGCTL_SCRATCH1_PTR(v)   (v)
HW_REGISTER_0(HW_DIGCTL_ARMCACHE, REGS_DIGCTL_BASE, 0x000002b0)
#define HW_DIGCTL_ARMCACHE_ADDR (REGS_DIGCTL_BASE + 0x000002b0)
#define BP_DIGCTL_ARMCACHE_VALID_SS      16
#define BM_DIGCTL_ARMCACHE_VALID_SS 0x00030000
#define BF_DIGCTL_ARMCACHE_VALID_SS(v)  \
	(((v) << 16) & BM_DIGCTL_ARMCACHE_VALID_SS)
#define BP_DIGCTL_ARMCACHE_DRTY_SS      12
#define BM_DIGCTL_ARMCACHE_DRTY_SS 0x00003000
#define BF_DIGCTL_ARMCACHE_DRTY_SS(v)  \
	(((v) << 12) & BM_DIGCTL_ARMCACHE_DRTY_SS)
#define BP_DIGCTL_ARMCACHE_CACHE_SS      8
#define BM_DIGCTL_ARMCACHE_CACHE_SS 0x00000300
#define BF_DIGCTL_ARMCACHE_CACHE_SS(v)  \
	(((v) << 8) & BM_DIGCTL_ARMCACHE_CACHE_SS)
#define BP_DIGCTL_ARMCACHE_DTAG_SS      4
#define BM_DIGCTL_ARMCACHE_DTAG_SS 0x00000030
#define BF_DIGCTL_ARMCACHE_DTAG_SS(v)  \
	(((v) << 4) & BM_DIGCTL_ARMCACHE_DTAG_SS)
#define BP_DIGCTL_ARMCACHE_ITAG_SS      0
#define BM_DIGCTL_ARMCACHE_ITAG_SS 0x00000003
#define BF_DIGCTL_ARMCACHE_ITAG_SS(v)  \
	(((v) << 0) & BM_DIGCTL_ARMCACHE_ITAG_SS)
HW_REGISTER_0(HW_DIGCTL_DEBUG_TRAP_ADDR_LOW, REGS_DIGCTL_BASE, 0x000002c0)
#define HW_DIGCTL_DEBUG_TRAP_ADDR_LOW_ADDR (REGS_DIGCTL_BASE + 0x000002c0)
#define BP_DIGCTL_DEBUG_TRAP_ADDR_LOW_ADDR      0
#define BM_DIGCTL_DEBUG_TRAP_ADDR_LOW_ADDR 0xFFFFFFFF
#define BF_DIGCTL_DEBUG_TRAP_ADDR_LOW_ADDR(v)   (v)
HW_REGISTER_0(HW_DIGCTL_DEBUG_TRAP_ADDR_HIGH, REGS_DIGCTL_BASE, 0x000002d0)
#define HW_DIGCTL_DEBUG_TRAP_ADDR_HIGH_ADDR (REGS_DIGCTL_BASE + 0x000002d0)
#define BP_DIGCTL_DEBUG_TRAP_ADDR_HIGH_ADDR      0
#define BM_DIGCTL_DEBUG_TRAP_ADDR_HIGH_ADDR 0xFFFFFFFF
#define BF_DIGCTL_DEBUG_TRAP_ADDR_HIGH_ADDR(v)   (v)
HW_REGISTER_0(HW_DIGCTL_SGTL, REGS_DIGCTL_BASE, 0x00000300)
#define HW_DIGCTL_SGTL_ADDR (REGS_DIGCTL_BASE + 0x00000300)
#define BP_DIGCTL_SGTL_COPYRIGHT      0
#define BM_DIGCTL_SGTL_COPYRIGHT 0xFFFFFFFF
#define BF_DIGCTL_SGTL_COPYRIGHT(v)   (v)
HW_REGISTER_0(HW_DIGCTL_CHIPID, REGS_DIGCTL_BASE, 0x00000310)
#define HW_DIGCTL_CHIPID_ADDR (REGS_DIGCTL_BASE + 0x00000310)
#define BP_DIGCTL_CHIPID_PRODUCT_CODE      16
#define BM_DIGCTL_CHIPID_PRODUCT_CODE 0xFFFF0000
#define BF_DIGCTL_CHIPID_PRODUCT_CODE(v) \
	(((v) << 16) & BM_DIGCTL_CHIPID_PRODUCT_CODE)
#define BP_DIGCTL_CHIPID_REVISION      0
#define BM_DIGCTL_CHIPID_REVISION 0x000000FF
#define BF_DIGCTL_CHIPID_REVISION(v)  \
	(((v) << 0) & BM_DIGCTL_CHIPID_REVISION)
HW_REGISTER_0(HW_DIGCTL_AHB_STATS_SELECT, REGS_DIGCTL_BASE, 0x00000330)
#define HW_DIGCTL_AHB_STATS_SELECT_ADDR (REGS_DIGCTL_BASE + 0x00000330)
#define BP_DIGCTL_AHB_STATS_SELECT_L3_MASTER_SELECT      24
#define BM_DIGCTL_AHB_STATS_SELECT_L3_MASTER_SELECT 0x0F000000
#define BF_DIGCTL_AHB_STATS_SELECT_L3_MASTER_SELECT(v)  \
	(((v) << 24) & BM_DIGCTL_AHB_STATS_SELECT_L3_MASTER_SELECT)
#define BV_DIGCTL_AHB_STATS_SELECT_L3_MASTER_SELECT__APBH 0x1
#define BV_DIGCTL_AHB_STATS_SELECT_L3_MASTER_SELECT__APBX 0x2
#define BV_DIGCTL_AHB_STATS_SELECT_L3_MASTER_SELECT__USB  0x4
#define BP_DIGCTL_AHB_STATS_SELECT_L2_MASTER_SELECT      16
#define BM_DIGCTL_AHB_STATS_SELECT_L2_MASTER_SELECT 0x000F0000
#define BF_DIGCTL_AHB_STATS_SELECT_L2_MASTER_SELECT(v)  \
	(((v) << 16) & BM_DIGCTL_AHB_STATS_SELECT_L2_MASTER_SELECT)
#define BV_DIGCTL_AHB_STATS_SELECT_L2_MASTER_SELECT__ARM_D 0x1
#define BP_DIGCTL_AHB_STATS_SELECT_L1_MASTER_SELECT      8
#define BM_DIGCTL_AHB_STATS_SELECT_L1_MASTER_SELECT 0x00000F00
#define BF_DIGCTL_AHB_STATS_SELECT_L1_MASTER_SELECT(v)  \
	(((v) << 8) & BM_DIGCTL_AHB_STATS_SELECT_L1_MASTER_SELECT)
#define BV_DIGCTL_AHB_STATS_SELECT_L1_MASTER_SELECT__ARM_I 0x1
#define BP_DIGCTL_AHB_STATS_SELECT_L0_MASTER_SELECT      0
#define BM_DIGCTL_AHB_STATS_SELECT_L0_MASTER_SELECT 0x0000000F
#define BF_DIGCTL_AHB_STATS_SELECT_L0_MASTER_SELECT(v)  \
	(((v) << 0) & BM_DIGCTL_AHB_STATS_SELECT_L0_MASTER_SELECT)
#define BV_DIGCTL_AHB_STATS_SELECT_L0_MASTER_SELECT__ECC8   0x1
#define BV_DIGCTL_AHB_STATS_SELECT_L0_MASTER_SELECT__CRYPTO 0x2
HW_REGISTER_0(HW_DIGCTL_L0_AHB_ACTIVE_CYCLES, REGS_DIGCTL_BASE, 0x00000340)
#define HW_DIGCTL_L0_AHB_ACTIVE_CYCLES_ADDR (REGS_DIGCTL_BASE + 0x00000340)
#define BP_DIGCTL_L0_AHB_ACTIVE_CYCLES_COUNT      0
#define BM_DIGCTL_L0_AHB_ACTIVE_CYCLES_COUNT 0xFFFFFFFF
#define BF_DIGCTL_L0_AHB_ACTIVE_CYCLES_COUNT(v)   (v)
HW_REGISTER_0(HW_DIGCTL_L0_AHB_DATA_STALLED, REGS_DIGCTL_BASE, 0x00000350)
#define HW_DIGCTL_L0_AHB_DATA_STALLED_ADDR (REGS_DIGCTL_BASE + 0x00000350)
#define BP_DIGCTL_L0_AHB_DATA_STALLED_COUNT      0
#define BM_DIGCTL_L0_AHB_DATA_STALLED_COUNT 0xFFFFFFFF
#define BF_DIGCTL_L0_AHB_DATA_STALLED_COUNT(v)   (v)
HW_REGISTER_0(HW_DIGCTL_L0_AHB_DATA_CYCLES, REGS_DIGCTL_BASE, 0x00000360)
#define HW_DIGCTL_L0_AHB_DATA_CYCLES_ADDR (REGS_DIGCTL_BASE + 0x00000360)
#define BP_DIGCTL_L0_AHB_DATA_CYCLES_COUNT      0
#define BM_DIGCTL_L0_AHB_DATA_CYCLES_COUNT 0xFFFFFFFF
#define BF_DIGCTL_L0_AHB_DATA_CYCLES_COUNT(v)   (v)
HW_REGISTER_0(HW_DIGCTL_L1_AHB_ACTIVE_CYCLES, REGS_DIGCTL_BASE, 0x00000370)
#define HW_DIGCTL_L1_AHB_ACTIVE_CYCLES_ADDR (REGS_DIGCTL_BASE + 0x00000370)
#define BP_DIGCTL_L1_AHB_ACTIVE_CYCLES_COUNT      0
#define BM_DIGCTL_L1_AHB_ACTIVE_CYCLES_COUNT 0xFFFFFFFF
#define BF_DIGCTL_L1_AHB_ACTIVE_CYCLES_COUNT(v)   (v)
HW_REGISTER_0(HW_DIGCTL_L1_AHB_DATA_STALLED, REGS_DIGCTL_BASE, 0x00000380)
#define HW_DIGCTL_L1_AHB_DATA_STALLED_ADDR (REGS_DIGCTL_BASE + 0x00000380)
#define BP_DIGCTL_L1_AHB_DATA_STALLED_COUNT      0
#define BM_DIGCTL_L1_AHB_DATA_STALLED_COUNT 0xFFFFFFFF
#define BF_DIGCTL_L1_AHB_DATA_STALLED_COUNT(v)   (v)
HW_REGISTER_0(HW_DIGCTL_L1_AHB_DATA_CYCLES, REGS_DIGCTL_BASE, 0x00000390)
#define HW_DIGCTL_L1_AHB_DATA_CYCLES_ADDR (REGS_DIGCTL_BASE + 0x00000390)
#define BP_DIGCTL_L1_AHB_DATA_CYCLES_COUNT      0
#define BM_DIGCTL_L1_AHB_DATA_CYCLES_COUNT 0xFFFFFFFF
#define BF_DIGCTL_L1_AHB_DATA_CYCLES_COUNT(v)   (v)
HW_REGISTER_0(HW_DIGCTL_L2_AHB_ACTIVE_CYCLES, REGS_DIGCTL_BASE, 0x000003a0)
#define HW_DIGCTL_L2_AHB_ACTIVE_CYCLES_ADDR (REGS_DIGCTL_BASE + 0x000003a0)
#define BP_DIGCTL_L2_AHB_ACTIVE_CYCLES_COUNT      0
#define BM_DIGCTL_L2_AHB_ACTIVE_CYCLES_COUNT 0xFFFFFFFF
#define BF_DIGCTL_L2_AHB_ACTIVE_CYCLES_COUNT(v)   (v)
HW_REGISTER_0(HW_DIGCTL_L2_AHB_DATA_STALLED, REGS_DIGCTL_BASE, 0x000003b0)
#define HW_DIGCTL_L2_AHB_DATA_STALLED_ADDR (REGS_DIGCTL_BASE + 0x000003b0)
#define BP_DIGCTL_L2_AHB_DATA_STALLED_COUNT      0
#define BM_DIGCTL_L2_AHB_DATA_STALLED_COUNT 0xFFFFFFFF
#define BF_DIGCTL_L2_AHB_DATA_STALLED_COUNT(v)   (v)
HW_REGISTER_0(HW_DIGCTL_L2_AHB_DATA_CYCLES, REGS_DIGCTL_BASE, 0x000003c0)
#define HW_DIGCTL_L2_AHB_DATA_CYCLES_ADDR (REGS_DIGCTL_BASE + 0x000003c0)
#define BP_DIGCTL_L2_AHB_DATA_CYCLES_COUNT      0
#define BM_DIGCTL_L2_AHB_DATA_CYCLES_COUNT 0xFFFFFFFF
#define BF_DIGCTL_L2_AHB_DATA_CYCLES_COUNT(v)   (v)
HW_REGISTER_0(HW_DIGCTL_L3_AHB_ACTIVE_CYCLES, REGS_DIGCTL_BASE, 0x000003d0)
#define HW_DIGCTL_L3_AHB_ACTIVE_CYCLES_ADDR (REGS_DIGCTL_BASE + 0x000003d0)
#define BP_DIGCTL_L3_AHB_ACTIVE_CYCLES_COUNT      0
#define BM_DIGCTL_L3_AHB_ACTIVE_CYCLES_COUNT 0xFFFFFFFF
#define BF_DIGCTL_L3_AHB_ACTIVE_CYCLES_COUNT(v)   (v)
HW_REGISTER_0(HW_DIGCTL_L3_AHB_DATA_STALLED, REGS_DIGCTL_BASE, 0x000003e0)
#define HW_DIGCTL_L3_AHB_DATA_STALLED_ADDR (REGS_DIGCTL_BASE + 0x000003e0)
#define BP_DIGCTL_L3_AHB_DATA_STALLED_COUNT      0
#define BM_DIGCTL_L3_AHB_DATA_STALLED_COUNT 0xFFFFFFFF
#define BF_DIGCTL_L3_AHB_DATA_STALLED_COUNT(v)   (v)
HW_REGISTER_0(HW_DIGCTL_L3_AHB_DATA_CYCLES, REGS_DIGCTL_BASE, 0x000003f0)
#define HW_DIGCTL_L3_AHB_DATA_CYCLES_ADDR (REGS_DIGCTL_BASE + 0x000003f0)
#define BP_DIGCTL_L3_AHB_DATA_CYCLES_COUNT      0
#define BM_DIGCTL_L3_AHB_DATA_CYCLES_COUNT 0xFFFFFFFF
#define BF_DIGCTL_L3_AHB_DATA_CYCLES_COUNT(v)   (v)
/*
 *  multi-register-define name HW_DIGCTL_MPTEn_LOC
 *	      base 0x00000400
 *	      count 16
 *	      offset 0x10
 */
HW_REGISTER_0_INDEXED(HW_DIGCTL_MPTEn_LOC, REGS_DIGCTL_BASE, 0x00000400,
		       0x10)
#define BP_DIGCTL_MPTEn_LOC_LOC      0
#define BM_DIGCTL_MPTEn_LOC_LOC 0x00000FFF
#define BF_DIGCTL_MPTEn_LOC_LOC(v)  \
	(((v) << 0) & BM_DIGCTL_MPTEn_LOC_LOC)
HW_REGISTER_0(HW_DIGCTL_EMICLK_DELAY, REGS_DIGCTL_BASE, 0x00000500)
#define HW_DIGCTL_EMICLK_DELAY_ADDR (REGS_DIGCTL_BASE + 0x00000500)
#define BP_DIGCTL_EMICLK_DELAY_NUM_TAPS      0
#define BM_DIGCTL_EMICLK_DELAY_NUM_TAPS 0x0000001F
#define BF_DIGCTL_EMICLK_DELAY_NUM_TAPS(v)  \
	(((v) << 0) & BM_DIGCTL_EMICLK_DELAY_NUM_TAPS)
#endif /* __ARCH_ARM___DIGCTL_H */
