/*
* Support for Medfield PNW Camera Imaging ISP subsystem.
*
* Copyright (c) 2010 Intel Corporation. All Rights Reserved.
*
* Copyright (c) 2010 Silicon Hive www.siliconhive.com.
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License version
* 2 as published by the Free Software Foundation.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
* 02110-1301, USA.
*
*/

#include "gdc_device.h"		/* gdc_lut_store(), ... */
#include "isp.h"			/* ISP_VEC_ELEMBITS */
#include "vamem.h"
#include "queue.h"			/* host2sp_enqueue_frame_data() */
#include "sw_event.h"		/* encode_sw_event */

#include "assert_support.h"

#include "sh_css.h"
#include "sh_css_params.h"
#include "sh_css_params_internal.h"
#include "sh_css_param_shading.h"
#include "sh_css_refcount.h"
#include "sh_css_pipeline.h"
#include "sh_css_internal.h"
#include "sh_css_defs.h"
#include "sh_css_sp.h"
#include "sh_css_sp_start.h"	/* SH_CSS_PREVENT_UNINIT_READS */
#include "sh_css_debug.h"
#include "memory_access.h"

#include "platform_support.h"

#define NOT_USED(a)                ((a) = (a))

#define sISP_REG_BIT		      ISP_VEC_ELEMBITS
#define uISP_REG_BIT		      ((unsigned)(sISP_REG_BIT-1))
#define sSHIFT				    (16-sISP_REG_BIT)
#define uSHIFT				    ((unsigned)(16-uISP_REG_BIT))
#define sFRACTION_BITS_FITTING(a) (a-sSHIFT)
#define uFRACTION_BITS_FITTING(a) ((unsigned)(a-uSHIFT))
#define sISP_VAL_MIN		      (-(1<<uISP_REG_BIT))
#define sISP_VAL_MAX		      ((1<<uISP_REG_BIT)-1)
#define uISP_VAL_MIN		      ((unsigned)0)
#define uISP_VAL_MAX		      ((unsigned)((1<<uISP_REG_BIT)-1))

/* Convenience macro to force a value to a lower even value.
 *  We do not want to (re)use the kernel macro round_down here
 *  because the same code base is used internally by Silicon Hive
 *  simulation environment, where the kernel macro is not available
 */
#define EVEN_FLOOR(x)	(x & ~1)

/* a:fraction bits for 16bit precision, b:fraction bits for ISP precision */
#define sDIGIT_FITTING(v, a, b) \
	min(max((((v)>>sSHIFT) >> (sFRACTION_BITS_FITTING(a)-(b))), \
	  sISP_VAL_MIN), sISP_VAL_MAX)
#define uDIGIT_FITTING(v, a, b) \
	min((unsigned)max((unsigned)(((v)>>uSHIFT) \
	>> (uFRACTION_BITS_FITTING(a)-(b))), \
	  uISP_VAL_MIN), uISP_VAL_MAX)

#define FPNTBL_BYTES(binary) \
	(sizeof(char) * (binary)->in_frame_info.height * \
	 (binary)->in_frame_info.padded_width)
#define SCTBL_BYTES(binary) \
	(sizeof(unsigned short) * (binary)->sctbl_height * \
	 (binary)->sctbl_aligned_width_per_color * SH_CSS_SC_NUM_COLORS)
#if 0
#define S3ATBL_BYTES(binary) \
	(sizeof(struct sh_css_3a_output) * (binary)->s3atbl_isp_width * \
	 (binary)->s3atbl_isp_height)
#endif
/* TODO: check if the stride is always the same max value or whether
 * it varies per resolution. */
#if 0
#define S3ATBL_HI_LO_BYTES(binary) \
	(ISP_S3ATBL_HI_LO_STRIDE_BYTES * (binary)->s3atbl_isp_height)
#endif
/* SDIS */
#define SDIS_VER_COEF_TBL__IN_DMEM(b) \
	_SDIS_VER_COEF_TBL_USE_DMEM(b->info->mode, b->info->enable.dis)

#define SH_CSS_DIS_VER_NUM_COEF_TYPES(b) \
	(SDIS_VER_COEF_TBL__IN_DMEM(b) ? \
		SH_CSS_DIS_COEF_TYPES_ON_DMEM : \
		SH_CSS_DIS_NUM_COEF_TYPES)

#define SDIS_HOR_COEF_TBL_BYTES(b) \
	(sizeof(short) * SH_CSS_DIS_NUM_COEF_TYPES * (b)->dis_hor_coef_num_isp)
#define SDIS_VER_COEF_TBL_BYTES(b) \
	(sizeof(short) * SH_CSS_DIS_VER_NUM_COEF_TYPES(b) * \
		(b)->dis_ver_coef_num_isp)
#if 0
#define SDIS_HOR_PROJ_TBL_BYTES(b) \
	(sizeof(int)   * SH_CSS_DIS_NUM_COEF_TYPES * (b)->dis_hor_proj_num_isp)
#define SDIS_VER_PROJ_TBL_BYTES(b) \
	(sizeof(int)   * SH_CSS_DIS_NUM_COEF_TYPES * (b)->dis_ver_proj_num_isp)
#endif
#define MORPH_PLANE_BYTES(binary) \
	(SH_CSS_MORPH_TABLE_ELEM_BYTES * (binary)->morph_tbl_aligned_width * \
	 (binary)->morph_tbl_height)

/* @GC TODO: Move these defines to the appropriate place later. */
#define DVS_BLOCKDIM_X (64)
#define DVS_BLOCKDIM_Y (64)
#define DVS_COORD_FRAC_BITS (10)
#define DVS_INPUT_BYTES_PER_PIXEL (1)
#define XMEM_ALIGN_LOG2 (5)

#define DVS_6AXIS_COORDS_ELEMS CEIL_MUL(sizeof(gdc_warp_param_mem_t) \
					, HIVE_ISP_DDR_WORD_BYTES)

#define DVS_6AXIS_BYTES(binary) \
	(DVS_6AXIS_COORDS_ELEMS \
	 * (binary)->out_frame_info.width / DVS_BLOCKDIM_X \
	 * (binary)->out_frame_info.height) / (DVS_BLOCKDIM_Y)


static struct sh_css_isp_params isp_parameters;
static struct sh_css_fpn_table fpn_table;
static struct sh_css_zoom zoom_config;
static struct sh_css_vector motion_config;
static const struct sh_css_morph_table   *morph_table;
static const struct sh_css_macc_table    *macc_table;
static const struct sh_css_gamma_table   *gamma_table;
static const struct sh_css_ctc_table     *ctc_table;
static const struct sh_css_xnr_table     *xnr_table;
static const struct sh_css_3a_config     *s3a_config;
static const struct sh_css_wb_config     *wb_config;
static const struct sh_css_cc_config     *cc_config;
static const struct sh_css_tnr_config    *tnr_config;
static const struct sh_css_ob_config     *ob_config;
static const struct sh_css_dp_config     *dp_config;
static const struct sh_css_nr_config     *nr_config;
static const struct sh_css_ee_config     *ee_config;
static const struct sh_css_de_config     *de_config;
static const struct sh_css_gc_config     *gc_config;
static const struct sh_css_anr_config    *anr_config;
static const struct sh_css_ce_config     *ce_config;
static const struct sh_css_dvs_6axis_config     *dvs_6axis_config;
static const struct sh_css_ecd_config    *ecd_config;
static const struct sh_css_ynr_config    *ynr_config;
static const struct sh_css_fc_config     *fc_config;
static const struct sh_css_cnr_config    *cnr_config;
static const struct sh_css_macc_config   *macc_config;
static const struct sh_css_ctc_config    *ctc_config;
static const struct sh_css_aa_config     *aa_config;
static const struct sh_css_xnr_config    *xnr_config;
static const struct sh_css_rgb_gamma_table     *r_gamma_table;
static const struct sh_css_rgb_gamma_table     *g_gamma_table;
static const struct sh_css_rgb_gamma_table     *b_gamma_table;
static const struct sh_css_yuv2rgb_cc_config   *yuv2rgb_cc_config;
static const struct sh_css_rgb2yuv_cc_config   *rgb2yuv_cc_config;
static bool isp_params_changed,
	    fpn_table_changed,
	    zoom_config_changed,
	    motion_config_changed,
	    dis_coef_table_changed,
	    morph_table_changed,
	    macc_table_changed,
	    gamma_table_changed,
	    ctc_table_changed,
	    xnr_table_changed,
	    s3a_config_changed,
	    wb_config_changed,
	    cc_config_changed,
	    tnr_config_changed,
	    ob_config_changed,
	    dp_config_changed,
	    nr_config_changed,
	    ee_config_changed,
	    de_config_changed,
	    gc_config_changed,
	    anr_config_changed,
	    ce_config_changed,
	    dvs_6axis_config_changed,
	    ecd_config_changed,
	    ynr_config_changed,
	    fc_config_changed,
	    cnr_config_changed,
	    macc_config_changed,
	    ctc_config_changed,
	    aa_config_changed,
	    r_gamma_table_changed,
	    g_gamma_table_changed,
	    b_gamma_table_changed,
	    yuv2rgb_cc_config_changed,
	    rgb2yuv_cc_config_changed,
		xnr_config_changed;


static unsigned int sensor_binning;
static bool raw_binning;

/* local buffers, used to re-order the 3a statistics in vmem-format */
static unsigned short s3a_tbl_hi_buf[ISP_S3ATBL_HI_LO_STRIDE *
				     SH_CSS_MAX_BQ_GRID_HEIGHT],
		      s3a_tbl_lo_buf[ISP_S3ATBL_HI_LO_STRIDE *
				     SH_CSS_MAX_BQ_GRID_HEIGHT];
static struct sh_css_macc_table converted_macc_table;
static const short *dis_hor_coef_tbl,
		   *dis_ver_coef_tbl;
static const struct sh_css_binary *current_3a_binary;
/*
 * for csim and fpga, we need to keep a copy of all data in DDR.
 * On the chip this is not necessary through.
 * TODO: remove this for the chip
 *
 * "memory_manager.h" defines mmgr_mmap()
 */
static struct sh_css_ddr_address_map ddr_ptrs;
static struct sh_css_ddr_address_map_size ddr_ptrs_size;

static struct sh_css_ddr_address_map
			pipe_ddr_ptrs[SH_CSS_NR_OF_PIPELINES];
static struct sh_css_ddr_address_map_size
			pipe_ddr_ptrs_size[SH_CSS_NR_OF_PIPELINES];

/* We keep a second copy of the ptr struct for the SP to access.
   Again, this would not be necessary on the chip. */
static hrt_vaddress sp_ddr_ptrs;

/* sp group address on DDR */
static hrt_vaddress xmem_sp_group_ptrs;

static hrt_vaddress xmem_sp_stage_ptrs[SH_CSS_NR_OF_PIPELINES]
						[SH_CSS_MAX_STAGES];
static hrt_vaddress xmem_isp_stage_ptrs[SH_CSS_NR_OF_PIPELINES]
						[SH_CSS_MAX_STAGES];



/* @GC: X and Y coords will later be pointer with no default value.
 * This is just for initial testing with hardcoded tetragon coords */
#if defined(DVS_6AXIS_COORDS_1080P_UNITY)
static const struct sh_css_dvs_6axis_config default_dvs_6axis_config = {
	.xcoords = {
{  196608,  262144,  327680,  393216,  458752,  524288,  589824,  655360,  720896,  786432,  851968,  917504,  983040, 1048576, 1114112, 1179648, 1245184, 1310720, 1376256, 1441792, 1507328, 1572864, 1638400, 1703936, 1769472, 1835008, 1900544, 1966080, 2031616, 2097152, 2162688},
{  196608,  262144,  327680,  393216,  458752,  524288,  589824,  655360,  720896,  786432,  851968,  917504,  983040, 1048576, 1114112, 1179648, 1245184, 1310720, 1376256, 1441792, 1507328, 1572864, 1638400, 1703936, 1769472, 1835008, 1900544, 1966080, 2031616, 2097152, 2162688},
{  196608,  262144,  327680,  393216,  458752,  524288,  589824,  655360,  720896,  786432,  851968,  917504,  983040, 1048576, 1114112, 1179648, 1245184, 1310720, 1376256, 1441792, 1507328, 1572864, 1638400, 1703936, 1769472, 1835008, 1900544, 1966080, 2031616, 2097152, 2162688},
{  196608,  262144,  327680,  393216,  458752,  524288,  589824,  655360,  720896,  786432,  851968,  917504,  983040, 1048576, 1114112, 1179648, 1245184, 1310720, 1376256, 1441792, 1507328, 1572864, 1638400, 1703936, 1769472, 1835008, 1900544, 1966080, 2031616, 2097152, 2162688},
{  196608,  262144,  327680,  393216,  458752,  524288,  589824,  655360,  720896,  786432,  851968,  917504,  983040, 1048576, 1114112, 1179648, 1245184, 1310720, 1376256, 1441792, 1507328, 1572864, 1638400, 1703936, 1769472, 1835008, 1900544, 1966080, 2031616, 2097152, 2162688},
{  196608,  262144,  327680,  393216,  458752,  524288,  589824,  655360,  720896,  786432,  851968,  917504,  983040, 1048576, 1114112, 1179648, 1245184, 1310720, 1376256, 1441792, 1507328, 1572864, 1638400, 1703936, 1769472, 1835008, 1900544, 1966080, 2031616, 2097152, 2162688},
{  196608,  262144,  327680,  393216,  458752,  524288,  589824,  655360,  720896,  786432,  851968,  917504,  983040, 1048576, 1114112, 1179648, 1245184, 1310720, 1376256, 1441792, 1507328, 1572864, 1638400, 1703936, 1769472, 1835008, 1900544, 1966080, 2031616, 2097152, 2162688},
{  196608,  262144,  327680,  393216,  458752,  524288,  589824,  655360,  720896,  786432,  851968,  917504,  983040, 1048576, 1114112, 1179648, 1245184, 1310720, 1376256, 1441792, 1507328, 1572864, 1638400, 1703936, 1769472, 1835008, 1900544, 1966080, 2031616, 2097152, 2162688},
{  196608,  262144,  327680,  393216,  458752,  524288,  589824,  655360,  720896,  786432,  851968,  917504,  983040, 1048576, 1114112, 1179648, 1245184, 1310720, 1376256, 1441792, 1507328, 1572864, 1638400, 1703936, 1769472, 1835008, 1900544, 1966080, 2031616, 2097152, 2162688},
{  196608,  262144,  327680,  393216,  458752,  524288,  589824,  655360,  720896,  786432,  851968,  917504,  983040, 1048576, 1114112, 1179648, 1245184, 1310720, 1376256, 1441792, 1507328, 1572864, 1638400, 1703936, 1769472, 1835008, 1900544, 1966080, 2031616, 2097152, 2162688},
{  196608,  262144,  327680,  393216,  458752,  524288,  589824,  655360,  720896,  786432,  851968,  917504,  983040, 1048576, 1114112, 1179648, 1245184, 1310720, 1376256, 1441792, 1507328, 1572864, 1638400, 1703936, 1769472, 1835008, 1900544, 1966080, 2031616, 2097152, 2162688},
{  196608,  262144,  327680,  393216,  458752,  524288,  589824,  655360,  720896,  786432,  851968,  917504,  983040, 1048576, 1114112, 1179648, 1245184, 1310720, 1376256, 1441792, 1507328, 1572864, 1638400, 1703936, 1769472, 1835008, 1900544, 1966080, 2031616, 2097152, 2162688},
{  196608,  262144,  327680,  393216,  458752,  524288,  589824,  655360,  720896,  786432,  851968,  917504,  983040, 1048576, 1114112, 1179648, 1245184, 1310720, 1376256, 1441792, 1507328, 1572864, 1638400, 1703936, 1769472, 1835008, 1900544, 1966080, 2031616, 2097152, 2162688},
{  196608,  262144,  327680,  393216,  458752,  524288,  589824,  655360,  720896,  786432,  851968,  917504,  983040, 1048576, 1114112, 1179648, 1245184, 1310720, 1376256, 1441792, 1507328, 1572864, 1638400, 1703936, 1769472, 1835008, 1900544, 1966080, 2031616, 2097152, 2162688},
{  196608,  262144,  327680,  393216,  458752,  524288,  589824,  655360,  720896,  786432,  851968,  917504,  983040, 1048576, 1114112, 1179648, 1245184, 1310720, 1376256, 1441792, 1507328, 1572864, 1638400, 1703936, 1769472, 1835008, 1900544, 1966080, 2031616, 2097152, 2162688},
{  196608,  262144,  327680,  393216,  458752,  524288,  589824,  655360,  720896,  786432,  851968,  917504,  983040, 1048576, 1114112, 1179648, 1245184, 1310720, 1376256, 1441792, 1507328, 1572864, 1638400, 1703936, 1769472, 1835008, 1900544, 1966080, 2031616, 2097152, 2162688},
{  196608,  262144,  327680,  393216,  458752,  524288,  589824,  655360,  720896,  786432,  851968,  917504,  983040, 1048576, 1114112, 1179648, 1245184, 1310720, 1376256, 1441792, 1507328, 1572864, 1638400, 1703936, 1769472, 1835008, 1900544, 1966080, 2031616, 2097152, 2162688},
{  196608,  262144,  327680,  393216,  458752,  524288,  589824,  655360,  720896,  786432,  851968,  917504,  983040, 1048576, 1114112, 1179648, 1245184, 1310720, 1376256, 1441792, 1507328, 1572864, 1638400, 1703936, 1769472, 1835008, 1900544, 1966080, 2031616, 2097152, 2162688}
},
	.ycoords = {
{  110592,  110592,  110592,  110592,  110592,  110592,  110592,  110592,  110592,  110592,  110592,  110592,  110592,  110592,  110592,  110592,  110592,  110592,  110592,  110592,  110592,  110592,  110592,  110592,  110592,  110592,  110592,  110592,  110592,  110592,  110592},
{  176128,  176128,  176128,  176128,  176128,  176128,  176128,  176128,  176128,  176128,  176128,  176128,  176128,  176128,  176128,  176128,  176128,  176128,  176128,  176128,  176128,  176128,  176128,  176128,  176128,  176128,  176128,  176128,  176128,  176128,  176128},
{  241664,  241664,  241664,  241664,  241664,  241664,  241664,  241664,  241664,  241664,  241664,  241664,  241664,  241664,  241664,  241664,  241664,  241664,  241664,  241664,  241664,  241664,  241664,  241664,  241664,  241664,  241664,  241664,  241664,  241664,  241664},
{  307200,  307200,  307200,  307200,  307200,  307200,  307200,  307200,  307200,  307200,  307200,  307200,  307200,  307200,  307200,  307200,  307200,  307200,  307200,  307200,  307200,  307200,  307200,  307200,  307200,  307200,  307200,  307200,  307200,  307200,  307200},
{  372736,  372736,  372736,  372736,  372736,  372736,  372736,  372736,  372736,  372736,  372736,  372736,  372736,  372736,  372736,  372736,  372736,  372736,  372736,  372736,  372736,  372736,  372736,  372736,  372736,  372736,  372736,  372736,  372736,  372736,  372736},
{  438272,  438272,  438272,  438272,  438272,  438272,  438272,  438272,  438272,  438272,  438272,  438272,  438272,  438272,  438272,  438272,  438272,  438272,  438272,  438272,  438272,  438272,  438272,  438272,  438272,  438272,  438272,  438272,  438272,  438272,  438272},
{  503808,  503808,  503808,  503808,  503808,  503808,  503808,  503808,  503808,  503808,  503808,  503808,  503808,  503808,  503808,  503808,  503808,  503808,  503808,  503808,  503808,  503808,  503808,  503808,  503808,  503808,  503808,  503808,  503808,  503808,  503808},
{  569344,  569344,  569344,  569344,  569344,  569344,  569344,  569344,  569344,  569344,  569344,  569344,  569344,  569344,  569344,  569344,  569344,  569344,  569344,  569344,  569344,  569344,  569344,  569344,  569344,  569344,  569344,  569344,  569344,  569344,  569344},
{  634880,  634880,  634880,  634880,  634880,  634880,  634880,  634880,  634880,  634880,  634880,  634880,  634880,  634880,  634880,  634880,  634880,  634880,  634880,  634880,  634880,  634880,  634880,  634880,  634880,  634880,  634880,  634880,  634880,  634880,  634880},
{  700416,  700416,  700416,  700416,  700416,  700416,  700416,  700416,  700416,  700416,  700416,  700416,  700416,  700416,  700416,  700416,  700416,  700416,  700416,  700416,  700416,  700416,  700416,  700416,  700416,  700416,  700416,  700416,  700416,  700416,  700416},
{  765952,  765952,  765952,  765952,  765952,  765952,  765952,  765952,  765952,  765952,  765952,  765952,  765952,  765952,  765952,  765952,  765952,  765952,  765952,  765952,  765952,  765952,  765952,  765952,  765952,  765952,  765952,  765952,  765952,  765952,  765952},
{  831488,  831488,  831488,  831488,  831488,  831488,  831488,  831488,  831488,  831488,  831488,  831488,  831488,  831488,  831488,  831488,  831488,  831488,  831488,  831488,  831488,  831488,  831488,  831488,  831488,  831488,  831488,  831488,  831488,  831488,  831488},
{  897024,  897024,  897024,  897024,  897024,  897024,  897024,  897024,  897024,  897024,  897024,  897024,  897024,  897024,  897024,  897024,  897024,  897024,  897024,  897024,  897024,  897024,  897024,  897024,  897024,  897024,  897024,  897024,  897024,  897024,  897024},
{  962560,  962560,  962560,  962560,  962560,  962560,  962560,  962560,  962560,  962560,  962560,  962560,  962560,  962560,  962560,  962560,  962560,  962560,  962560,  962560,  962560,  962560,  962560,  962560,  962560,  962560,  962560,  962560,  962560,  962560,  962560},
{ 1028096, 1028096, 1028096, 1028096, 1028096, 1028096, 1028096, 1028096, 1028096, 1028096, 1028096, 1028096, 1028096, 1028096, 1028096, 1028096, 1028096, 1028096, 1028096, 1028096, 1028096, 1028096, 1028096, 1028096, 1028096, 1028096, 1028096, 1028096, 1028096, 1028096, 1028096},
{ 1093632, 1093632, 1093632, 1093632, 1093632, 1093632, 1093632, 1093632, 1093632, 1093632, 1093632, 1093632, 1093632, 1093632, 1093632, 1093632, 1093632, 1093632, 1093632, 1093632, 1093632, 1093632, 1093632, 1093632, 1093632, 1093632, 1093632, 1093632, 1093632, 1093632, 1093632},
{ 1159168, 1159168, 1159168, 1159168, 1159168, 1159168, 1159168, 1159168, 1159168, 1159168, 1159168, 1159168, 1159168, 1159168, 1159168, 1159168, 1159168, 1159168, 1159168, 1159168, 1159168, 1159168, 1159168, 1159168, 1159168, 1159168, 1159168, 1159168, 1159168, 1159168, 1159168},
{ 1224704, 1224704, 1224704, 1224704, 1224704, 1224704, 1224704, 1224704, 1224704, 1224704, 1224704, 1224704, 1224704, 1224704, 1224704, 1224704, 1224704, 1224704, 1224704, 1224704, 1224704, 1224704, 1224704, 1224704, 1224704, 1224704, 1224704, 1224704, 1224704, 1224704, 1224704}
}
};
#elif defined(DVS_6AXIS_COORDS_SMALL_UNITY)
static const struct sh_css_dvs_6axis_config default_dvs_6axis_config = {
	.xcoords = {
{  131072,  196608,  262144,  327680,  393216,  458752,  524288,  589824,  655360,  720896,  786432,  851968,  917504},
{  131072,  196608,  262144,  327680,  393216,  458752,  524288,  589824,  655360,  720896,  786432,  851968,  917504},
{  131072,  196608,  262144,  327680,  393216,  458752,  524288,  589824,  655360,  720896,  786432,  851968,  917504},
{  131072,  196608,  262144,  327680,  393216,  458752,  524288,  589824,  655360,  720896,  786432,  851968,  917504},
{  131072,  196608,  262144,  327680,  393216,  458752,  524288,  589824,  655360,  720896,  786432,  851968,  917504},
{  131072,  196608,  262144,  327680,  393216,  458752,  524288,  589824,  655360,  720896,  786432,  851968,  917504},
{  131072,  196608,  262144,  327680,  393216,  458752,  524288,  589824,  655360,  720896,  786432,  851968,  917504},
{  131072,  196608,  262144,  327680,  393216,  458752,  524288,  589824,  655360,  720896,  786432,  851968,  917504},
{  131072,  196608,  262144,  327680,  393216,  458752,  524288,  589824,  655360,  720896,  786432,  851968,  917504},
{  131072,  196608,  262144,  327680,  393216,  458752,  524288,  589824,  655360,  720896,  786432,  851968,  917504}
},
	.ycoords = {
{   98304,   98304,   98304,   98304,   98304,   98304,   98304,   98304,   98304,   98304,   98304,   98304,   98304},
{  163840,  163840,  163840,  163840,  163840,  163840,  163840,  163840,  163840,  163840,  163840,  163840,  163840},
{  229376,  229376,  229376,  229376,  229376,  229376,  229376,  229376,  229376,  229376,  229376,  229376,  229376},
{  294912,  294912,  294912,  294912,  294912,  294912,  294912,  294912,  294912,  294912,  294912,  294912,  294912},
{  360448,  360448,  360448,  360448,  360448,  360448,  360448,  360448,  360448,  360448,  360448,  360448,  360448},
{  425984,  425984,  425984,  425984,  425984,  425984,  425984,  425984,  425984,  425984,  425984,  425984,  425984},
{  491520,  491520,  491520,  491520,  491520,  491520,  491520,  491520,  491520,  491520,  491520,  491520,  491520},
{  557056,  557056,  557056,  557056,  557056,  557056,  557056,  557056,  557056,  557056,  557056,  557056,  557056},
{  622592,  622592,  622592,  622592,  622592,  622592,  622592,  622592,  622592,  622592,  622592,  622592,  622592},
{  688128,  688128,  688128,  688128,  688128,  688128,  688128,  688128,  688128,  688128,  688128,  688128,  688128}
}
};
#elif defined(DVS_6AXIS_COORDS_SMALL_WARPED)
static const struct sh_css_dvs_6axis_config default_dvs_6axis_config = {
	.xcoords = {
{  223864,  254656,  285447,  316239,  347031,  377823,  408615,  439407,  470199,  500990,  531782,  562574,  593366},
{  212656,  243448,  274240,  305032,  335824,  366616,  397408,  428199,  458991,  489783,  520575,  551367,  582159},
{  201449,  232241,  263033,  293825,  324617,  355408,  386200,  416992,  447784,  478576,  509368,  540159,  570951},
{  190242,  221034,  251825,  282617,  313409,  344201,  374993,  405785,  436577,  467368,  498160,  528952,  559744},
{  179034,  209826,  240618,  271410,  302202,  332994,  363786,  394577,  425369,  456161,  486953,  517745,  548537},
{  167827,  198619,  229411,  260203,  290995,  321786,  352578,  383370,  414162,  444954,  475746,  506538,  537329},
{  156620,  187412,  218204,  248995,  279787,  310579,  341371,  372163,  402955,  433747,  464538,  495330,  526122},
{  145413,  176204,  206996,  237788,  268580,  299372,  330164,  360956,  391747,  422539,  453331,  484123,  514915},
{  134205,  164997,  195789,  226581,  257373,  288165,  318956,  349748,  380540,  411332,  442124,  472916,  503707},
{  122998,  153790,  184582,  215374,  246165,  276957,  307749,  338541,  369333,  400125,  430916,  461708,  492500}
},
	.ycoords = {
{  343012,  354219,  365427,  376634,  387841,  399048,  410256,  421463,  432670,  443878,  455085,  466292,  477500},
{  373804,  385011,  396218,  407426,  418633,  429840,  441048,  452255,  463462,  474670,  485877,  497084,  508291},
{  404596,  415803,  427010,  438218,  449425,  460632,  471839,  483047,  494254,  505461,  516669,  527876,  539083},
{  435387,  446595,  457802,  469009,  480217,  491424,  502631,  513839,  525046,  536253,  547461,  558668,  569875},
{  466179,  477387,  488594,  499801,  511009,  522216,  533423,  544631,  555838,  567045,  578252,  589460,  600667},
{  496971,  508179,  519386,  530593,  541800,  553008,  564215,  575422,  586630,  597837,  609044,  620252,  631459},
{  527763,  538970,  550178,  561385,  572592,  583800,  595007,  606214,  617422,  628629,  639836,  651043,  662251},
{  558555,  569762,  580970,  592177,  603384,  614591,  625799,  637006,  648213,  659421,  670628,  681835,  693043},
{  589347,  600554,  611761,  622969,  634176,  645383,  656591,  667798,  679005,  690213,  701420,  712627,  723834},
{  620139,  631346,  642553,  653761,  664968,  676175,  687382,  698590,  709797,  721004,  732212,  743419,  754626}
}
};
#else
#error No default DVS coordinate table specified.
#endif




#if defined(HAS_VAMEM_VERSION_2)

static const struct sh_css_gamma_table default_gamma_table = {
{ 0,   4,   8,  12,  17,  21,  27,  32,
 38,  44,  49,  55,  61,  66,  71,  76,
 80,  84,  88,  92,  95,  98, 102, 105,
108, 110, 113, 116, 118, 121, 123, 126,
128, 130, 132, 135, 137, 139, 141, 143,
145, 146, 148, 150, 152, 153, 155, 156,
158, 160, 161, 162, 164, 165, 166, 168,
169, 170, 171, 172, 174, 175, 176, 177,
178, 179, 180, 181, 182, 183, 184, 184,
185, 186, 187, 188, 189, 189, 190, 191,
192, 192, 193, 194, 195, 195, 196, 197,
197, 198, 198, 199, 200, 200, 201, 201,
202, 203, 203, 204, 204, 205, 205, 206,
206, 207, 207, 208, 208, 209, 209, 210,
210, 210, 211, 211, 212, 212, 213, 213,
214, 214, 214, 215, 215, 216, 216, 216,
217, 217, 218, 218, 218, 219, 219, 220,
220, 220, 221, 221, 222, 222, 222, 223,
223, 223, 224, 224, 225, 225, 225, 226,
226, 226, 227, 227, 227, 228, 228, 228,
229, 229, 229, 230, 230, 230, 231, 231,
231, 232, 232, 232, 233, 233, 233, 234,
234, 234, 234, 235, 235, 235, 236, 236,
236, 237, 237, 237, 237, 238, 238, 238,
239, 239, 239, 239, 240, 240, 240, 241,
241, 241, 241, 242, 242, 242, 242, 243,
243, 243, 243, 244, 244, 244, 245, 245,
245, 245, 246, 246, 246, 246, 247, 247,
247, 247, 248, 248, 248, 248, 249, 249,
249, 249, 250, 250, 250, 250, 251, 251,
251, 251, 252, 252, 252, 252, 253, 253,
253, 253, 254, 254, 254, 254, 255, 255,
255 }
};

static const struct sh_css_ctc_table default_ctc_table = {
 { 0,  384,  837,  957, 1011, 1062, 1083, 1080,
1078, 1077, 1053, 1039, 1012,  992,  969,  951,
 929,  906,  886,  866,  845,  823,  809,  790,
 772,  758,  741,  726,  711,  701,  688,  675,
 666,  656,  648,  639,  633,  626,  618,  612,
 603,  594,  582,  572,  557,  545,  529,  516,
 504,  491,  480,  467,  459,  447,  438,  429,
 419,  412,  404,  397,  389,  382,  376,  368,
 363,  357,  351,  345,  340,  336,  330,  326,
 321,  318,  312,  308,  304,  300,  297,  294,
 291,  286,  284,  281,  278,  275,  271,  268,
 261,  257,  251,  245,  240,  235,  232,  225,
 223,  218,  213,  209,  206,  204,  199,  197,
 193,  189,  186,  185,  183,  179,  177,  175,
 172,  170,  169,  167,  164,  164,  162,  160,
 158,  157,  156,  154,  154,  152,  151,  150,
 149,  148,  146,  147,  146,  144,  143,  143,
 142,  141,  140,  141,  139,  138,  138,  138,
 137,  136,  136,  135,  134,  134,  134,  133,
 132,  132,  131,  130,  131,  130,  129,  128,
 129,  127,  127,  127,  127,  125,  125,  125,
 123,  123,  122,  120,  118,  115,  114,  111,
 110,  108,  106,  105,  103,  102,  100,   99,
  97,   97,   96,   95,   94,   93,   93,   91,
  91,   91,   90,   90,   89,   89,   88,   88,
  89,   88,   88,   87,   87,   87,   87,   86,
  87,   87,   86,   87,   86,   86,   84,   84,
  82,   80,   78,   76,   74,   72,   70,   68,
  67,   65,   62,   60,   58,   56,   55,   54,
  53,   51,   49,   49,   47,   45,   45,   45,
  41,   40,   39,   39,   34,   33,   34,   32,
  25,   23,   24,   20,   13,    9,   12,    0,
   0 }
};

static const struct sh_css_rgb_gamma_table default_r_gamma_table = {
{  0,   72,  144,  216,  288,  360,  426,  486,
 541,  592,  641,  687,  730,  772,  812,  850,
 887,  923,  958,  991, 1024, 1055, 1086, 1117,
1146, 1175, 1203, 1230, 1257, 1284, 1310, 1335,
1360, 1385, 1409, 1433, 1457, 1480, 1502, 1525,
1547, 1569, 1590, 1612, 1632, 1653, 1674, 1694,
1714, 1734, 1753, 1772, 1792, 1811, 1829, 1848,
1866, 1884, 1902, 1920, 1938, 1955, 1973, 1990,
2007, 2024, 2040, 2057, 2074, 2090, 2106, 2122,
2138, 2154, 2170, 2185, 2201, 2216, 2231, 2247,
2262, 2277, 2291, 2306, 2321, 2335, 2350, 2364,
2378, 2393, 2407, 2421, 2435, 2449, 2462, 2476,
2490, 2503, 2517, 2530, 2543, 2557, 2570, 2583,
2596, 2609, 2622, 2634, 2647, 2660, 2673, 2685,
2698, 2710, 2722, 2735, 2747, 2759, 2771, 2783,
2795, 2807, 2819, 2831, 2843, 2855, 2867, 2878,
2890, 2901, 2913, 2924, 2936, 2947, 2958, 2970,
2981, 2992, 3003, 3014, 3025, 3036, 3047, 3058,
3069, 3080, 3091, 3102, 3112, 3123, 3134, 3144,
3155, 3165, 3176, 3186, 3197, 3207, 3217, 3228,
3238, 3248, 3258, 3268, 3279, 3289, 3299, 3309,
3319, 3329, 3339, 3349, 3358, 3368, 3378, 3388,
3398, 3407, 3417, 3427, 3436, 3446, 3455, 3465,
3474, 3484, 3493, 3503, 3512, 3521, 3531, 3540,
3549, 3559, 3568, 3577, 3586, 3595, 3605, 3614,
3623, 3632, 3641, 3650, 3659, 3668, 3677, 3686,
3694, 3703, 3712, 3721, 3730, 3739, 3747, 3756,
3765, 3773, 3782, 3791, 3799, 3808, 3816, 3825,
3833, 3842, 3850, 3859, 3867, 3876, 3884, 3893,
3901, 3909, 3918, 3926, 3934, 3942, 3951, 3959,
3967, 3975, 3984, 3992, 4000, 4008, 4016, 4024,
4032, 4040, 4048, 4056, 4064, 4072, 4080, 4088,
4095 }
};

static const struct sh_css_rgb_gamma_table default_g_gamma_table = {
{  0,   72,  144,  216,  288,  360,  426,  486,
 541,  592,  641,  687,  730,  772,  812,  850,
 887,  923,  958,  991, 1024, 1055, 1086, 1117,
1146, 1175, 1203, 1230, 1257, 1284, 1310, 1335,
1360, 1385, 1409, 1433, 1457, 1480, 1502, 1525,
1547, 1569, 1590, 1612, 1632, 1653, 1674, 1694,
1714, 1734, 1753, 1772, 1792, 1811, 1829, 1848,
1866, 1884, 1902, 1920, 1938, 1955, 1973, 1990,
2007, 2024, 2040, 2057, 2074, 2090, 2106, 2122,
2138, 2154, 2170, 2185, 2201, 2216, 2231, 2247,
2262, 2277, 2291, 2306, 2321, 2335, 2350, 2364,
2378, 2393, 2407, 2421, 2435, 2449, 2462, 2476,
2490, 2503, 2517, 2530, 2543, 2557, 2570, 2583,
2596, 2609, 2622, 2634, 2647, 2660, 2673, 2685,
2698, 2710, 2722, 2735, 2747, 2759, 2771, 2783,
2795, 2807, 2819, 2831, 2843, 2855, 2867, 2878,
2890, 2901, 2913, 2924, 2936, 2947, 2958, 2970,
2981, 2992, 3003, 3014, 3025, 3036, 3047, 3058,
3069, 3080, 3091, 3102, 3112, 3123, 3134, 3144,
3155, 3165, 3176, 3186, 3197, 3207, 3217, 3228,
3238, 3248, 3258, 3268, 3279, 3289, 3299, 3309,
3319, 3329, 3339, 3349, 3358, 3368, 3378, 3388,
3398, 3407, 3417, 3427, 3436, 3446, 3455, 3465,
3474, 3484, 3493, 3503, 3512, 3521, 3531, 3540,
3549, 3559, 3568, 3577, 3586, 3595, 3605, 3614,
3623, 3632, 3641, 3650, 3659, 3668, 3677, 3686,
3694, 3703, 3712, 3721, 3730, 3739, 3747, 3756,
3765, 3773, 3782, 3791, 3799, 3808, 3816, 3825,
3833, 3842, 3850, 3859, 3867, 3876, 3884, 3893,
3901, 3909, 3918, 3926, 3934, 3942, 3951, 3959,
3967, 3975, 3984, 3992, 4000, 4008, 4016, 4024,
4032, 4040, 4048, 4056, 4064, 4072, 4080, 4088,
4095 }
};

static const struct sh_css_rgb_gamma_table default_b_gamma_table = {
{  0,   72,  144,  216,  288,  360,  426,  486,
 541,  592,  641,  687,  730,  772,  812,  850,
 887,  923,  958,  991, 1024, 1055, 1086, 1117,
1146, 1175, 1203, 1230, 1257, 1284, 1310, 1335,
1360, 1385, 1409, 1433, 1457, 1480, 1502, 1525,
1547, 1569, 1590, 1612, 1632, 1653, 1674, 1694,
1714, 1734, 1753, 1772, 1792, 1811, 1829, 1848,
1866, 1884, 1902, 1920, 1938, 1955, 1973, 1990,
2007, 2024, 2040, 2057, 2074, 2090, 2106, 2122,
2138, 2154, 2170, 2185, 2201, 2216, 2231, 2247,
2262, 2277, 2291, 2306, 2321, 2335, 2350, 2364,
2378, 2393, 2407, 2421, 2435, 2449, 2462, 2476,
2490, 2503, 2517, 2530, 2543, 2557, 2570, 2583,
2596, 2609, 2622, 2634, 2647, 2660, 2673, 2685,
2698, 2710, 2722, 2735, 2747, 2759, 2771, 2783,
2795, 2807, 2819, 2831, 2843, 2855, 2867, 2878,
2890, 2901, 2913, 2924, 2936, 2947, 2958, 2970,
2981, 2992, 3003, 3014, 3025, 3036, 3047, 3058,
3069, 3080, 3091, 3102, 3112, 3123, 3134, 3144,
3155, 3165, 3176, 3186, 3197, 3207, 3217, 3228,
3238, 3248, 3258, 3268, 3279, 3289, 3299, 3309,
3319, 3329, 3339, 3349, 3358, 3368, 3378, 3388,
3398, 3407, 3417, 3427, 3436, 3446, 3455, 3465,
3474, 3484, 3493, 3503, 3512, 3521, 3531, 3540,
3549, 3559, 3568, 3577, 3586, 3595, 3605, 3614,
3623, 3632, 3641, 3650, 3659, 3668, 3677, 3686,
3694, 3703, 3712, 3721, 3730, 3739, 3747, 3756,
3765, 3773, 3782, 3791, 3799, 3808, 3816, 3825,
3833, 3842, 3850, 3859, 3867, 3876, 3884, 3893,
3901, 3909, 3918, 3926, 3934, 3942, 3951, 3959,
3967, 3975, 3984, 3992, 4000, 4008, 4016, 4024,
4032, 4040, 4048, 4056, 4064, 4072, 4080, 4088,
4095 }
};

static const struct sh_css_xnr_table default_xnr_table = {
  /* 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 */
  { 8191>>1, 4096>>1, 2730>>1, 2048>>1, 1638>>1, 1365>>1, 1170>>1, 1024>>1, 910>>1, 819>>1, 744>>1, 682>>1, 630>>1, 585>>1,
    546>>1, 512>>1,

  /* 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 */
  481>>1, 455>>1, 431>>1, 409>>1, 390>>1, 372>>1, 356>>1, 341>>1, 327>>1, 315>>1, 303>>1, 292>>1, 282>>1, 273>>1, 264>>1,
    256>>1,

  /* 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 */
  248>>1, 240>>1, 234>>1, 227>>1, 221>>1, 215>>1, 210>>1, 204>>1, 199>>1, 195>>1, 190>>1, 186>>1, 182>>1, 178>>1, 174>>1,
    170>>1,

  /* 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 */
  167>>1, 163>>1, 160>>1, 157>>1, 154>>1, 151>>1, 148>>1, 146>>1, 143>>1, 141>>1, 138>>1, 136>>1, 134>>1, 132>>1, 130>>1, 128>>1 }
  };

const struct sh_css_gamma_table *default_gamma_table_ptr = &default_gamma_table;
const struct sh_css_ctc_table *default_ctc_table_ptr = &default_ctc_table;
const struct sh_css_xnr_table *default_xnr_table_ptr = &default_xnr_table;

#elif defined(HAS_VAMEM_VERSION_1)

/* Default Parameters */
static const struct sh_css_gamma_table default_gamma_table = {
		{ 0, 1, 2, 3, 4, 5, 6, 7,
		8, 9, 10, 11, 12, 13, 14, 16,
		17, 18, 19, 20, 21, 23, 24, 25,
		27, 28, 29, 31, 32, 33, 35, 36,
		38, 39, 41, 42, 44, 45, 47, 48,
		49, 51, 52, 54, 55, 57, 58, 60,
		61, 62, 64, 65, 66, 68, 69, 70,
		71, 72, 74, 75, 76, 77, 78, 79,
		80, 81, 82, 83, 84, 85, 86, 87,
		88, 89, 90, 91, 92, 93, 93, 94,
		95, 96, 97, 98, 98, 99, 100, 101,
		102, 102, 103, 104, 105, 105, 106, 107,
		108, 108, 109, 110, 110, 111, 112, 112,
		113, 114, 114, 115, 116, 116, 117, 118,
		118, 119, 120, 120, 121, 121, 122, 123,
		123, 124, 125, 125, 126, 126, 127, 127,	/* 128 */
		128, 129, 129, 130, 130, 131, 131, 132,
		132, 133, 134, 134, 135, 135, 136, 136,
		137, 137, 138, 138, 139, 139, 140, 140,
		141, 141, 142, 142, 143, 143, 144, 144,
		145, 145, 145, 146, 146, 147, 147, 148,
		148, 149, 149, 150, 150, 150, 151, 151,
		152, 152, 152, 153, 153, 154, 154, 155,
		155, 155, 156, 156, 156, 157, 157, 158,
		158, 158, 159, 159, 160, 160, 160, 161,
		161, 161, 162, 162, 162, 163, 163, 163,
		164, 164, 164, 165, 165, 165, 166, 166,
		166, 167, 167, 167, 168, 168, 168, 169,
		169, 169, 170, 170, 170, 170, 171, 171,
		171, 172, 172, 172, 172, 173, 173, 173,
		174, 174, 174, 174, 175, 175, 175, 176,
		176, 176, 176, 177, 177, 177, 177, 178,	/* 256 */
		178, 178, 178, 179, 179, 179, 179, 180,
		180, 180, 180, 181, 181, 181, 181, 182,
		182, 182, 182, 182, 183, 183, 183, 183,
		184, 184, 184, 184, 184, 185, 185, 185,
		185, 186, 186, 186, 186, 186, 187, 187,
		187, 187, 187, 188, 188, 188, 188, 188,
		189, 189, 189, 189, 189, 190, 190, 190,
		190, 190, 191, 191, 191, 191, 191, 192,
		192, 192, 192, 192, 192, 193, 193, 193,
		193, 193, 194, 194, 194, 194, 194, 194,
		195, 195, 195, 195, 195, 195, 196, 196,
		196, 196, 196, 196, 197, 197, 197, 197,
		197, 197, 198, 198, 198, 198, 198, 198,
		198, 199, 199, 199, 199, 199, 199, 200,
		200, 200, 200, 200, 200, 200, 201, 201,
		201, 201, 201, 201, 201, 202, 202, 202,	/* 384 */
		202, 202, 202, 202, 203, 203, 203, 203,
		203, 203, 203, 204, 204, 204, 204, 204,
		204, 204, 204, 205, 205, 205, 205, 205,
		205, 205, 205, 206, 206, 206, 206, 206,
		206, 206, 206, 207, 207, 207, 207, 207,
		207, 207, 207, 208, 208, 208, 208, 208,
		208, 208, 208, 209, 209, 209, 209, 209,
		209, 209, 209, 209, 210, 210, 210, 210,
		210, 210, 210, 210, 210, 211, 211, 211,
		211, 211, 211, 211, 211, 211, 212, 212,
		212, 212, 212, 212, 212, 212, 212, 213,
		213, 213, 213, 213, 213, 213, 213, 213,
		214, 214, 214, 214, 214, 214, 214, 214,
		214, 214, 215, 215, 215, 215, 215, 215,
		215, 215, 215, 216, 216, 216, 216, 216,
		216, 216, 216, 216, 216, 217, 217, 217,	/* 512 */
		217, 217, 217, 217, 217, 217, 217, 218,
		218, 218, 218, 218, 218, 218, 218, 218,
		218, 219, 219, 219, 219, 219, 219, 219,
		219, 219, 219, 220, 220, 220, 220, 220,
		220, 220, 220, 220, 220, 221, 221, 221,
		221, 221, 221, 221, 221, 221, 221, 221,
		222, 222, 222, 222, 222, 222, 222, 222,
		222, 222, 223, 223, 223, 223, 223, 223,
		223, 223, 223, 223, 223, 224, 224, 224,
		224, 224, 224, 224, 224, 224, 224, 224,
		225, 225, 225, 225, 225, 225, 225, 225,
		225, 225, 225, 226, 226, 226, 226, 226,
		226, 226, 226, 226, 226, 226, 226, 227,
		227, 227, 227, 227, 227, 227, 227, 227,
		227, 227, 228, 228, 228, 228, 228, 228,
		228, 228, 228, 228, 228, 228, 229, 229,
		229, 229, 229, 229, 229, 229, 229, 229,
		229, 229, 230, 230, 230, 230, 230, 230,
		230, 230, 230, 230, 230, 230, 231, 231,
		231, 231, 231, 231, 231, 231, 231, 231,
		231, 231, 231, 232, 232, 232, 232, 232,
		232, 232, 232, 232, 232, 232, 232, 233,
		233, 233, 233, 233, 233, 233, 233, 233,
		233, 233, 233, 233, 234, 234, 234, 234,
		234, 234, 234, 234, 234, 234, 234, 234,
		234, 235, 235, 235, 235, 235, 235, 235,
		235, 235, 235, 235, 235, 235, 236, 236,
		236, 236, 236, 236, 236, 236, 236, 236,
		236, 236, 236, 236, 237, 237, 237, 237,
		237, 237, 237, 237, 237, 237, 237, 237,
		237, 237, 238, 238, 238, 238, 238, 238,
		238, 238, 238, 238, 238, 238, 238, 238,
		239, 239, 239, 239, 239, 239, 239, 239,
		239, 239, 239, 239, 239, 239, 240, 240,
		240, 240, 240, 240, 240, 240, 240, 240,
		240, 240, 240, 240, 241, 241, 241, 241,
		241, 241, 241, 241, 241, 241, 241, 241,
		241, 241, 241, 242, 242, 242, 242, 242,
		242, 242, 242, 242, 242, 242, 242, 242,
		242, 242, 243, 243, 243, 243, 243, 243,
		243, 243, 243, 243, 243, 243, 243, 243,
		243, 244, 244, 244, 244, 244, 244, 244,
		244, 244, 244, 244, 244, 244, 244, 244,
		245, 245, 245, 245, 245, 245, 245, 245,
		245, 245, 245, 245, 245, 245, 245, 246,
		246, 246, 246, 246, 246, 246, 246, 246,
		246, 246, 246, 246, 246, 246, 246, 247,
		247, 247, 247, 247, 247, 247, 247, 247,
		247, 247, 247, 247, 247, 247, 247, 248,
		248, 248, 248, 248, 248, 248, 248, 248,
		248, 248, 248, 248, 248, 248, 248, 249,
		249, 249, 249, 249, 249, 249, 249, 249,
		249, 249, 249, 249, 249, 249, 249, 250,
		250, 250, 250, 250, 250, 250, 250, 250,
		250, 250, 250, 250, 250, 250, 250, 251,
		251, 251, 251, 251, 251, 251, 251, 251,
		251, 251, 251, 251, 251, 251, 251, 252,
		252, 252, 252, 252, 252, 252, 252, 252,
		252, 252, 252, 252, 252, 252, 252, 253,
		253, 253, 253, 253, 253, 253, 253, 253,
		253, 253, 253, 253, 253, 253, 253, 253,
		254, 254, 254, 254, 254, 254, 254, 254,
		254, 254, 254, 254, 254, 254, 254, 254,
		255, 255, 255, 255, 255, 255, 255, 255 }
};

static const struct sh_css_ctc_table default_ctc_table = {
		{ 0, 0, 256, 384, 384, 497, 765, 806,
		837, 851, 888, 901, 957, 981, 993, 1001,
		1011, 1029, 1028, 1039, 1062, 1059, 1073, 1080,
		1083, 1085, 1085, 1098, 1080, 1084, 1085, 1093,
		1078, 1073, 1070, 1069, 1077, 1066, 1072, 1063,
		1053, 1044, 1046, 1053, 1039, 1028, 1025, 1024,
		1012, 1013, 1016, 996, 992, 990, 990, 980,
		969, 968, 961, 955, 951, 949, 933, 930,
		929, 925, 921, 916, 906, 901, 895, 893,
		886, 877, 872, 869, 866, 861, 857, 849,
		845, 838, 836, 832, 823, 821, 815, 813,
		809, 805, 796, 793, 790, 785, 784, 778,
		772, 768, 766, 763, 758, 752, 749, 745,
		741, 740, 736, 730, 726, 724, 723, 718,
		711, 709, 706, 704, 701, 698, 691, 689,
		688, 683, 683, 678, 675, 673, 671, 669,
		666, 663, 661, 660, 656, 656, 653, 650,
		648, 647, 646, 643, 639, 638, 637, 635,
		633, 632, 629, 627, 626, 625, 622, 621,
		618, 618, 614, 614, 612, 609, 606, 606,
		603, 600, 600, 597, 594, 591, 590, 586,
		582, 581, 578, 575, 572, 569, 563, 560,
		557, 554, 551, 548, 545, 539, 536, 533,
		529, 527, 524, 519, 516, 513, 510, 507,
		504, 501, 498, 493, 491, 488, 485, 484,
		480, 476, 474, 471, 467, 466, 464, 460,
		459, 455, 453, 449, 447, 446, 443, 441,
		438, 435, 432, 432, 429, 427, 426, 422,
		419, 418, 416, 414, 412, 410, 408, 406,
		404, 402, 401, 398, 397, 395, 393, 390,
		389, 388, 387, 384, 382, 380, 378, 377,
		376, 375, 372, 370, 368, 368, 366, 364,
		363, 361, 360, 358, 357, 355, 354, 352,
		351, 350, 349, 346, 345, 344, 344, 342,
		340, 339, 337, 337, 336, 335, 333, 331,
		330, 329, 328, 326, 326, 324, 324, 322,
		321, 320, 318, 318, 318, 317, 315, 313,
		312, 311, 311, 310, 308, 307, 306, 306,
		304, 304, 302, 301, 300, 300, 299, 297,
		297, 296, 296, 294, 294, 292, 291, 291,
		291, 290, 288, 287, 286, 286, 287, 285,
		284, 283, 282, 282, 281, 281, 279, 278,
		278, 278, 276, 276, 275, 274, 274, 273,
		271, 270, 269, 268, 268, 267, 265, 262,
		261, 260, 260, 259, 257, 254, 252, 252,
		251, 251, 249, 246, 245, 244, 243, 242,
		240, 239, 239, 237, 235, 235, 233, 231,
		232, 230, 229, 226, 225, 224, 225, 224,
		223, 220, 219, 219, 218, 217, 217, 214,
		213, 213, 212, 211, 209, 209, 209, 208,
		206, 205, 204, 203, 204, 203, 201, 200,
		199, 197, 198, 198, 197, 195, 194, 194,
		193, 192, 192, 191, 189, 190, 189, 188,
		186, 187, 186, 185, 185, 184, 183, 181,
		183, 182, 181, 180, 179, 178, 178, 178,
		177, 176, 175, 176, 175, 174, 174, 173,
		172, 173, 172, 171, 170, 170, 169, 169,
		169, 168, 167, 166, 167, 167, 166, 165,
		164, 164, 164, 163, 164, 163, 162, 163,
		162, 161, 160, 161, 160, 160, 160, 159,
		158, 157, 158, 158, 157, 157, 156, 156,
		156, 156, 155, 155, 154, 154, 154, 154,
		154, 153, 152, 153, 152, 152, 151, 152,
		151, 152, 151, 150, 150, 149, 149, 150,
		149, 149, 148, 148, 148, 149, 148, 147,
		146, 146, 147, 146, 147, 146, 145, 146,
		146, 145, 144, 145, 144, 145, 144, 144,
		143, 143, 143, 144, 143, 142, 142, 142,
		142, 142, 142, 141, 141, 141, 141, 140,
		140, 141, 140, 140, 141, 140, 139, 139,
		139, 140, 139, 139, 138, 138, 137, 139,
		138, 138, 138, 137, 138, 137, 137, 137,
		137, 136, 137, 136, 136, 136, 136, 135,
		136, 135, 135, 135, 135, 136, 135, 135,
		134, 134, 133, 135, 134, 134, 134, 133,
		134, 133, 134, 133, 133, 132, 133, 133,
		132, 133, 132, 132, 132, 132, 131, 131,
		131, 132, 131, 131, 130, 131, 130, 132,
		131, 130, 130, 129, 130, 129, 130, 129,
		129, 129, 130, 129, 128, 128, 128, 128,
		129, 128, 128, 127, 127, 128, 128, 127,
		127, 126, 126, 127, 127, 126, 126, 126,
		127, 126, 126, 126, 125, 125, 126, 125,
		125, 124, 124, 124, 125, 125, 124, 124,
		123, 124, 124, 123, 123, 122, 122, 122,
		122, 122, 121, 120, 120, 119, 118, 118,
		118, 117, 117, 116, 115, 115, 115, 114,
		114, 113, 113, 112, 111, 111, 111, 110,
		110, 109, 109, 108, 108, 108, 107, 107,
		106, 106, 105, 105, 105, 104, 104, 103,
		103, 102, 102, 102, 102, 101, 101, 100,
		100, 99, 99, 99, 99, 99, 99, 98,
		97, 98, 97, 97, 97, 96, 96, 95,
		96, 95, 96, 95, 95, 94, 94, 95,
		94, 94, 94, 93, 93, 92, 93, 93,
		93, 93, 92, 92, 91, 92, 92, 92,
		91, 91, 90, 90, 91, 91, 91, 90,
		90, 90, 90, 91, 90, 90, 90, 89,
		89, 89, 90, 89, 89, 89, 89, 89,
		88, 89, 89, 88, 88, 88, 88, 87,
		89, 88, 88, 88, 88, 88, 87, 88,
		88, 88, 87, 87, 87, 87, 87, 88,
		87, 87, 87, 87, 87, 87, 88, 87,
		87, 87, 87, 86, 86, 87, 87, 87,
		87, 86, 86, 86, 87, 87, 86, 87,
		86, 86, 86, 87, 87, 86, 86, 86,
		86, 86, 87, 87, 86, 85, 85, 85,
		84, 85, 85, 84, 84, 83, 83, 82,
		82, 82, 81, 81, 80, 79, 79, 79,
		78, 77, 77, 76, 76, 76, 75, 74,
		74, 74, 73, 73, 72, 71, 71, 71,
		70, 70, 69, 69, 68, 68, 67, 67,
		67, 66, 66, 65, 65, 64, 64, 63,
		62, 62, 62, 61, 60, 60, 59, 59,
		58, 58, 57, 57, 56, 56, 56, 55,
		55, 54, 55, 55, 54, 53, 53, 52,
		53, 53, 52, 51, 51, 50, 51, 50,
		49, 49, 50, 49, 49, 48, 48, 47,
		47, 48, 46, 45, 45, 45, 46, 45,
		45, 44, 45, 45, 45, 43, 42, 42,
		41, 43, 41, 40, 40, 39, 40, 41,
		39, 39, 39, 39, 39, 38, 35, 35,
		34, 37, 36, 34, 33, 33, 33, 35,
		34, 32, 32, 31, 32, 30, 29, 26,
		25, 25, 27, 26, 23, 23, 23, 25,
		24, 24, 22, 21, 20, 19, 16, 14,
		13, 13, 13, 10, 9, 7, 7, 7,
		12, 12, 12, 7, 0, 0, 0, 0 }
};

static const struct sh_css_rgb_gamma_table default_r_gamma_table = {
{  0,   72,  144,  216,  288,  360,  426,  486,
 541,  592,  641,  687,  730,  772,  812,  850,
 887,  923,  958,  991, 1024, 1055, 1086, 1117,
1146, 1175, 1203, 1230, 1257, 1284, 1310, 1335,
1360, 1385, 1409, 1433, 1457, 1480, 1502, 1525,
1547, 1569, 1590, 1612, 1632, 1653, 1674, 1694,
1714, 1734, 1753, 1772, 1792, 1811, 1829, 1848,
1866, 1884, 1902, 1920, 1938, 1955, 1973, 1990,
2007, 2024, 2040, 2057, 2074, 2090, 2106, 2122,
2138, 2154, 2170, 2185, 2201, 2216, 2231, 2247,
2262, 2277, 2291, 2306, 2321, 2335, 2350, 2364,
2378, 2393, 2407, 2421, 2435, 2449, 2462, 2476,
2490, 2503, 2517, 2530, 2543, 2557, 2570, 2583,
2596, 2609, 2622, 2634, 2647, 2660, 2673, 2685,
2698, 2710, 2722, 2735, 2747, 2759, 2771, 2783,
2795, 2807, 2819, 2831, 2843, 2855, 2867, 2878,
2890, 2901, 2913, 2924, 2936, 2947, 2958, 2970,
2981, 2992, 3003, 3014, 3025, 3036, 3047, 3058,
3069, 3080, 3091, 3102, 3112, 3123, 3134, 3144,
3155, 3165, 3176, 3186, 3197, 3207, 3217, 3228,
3238, 3248, 3258, 3268, 3279, 3289, 3299, 3309,
3319, 3329, 3339, 3349, 3358, 3368, 3378, 3388,
3398, 3407, 3417, 3427, 3436, 3446, 3455, 3465,
3474, 3484, 3493, 3503, 3512, 3521, 3531, 3540,
3549, 3559, 3568, 3577, 3586, 3595, 3605, 3614,
3623, 3632, 3641, 3650, 3659, 3668, 3677, 3686,
3694, 3703, 3712, 3721, 3730, 3739, 3747, 3756,
3765, 3773, 3782, 3791, 3799, 3808, 3816, 3825,
3833, 3842, 3850, 3859, 3867, 3876, 3884, 3893,
3901, 3909, 3918, 3926, 3934, 3942, 3951, 3959,
3967, 3975, 3984, 3992, 4000, 4008, 4016, 4024,
4032, 4040, 4048, 4056, 4064, 4072, 4080, 4088 }
};

static const struct sh_css_rgb_gamma_table default_g_gamma_table = {
{  0,   72,  144,  216,  288,  360,  426,  486,
 541,  592,  641,  687,  730,  772,  812,  850,
 887,  923,  958,  991, 1024, 1055, 1086, 1117,
1146, 1175, 1203, 1230, 1257, 1284, 1310, 1335,
1360, 1385, 1409, 1433, 1457, 1480, 1502, 1525,
1547, 1569, 1590, 1612, 1632, 1653, 1674, 1694,
1714, 1734, 1753, 1772, 1792, 1811, 1829, 1848,
1866, 1884, 1902, 1920, 1938, 1955, 1973, 1990,
2007, 2024, 2040, 2057, 2074, 2090, 2106, 2122,
2138, 2154, 2170, 2185, 2201, 2216, 2231, 2247,
2262, 2277, 2291, 2306, 2321, 2335, 2350, 2364,
2378, 2393, 2407, 2421, 2435, 2449, 2462, 2476,
2490, 2503, 2517, 2530, 2543, 2557, 2570, 2583,
2596, 2609, 2622, 2634, 2647, 2660, 2673, 2685,
2698, 2710, 2722, 2735, 2747, 2759, 2771, 2783,
2795, 2807, 2819, 2831, 2843, 2855, 2867, 2878,
2890, 2901, 2913, 2924, 2936, 2947, 2958, 2970,
2981, 2992, 3003, 3014, 3025, 3036, 3047, 3058,
3069, 3080, 3091, 3102, 3112, 3123, 3134, 3144,
3155, 3165, 3176, 3186, 3197, 3207, 3217, 3228,
3238, 3248, 3258, 3268, 3279, 3289, 3299, 3309,
3319, 3329, 3339, 3349, 3358, 3368, 3378, 3388,
3398, 3407, 3417, 3427, 3436, 3446, 3455, 3465,
3474, 3484, 3493, 3503, 3512, 3521, 3531, 3540,
3549, 3559, 3568, 3577, 3586, 3595, 3605, 3614,
3623, 3632, 3641, 3650, 3659, 3668, 3677, 3686,
3694, 3703, 3712, 3721, 3730, 3739, 3747, 3756,
3765, 3773, 3782, 3791, 3799, 3808, 3816, 3825,
3833, 3842, 3850, 3859, 3867, 3876, 3884, 3893,
3901, 3909, 3918, 3926, 3934, 3942, 3951, 3959,
3967, 3975, 3984, 3992, 4000, 4008, 4016, 4024,
4032, 4040, 4048, 4056, 4064, 4072, 4080, 4088 }
};

static const struct sh_css_rgb_gamma_table default_b_gamma_table = {
{  0,   72,  144,  216,  288,  360,  426,  486,
 541,  592,  641,  687,  730,  772,  812,  850,
 887,  923,  958,  991, 1024, 1055, 1086, 1117,
1146, 1175, 1203, 1230, 1257, 1284, 1310, 1335,
1360, 1385, 1409, 1433, 1457, 1480, 1502, 1525,
1547, 1569, 1590, 1612, 1632, 1653, 1674, 1694,
1714, 1734, 1753, 1772, 1792, 1811, 1829, 1848,
1866, 1884, 1902, 1920, 1938, 1955, 1973, 1990,
2007, 2024, 2040, 2057, 2074, 2090, 2106, 2122,
2138, 2154, 2170, 2185, 2201, 2216, 2231, 2247,
2262, 2277, 2291, 2306, 2321, 2335, 2350, 2364,
2378, 2393, 2407, 2421, 2435, 2449, 2462, 2476,
2490, 2503, 2517, 2530, 2543, 2557, 2570, 2583,
2596, 2609, 2622, 2634, 2647, 2660, 2673, 2685,
2698, 2710, 2722, 2735, 2747, 2759, 2771, 2783,
2795, 2807, 2819, 2831, 2843, 2855, 2867, 2878,
2890, 2901, 2913, 2924, 2936, 2947, 2958, 2970,
2981, 2992, 3003, 3014, 3025, 3036, 3047, 3058,
3069, 3080, 3091, 3102, 3112, 3123, 3134, 3144,
3155, 3165, 3176, 3186, 3197, 3207, 3217, 3228,
3238, 3248, 3258, 3268, 3279, 3289, 3299, 3309,
3319, 3329, 3339, 3349, 3358, 3368, 3378, 3388,
3398, 3407, 3417, 3427, 3436, 3446, 3455, 3465,
3474, 3484, 3493, 3503, 3512, 3521, 3531, 3540,
3549, 3559, 3568, 3577, 3586, 3595, 3605, 3614,
3623, 3632, 3641, 3650, 3659, 3668, 3677, 3686,
3694, 3703, 3712, 3721, 3730, 3739, 3747, 3756,
3765, 3773, 3782, 3791, 3799, 3808, 3816, 3825,
3833, 3842, 3850, 3859, 3867, 3876, 3884, 3893,
3901, 3909, 3918, 3926, 3934, 3942, 3951, 3959,
3967, 3975, 3984, 3992, 4000, 4008, 4016, 4024,
4032, 4040, 4048, 4056, 4064, 4072, 4080, 4088 }
};

static const struct sh_css_xnr_table default_xnr_table = {
  /* 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 */
  { 8191>>1, 4096>>1, 2730>>1, 2048>>1, 1638>>1, 1365>>1, 1170>>1, 1024>>1, 910>>1, 819>>1, 744>>1, 682>>1, 630>>1, 585>>1,
    546>>1, 512>>1,

  /* 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 */
  481>>1, 455>>1, 431>>1, 409>>1, 390>>1, 372>>1, 356>>1, 341>>1, 327>>1, 315>>1, 303>>1, 292>>1, 282>>1, 273>>1, 264>>1,
    256>>1,

  /* 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 */
  248>>1, 240>>1, 234>>1, 227>>1, 221>>1, 215>>1, 210>>1, 204>>1, 199>>1, 195>>1, 190>>1, 186>>1, 182>>1, 178>>1, 174>>1,
    170>>1,

  /* 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 */
  167>>1, 163>>1, 160>>1, 157>>1, 154>>1, 151>>1, 148>>1, 146>>1, 143>>1, 141>>1, 138>>1, 136>>1, 134>>1, 132>>1, 130>>1, 128>>1 }
};

#else
#error "sh_css_params.c: VAMEM version must \
	be one of {VAMEM_VERSION_1, VAMEM_VERSION_2}"
#endif

/* multiple axis color correction table,
 * 64values = 2x2matrix for 16area, [s2.11].
 */
static const struct sh_css_macc_table default_macc_table = {
		{ 8192, 0, 0, 8192, 8192, 0, 0, 8192,
		8192, 0, 0, 8192, 8192, 0, 0, 8192,
		8192, 0, 0, 8192, 8192, 0, 0, 8192,
		8192, 0, 0, 8192, 8192, 0, 0, 8192,
		8192, 0, 0, 8192, 8192, 0, 0, 8192,
		8192, 0, 0, 8192, 8192, 0, 0, 8192,
		8192, 0, 0, 8192, 8192, 0, 0, 8192,
		8192, 0, 0, 8192, 8192, 0, 0, 8192 }
};

/* Digital Zoom lookup table. See documentation for more details about the
 * contents of this table.
 */
#if defined(HAS_GDC_VERSION_2)
static const int zoom_table[4][HRT_GDC_N] = {
		 {0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,
		  0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,
		  0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,
		  0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,
		  0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,
		  0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,
		  0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,
		  0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,
		  0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,
		  0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,
		  0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,
		  0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,
		 -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,
		 -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,
		 -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,
		 -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,
		 -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,
		 -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,
		 -2<<4,  -2<<4,  -2<<4,  -2<<4,  -2<<4,  -2<<4,  -2<<4,  -2<<4,
		 -2<<4,  -2<<4,  -2<<4,  -2<<4,  -2<<4,  -2<<4,  -2<<4,  -2<<4,
		 -2<<4,  -2<<4,  -2<<4,  -2<<4,  -2<<4,  -2<<4,  -2<<4,  -2<<4,
		 -2<<4,  -2<<4,  -2<<4,  -2<<4,  -2<<4,  -2<<4,  -2<<4,  -2<<4,
		 -3<<4,  -3<<4,  -3<<4,  -3<<4,  -3<<4,  -3<<4,  -3<<4,  -3<<4,
		 -3<<4,  -3<<4,  -3<<4,  -3<<4,  -3<<4,  -3<<4,  -3<<4,  -3<<4,
		 -3<<4,  -3<<4,  -3<<4,  -3<<4,  -3<<4,  -3<<4,  -3<<4,  -3<<4,
		 -3<<4,  -3<<4,  -3<<4,  -3<<4,  -3<<4,  -3<<4,  -3<<4,  -3<<4,
		 -4<<4,  -4<<4,  -4<<4,  -4<<4,  -4<<4,  -4<<4,  -4<<4,  -4<<4,
		 -4<<4,  -4<<4,  -4<<4,  -4<<4,  -4<<4,  -4<<4,  -4<<4,  -4<<4,
		 -4<<4,  -4<<4,  -4<<4,  -4<<4,  -4<<4,  -4<<4,  -4<<4,  -4<<4,
		 -4<<4,  -4<<4,  -4<<4,  -4<<4,  -4<<4,  -4<<4,  -4<<4,  -4<<4,
		 -5<<4,  -5<<4,  -5<<4,  -5<<4,  -5<<4,  -5<<4,  -5<<4,  -5<<4,
		 -5<<4,  -5<<4,  -5<<4,  -5<<4,  -5<<4,  -5<<4,  -5<<4,  -5<<4,
		 -6<<4,  -6<<4,  -6<<4,  -6<<4,  -6<<4,  -6<<4,  -6<<4,  -6<<4,
		 -6<<4,  -6<<4,  -6<<4,  -6<<4,  -6<<4,  -6<<4,  -6<<4,  -6<<4,
		 -6<<4,  -6<<4,  -6<<4,  -6<<4,  -6<<4,  -6<<4,  -6<<4,  -6<<4,
		 -6<<4,  -6<<4,  -6<<4,  -6<<4,  -6<<4,  -6<<4,  -6<<4,  -6<<4,
		 -7<<4,  -7<<4,  -7<<4,  -7<<4,  -7<<4,  -7<<4,  -7<<4,  -7<<4,
		 -7<<4,  -7<<4,  -7<<4,  -7<<4,  -7<<4,  -7<<4,  -7<<4,  -7<<4,
		 -7<<4,  -7<<4,  -7<<4,  -7<<4,  -7<<4,  -7<<4,  -7<<4,  -7<<4,
		 -7<<4,  -7<<4,  -7<<4,  -7<<4,  -7<<4,  -7<<4,  -7<<4,  -7<<4,
		 -8<<4,  -8<<4,  -8<<4,  -8<<4,  -8<<4,  -8<<4,  -8<<4,  -8<<4,
		 -8<<4,  -8<<4,  -8<<4,  -8<<4,  -8<<4,  -8<<4,  -8<<4,  -8<<4,
		 -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,
		 -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,
		 -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,
		 -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,
		-10<<4, -10<<4, -10<<4, -10<<4, -10<<4, -10<<4, -10<<4, -10<<4,
		-10<<4, -10<<4, -10<<4, -10<<4, -10<<4, -10<<4, -10<<4, -10<<4,
		-11<<4, -11<<4, -11<<4, -11<<4, -11<<4, -11<<4, -11<<4, -11<<4,
		-11<<4, -11<<4, -11<<4, -11<<4, -11<<4, -11<<4, -11<<4, -11<<4,
		-11<<4, -11<<4, -11<<4, -11<<4, -11<<4, -11<<4, -11<<4, -11<<4,
		-11<<4, -11<<4, -11<<4, -11<<4, -11<<4, -11<<4, -11<<4, -11<<4,
		-12<<4, -12<<4, -12<<4, -12<<4, -12<<4, -12<<4, -12<<4, -12<<4,
		-12<<4, -12<<4, -12<<4, -12<<4, -12<<4, -12<<4, -12<<4, -12<<4,
		-13<<4, -13<<4, -13<<4, -13<<4, -13<<4, -13<<4, -13<<4, -13<<4,
		-13<<4, -13<<4, -13<<4, -13<<4, -13<<4, -13<<4, -13<<4, -13<<4,
		-13<<4, -13<<4, -13<<4, -13<<4, -13<<4, -13<<4, -13<<4, -13<<4,
		-13<<4, -13<<4, -13<<4, -13<<4, -13<<4, -13<<4, -13<<4, -13<<4,
		-14<<4, -14<<4, -14<<4, -14<<4, -14<<4, -14<<4, -14<<4, -14<<4,
		-14<<4, -14<<4, -14<<4, -14<<4, -14<<4, -14<<4, -14<<4, -14<<4,
		-14<<4, -14<<4, -14<<4, -14<<4, -14<<4, -14<<4, -14<<4, -14<<4,
		-14<<4, -14<<4, -14<<4, -14<<4, -14<<4, -14<<4, -14<<4, -14<<4,
		-15<<4, -15<<4, -15<<4, -15<<4, -15<<4, -15<<4, -15<<4, -15<<4,
		-15<<4, -15<<4, -15<<4, -15<<4, -15<<4, -15<<4, -15<<4, -15<<4,
		-16<<4, -16<<4, -16<<4, -16<<4, -16<<4, -16<<4, -16<<4, -16<<4,
		-16<<4, -16<<4, -16<<4, -16<<4, -16<<4, -16<<4, -16<<4, -16<<4,
		-16<<4, -16<<4, -16<<4, -16<<4, -16<<4, -16<<4, -16<<4, -16<<4,
		-16<<4, -16<<4, -16<<4, -16<<4, -16<<4, -16<<4, -16<<4, -16<<4,
		-16<<4, -16<<4, -16<<4, -16<<4, -16<<4, -16<<4, -16<<4, -16<<4,
		-16<<4, -16<<4, -16<<4, -16<<4, -16<<4, -16<<4, -16<<4, -16<<4,
		-17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4,
		-17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4,
		-17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4,
		-17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4,
		-18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4,
		-18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4,
		-18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4,
		-18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4,
		-18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4,
		-18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4,
		-18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4,
		-18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4,
		-18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4,
		-18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4,
		-18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4,
		-18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4,
		-18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4,
		-18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4,
		-18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4,
		-18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4,
		-18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4,
		-18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4,
		-18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4,
		-18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4,
		-18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4,
		-18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4,
		-18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4,
		-18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4,
		-17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4,
		-17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4,
		-17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4,
		-17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4,
		-16<<4, -16<<4, -16<<4, -16<<4, -16<<4, -16<<4, -16<<4, -16<<4,
		-16<<4, -16<<4, -16<<4, -16<<4, -16<<4, -16<<4, -16<<4, -16<<4,
		-15<<4, -15<<4, -15<<4, -15<<4, -15<<4, -15<<4, -15<<4, -15<<4,
		-15<<4, -15<<4, -15<<4, -15<<4, -15<<4, -15<<4, -15<<4, -15<<4,
		-15<<4, -15<<4, -15<<4, -15<<4, -15<<4, -15<<4, -15<<4, -15<<4,
		-15<<4, -15<<4, -15<<4, -15<<4, -15<<4, -15<<4, -15<<4, -15<<4,
		-14<<4, -14<<4, -14<<4, -14<<4, -14<<4, -14<<4, -14<<4, -14<<4,
		-14<<4, -14<<4, -14<<4, -14<<4, -14<<4, -14<<4, -14<<4, -14<<4,
		-13<<4, -13<<4, -13<<4, -13<<4, -13<<4, -13<<4, -13<<4, -13<<4,
		-13<<4, -13<<4, -13<<4, -13<<4, -13<<4, -13<<4, -13<<4, -13<<4,
		-12<<4, -12<<4, -12<<4, -12<<4, -12<<4, -12<<4, -12<<4, -12<<4,
		-12<<4, -12<<4, -12<<4, -12<<4, -12<<4, -12<<4, -12<<4, -12<<4,
		-11<<4, -11<<4, -11<<4, -11<<4, -11<<4, -11<<4, -11<<4, -11<<4,
		-11<<4, -11<<4, -11<<4, -11<<4, -11<<4, -11<<4, -11<<4, -11<<4,
		 -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,
		 -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,
		 -8<<4,  -8<<4,  -8<<4,  -8<<4,  -8<<4,  -8<<4,  -8<<4,  -8<<4,
		 -8<<4,  -8<<4,  -8<<4,  -8<<4,  -8<<4,  -8<<4,  -8<<4,  -8<<4,
		 -7<<4,  -7<<4,  -7<<4,  -7<<4,  -7<<4,  -7<<4,  -7<<4,  -7<<4,
		 -7<<4,  -7<<4,  -7<<4,  -7<<4,  -7<<4,  -7<<4,  -7<<4,  -7<<4,
		 -5<<4,  -5<<4,  -5<<4,  -5<<4,  -5<<4,  -5<<4,  -5<<4,  -5<<4,
		 -5<<4,  -5<<4,  -5<<4,  -5<<4,  -5<<4,  -5<<4,  -5<<4,  -5<<4,
		 -3<<4,  -3<<4,  -3<<4,  -3<<4,  -3<<4,  -3<<4,  -3<<4,  -3<<4,
		 -3<<4,  -3<<4,  -3<<4,  -3<<4,  -3<<4,  -3<<4,  -3<<4,  -3<<4,
		 -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,
		 -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4},
		 {0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,
		  0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,
		  2<<4,   2<<4,   2<<4,   2<<4,   2<<4,   2<<4,   2<<4,   2<<4,
		  2<<4,   2<<4,   2<<4,   2<<4,   2<<4,   2<<4,   2<<4,   2<<4,
		  4<<4,   4<<4,   4<<4,   4<<4,   4<<4,   4<<4,   4<<4,   4<<4,
		  4<<4,   4<<4,   4<<4,   4<<4,   4<<4,   4<<4,   4<<4,   4<<4,
		  7<<4,   7<<4,   7<<4,   7<<4,   7<<4,   7<<4,   7<<4,   7<<4,
		  7<<4,   7<<4,   7<<4,   7<<4,   7<<4,   7<<4,   7<<4,   7<<4,
		  9<<4,   9<<4,   9<<4,   9<<4,   9<<4,   9<<4,   9<<4,   9<<4,
		  9<<4,   9<<4,   9<<4,   9<<4,   9<<4,   9<<4,   9<<4,   9<<4,
		  12<<4,  12<<4,  12<<4,  12<<4,  12<<4,  12<<4,  12<<4,  12<<4,
		  12<<4,  12<<4,  12<<4,  12<<4,  12<<4,  12<<4,  12<<4,  12<<4,
		  16<<4,  16<<4,  16<<4,  16<<4,  16<<4,  16<<4,  16<<4,  16<<4,
		  16<<4,  16<<4,  16<<4,  16<<4,  16<<4,  16<<4,  16<<4,  16<<4,
		  19<<4,  19<<4,  19<<4,  19<<4,  19<<4,  19<<4,  19<<4,  19<<4,
		  19<<4,  19<<4,  19<<4,  19<<4,  19<<4,  19<<4,  19<<4,  19<<4,
		  23<<4,  23<<4,  23<<4,  23<<4,  23<<4,  23<<4,  23<<4,  23<<4,
		  23<<4,  23<<4,  23<<4,  23<<4,  23<<4,  23<<4,  23<<4,  23<<4,
		  27<<4,  27<<4,  27<<4,  27<<4,  27<<4,  27<<4,  27<<4,  27<<4,
		  27<<4,  27<<4,  27<<4,  27<<4,  27<<4,  27<<4,  27<<4,  27<<4,
		  31<<4,  31<<4,  31<<4,  31<<4,  31<<4,  31<<4,  31<<4,  31<<4,
		  31<<4,  31<<4,  31<<4,  31<<4,  31<<4,  31<<4,  31<<4,  31<<4,
		  35<<4,  35<<4,  35<<4,  35<<4,  35<<4,  35<<4,  35<<4,  35<<4,
		  35<<4,  35<<4,  35<<4,  35<<4,  35<<4,  35<<4,  35<<4,  35<<4,
		  39<<4,  39<<4,  39<<4,  39<<4,  39<<4,  39<<4,  39<<4,  39<<4,
		  39<<4,  39<<4,  39<<4,  39<<4,  39<<4,  39<<4,  39<<4,  39<<4,
		  43<<4,  43<<4,  43<<4,  43<<4,  43<<4,  43<<4,  43<<4,  43<<4,
		  43<<4,  43<<4,  43<<4,  43<<4,  43<<4,  43<<4,  43<<4,  43<<4,
		  48<<4,  48<<4,  48<<4,  48<<4,  48<<4,  48<<4,  48<<4,  48<<4,
		  48<<4,  48<<4,  48<<4,  48<<4,  48<<4,  48<<4,  48<<4,  48<<4,
		  53<<4,  53<<4,  53<<4,  53<<4,  53<<4,  53<<4,  53<<4,  53<<4,
		  53<<4,  53<<4,  53<<4,  53<<4,  53<<4,  53<<4,  53<<4,  53<<4,
		  58<<4,  58<<4,  58<<4,  58<<4,  58<<4,  58<<4,  58<<4,  58<<4,
		  58<<4,  58<<4,  58<<4,  58<<4,  58<<4,  58<<4,  58<<4,  58<<4,
		  62<<4,  62<<4,  62<<4,  62<<4,  62<<4,  62<<4,  62<<4,  62<<4,
		  62<<4,  62<<4,  62<<4,  62<<4,  62<<4,  62<<4,  62<<4,  62<<4,
		  67<<4,  67<<4,  67<<4,  67<<4,  67<<4,  67<<4,  67<<4,  67<<4,
		  67<<4,  67<<4,  67<<4,  67<<4,  67<<4,  67<<4,  67<<4,  67<<4,
		  73<<4,  73<<4,  73<<4,  73<<4,  73<<4,  73<<4,  73<<4,  73<<4,
		  73<<4,  73<<4,  73<<4,  73<<4,  73<<4,  73<<4,  73<<4,  73<<4,
		  78<<4,  78<<4,  78<<4,  78<<4,  78<<4,  78<<4,  78<<4,  78<<4,
		  78<<4,  78<<4,  78<<4,  78<<4,  78<<4,  78<<4,  78<<4,  78<<4,
		  83<<4,  83<<4,  83<<4,  83<<4,  83<<4,  83<<4,  83<<4,  83<<4,
		  83<<4,  83<<4,  83<<4,  83<<4,  83<<4,  83<<4,  83<<4,  83<<4,
		  88<<4,  88<<4,  88<<4,  88<<4,  88<<4,  88<<4,  88<<4,  88<<4,
		  88<<4,  88<<4,  88<<4,  88<<4,  88<<4,  88<<4,  88<<4,  88<<4,
		  94<<4,  94<<4,  94<<4,  94<<4,  94<<4,  94<<4,  94<<4,  94<<4,
		  94<<4,  94<<4,  94<<4,  94<<4,  94<<4,  94<<4,  94<<4,  94<<4,
		  99<<4,  99<<4,  99<<4,  99<<4,  99<<4,  99<<4,  99<<4,  99<<4,
		  99<<4,  99<<4,  99<<4,  99<<4,  99<<4,  99<<4,  99<<4,  99<<4,
		 105<<4, 105<<4, 105<<4, 105<<4, 105<<4, 105<<4, 105<<4, 105<<4,
		 105<<4, 105<<4, 105<<4, 105<<4, 105<<4, 105<<4, 105<<4, 105<<4,
		 110<<4, 110<<4, 110<<4, 110<<4, 110<<4, 110<<4, 110<<4, 110<<4,
		 110<<4, 110<<4, 110<<4, 110<<4, 110<<4, 110<<4, 110<<4, 110<<4,
		 116<<4, 116<<4, 116<<4, 116<<4, 116<<4, 116<<4, 116<<4, 116<<4,
		 116<<4, 116<<4, 116<<4, 116<<4, 116<<4, 116<<4, 116<<4, 116<<4,
		 121<<4, 121<<4, 121<<4, 121<<4, 121<<4, 121<<4, 121<<4, 121<<4,
		 121<<4, 121<<4, 121<<4, 121<<4, 121<<4, 121<<4, 121<<4, 121<<4,
		 127<<4, 127<<4, 127<<4, 127<<4, 127<<4, 127<<4, 127<<4, 127<<4,
		 127<<4, 127<<4, 127<<4, 127<<4, 127<<4, 127<<4, 127<<4, 127<<4,
		 132<<4, 132<<4, 132<<4, 132<<4, 132<<4, 132<<4, 132<<4, 132<<4,
		 132<<4, 132<<4, 132<<4, 132<<4, 132<<4, 132<<4, 132<<4, 132<<4,
		 138<<4, 138<<4, 138<<4, 138<<4, 138<<4, 138<<4, 138<<4, 138<<4,
		 138<<4, 138<<4, 138<<4, 138<<4, 138<<4, 138<<4, 138<<4, 138<<4,
		 144<<4, 144<<4, 144<<4, 144<<4, 144<<4, 144<<4, 144<<4, 144<<4,
		 144<<4, 144<<4, 144<<4, 144<<4, 144<<4, 144<<4, 144<<4, 144<<4,
		 149<<4, 149<<4, 149<<4, 149<<4, 149<<4, 149<<4, 149<<4, 149<<4,
		 149<<4, 149<<4, 149<<4, 149<<4, 149<<4, 149<<4, 149<<4, 149<<4,
		 154<<4, 154<<4, 154<<4, 154<<4, 154<<4, 154<<4, 154<<4, 154<<4,
		 154<<4, 154<<4, 154<<4, 154<<4, 154<<4, 154<<4, 154<<4, 154<<4,
		 160<<4, 160<<4, 160<<4, 160<<4, 160<<4, 160<<4, 160<<4, 160<<4,
		 160<<4, 160<<4, 160<<4, 160<<4, 160<<4, 160<<4, 160<<4, 160<<4,
		 165<<4, 165<<4, 165<<4, 165<<4, 165<<4, 165<<4, 165<<4, 165<<4,
		 165<<4, 165<<4, 165<<4, 165<<4, 165<<4, 165<<4, 165<<4, 165<<4,
		 170<<4, 170<<4, 170<<4, 170<<4, 170<<4, 170<<4, 170<<4, 170<<4,
		 170<<4, 170<<4, 170<<4, 170<<4, 170<<4, 170<<4, 170<<4, 170<<4,
		 176<<4, 176<<4, 176<<4, 176<<4, 176<<4, 176<<4, 176<<4, 176<<4,
		 176<<4, 176<<4, 176<<4, 176<<4, 176<<4, 176<<4, 176<<4, 176<<4,
		 181<<4, 181<<4, 181<<4, 181<<4, 181<<4, 181<<4, 181<<4, 181<<4,
		 181<<4, 181<<4, 181<<4, 181<<4, 181<<4, 181<<4, 181<<4, 181<<4,
		 186<<4, 186<<4, 186<<4, 186<<4, 186<<4, 186<<4, 186<<4, 186<<4,
		 186<<4, 186<<4, 186<<4, 186<<4, 186<<4, 186<<4, 186<<4, 186<<4,
		 191<<4, 191<<4, 191<<4, 191<<4, 191<<4, 191<<4, 191<<4, 191<<4,
		 191<<4, 191<<4, 191<<4, 191<<4, 191<<4, 191<<4, 191<<4, 191<<4,
		 195<<4, 195<<4, 195<<4, 195<<4, 195<<4, 195<<4, 195<<4, 195<<4,
		 195<<4, 195<<4, 195<<4, 195<<4, 195<<4, 195<<4, 195<<4, 195<<4,
		 200<<4, 200<<4, 200<<4, 200<<4, 200<<4, 200<<4, 200<<4, 200<<4,
		 200<<4, 200<<4, 200<<4, 200<<4, 200<<4, 200<<4, 200<<4, 200<<4,
		 205<<4, 205<<4, 205<<4, 205<<4, 205<<4, 205<<4, 205<<4, 205<<4,
		 205<<4, 205<<4, 205<<4, 205<<4, 205<<4, 205<<4, 205<<4, 205<<4,
		 209<<4, 209<<4, 209<<4, 209<<4, 209<<4, 209<<4, 209<<4, 209<<4,
		 209<<4, 209<<4, 209<<4, 209<<4, 209<<4, 209<<4, 209<<4, 209<<4,
		 213<<4, 213<<4, 213<<4, 213<<4, 213<<4, 213<<4, 213<<4, 213<<4,
		 213<<4, 213<<4, 213<<4, 213<<4, 213<<4, 213<<4, 213<<4, 213<<4,
		 218<<4, 218<<4, 218<<4, 218<<4, 218<<4, 218<<4, 218<<4, 218<<4,
		 218<<4, 218<<4, 218<<4, 218<<4, 218<<4, 218<<4, 218<<4, 218<<4,
		 222<<4, 222<<4, 222<<4, 222<<4, 222<<4, 222<<4, 222<<4, 222<<4,
		 222<<4, 222<<4, 222<<4, 222<<4, 222<<4, 222<<4, 222<<4, 222<<4,
		 225<<4, 225<<4, 225<<4, 225<<4, 225<<4, 225<<4, 225<<4, 225<<4,
		 225<<4, 225<<4, 225<<4, 225<<4, 225<<4, 225<<4, 225<<4, 225<<4,
		 229<<4, 229<<4, 229<<4, 229<<4, 229<<4, 229<<4, 229<<4, 229<<4,
		 229<<4, 229<<4, 229<<4, 229<<4, 229<<4, 229<<4, 229<<4, 229<<4,
		 232<<4, 232<<4, 232<<4, 232<<4, 232<<4, 232<<4, 232<<4, 232<<4,
		 232<<4, 232<<4, 232<<4, 232<<4, 232<<4, 232<<4, 232<<4, 232<<4,
		 236<<4, 236<<4, 236<<4, 236<<4, 236<<4, 236<<4, 236<<4, 236<<4,
		 236<<4, 236<<4, 236<<4, 236<<4, 236<<4, 236<<4, 236<<4, 236<<4,
		 239<<4, 239<<4, 239<<4, 239<<4, 239<<4, 239<<4, 239<<4, 239<<4,
		 239<<4, 239<<4, 239<<4, 239<<4, 239<<4, 239<<4, 239<<4, 239<<4,
		 241<<4, 241<<4, 241<<4, 241<<4, 241<<4, 241<<4, 241<<4, 241<<4,
		 241<<4, 241<<4, 241<<4, 241<<4, 241<<4, 241<<4, 241<<4, 241<<4,
		 244<<4, 244<<4, 244<<4, 244<<4, 244<<4, 244<<4, 244<<4, 244<<4,
		 244<<4, 244<<4, 244<<4, 244<<4, 244<<4, 244<<4, 244<<4, 244<<4,
		 246<<4, 246<<4, 246<<4, 246<<4, 246<<4, 246<<4, 246<<4, 246<<4,
		 246<<4, 246<<4, 246<<4, 246<<4, 246<<4, 246<<4, 246<<4, 246<<4,
		 248<<4, 248<<4, 248<<4, 248<<4, 248<<4, 248<<4, 248<<4, 248<<4,
		 248<<4, 248<<4, 248<<4, 248<<4, 248<<4, 248<<4, 248<<4, 248<<4,
		 250<<4, 250<<4, 250<<4, 250<<4, 250<<4, 250<<4, 250<<4, 250<<4,
		 250<<4, 250<<4, 250<<4, 250<<4, 250<<4, 250<<4, 250<<4, 250<<4,
		 252<<4, 252<<4, 252<<4, 252<<4, 252<<4, 252<<4, 252<<4, 252<<4,
		 252<<4, 252<<4, 252<<4, 252<<4, 252<<4, 252<<4, 252<<4, 252<<4,
		 253<<4, 253<<4, 253<<4, 253<<4, 253<<4, 253<<4, 253<<4, 253<<4,
		 253<<4, 253<<4, 253<<4, 253<<4, 253<<4, 253<<4, 253<<4, 253<<4,
		 254<<4, 254<<4, 254<<4, 254<<4, 254<<4, 254<<4, 254<<4, 254<<4,
		 254<<4, 254<<4, 254<<4, 254<<4, 254<<4, 254<<4, 254<<4, 254<<4,
		 255<<4, 255<<4, 255<<4, 255<<4, 255<<4, 255<<4, 255<<4, 255<<4,
		 255<<4, 255<<4, 255<<4, 255<<4, 255<<4, 255<<4, 255<<4, 255<<4,
		 255<<4, 255<<4, 255<<4, 255<<4, 255<<4, 255<<4, 255<<4, 255<<4,
		 255<<4, 255<<4, 255<<4, 255<<4, 255<<4, 255<<4, 255<<4, 255<<4},
		{256<<4, 256<<4, 256<<4, 256<<4, 256<<4, 256<<4, 256<<4, 256<<4,
		 256<<4, 256<<4, 256<<4, 256<<4, 256<<4, 256<<4, 256<<4, 256<<4,
		 255<<4, 255<<4, 255<<4, 255<<4, 255<<4, 255<<4, 255<<4, 255<<4,
		 255<<4, 255<<4, 255<<4, 255<<4, 255<<4, 255<<4, 255<<4, 255<<4,
		 255<<4, 255<<4, 255<<4, 255<<4, 255<<4, 255<<4, 255<<4, 255<<4,
		 255<<4, 255<<4, 255<<4, 255<<4, 255<<4, 255<<4, 255<<4, 255<<4,
		 254<<4, 254<<4, 254<<4, 254<<4, 254<<4, 254<<4, 254<<4, 254<<4,
		 254<<4, 254<<4, 254<<4, 254<<4, 254<<4, 254<<4, 254<<4, 254<<4,
		 253<<4, 253<<4, 253<<4, 253<<4, 253<<4, 253<<4, 253<<4, 253<<4,
		 253<<4, 253<<4, 253<<4, 253<<4, 253<<4, 253<<4, 253<<4, 253<<4,
		 252<<4, 252<<4, 252<<4, 252<<4, 252<<4, 252<<4, 252<<4, 252<<4,
		 252<<4, 252<<4, 252<<4, 252<<4, 252<<4, 252<<4, 252<<4, 252<<4,
		 250<<4, 250<<4, 250<<4, 250<<4, 250<<4, 250<<4, 250<<4, 250<<4,
		 250<<4, 250<<4, 250<<4, 250<<4, 250<<4, 250<<4, 250<<4, 250<<4,
		 248<<4, 248<<4, 248<<4, 248<<4, 248<<4, 248<<4, 248<<4, 248<<4,
		 248<<4, 248<<4, 248<<4, 248<<4, 248<<4, 248<<4, 248<<4, 248<<4,
		 246<<4, 246<<4, 246<<4, 246<<4, 246<<4, 246<<4, 246<<4, 246<<4,
		 246<<4, 246<<4, 246<<4, 246<<4, 246<<4, 246<<4, 246<<4, 246<<4,
		 244<<4, 244<<4, 244<<4, 244<<4, 244<<4, 244<<4, 244<<4, 244<<4,
		 244<<4, 244<<4, 244<<4, 244<<4, 244<<4, 244<<4, 244<<4, 244<<4,
		 241<<4, 241<<4, 241<<4, 241<<4, 241<<4, 241<<4, 241<<4, 241<<4,
		 241<<4, 241<<4, 241<<4, 241<<4, 241<<4, 241<<4, 241<<4, 241<<4,
		 239<<4, 239<<4, 239<<4, 239<<4, 239<<4, 239<<4, 239<<4, 239<<4,
		 239<<4, 239<<4, 239<<4, 239<<4, 239<<4, 239<<4, 239<<4, 239<<4,
		 236<<4, 236<<4, 236<<4, 236<<4, 236<<4, 236<<4, 236<<4, 236<<4,
		 236<<4, 236<<4, 236<<4, 236<<4, 236<<4, 236<<4, 236<<4, 236<<4,
		 232<<4, 232<<4, 232<<4, 232<<4, 232<<4, 232<<4, 232<<4, 232<<4,
		 232<<4, 232<<4, 232<<4, 232<<4, 232<<4, 232<<4, 232<<4, 232<<4,
		 229<<4, 229<<4, 229<<4, 229<<4, 229<<4, 229<<4, 229<<4, 229<<4,
		 229<<4, 229<<4, 229<<4, 229<<4, 229<<4, 229<<4, 229<<4, 229<<4,
		 225<<4, 225<<4, 225<<4, 225<<4, 225<<4, 225<<4, 225<<4, 225<<4,
		 225<<4, 225<<4, 225<<4, 225<<4, 225<<4, 225<<4, 225<<4, 225<<4,
		 222<<4, 222<<4, 222<<4, 222<<4, 222<<4, 222<<4, 222<<4, 222<<4,
		 222<<4, 222<<4, 222<<4, 222<<4, 222<<4, 222<<4, 222<<4, 222<<4,
		 218<<4, 218<<4, 218<<4, 218<<4, 218<<4, 218<<4, 218<<4, 218<<4,
		 218<<4, 218<<4, 218<<4, 218<<4, 218<<4, 218<<4, 218<<4, 218<<4,
		 213<<4, 213<<4, 213<<4, 213<<4, 213<<4, 213<<4, 213<<4, 213<<4,
		 213<<4, 213<<4, 213<<4, 213<<4, 213<<4, 213<<4, 213<<4, 213<<4,
		 209<<4, 209<<4, 209<<4, 209<<4, 209<<4, 209<<4, 209<<4, 209<<4,
		 209<<4, 209<<4, 209<<4, 209<<4, 209<<4, 209<<4, 209<<4, 209<<4,
		 205<<4, 205<<4, 205<<4, 205<<4, 205<<4, 205<<4, 205<<4, 205<<4,
		 205<<4, 205<<4, 205<<4, 205<<4, 205<<4, 205<<4, 205<<4, 205<<4,
		 200<<4, 200<<4, 200<<4, 200<<4, 200<<4, 200<<4, 200<<4, 200<<4,
		 200<<4, 200<<4, 200<<4, 200<<4, 200<<4, 200<<4, 200<<4, 200<<4,
		 195<<4, 195<<4, 195<<4, 195<<4, 195<<4, 195<<4, 195<<4, 195<<4,
		 195<<4, 195<<4, 195<<4, 195<<4, 195<<4, 195<<4, 195<<4, 195<<4,
		 191<<4, 191<<4, 191<<4, 191<<4, 191<<4, 191<<4, 191<<4, 191<<4,
		 191<<4, 191<<4, 191<<4, 191<<4, 191<<4, 191<<4, 191<<4, 191<<4,
		 186<<4, 186<<4, 186<<4, 186<<4, 186<<4, 186<<4, 186<<4, 186<<4,
		 186<<4, 186<<4, 186<<4, 186<<4, 186<<4, 186<<4, 186<<4, 186<<4,
		 181<<4, 181<<4, 181<<4, 181<<4, 181<<4, 181<<4, 181<<4, 181<<4,
		 181<<4, 181<<4, 181<<4, 181<<4, 181<<4, 181<<4, 181<<4, 181<<4,
		 176<<4, 176<<4, 176<<4, 176<<4, 176<<4, 176<<4, 176<<4, 176<<4,
		 176<<4, 176<<4, 176<<4, 176<<4, 176<<4, 176<<4, 176<<4, 176<<4,
		 170<<4, 170<<4, 170<<4, 170<<4, 170<<4, 170<<4, 170<<4, 170<<4,
		 170<<4, 170<<4, 170<<4, 170<<4, 170<<4, 170<<4, 170<<4, 170<<4,
		 165<<4, 165<<4, 165<<4, 165<<4, 165<<4, 165<<4, 165<<4, 165<<4,
		 165<<4, 165<<4, 165<<4, 165<<4, 165<<4, 165<<4, 165<<4, 165<<4,
		 160<<4, 160<<4, 160<<4, 160<<4, 160<<4, 160<<4, 160<<4, 160<<4,
		 160<<4, 160<<4, 160<<4, 160<<4, 160<<4, 160<<4, 160<<4, 160<<4,
		 154<<4, 154<<4, 154<<4, 154<<4, 154<<4, 154<<4, 154<<4, 154<<4,
		 154<<4, 154<<4, 154<<4, 154<<4, 154<<4, 154<<4, 154<<4, 154<<4,
		 149<<4, 149<<4, 149<<4, 149<<4, 149<<4, 149<<4, 149<<4, 149<<4,
		 149<<4, 149<<4, 149<<4, 149<<4, 149<<4, 149<<4, 149<<4, 149<<4,
		 144<<4, 144<<4, 144<<4, 144<<4, 144<<4, 144<<4, 144<<4, 144<<4,
		 144<<4, 144<<4, 144<<4, 144<<4, 144<<4, 144<<4, 144<<4, 144<<4,
		 138<<4, 138<<4, 138<<4, 138<<4, 138<<4, 138<<4, 138<<4, 138<<4,
		 138<<4, 138<<4, 138<<4, 138<<4, 138<<4, 138<<4, 138<<4, 138<<4,
		 132<<4, 132<<4, 132<<4, 132<<4, 132<<4, 132<<4, 132<<4, 132<<4,
		 132<<4, 132<<4, 132<<4, 132<<4, 132<<4, 132<<4, 132<<4, 132<<4,
		 127<<4, 127<<4, 127<<4, 127<<4, 127<<4, 127<<4, 127<<4, 127<<4,
		 127<<4, 127<<4, 127<<4, 127<<4, 127<<4, 127<<4, 127<<4, 127<<4,
		 121<<4, 121<<4, 121<<4, 121<<4, 121<<4, 121<<4, 121<<4, 121<<4,
		 121<<4, 121<<4, 121<<4, 121<<4, 121<<4, 121<<4, 121<<4, 121<<4,
		 116<<4, 116<<4, 116<<4, 116<<4, 116<<4, 116<<4, 116<<4, 116<<4,
		 116<<4, 116<<4, 116<<4, 116<<4, 116<<4, 116<<4, 116<<4, 116<<4,
		 110<<4, 110<<4, 110<<4, 110<<4, 110<<4, 110<<4, 110<<4, 110<<4,
		 110<<4, 110<<4, 110<<4, 110<<4, 110<<4, 110<<4, 110<<4, 110<<4,
		 105<<4, 105<<4, 105<<4, 105<<4, 105<<4, 105<<4, 105<<4, 105<<4,
		 105<<4, 105<<4, 105<<4, 105<<4, 105<<4, 105<<4, 105<<4, 105<<4,
		  99<<4,  99<<4,  99<<4,  99<<4,  99<<4,  99<<4,  99<<4,  99<<4,
		  99<<4,  99<<4,  99<<4,  99<<4,  99<<4,  99<<4,  99<<4,  99<<4,
		  94<<4,  94<<4,  94<<4,  94<<4,  94<<4,  94<<4,  94<<4,  94<<4,
		  94<<4,  94<<4,  94<<4,  94<<4,  94<<4,  94<<4,  94<<4,  94<<4,
		  88<<4,  88<<4,  88<<4,  88<<4,  88<<4,  88<<4,  88<<4,  88<<4,
		  88<<4,  88<<4,  88<<4,  88<<4,  88<<4,  88<<4,  88<<4,  88<<4,
		  83<<4,  83<<4,  83<<4,  83<<4,  83<<4,  83<<4,  83<<4,  83<<4,
		  83<<4,  83<<4,  83<<4,  83<<4,  83<<4,  83<<4,  83<<4,  83<<4,
		  78<<4,  78<<4,  78<<4,  78<<4,  78<<4,  78<<4,  78<<4,  78<<4,
		  78<<4,  78<<4,  78<<4,  78<<4,  78<<4,  78<<4,  78<<4,  78<<4,
		  73<<4,  73<<4,  73<<4,  73<<4,  73<<4,  73<<4,  73<<4,  73<<4,
		  73<<4,  73<<4,  73<<4,  73<<4,  73<<4,  73<<4,  73<<4,  73<<4,
		  67<<4,  67<<4,  67<<4,  67<<4,  67<<4,  67<<4,  67<<4,  67<<4,
		  67<<4,  67<<4,  67<<4,  67<<4,  67<<4,  67<<4,  67<<4,  67<<4,
		  62<<4,  62<<4,  62<<4,  62<<4,  62<<4,  62<<4,  62<<4,  62<<4,
		  62<<4,  62<<4,  62<<4,  62<<4,  62<<4,  62<<4,  62<<4,  62<<4,
		  58<<4,  58<<4,  58<<4,  58<<4,  58<<4,  58<<4,  58<<4,  58<<4,
		  58<<4,  58<<4,  58<<4,  58<<4,  58<<4,  58<<4,  58<<4,  58<<4,
		  53<<4,  53<<4,  53<<4,  53<<4,  53<<4,  53<<4,  53<<4,  53<<4,
		  53<<4,  53<<4,  53<<4,  53<<4,  53<<4,  53<<4,  53<<4,  53<<4,
		  48<<4,  48<<4,  48<<4,  48<<4,  48<<4,  48<<4,  48<<4,  48<<4,
		  48<<4,  48<<4,  48<<4,  48<<4,  48<<4,  48<<4,  48<<4,  48<<4,
		  43<<4,  43<<4,  43<<4,  43<<4,  43<<4,  43<<4,  43<<4,  43<<4,
		  43<<4,  43<<4,  43<<4,  43<<4,  43<<4,  43<<4,  43<<4,  43<<4,
		  39<<4,  39<<4,  39<<4,  39<<4,  39<<4,  39<<4,  39<<4,  39<<4,
		  39<<4,  39<<4,  39<<4,  39<<4,  39<<4,  39<<4,  39<<4,  39<<4,
		  35<<4,  35<<4,  35<<4,  35<<4,  35<<4,  35<<4,  35<<4,  35<<4,
		  35<<4,  35<<4,  35<<4,  35<<4,  35<<4,  35<<4,  35<<4,  35<<4,
		  31<<4,  31<<4,  31<<4,  31<<4,  31<<4,  31<<4,  31<<4,  31<<4,
		  31<<4,  31<<4,  31<<4,  31<<4,  31<<4,  31<<4,  31<<4,  31<<4,
		  27<<4,  27<<4,  27<<4,  27<<4,  27<<4,  27<<4,  27<<4,  27<<4,
		  27<<4,  27<<4,  27<<4,  27<<4,  27<<4,  27<<4,  27<<4,  27<<4,
		  23<<4,  23<<4,  23<<4,  23<<4,  23<<4,  23<<4,  23<<4,  23<<4,
		  23<<4,  23<<4,  23<<4,  23<<4,  23<<4,  23<<4,  23<<4,  23<<4,
		  19<<4,  19<<4,  19<<4,  19<<4,  19<<4,  19<<4,  19<<4,  19<<4,
		  19<<4,  19<<4,  19<<4,  19<<4,  19<<4,  19<<4,  19<<4,  19<<4,
		  16<<4,  16<<4,  16<<4,  16<<4,  16<<4,  16<<4,  16<<4,  16<<4,
		  16<<4,  16<<4,  16<<4,  16<<4,  16<<4,  16<<4,  16<<4,  16<<4,
		  12<<4,  12<<4,  12<<4,  12<<4,  12<<4,  12<<4,  12<<4,  12<<4,
		  12<<4,  12<<4,  12<<4,  12<<4,  12<<4,  12<<4,  12<<4,  12<<4,
		  9<<4,   9<<4,   9<<4,   9<<4,   9<<4,   9<<4,   9<<4,   9<<4,
		  9<<4,   9<<4,   9<<4,   9<<4,   9<<4,   9<<4,   9<<4,   9<<4,
		  7<<4,   7<<4,   7<<4,   7<<4,   7<<4,   7<<4,   7<<4,   7<<4,
		  7<<4,   7<<4,   7<<4,   7<<4,   7<<4,   7<<4,   7<<4,   7<<4,
		  4<<4,   4<<4,   4<<4,   4<<4,   4<<4,   4<<4,   4<<4,   4<<4,
		  4<<4,   4<<4,   4<<4,   4<<4,   4<<4,   4<<4,   4<<4,   4<<4,
		  2<<4,   2<<4,   2<<4,   2<<4,   2<<4,   2<<4,   2<<4,   2<<4,
		  2<<4,   2<<4,   2<<4,   2<<4,   2<<4,   2<<4,   2<<4,   2<<4},
		 {0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,
		  0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,
		 -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,
		 -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,
		 -3<<4,  -3<<4,  -3<<4,  -3<<4,  -3<<4,  -3<<4,  -3<<4,  -3<<4,
		 -3<<4,  -3<<4,  -3<<4,  -3<<4,  -3<<4,  -3<<4,  -3<<4,  -3<<4,
		 -5<<4,  -5<<4,  -5<<4,  -5<<4,  -5<<4,  -5<<4,  -5<<4,  -5<<4,
		 -5<<4,  -5<<4,  -5<<4,  -5<<4,  -5<<4,  -5<<4,  -5<<4,  -5<<4,
		 -6<<4,  -6<<4,  -6<<4,  -6<<4,  -6<<4,  -6<<4,  -6<<4,  -6<<4,
		 -6<<4,  -6<<4,  -6<<4,  -6<<4,  -6<<4,  -6<<4,  -6<<4,  -6<<4,
		 -8<<4,  -8<<4,  -8<<4,  -8<<4,  -8<<4,  -8<<4,  -8<<4,  -8<<4,
		 -8<<4,  -8<<4,  -8<<4,  -8<<4,  -8<<4,  -8<<4,  -8<<4,  -8<<4,
		 -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,
		 -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,
		-10<<4, -10<<4, -10<<4, -10<<4, -10<<4, -10<<4, -10<<4, -10<<4,
		-10<<4, -10<<4, -10<<4, -10<<4, -10<<4, -10<<4, -10<<4, -10<<4,
		-12<<4, -12<<4, -12<<4, -12<<4, -12<<4, -12<<4, -12<<4, -12<<4,
		-12<<4, -12<<4, -12<<4, -12<<4, -12<<4, -12<<4, -12<<4, -12<<4,
		-13<<4, -13<<4, -13<<4, -13<<4, -13<<4, -13<<4, -13<<4, -13<<4,
		-13<<4, -13<<4, -13<<4, -13<<4, -13<<4, -13<<4, -13<<4, -13<<4,
		-14<<4, -14<<4, -14<<4, -14<<4, -14<<4, -14<<4, -14<<4, -14<<4,
		-14<<4, -14<<4, -14<<4, -14<<4, -14<<4, -14<<4, -14<<4, -14<<4,
		-15<<4, -15<<4, -15<<4, -15<<4, -15<<4, -15<<4, -15<<4, -15<<4,
		-15<<4, -15<<4, -15<<4, -15<<4, -15<<4, -15<<4, -15<<4, -15<<4,
		-16<<4, -16<<4, -16<<4, -16<<4, -16<<4, -16<<4, -16<<4, -16<<4,
		-16<<4, -16<<4, -16<<4, -16<<4, -16<<4, -16<<4, -16<<4, -16<<4,
		-15<<4, -15<<4, -15<<4, -15<<4, -15<<4, -15<<4, -15<<4, -15<<4,
		-15<<4, -15<<4, -15<<4, -15<<4, -15<<4, -15<<4, -15<<4, -15<<4,
		-17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4,
		-17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4,
		-17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4,
		-17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4,
		-18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4,
		-18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4,
		-18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4,
		-18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4,
		-17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4,
		-17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4,
		-19<<4, -19<<4, -19<<4, -19<<4, -19<<4, -19<<4, -19<<4, -19<<4,
		-19<<4, -19<<4, -19<<4, -19<<4, -19<<4, -19<<4, -19<<4, -19<<4,
		-19<<4, -19<<4, -19<<4, -19<<4, -19<<4, -19<<4, -19<<4, -19<<4,
		-19<<4, -19<<4, -19<<4, -19<<4, -19<<4, -19<<4, -19<<4, -19<<4,
		-18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4,
		-18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4,
		-18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4,
		-18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4,
		-19<<4, -19<<4, -19<<4, -19<<4, -19<<4, -19<<4, -19<<4, -19<<4,
		-19<<4, -19<<4, -19<<4, -19<<4, -19<<4, -19<<4, -19<<4, -19<<4,
		-18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4,
		-18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4,
		-19<<4, -19<<4, -19<<4, -19<<4, -19<<4, -19<<4, -19<<4, -19<<4,
		-19<<4, -19<<4, -19<<4, -19<<4, -19<<4, -19<<4, -19<<4, -19<<4,
		-18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4,
		-18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4, -18<<4,
		-17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4,
		-17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4,
		-17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4,
		-17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4,
		-17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4,
		-17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4, -17<<4,
		-16<<4, -16<<4, -16<<4, -16<<4, -16<<4, -16<<4, -16<<4, -16<<4,
		-16<<4, -16<<4, -16<<4, -16<<4, -16<<4, -16<<4, -16<<4, -16<<4,
		-16<<4, -16<<4, -16<<4, -16<<4, -16<<4, -16<<4, -16<<4, -16<<4,
		-16<<4, -16<<4, -16<<4, -16<<4, -16<<4, -16<<4, -16<<4, -16<<4,
		-16<<4, -16<<4, -16<<4, -16<<4, -16<<4, -16<<4, -16<<4, -16<<4,
		-16<<4, -16<<4, -16<<4, -16<<4, -16<<4, -16<<4, -16<<4, -16<<4,
		-15<<4, -15<<4, -15<<4, -15<<4, -15<<4, -15<<4, -15<<4, -15<<4,
		-15<<4, -15<<4, -15<<4, -15<<4, -15<<4, -15<<4, -15<<4, -15<<4,
		-14<<4, -14<<4, -14<<4, -14<<4, -14<<4, -14<<4, -14<<4, -14<<4,
		-14<<4, -14<<4, -14<<4, -14<<4, -14<<4, -14<<4, -14<<4, -14<<4,
		-14<<4, -14<<4, -14<<4, -14<<4, -14<<4, -14<<4, -14<<4, -14<<4,
		-14<<4, -14<<4, -14<<4, -14<<4, -14<<4, -14<<4, -14<<4, -14<<4,
		-13<<4, -13<<4, -13<<4, -13<<4, -13<<4, -13<<4, -13<<4, -13<<4,
		-13<<4, -13<<4, -13<<4, -13<<4, -13<<4, -13<<4, -13<<4, -13<<4,
		-12<<4, -12<<4, -12<<4, -12<<4, -12<<4, -12<<4, -12<<4, -12<<4,
		-12<<4, -12<<4, -12<<4, -12<<4, -12<<4, -12<<4, -12<<4, -12<<4,
		-12<<4, -12<<4, -12<<4, -12<<4, -12<<4, -12<<4, -12<<4, -12<<4,
		-12<<4, -12<<4, -12<<4, -12<<4, -12<<4, -12<<4, -12<<4, -12<<4,
		-12<<4, -12<<4, -12<<4, -12<<4, -12<<4, -12<<4, -12<<4, -12<<4,
		-12<<4, -12<<4, -12<<4, -12<<4, -12<<4, -12<<4, -12<<4, -12<<4,
		-11<<4, -11<<4, -11<<4, -11<<4, -11<<4, -11<<4, -11<<4, -11<<4,
		-11<<4, -11<<4, -11<<4, -11<<4, -11<<4, -11<<4, -11<<4, -11<<4,
		-11<<4, -11<<4, -11<<4, -11<<4, -11<<4, -11<<4, -11<<4, -11<<4,
		-11<<4, -11<<4, -11<<4, -11<<4, -11<<4, -11<<4, -11<<4, -11<<4,
		 -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,
		 -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,
		 -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,
		 -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,
		 -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,
		 -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,  -9<<4,
		 -8<<4,  -8<<4,  -8<<4,  -8<<4,  -8<<4,  -8<<4,  -8<<4,  -8<<4,
		 -8<<4,  -8<<4,  -8<<4,  -8<<4,  -8<<4,  -8<<4,  -8<<4,  -8<<4,
		 -6<<4,  -6<<4,  -6<<4,  -6<<4,  -6<<4,  -6<<4,  -6<<4,  -6<<4,
		 -6<<4,  -6<<4,  -6<<4,  -6<<4,  -6<<4,  -6<<4,  -6<<4,  -6<<4,
		 -6<<4,  -6<<4,  -6<<4,  -6<<4,  -6<<4,  -6<<4,  -6<<4,  -6<<4,
		 -6<<4,  -6<<4,  -6<<4,  -6<<4,  -6<<4,  -6<<4,  -6<<4,  -6<<4,
		 -6<<4,  -6<<4,  -6<<4,  -6<<4,  -6<<4,  -6<<4,  -6<<4,  -6<<4,
		 -6<<4,  -6<<4,  -6<<4,  -6<<4,  -6<<4,  -6<<4,  -6<<4,  -6<<4,
		 -5<<4,  -5<<4,  -5<<4,  -5<<4,  -5<<4,  -5<<4,  -5<<4,  -5<<4,
		 -5<<4,  -5<<4,  -5<<4,  -5<<4,  -5<<4,  -5<<4,  -5<<4,  -5<<4,
		 -4<<4,  -4<<4,  -4<<4,  -4<<4,  -4<<4,  -4<<4,  -4<<4,  -4<<4,
		 -4<<4,  -4<<4,  -4<<4,  -4<<4,  -4<<4,  -4<<4,  -4<<4,  -4<<4,
		 -3<<4,  -3<<4,  -3<<4,  -3<<4,  -3<<4,  -3<<4,  -3<<4,  -3<<4,
		 -3<<4,  -3<<4,  -3<<4,  -3<<4,  -3<<4,  -3<<4,  -3<<4,  -3<<4,
		 -4<<4,  -4<<4,  -4<<4,  -4<<4,  -4<<4,  -4<<4,  -4<<4,  -4<<4,
		 -4<<4,  -4<<4,  -4<<4,  -4<<4,  -4<<4,  -4<<4,  -4<<4,  -4<<4,
		 -3<<4,  -3<<4,  -3<<4,  -3<<4,  -3<<4,  -3<<4,  -3<<4,  -3<<4,
		 -3<<4,  -3<<4,  -3<<4,  -3<<4,  -3<<4,  -3<<4,  -3<<4,  -3<<4,
		 -2<<4,  -2<<4,  -2<<4,  -2<<4,  -2<<4,  -2<<4,  -2<<4,  -2<<4,
		 -2<<4,  -2<<4,  -2<<4,  -2<<4,  -2<<4,  -2<<4,  -2<<4,  -2<<4,
		 -2<<4,  -2<<4,  -2<<4,  -2<<4,  -2<<4,  -2<<4,  -2<<4,  -2<<4,
		 -2<<4,  -2<<4,  -2<<4,  -2<<4,  -2<<4,  -2<<4,  -2<<4,  -2<<4,
		 -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,
		 -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,
		  0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,
		  0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,
		 -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,
		 -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,  -1<<4,
		  0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,
		  0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,
		  1<<4,   1<<4,   1<<4,   1<<4,   1<<4,   1<<4,   1<<4,   1<<4,
		  1<<4,   1<<4,   1<<4,   1<<4,   1<<4,   1<<4,   1<<4,   1<<4,
		  0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,
		  0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,
		  0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,
		  0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,
		  0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,
		  0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4,   0<<4}
};
#elif defined(HAS_GDC_VERSION_1)
static const int zoom_table[4][HRT_GDC_N] = {
	{0, 0, 0, 0, 0, 0, -1, -1,
	 -1, -2, -2, -3, -3, -4, -4, -5,
	 -6, -6, -7, -7, -8, -9, -9, -10,
	 -11, -11, -12, -13, -13, -14, -14, -15,
	 -16, -16, -16, -17, -17, -18, -18, -18,
	 -18, -18, -18, -18, -18, -18, -18, -18,
	 -18, -17, -17, -16, -15, -15, -14, -13,
	 -12, -11, -9, -8, -7, -5, -3, -1},
	{0, 2, 4, 7, 9, 12, 16, 19,
	 23, 27, 31, 35, 39, 43, 48, 53,
	 58, 62, 67, 73, 78, 83, 88, 94,
	 99, 105, 110, 116, 121, 127, 132, 138,
	 144, 149, 154, 160, 165, 170, 176, 181,
	 186, 191, 195, 200, 205, 209, 213, 218,
	 222, 225, 229, 232, 236, 239, 241, 244,
	 246, 248, 250, 252, 253, 254, 255, 255},
	{256, 255, 255, 254, 253, 252, 250, 248,
	 246, 244, 241, 239, 236, 232, 229, 225,
	 222, 218, 213, 209, 205, 200, 195, 191,
	 186, 181, 176, 170, 165, 160, 154, 149,
	 144, 138, 132, 127, 121, 116, 110, 105,
	 99, 94, 88, 83, 78, 73, 67, 62,
	 58, 53, 48, 43, 39, 35, 31, 27,
	 23, 19, 16, 12, 9, 7, 4, 2},
	{0, -1, -3, -5, -6, -8, -9, -10,
	 -12, -13, -14, -15, -16, -15, -17, -17,
	 -18, -18, -17, -19, -19, -18, -18, -19,
	 -18, -19, -18, -17, -17, -17, -16, -16,
	 -16, -15, -14, -14, -13, -12, -12, -12,
	 -11, -11, -9, -9, -9, -8, -6, -6,
	 -6, -5, -4, -3, -4, -3, -2, -2,
	 -1, 0, -1, 0, 1, 0, 0, 0}
};
#else
#error "sh_css_params.c: GDC version must be \
	one of {GDC_VERSION_1, GDC_VERSION_2}"
#endif

static const struct sh_css_3a_config default_3a_config = {
	25559,
	32768,
	7209,
	65535,
	0,
	65535,
	{-3344, -6104, -19143, 19143, 6104, 3344, 0},
	{1027, 0, -9219, 16384, -9219, 1027, 0}
};

static const struct sh_css_3a_config disabled_3a_config = {
	25559,
	32768,
	7209,
	65535,
	0,
	65535,
	{-6689, -12207, -32768, 32767, 12207, 6689, 0},
	{2053, 0, -18437, 32767, -18437, 2053, 0}
};

static const struct sh_css_wb_config default_wb_config = {
	1,
	32768,
	32768,
	32768,
	32768
};

static const struct sh_css_wb_config disabled_wb_config = {
	1,
	32768,
	32768,
	32768,
	32768
};

static const struct sh_css_cc_config default_cc_config = {
	8,
	{255, 29, 120, 0, -374, -342, 0, -672, 301},
};

static const struct sh_css_cc_config disabled_cc_config = {
	8,
	{256, 44, 47, 0, -169, -171, 0, -214, 148},
};

static const struct sh_css_tnr_config default_tnr_config = {
	32768,
	32,
	32,
};

static const struct sh_css_tnr_config disabled_tnr_config = {
	0,
	0,
	0,
};

static const struct sh_css_ob_config default_ob_config = {
	sh_css_ob_mode_none,
	0,
	0,
	0,
	0,
	0,
	0
};

static const struct sh_css_ob_config disabled_ob_config = {
	sh_css_ob_mode_none,
	0,
	0,
	0,
	0,
	0,
	0
};

static const struct sh_css_dp_config default_dp_config = {
	8192,
	2048
};

static const struct sh_css_dp_config disabled_dp_config = {
	65535,
	65535
};

static const struct sh_css_nr_config default_nr_config = {
	16384,
	8192,
	1280,
	0,
	0
};

static const struct sh_css_nr_config disabled_nr_config = {
	0,
	0,
	0,
	0,
	0
};

static const struct sh_css_ee_config default_ee_config = {
	8192,
	128,
	2048
};

static const struct sh_css_ee_config disabled_ee_config = {
	0,
	0,
	0
};

static const struct sh_css_de_config default_de_config = {
	0,
	0,
	0
};

static const struct sh_css_de_config disabled_de_config = {
	65535,
	0,
	0
};

static const struct sh_css_gc_config default_gc_config = {
	0,
	0
};

static const struct sh_css_gc_config disabled_gc_config = {
	0,
	0
};

static const struct sh_css_anr_config default_anr_config = {
	10,
};

static const struct sh_css_ce_config default_ce_config = {
	0,
	255
};

static const struct sh_css_zoom default_zoom_config = {
	HRT_GDC_N,
	HRT_GDC_N
};

static const struct sh_css_vector default_motion_config = {
	0,
	0
};

static const struct sh_css_ecd_config default_ecd_config = {
	(1 << (ISP_VEC_ELEMBITS - 1)) * 2 / 3,	/* 2/3 */
	(1 << (ISP_VEC_ELEMBITS - 1)) - 1,	/* 1.0 */
	0,					/* 0.0 */
};

static const struct sh_css_ecd_config disabled_ecd_config = {
	0,	/* 0.0 */
	0,	/* 0.0 */
	0,	/* 0.0 */
};

static const struct sh_css_ynr_config default_ynr_config = {
	0,
	0,
	0,
	0,
};

static const struct sh_css_ynr_config disabled_ynr_config = {
	0,
	0,
	0,
	0,
};

static const struct sh_css_fc_config default_fc_config = {
	1,
	(1 << (ISP_VEC_ELEMBITS - 2)),		/* 0.5 */
	(1 << (ISP_VEC_ELEMBITS - 2)),		/* 0.5 */
	(1 << (ISP_VEC_ELEMBITS - 2)),		/* 0.5 */
	(1 << (ISP_VEC_ELEMBITS - 2)),		/* 0.5 */
	(1 << (ISP_VEC_ELEMBITS - 1)) - 1,	/* 1 */
	(1 << (ISP_VEC_ELEMBITS - 1)) - 1,	/* 1 */
	- (1 << (ISP_VEC_ELEMBITS - 1)),	/* -1 */
	- (1 << (ISP_VEC_ELEMBITS - 1)),	/* -1 */
};

static const struct sh_css_fc_config disabled_fc_config = {
	1,
	(1 << (ISP_VEC_ELEMBITS - 2)),		/* 0.5 */
	(1 << (ISP_VEC_ELEMBITS - 2)),		/* 0.5 */
	(1 << (ISP_VEC_ELEMBITS - 2)),		/* 0.5 */
	(1 << (ISP_VEC_ELEMBITS - 2)),		/* 0.5 */
	(1 << (ISP_VEC_ELEMBITS - 1)) - 1,	/* 1 */
	(1 << (ISP_VEC_ELEMBITS - 1)) - 1,	/* 1 */
	- (1 << (ISP_VEC_ELEMBITS - 1)),	/* -1 */
	- (1 << (ISP_VEC_ELEMBITS - 1)),	/* -1 */
};

static const struct sh_css_cnr_config default_cnr_config = {
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0
};

static const struct sh_css_cnr_config disabled_cnr_config = {
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0
};

static const struct sh_css_macc_config default_macc_config = {
	0,
};

static const struct sh_css_macc_config disabled_macc_config = {
	0,
};

static const struct sh_css_ctc_config default_ctc_config = {
	((1 << SH_CSS_CTC_COEF_SHIFT) + 1) / 2,		/* 0.5 */
	((1 << SH_CSS_CTC_COEF_SHIFT) + 1) / 2,		/* 0.5 */
	((1 << SH_CSS_CTC_COEF_SHIFT) + 1) / 2,		/* 0.5 */
	((1 << SH_CSS_CTC_COEF_SHIFT) + 1) / 2,		/* 0.5 */
	((1 << SH_CSS_CTC_COEF_SHIFT) + 1) / 2,		/* 0.5 */
	((1 << SH_CSS_CTC_COEF_SHIFT) + 1) / 2,		/* 0.5 */
	1,
	SH_CSS_BAYER_MAXVAL / 5,	/* To be implemented */
	SH_CSS_BAYER_MAXVAL * 2 / 5,	/* To be implemented */
	SH_CSS_BAYER_MAXVAL * 3 / 5,	/* To be implemented */
	SH_CSS_BAYER_MAXVAL * 4 / 5,	/* To be implemented */
};

#if SH_CSS_ISP_PARAMS_VERSION == 1
static const struct sh_css_aa_config default_aa_config = {
	8140,
};
#elif SH_CSS_ISP_PARAMS_VERSION == 2
static const struct sh_css_aa_config default_aa_config = {
	8191,
};
#else
#error "sh_css_params.c: PARAMS_VERSION must be one of {1,2}"
#endif

static const struct sh_css_xnr_config default_xnr_config = {
	25
};

static const struct sh_css_yuv2rgb_cc_config
default_yuv2rgb_cc_config = {
	/* Bits of fractional part = SH_CSS_YUV2RGB_CCM_COEF_SHIFT = 12 */
	{4096, -4096, 4096, 4096, 4096, 0, 4096, -4096, -4096}
};

static const struct sh_css_yuv2rgb_cc_config
disabled_yuv2rgb_cc_config = {
	/* Bits of fractional part = SH_CSS_YUV2RGB_CCM_COEF_SHIFT = 12 */
	{4096, -4096, 4096, 4096, 4096, 0, 4096, -4096, -4096}
};

static const struct sh_css_rgb2yuv_cc_config
default_rgb2yuv_cc_config = {
	/* Bits of fractional part = SH_CSS_RGB2YUV_CSC_COEF_SHIFT = 13 */
	{2449, 4809, 934, -1382, -2714, 4096, 4096, -3430, -666}
};

static const struct sh_css_rgb2yuv_cc_config
disabled_rgb2yuv_cc_config = {
	/* Bits of fractional part = SH_CSS_RGB2YUV_CSC_COEF_SHIFT = 13s */
	{2449, 4809, 934, -1382, -2714, 4096, 4096, -3430, -666}
};


static void
sh_css_dequeue_param_buffers(void);

static enum sh_css_err
ref_sh_css_ddr_address_map(
		struct sh_css_ddr_address_map *map,
		struct sh_css_ddr_address_map *out);

static enum sh_css_err
write_sh_css_address_map_to_ddr(
		struct sh_css_ddr_address_map *map,
		hrt_vaddress *out);

static enum sh_css_err
free_sh_css_ddr_address_map(hrt_vaddress ptr);

static enum sh_css_err
sh_css_params_write_to_ddr_internal(
		const struct sh_css_binary *binary,
		struct sh_css_ddr_address_map *ddr_map,
		struct sh_css_ddr_address_map_size *ddr_map_size);

int sh_css_get_gdc_coord_one(void)
{
#if defined(HAS_GDC_VERSION_2)
/*
 * MW: We don't want to store the coordinates
 * full range in memory: Truncate
 */
	return gdc_get_unity(GDC0_ID)/HRT_GDC_COORD_SCALE;
#elif defined(HAS_GDC_VERSION_1)
	return gdc_get_unity(GDC0_ID);
#else
#error "sh_css_params.c: GDC version must be \
	one of {GDC_VERSION_1, GDC_VERSION_2}"
#endif
}

void
sh_css_set_dis_coefficients(
	const short *horizontal_coefficients,
	const short *vertical_coefficients)
{
/* input can be NULL */
	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_set_dis_coefficients() enter: hcoef=%p, vcoef=%p",
		horizontal_coefficients,vertical_coefficients);
	dis_hor_coef_tbl = horizontal_coefficients;
	dis_ver_coef_tbl = vertical_coefficients;
	dis_coef_table_changed = true;
	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_set_dis_coefficients() leave: void\n");
}

#ifdef __KERNEL__
/* This is the optimized code that uses the aligned_width and aligned_height
 * for the projections. This should be enabled in the same patch set that
 * adds the correct handling of these strides to the DIS IA code.
 */
void
sh_css_get_dis_projections(
	int *horizontal_projections,
	int *vertical_projections,
	struct sh_css_dis_data *dis_data)
{
	unsigned int hor_num_isp, ver_num_isp,
		hor_bytes, ver_bytes;
	hrt_vaddress hor_ptr_isp, ver_ptr_isp;

	assert(dis_data != NULL);
	if(dis_data == NULL)
		return;

	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_dis_projections() enter: "
		"hcoef=%p, vcoef=%p, haddr=%x, vaddr=%x\n",
		horizontal_projections,vertical_projections,
		dis_data->sdis_hor_proj,dis_data->sdis_ver_proj);

	assert(horizontal_projections != NULL);
	if(horizontal_projections == NULL)
		return;

	assert(vertical_projections != NULL);
	if(vertical_projections == NULL)
		return;

	assert(dis_data->sdis_hor_proj != mmgr_NULL);
	assert(dis_data->sdis_hor_proj != mmgr_NULL);

	hor_ptr_isp = dis_data->sdis_hor_proj;
	ver_ptr_isp = dis_data->sdis_ver_proj;

	if (current_3a_binary == NULL) {
		sh_css_dtrace(SH_DBG_TRACE,
			"sh_css_get_dis_projections() leave: void\n");
		return;
	}

	hor_num_isp = current_3a_binary->dis_hor_proj_num_isp;
	ver_num_isp = current_3a_binary->dis_ver_proj_num_isp;

	hor_bytes = hor_num_isp * sizeof(*horizontal_projections) *
		SH_CSS_DIS_NUM_COEF_TYPES;
	ver_bytes = ver_num_isp * sizeof(*vertical_projections) *
		SH_CSS_DIS_NUM_COEF_TYPES;

	mmgr_load(hor_ptr_isp,
		horizontal_projections, hor_bytes);
	mmgr_load(ver_ptr_isp,
		vertical_projections, ver_bytes);

	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_dis_projections() leave: void\n");
}
#else
void
sh_css_get_dis_projections(
	int *horizontal_projections,
	int *vertical_projections,
	struct sh_css_dis_data *dis_data)
{
	unsigned int hor_num_isp, ver_num_isp,
		     hor_num_3a, ver_num_3a, i;
	int *hor_ptr_3a  = horizontal_projections,
		*ver_ptr_3a  = vertical_projections;
	hrt_vaddress hor_ptr_isp, ver_ptr_isp;

	assert(dis_data != NULL);
	if(dis_data == NULL)
		return;

	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_dis_projections() enter: "
		"hcoef=%p, vcoef=%p, "
		"haddr=%x, vaddr=%x\n",
		horizontal_projections,vertical_projections,
		dis_data->sdis_hor_proj,dis_data->sdis_ver_proj);

	hor_ptr_isp = dis_data->sdis_hor_proj;
	ver_ptr_isp = dis_data->sdis_ver_proj;

	assert(horizontal_projections != NULL);
	if(horizontal_projections == NULL)
		return;

	assert(vertical_projections != NULL);
	if(vertical_projections == NULL)
		return;

	assert(dis_data->sdis_hor_proj != mmgr_NULL);
	assert(dis_data->sdis_hor_proj != mmgr_NULL);

	if (current_3a_binary == NULL) {
		sh_css_dtrace(SH_DBG_TRACE,
			"sh_css_get_dis_projections() leave: return_void\n");
		return;
	}

	hor_num_isp = current_3a_binary->dis_hor_proj_num_isp;
	ver_num_isp = current_3a_binary->dis_ver_proj_num_isp;
	hor_num_3a  = current_3a_binary->dis_hor_proj_num_3a;
	ver_num_3a  = current_3a_binary->dis_ver_proj_num_3a;

	for (i = 0; i < SH_CSS_DIS_NUM_COEF_TYPES; i++) {
		mmgr_load(hor_ptr_isp,
			hor_ptr_3a, hor_num_3a * sizeof(int));
		hor_ptr_isp += hor_num_isp * sizeof(int);
		hor_ptr_3a  += hor_num_3a;

		mmgr_load(ver_ptr_isp,
			ver_ptr_3a, ver_num_3a * sizeof(int));
		ver_ptr_isp += ver_num_isp * sizeof(int);
		ver_ptr_3a  += ver_num_3a;
	}
	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_get_dis_projections() leave: return_void\n");
}
#endif

static void get_3a_stats_from_dmem(
	struct sh_css_3a_output *output, hrt_vaddress ddr_ptr)
{
	int ddr_width  = current_3a_binary->s3atbl_isp_width,
		out_width  = current_3a_binary->s3atbl_width,
		out_height = current_3a_binary->s3atbl_height, i;
	struct sh_css_3a_output *out_ptr = output;

	assert(output != NULL);
	if(output == NULL)
		return;

	assert(ddr_ptr != mmgr_NULL);

	for (i = 0; i < out_height; i++) {
		mmgr_load(ddr_ptr,
			out_ptr, out_width * sizeof(struct sh_css_3a_output));
		ddr_ptr += ddr_width * sizeof(struct sh_css_3a_output);
		out_ptr += out_width;
	}
}

static inline int merge_hi14bit_lo14bit(
	unsigned short hi, unsigned short lo)
{
	int val = (int) ((((unsigned int) hi << 14) & 0xfffc000) |
		((unsigned int) lo & 0x3fff));
	return val;
}

static void
get_3a_stats_from_vmem(
	struct sh_css_3a_output *output,
	hrt_vaddress ddr_ptr_hi,
	hrt_vaddress ddr_ptr_lo)
{
	int out_width  = current_3a_binary->s3atbl_width,
		out_height = current_3a_binary->s3atbl_height;
	unsigned short *hi, *lo;
	int chunk, rest, kmax, y, x, k, elm_start, elm, ofs, bytes;

	assert(output != NULL);
	if(output == NULL)
		return;

	assert(ddr_ptr_hi != mmgr_NULL);
	assert(ddr_ptr_lo != mmgr_NULL);

	hi = s3a_tbl_hi_buf;
	lo = s3a_tbl_lo_buf;

	chunk = (ISP_VEC_NELEMS >> current_3a_binary->deci_factor_log2);
	chunk = max(chunk, 1);
	bytes = ISP_S3ATBL_HI_LO_STRIDE_BYTES * out_height;

	mmgr_load(ddr_ptr_hi, hi, bytes);
	mmgr_load(ddr_ptr_lo, lo, bytes);

	for (y = 0; y < out_height; y++) {
		elm_start = y * ISP_S3ATBL_HI_LO_STRIDE;
		rest = out_width;
		x = 0;
		while (x < out_width) {
			kmax = (rest > chunk) ? chunk : rest;
			ofs = y * out_width + x;
			elm = elm_start + x * sizeof(*output) / sizeof(int);
			for (k = 0; k < kmax; k++, elm++) {
				output[ofs + k].ae_y =
				    merge_hi14bit_lo14bit
				    (hi[elm], lo[elm]);
				output[ofs + k].awb_cnt =
				    merge_hi14bit_lo14bit
				    (hi[elm + chunk], lo[elm + chunk]);
				output[ofs + k].awb_gr =
				    merge_hi14bit_lo14bit
				    (hi[elm + chunk * 2],
				     lo[elm + chunk * 2]);
				output[ofs + k].awb_r =
				    merge_hi14bit_lo14bit
				    (hi[elm + chunk * 3],
				     lo[elm + chunk * 3]);
				output[ofs + k].awb_b =
				    merge_hi14bit_lo14bit
				    (hi[elm + chunk * 4],
				     lo[elm + chunk * 4]);
				output[ofs + k].awb_gb =
				    merge_hi14bit_lo14bit
				    (hi[elm + chunk * 5],
				     lo[elm + chunk * 5]);
				output[ofs + k].af_hpf1 =
				    merge_hi14bit_lo14bit
				    (hi[elm + chunk * 6],
				     lo[elm + chunk * 6]);
				output[ofs + k].af_hpf2 =
				    merge_hi14bit_lo14bit
				    (hi[elm + chunk * 7],
				     lo[elm + chunk * 7]);
			}
			x += chunk;
			rest -= chunk;
		}
	}
}

static void
sh_css_process_3a(void)
{
	unsigned int i, raw_bit_depth = 10;

	/* coefficients to calculate Y */
	isp_parameters.ae_y_coef_r =
	    uDIGIT_FITTING(s3a_config->ae_y_coef_r, 16, SH_CSS_AE_YCOEF_SHIFT);
	isp_parameters.ae_y_coef_g =
	    uDIGIT_FITTING(s3a_config->ae_y_coef_g, 16, SH_CSS_AE_YCOEF_SHIFT);
	isp_parameters.ae_y_coef_b =
	    uDIGIT_FITTING(s3a_config->ae_y_coef_b, 16, SH_CSS_AE_YCOEF_SHIFT);

	/* AWB level gate */
	if (current_3a_binary)
		raw_bit_depth
	    = current_3a_binary->in_frame_info.raw_bit_depth;
	isp_parameters.awb_lg_high_raw =
		uDIGIT_FITTING(s3a_config->awb_lg_high_raw, 16, raw_bit_depth);
	isp_parameters.awb_lg_low =
		uDIGIT_FITTING(s3a_config->awb_lg_low, 16, SH_CSS_BAYER_BITS);
	isp_parameters.awb_lg_high =
		uDIGIT_FITTING(s3a_config->awb_lg_high, 16, SH_CSS_BAYER_BITS);

	/* af fir coefficients */
	for (i = 0; i < 7; ++i) {
		isp_parameters.af_fir1[i] =
		  sDIGIT_FITTING(s3a_config->af_fir1_coef[i], 15,
				 SH_CSS_AF_FIR_SHIFT);
		isp_parameters.af_fir2[i] =
		  sDIGIT_FITTING(s3a_config->af_fir2_coef[i], 15,
				 SH_CSS_AF_FIR_SHIFT);
	}
	isp_params_changed = true;
	s3a_config_changed = false;
}

hrt_vaddress
sh_css_params_ddr_address_map(void)
{
	return sp_ddr_ptrs;
}

/*
 * @GC:
 */
static void
convert_coords_to_ispparams(
	hrt_vaddress ddr_addr,
	const struct sh_css_dvs_6axis_config *config,
	unsigned int i_width,
	unsigned int o_width,
	unsigned int o_height,
	unsigned int uv_flag)
{
	unsigned int i, j;
	gdc_warp_param_mem_t s;
	unsigned int x00, x01, x10, x11,
		     y00, y01, y10, y11;

	unsigned int xmin, ymin;
	unsigned int topleft_x, topleft_y,
		     topleft_x_frac, topleft_y_frac;

	unsigned int blockdim_y = DVS_BLOCKDIM_Y >> uv_flag;
	unsigned int blockdim_x = DVS_BLOCKDIM_X;

	/* number of blocks per height and width */
	unsigned int num_blocks_y = o_height / blockdim_y;
	unsigned int num_blocks_x = o_width / blockdim_x;

	unsigned int in_stride = i_width * DVS_INPUT_BYTES_PER_PIXEL << uv_flag;

	assert(config != NULL);
	if (config == NULL)
		return;

	assert(ddr_addr != mmgr_NULL);

	ddr_addr += (2* DVS_6AXIS_COORDS_ELEMS * uv_flag); /* format is Y0 Y1 UV, so UV starts at 3rd position */

	assert (o_height % blockdim_y == 0);
	assert (o_width % blockdim_x == 0);

	for (j = 0; j < num_blocks_y; j++) {
		for (i = 0; i < num_blocks_x; i++) {
			x00 = config->xcoords[j][i<<uv_flag] >> uv_flag;
			x01 = config->xcoords[j][(i+1)<<uv_flag] >> uv_flag;
			x10 = config->xcoords[j+1][i<<uv_flag] >> uv_flag;
			x11 = config->xcoords[j+1][(i+1)<<uv_flag] >> uv_flag;

			y00 = config->ycoords[j][i<<uv_flag] >> uv_flag;
			y01 = config->ycoords[j][(i+1)<<uv_flag] >> uv_flag;
			y10 = config->ycoords[j+1][i<<uv_flag] >> uv_flag;
			y11 = config->ycoords[j+1][(i+1)<<uv_flag] >> uv_flag;

			/* TODO: Assert that right column's X is greater */
			xmin = MIN(x00, x10);
			/* TODO: Assert that bottom row's Y is greater */
			ymin = MIN(y00, y01);

#if 0
			/* TODO: Round width to the multiple of bus width */
			xmax = MAX(x01, x11);
			ymax = MAX(y10, y11);
			in_block_width  = xmax - xmin;
			in_block_height = ymax - ymin;
#else
			/*
			 * For initial testing, we are using constant input
			 * block size
			 * */
			s.in_block_width  = 128;
			s.in_block_height = 96 >> uv_flag;
#endif

			topleft_y = ymin >> DVS_COORD_FRAC_BITS;
			topleft_x = ((xmin >> DVS_COORD_FRAC_BITS)
					>> XMEM_ALIGN_LOG2)
					<< (XMEM_ALIGN_LOG2);

			s.in_addr_offset = topleft_y * in_stride + topleft_x;

			topleft_x_frac = topleft_x << (DVS_COORD_FRAC_BITS);
			topleft_y_frac = topleft_y << (DVS_COORD_FRAC_BITS);

			s.p0_x = x00 - topleft_x_frac;
			s.p1_x = x01 - topleft_x_frac;
			s.p2_x = x10 - topleft_x_frac;
			s.p3_x = x11 - topleft_x_frac;

			s.p0_y = y00 - topleft_y_frac;
			s.p1_y = y01 - topleft_y_frac;
			s.p2_y = y10 - topleft_y_frac;
			s.p3_y = y11 - topleft_y_frac;
#if 0
			printf("j: %d\ti:%d\n", j, i);
			printf("offset: %d\n", s.in_addr_offset);
			printf("relative_x[0]: %d\n", s.relative_x[0]);
			printf("relative_x[1]: %d\n", s.relative_x[1]);
			printf("relative_x[2]: %d\n", s.relative_x[2]);
			printf("relative_x[3]: %d\n", s.relative_x[3]);
			printf("relative_y[0]: %d\n", s.relative_y[0]);
			printf("relative_y[1]: %d\n", s.relative_y[1]);
			printf("relative_y[2]: %d\n", s.relative_y[2]);
			printf("relative_y[3]: %d\n", s.relative_y[3]);
			printf("relative_x_nofrac[0]: %d\n", s.relative_x[0]>>DVS_COORD_FRAC_BITS);
			printf("relative_x_nofrac[1]: %d\n", s.relative_x[1]>>DVS_COORD_FRAC_BITS);
			printf("relative_x_nofrac[2]: %d\n", s.relative_x[2]>>DVS_COORD_FRAC_BITS);
			printf("relative_x_nofrac[3]: %d\n", s.relative_x[3]>>DVS_COORD_FRAC_BITS);
			printf("relative_y_nofrac[0]: %d\n", s.relative_y[0]>>DVS_COORD_FRAC_BITS);
			printf("relative_y_nofrac[1]: %d\n", s.relative_y[1]>>DVS_COORD_FRAC_BITS);
			printf("relative_y_nofrac[2]: %d\n", s.relative_y[2]>>DVS_COORD_FRAC_BITS);
			printf("relative_y_nofrac[3]: %d\n", s.relative_y[3]>>DVS_COORD_FRAC_BITS);
			printf("\n");
#endif

			/* HMM STORE the struct "s" */
			mmgr_store(ddr_addr,
				   (void *)(&s),
				   sizeof(gdc_warp_param_mem_t));

			// storage format:
			// Y0 Y1 UV0 Y2 Y3 UV1
			if (uv_flag) {
				ddr_addr += DVS_6AXIS_COORDS_ELEMS * 3;
		}
			else {
        ddr_addr += DVS_6AXIS_COORDS_ELEMS * (1 + (i&1)); // increment with 2 incase x is odd, this to skip the uv position.
	}

}
	}
}

static void
store_dvs_6axis_config(
	const struct sh_css_binary *binary,
	hrt_vaddress ddr_addr_y)
{
	unsigned int i_width;
	unsigned int o_width;
	unsigned int o_height;

	assert(binary != NULL);
	if (binary == NULL)
		return;

	i_width  = binary->in_frame_info.width;
	o_width  = binary->out_frame_info.width;
	o_height = binary->out_frame_info.height;

	assert(ddr_addr_y != mmgr_NULL);

	if (!dvs_6axis_config) {
/* Checkpatch patch */
		return;
	}
	/* Y plane */
	convert_coords_to_ispparams(ddr_addr_y, dvs_6axis_config
					, i_width, o_width, o_height, 0);
	/* UV plane (packed inside the y plane) */
	convert_coords_to_ispparams(ddr_addr_y, dvs_6axis_config
					, i_width/2, o_width/2, o_height/2, 1);

	isp_params_changed = true;
}
/* ****************************************************
 * Each coefficient is stored as 7bits to fit 2 of them into one
 * ISP vector element, so we will store 4 coefficents on every
 * memory word (32bits)
 *
 * 0: Coefficient 0 used bits
 * 1: Coefficient 1 used bits
 * 2: Coefficient 2 used bits
 * 3: Coefficient 3 used bit3
 * x: not used
 *
 * xx33333332222222 | xx11111110000000
 *
 * ***************************************************
 */
static void
store_fpntbl(hrt_vaddress ptr)
{
	unsigned int i, j;
	short *data_ptr = fpn_table.data;

	assert(ptr != mmgr_NULL);

	for (i = 0; i < fpn_table.height; i++) {
		for (j = 0;
		     j < fpn_table.width;
		     j += 4, ptr += 4, data_ptr += 4) {
			int data = data_ptr[0] << 0 |
				   data_ptr[1] << 7 |
				   data_ptr[2] << 16 |
				   data_ptr[3] << 23;
			mmgr_store(ptr, (void *)(&data), sizeof(data));
		}
	}
}

static void
convert_raw_to_fpn(void)
{
	short maxval = 0;
	unsigned int i;

	/* Find the maximum value in the table */
	for (i = 0; i < fpn_table.height * fpn_table.width; i++) {
		short val = fpn_table.data[i];
		/* Make sure FPN value can be represented in 13-bit unsigned
		 * number (ISP precision - 1), but note that actual input range
		 * depends on precision of input frame data.
		 */
		if (val < 0) {
/* Checkpatch patch */
			val = 0;
		} else if (val >= (1 << 13)) {
/* Checkpatch patch */
/* MW: BUG, is "13" a system or application property */
			val = (1 << 13) - 1;
		}
		maxval = max(maxval, val);
	}
	/* Find the lowest shift value to remap the values in the range
	 * 0..maxval to 0..2^shiftval*63.
	 */
	fpn_table.shift = 0;
	while (maxval > 63) {
/* MW: BUG, is "63" a system or application property */
		maxval /= 2;
		fpn_table.shift++;
	}
	/* Adjust the values in the table for the shift value */
	for (i = 0; i < fpn_table.height * fpn_table.width; i++)
		((unsigned short *) fpn_table.data)[i] >>= fpn_table.shift;
}

enum sh_css_err
sh_css_set_black_frame(
	const struct sh_css_frame *raw_black_frame)
{
	/* this function desperately needs to be moved to the ISP or SP such
	 * that it can use the DMA.
	 */
	unsigned int height,
		     width,
		     y, x, k, data = 0;
	hrt_vaddress ptr;

	assert(raw_black_frame != NULL);
	if (raw_black_frame == NULL)
		return sh_css_err_internal_error;

	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_set_black_frame() enter: black_frame=%p\n",
		raw_black_frame);

	height = raw_black_frame->info.height;
	width = raw_black_frame->info.padded_width;
	ptr = raw_black_frame->data + raw_black_frame->planes.raw.offset;

	if (fpn_table.data &&
	    (fpn_table.width != width || fpn_table.height != height)) {
		sh_css_free(fpn_table.data);
		fpn_table.data = NULL;
	}
	if (fpn_table.data == NULL) {
		fpn_table.data = sh_css_malloc(height * width * sizeof(short));
		if (!fpn_table.data) {
	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_set_black_frame() leave: return_err=%d\n",
			sh_css_err_cannot_allocate_memory);
			return sh_css_err_cannot_allocate_memory;
		}
		fpn_table.width = width;
		fpn_table.height = height;
		fpn_table.shift = 0;
	}

	/* store raw to fpntbl */
	for (y = 0; y < height; y++) {
		for (x = 0; x < width; x += (ISP_VEC_NELEMS * 2)) {
			int ofs = y * width + x;
			for (k = 0; k < ISP_VEC_NELEMS; k += 2) {
				mmgr_load(ptr, (void *)(&data), sizeof(int));
				fpn_table.data[ofs + 2 * k] =
				    (short) (data & 0xFFFF);
				fpn_table.data[ofs + 2 * k + 2] =
				    (short) ((data >> 16) & 0xFFFF);
	ptr += sizeof(int);	/* byte system address */
			}
			for (k = 0; k < ISP_VEC_NELEMS; k += 2) {
				mmgr_load(ptr, (void *)(&data), sizeof(int));
				fpn_table.data[ofs + 2 * k + 1] =
				    (short) (data & 0xFFFF);
				fpn_table.data[ofs + 2 * k + 3] =
				    (short) ((data >> 16) & 0xFFFF);
	ptr += sizeof(int);	/* byte system address */
			}
		}
	}

	/* raw -> fpn */
	convert_raw_to_fpn();

	/* overwrite isp parameter */
	isp_parameters.fpn_shift = fpn_table.shift;
	isp_parameters.fpn_enabled = 1;
	fpn_table_changed = true;
	isp_params_changed = true;

	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_set_black_frame() leave: return_err=%d\n",
		sh_css_success);

	return sh_css_success;
}

bool
sh_css_params_set_binning_factor(unsigned int binning_fact)
{
/* assert(binning_fact > 0); true ?? */

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE,
		"sh_css_params_set_binning_factor() enter:\n");

	if (sensor_binning != binning_fact) {
		sensor_binning = binning_fact;
		sh_css_param_shading_table_changed_set(true);
	}

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE,
		"sh_css_params_set_binning_factor() leave:\n");

	return sh_css_param_shading_table_changed_get();
}

void
sh_css_params_set_raw_binning(bool needs_raw_binning)
{
	raw_binning = needs_raw_binning;
}

static void
sh_css_process_wb(void)
{
	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_process_wb() enter:\n");

	isp_parameters.wb_gain_shift =
	    uISP_REG_BIT - wb_config->integer_bits;
	isp_parameters.wb_gain_gr =
	    uDIGIT_FITTING(wb_config->gr, 16 - wb_config->integer_bits,
			   isp_parameters.wb_gain_shift);
	isp_parameters.wb_gain_r =
	    uDIGIT_FITTING(wb_config->r, 16 - wb_config->integer_bits,
			   isp_parameters.wb_gain_shift);
	isp_parameters.wb_gain_b =
	    uDIGIT_FITTING(wb_config->b, 16 - wb_config->integer_bits,
			   isp_parameters.wb_gain_shift);
	isp_parameters.wb_gain_gb =
	    uDIGIT_FITTING(wb_config->gb, 16 - wb_config->integer_bits,
			   isp_parameters.wb_gain_shift);
	isp_params_changed = true;
	wb_config_changed = false;

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_process_wb() leave:\n");
}

static void
sh_css_process_cc(void)
{
	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_process_cc() enter:\n");

	isp_parameters.csc_coef_shift    = (int) cc_config->fraction_bits;
	isp_parameters.yc1c2_to_ycbcr_00 = (int) cc_config->matrix[0];
	isp_parameters.yc1c2_to_ycbcr_01 = (int) cc_config->matrix[1];
	isp_parameters.yc1c2_to_ycbcr_02 = (int) cc_config->matrix[2];
	isp_parameters.yc1c2_to_ycbcr_10 = (int) cc_config->matrix[3];
	isp_parameters.yc1c2_to_ycbcr_11 = (int) cc_config->matrix[4];
	isp_parameters.yc1c2_to_ycbcr_12 = (int) cc_config->matrix[5];
	isp_parameters.yc1c2_to_ycbcr_20 = (int) cc_config->matrix[6];
	isp_parameters.yc1c2_to_ycbcr_21 = (int) cc_config->matrix[7];
	isp_parameters.yc1c2_to_ycbcr_22 = (int) cc_config->matrix[8];
	isp_params_changed = true;
	cc_config_changed = false;

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_process_cc() leave:\n");
}

static void
sh_css_process_tnr(void)
{
	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_process_tnr() enter:\n");

	isp_parameters.tnr_coef =
	    uDIGIT_FITTING(tnr_config->gain, 16, SH_CSS_TNR_COEF_SHIFT);
	isp_parameters.tnr_threshold_Y =
	    uDIGIT_FITTING(tnr_config->threshold_y, 16, SH_CSS_ISP_YUV_BITS);
	isp_parameters.tnr_threshold_C =
	    uDIGIT_FITTING(tnr_config->threshold_uv, 16, SH_CSS_ISP_YUV_BITS);
	isp_params_changed = true;
	tnr_config_changed = false;

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_process_tnr() leqave:\n");
}

static void
sh_css_process_ob(void)
{
	unsigned int raw_bit_depth = 16;

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_process_ob() enter:\n");

	switch (ob_config->mode) {
	case sh_css_ob_mode_fixed:
		if (current_3a_binary)
			raw_bit_depth
			  = current_3a_binary->in_frame_info.raw_bit_depth;
		isp_parameters.ob_blacklevel_gr
			= ob_config->level_gr >> (16 - raw_bit_depth);
		isp_parameters.ob_blacklevel_r
			= ob_config->level_r  >> (16 - raw_bit_depth);
		isp_parameters.ob_blacklevel_b
			= ob_config->level_b  >> (16 - raw_bit_depth);
		isp_parameters.ob_blacklevel_gb
			= ob_config->level_gb >> (16 - raw_bit_depth);
		isp_parameters.obarea_start_bq = 0;
		isp_parameters.obarea_length_bq = 0;
		isp_parameters.obarea_length_bq_inverse = 0;
		break;
	case sh_css_ob_mode_raster:
		isp_parameters.ob_blacklevel_gr = 0;
		isp_parameters.ob_blacklevel_r = 0;
		isp_parameters.ob_blacklevel_b = 0;
		isp_parameters.ob_blacklevel_gb = 0;
		isp_parameters.obarea_start_bq =
		    ob_config->start_position;
		isp_parameters.obarea_length_bq =
		    ((ob_config->end_position - ob_config->start_position) + 1);
		isp_parameters.obarea_length_bq_inverse =
		    (1 << 12) / isp_parameters.obarea_length_bq;
		break;
	default:
		isp_parameters.ob_blacklevel_gr = 0;
		isp_parameters.ob_blacklevel_r = 0;
		isp_parameters.ob_blacklevel_b = 0;
		isp_parameters.ob_blacklevel_gb = 0;
		isp_parameters.obarea_start_bq = 0;
		isp_parameters.obarea_length_bq = 0;
		isp_parameters.obarea_length_bq_inverse = 0;
		break;
	}
	isp_params_changed = true;
	ob_config_changed = false;

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_process_ob() leave:\n");
}

static void
sh_css_process_dp(void)
{
	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_process_dp() enter:\n");

	isp_parameters.dp_threshold_single_when_2adjacent_on =
	    SH_CSS_BAYER_MAXVAL;
	isp_parameters.dp_threshold_2adjacent_when_2adjacent_on =
	    uDIGIT_FITTING(dp_config->threshold, 16, SH_CSS_BAYER_BITS);
	isp_parameters.dp_threshold_single_when_2adjacent_off =
	    uDIGIT_FITTING(dp_config->threshold, 16, SH_CSS_BAYER_BITS);
	isp_parameters.dp_threshold_2adjacent_when_2adjacent_off =
	    SH_CSS_BAYER_MAXVAL;
	isp_parameters.dp_gain =
	    uDIGIT_FITTING(dp_config->gain, 8, SH_CSS_DP_GAIN_SHIFT);
	isp_params_changed = true;
	dp_config_changed = false;

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_process_dp() leave:\n");
}

static void
sh_css_process_nr_ee(void)
{
	int asiWk1, asiWk2, asiWk3;

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_process_nr_ee() enter:\n");

	/* BNR (Bayer Noise Reduction) */
	isp_parameters.bnr_threshold_low =
	    uDIGIT_FITTING(nr_config->direction, 16, SH_CSS_BAYER_BITS);
	isp_parameters.bnr_threshold_width_log2 = uFRACTION_BITS_FITTING(8);
	isp_parameters.bnr_threshold_width =
	    1 << isp_parameters.bnr_threshold_width_log2;
	isp_parameters.bnr_gain_all =
	    uDIGIT_FITTING(nr_config->bnr_gain, 16, SH_CSS_BNR_GAIN_SHIFT);
	isp_parameters.bnr_gain_dir =
	    uDIGIT_FITTING(nr_config->bnr_gain, 16, SH_CSS_BNR_GAIN_SHIFT);
	isp_parameters.bnr_clip = uDIGIT_FITTING(
					(unsigned)16384, 16, SH_CSS_BAYER_BITS);

	/* YNR (Y Noise Reduction), YEE (Y Edge Enhancement) */
	asiWk1 = (int) ee_config->gain;
	asiWk2 = asiWk1 / 8;
	asiWk3 = asiWk1 / 4;
	isp_parameters.ynr_threshold =
		uDIGIT_FITTING((unsigned)8192, 16, SH_CSS_BAYER_BITS);
	isp_parameters.ynr_gain_all =
	    uDIGIT_FITTING(nr_config->ynr_gain, 16, SH_CSS_YNR_GAIN_SHIFT);
	isp_parameters.ynr_gain_dir =
	    uDIGIT_FITTING(nr_config->ynr_gain, 16, SH_CSS_YNR_GAIN_SHIFT);
	isp_parameters.ynryee_dirthreshold_s =
	    min((uDIGIT_FITTING(nr_config->direction, 16, SH_CSS_BAYER_BITS)
				    << 1),
		SH_CSS_BAYER_MAXVAL);
	isp_parameters.ynryee_dirthreshold_g =
	    min((uDIGIT_FITTING(nr_config->direction, 16, SH_CSS_BAYER_BITS)
				    << 4),
		SH_CSS_BAYER_MAXVAL);
	isp_parameters.ynryee_dirthreshold_width_log2 =
	    uFRACTION_BITS_FITTING(8);
	isp_parameters.ynryee_dirthreshold_width =
	    1 << isp_parameters.ynryee_dirthreshold_width_log2;
	isp_parameters.yee_detailgain =
	    uDIGIT_FITTING(ee_config->detail_gain, 11,
			   SH_CSS_YEE_DETAIL_GAIN_SHIFT);
	isp_parameters.yee_coring_s =
	    (uDIGIT_FITTING((unsigned)56, 16, SH_CSS_BAYER_BITS) *
	     ee_config->threshold) >> 8;
	isp_parameters.yee_coring_g =
	    (uDIGIT_FITTING((unsigned)224, 16, SH_CSS_BAYER_BITS) *
	     ee_config->threshold) >> 8;
	/* 8; // *1.125 ->[s4.8] */
	isp_parameters.yee_scale_plus_s =
	    (asiWk1 + asiWk2) >> (11 - SH_CSS_YEE_SCALE_SHIFT);
	/* 8; // ( * -.25)->[s4.8] */
	isp_parameters.yee_scale_plus_g =
	    (0 - asiWk3) >> (11 - SH_CSS_YEE_SCALE_SHIFT);
	/* 8; // *0.875 ->[s4.8] */
	isp_parameters.yee_scale_minus_s =
	    (asiWk1 - asiWk2) >> (11 - SH_CSS_YEE_SCALE_SHIFT);
	/* 8; // ( *.25 ) ->[s4.8] */
	isp_parameters.yee_scale_minus_g =
	    (asiWk3) >> (11 - SH_CSS_YEE_SCALE_SHIFT);
	isp_parameters.yee_clip_plus_s =
	    uDIGIT_FITTING((unsigned)32760, 16, SH_CSS_BAYER_BITS);
	isp_parameters.yee_clip_plus_g = 0;
	isp_parameters.yee_clip_minus_s =
	    uDIGIT_FITTING((unsigned)504, 16, SH_CSS_BAYER_BITS);
	isp_parameters.yee_clip_minus_g =
	    uDIGIT_FITTING((unsigned)32256, 16, SH_CSS_BAYER_BITS);
	isp_parameters.ynryee_Yclip = SH_CSS_BAYER_MAXVAL;
	isp_params_changed = true;
	nr_config_changed = false;
	ee_config_changed = false;

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_process_nr_ee() leave:\n");
}

static void
sh_css_process_de(void)
{
	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_process_de() enter:\n");

	isp_parameters.de_pixelnoise =
	    uDIGIT_FITTING(de_config->pixelnoise, 16, SH_CSS_BAYER_BITS);
	isp_parameters.de_c1_coring_threshold =
	    uDIGIT_FITTING(de_config->c1_coring_threshold, 16,
			   SH_CSS_BAYER_BITS);
	isp_parameters.de_c2_coring_threshold =
	    uDIGIT_FITTING(de_config->c2_coring_threshold, 16,
			   SH_CSS_BAYER_BITS);
	isp_params_changed = true;
	de_config_changed = false;

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_process_de() leave:\n");
}

static void
sh_css_process_gc(void)
{
	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_process_gc() enter:\n");

	isp_parameters.gamma_gain_k1 =
	    uDIGIT_FITTING((int)gc_config->gain_k1, 16,
		SH_CSS_GAMMA_GAIN_K_SHIFT);
	isp_parameters.gamma_gain_k2 =
	    uDIGIT_FITTING((int)gc_config->gain_k2, 16,
		SH_CSS_GAMMA_GAIN_K_SHIFT);
	isp_params_changed = true;
	gc_config_changed = false;

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_process_gc() leave:\n");
}

static void
sh_css_process_anr(void)
{
	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_process_anr() enter:\n");

	isp_parameters.anr_threshold = anr_config->threshold;
	isp_params_changed = true;
	anr_config_changed = false;

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_process_anr() leave:\n");
}

static void
sh_css_process_ce(void)
{
	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_process_ce() enter:\n");

	isp_parameters.ce_uv_level_min = ce_config->uv_level_min;
	isp_parameters.ce_uv_level_max = ce_config->uv_level_max;
	isp_params_changed = true;
	ce_config_changed = false;

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_process_ce() leave:\n");
}

static void sh_css_process_zoom_and_motion(
	enum sh_css_pipe_id pipe_id,
	const struct sh_css_pipeline_stage *first_stage)
{
/* first_stage can be  NULL */
	const struct sh_css_pipeline_stage *stage;

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE,
		"sh_css_process_zoom_and_motion() enter:\n");

	/* Go through all stages to udate uds and cropping */
	for (stage = first_stage; stage; stage = stage->next) {

		struct sh_css_binary *binary;
		struct sh_css_binary tmp_binary;

		const struct sh_css_binary_info *info = NULL;

		binary = stage->binary;
		if (binary) {
			info = binary->info;
		} else {
			const struct sh_css_binary_args *args = &stage->args;
			info = &stage->firmware->info.isp;
			sh_css_fill_binary_info(info, false, false,
				SH_CSS_INPUT_FORMAT_RAW_10,
				args->in_frame  ? &args->in_frame->info  : NULL,
				args->out_frame ? &args->out_frame->info : NULL,
				args->out_vf_frame ? &args->out_vf_frame->info
									: NULL,
				&tmp_binary,
				false);
			binary = &tmp_binary;
			binary->info = info;
		}

		assert(stage->stage_num < SH_CSS_MAX_STAGES);
		sh_css_update_uds_and_crop_info(
			info,
			&binary->in_frame_info,
			&binary->out_frame_info,
			&binary->dvs_envelope,
			pipe_id == SH_CSS_PREVIEW_PIPELINE,
			&zoom_config,
			&motion_config,
			&isp_parameters.uds[stage->stage_num],
			&isp_parameters.sp_out_crop_pos[stage->stage_num]);
	}
	isp_params_changed = true;
	zoom_config_changed = false;
	motion_config_changed = false;

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE,
		"sh_css_process_zoom_and_motion() leave:\n");
}

static void
sh_css_process_ecd(void)
{
#if SH_CSS_ISP_PARAMS_VERSION == 2
	isp_parameters.ecd_zip_strength = ecd_config->ecd_zip_strength;
	isp_parameters.ecd_fc_strength  = ecd_config->ecd_fc_strength;
	isp_parameters.ecd_fc_debias    = ecd_config->ecd_fc_debias;
	isp_params_changed = true;
	ecd_config_changed = false;
#endif /* SH_CSS_ISP_PARAMS_VERSION == 2 */
}

static void
sh_css_process_ynr(void)
{
	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_process_ynr() enter:\n");

#if SH_CSS_ISP_PARAMS_VERSION == 2
	isp_parameters.yee_edge_sense_gain_0   = ynr_config->edge_sense_gain_0;
	isp_parameters.yee_edge_sense_gain_1   = ynr_config->edge_sense_gain_1;
	isp_parameters.yee_corner_sense_gain_0 = ynr_config->corner_sense_gain_0;
	isp_parameters.yee_corner_sense_gain_1 = ynr_config->corner_sense_gain_1;
	isp_params_changed = true;
	ynr_config_changed = false;
#endif /* SH_CSS_ISP_PARAMS_VERSION == 2 */

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_process_ynr() leave:\n");
}

static void
sh_css_process_fc(void)
{
	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_process_fc() enter:\n");

#if SH_CSS_ISP_PARAMS_VERSION == 2
	isp_parameters.fc_gain_exp   = fc_config->gain_exp;

	isp_parameters.fc_gain_pos_0 = fc_config->gain_pos_0;
	isp_parameters.fc_gain_pos_1 = fc_config->gain_pos_1;
	isp_parameters.fc_gain_neg_0 = fc_config->gain_neg_0;
	isp_parameters.fc_gain_neg_1 = fc_config->gain_neg_1;

	isp_parameters.fc_crop_pos_0 = fc_config->crop_pos_0;
	isp_parameters.fc_crop_pos_1 = fc_config->crop_pos_1;
	isp_parameters.fc_crop_neg_0 = fc_config->crop_neg_0;
	isp_parameters.fc_crop_neg_1 = fc_config->crop_neg_1;
	isp_params_changed = true;
	fc_config_changed = false;
#endif /* SH_CSS_ISP_PARAMS_VERSION == 2 */

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_process_fc() leave:\n");
}

static void
sh_css_process_cnr(void)
{
	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_process_cnr() enter:\n");

#if SH_CSS_ISP_PARAMS_VERSION == 2
	isp_parameters.cnr_coring_u = cnr_config->coring_u;
	isp_parameters.cnr_coring_v = cnr_config->coring_v;
	isp_parameters.cnr_sense_gain_vy = cnr_config->sense_gain_vy;
	isp_parameters.cnr_sense_gain_vu = cnr_config->sense_gain_vu;
	isp_parameters.cnr_sense_gain_vv = cnr_config->sense_gain_vv;
	isp_parameters.cnr_sense_gain_hy = cnr_config->sense_gain_hy;
	isp_parameters.cnr_sense_gain_hu = cnr_config->sense_gain_hu;
	isp_parameters.cnr_sense_gain_hv = cnr_config->sense_gain_hv;
	isp_params_changed = true;
	cnr_config_changed = false;
#endif /* SH_CSS_ISP_PARAMS_VERSION == 2 */

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_process_cnr() leave:\n");
}

static void
sh_css_process_macc(void)
{
	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_process_macc() enter:\n");

	isp_parameters.exp = macc_config->exp;
	isp_params_changed = true;
	macc_config_changed = false;

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_process_macc() leave:\n");
}

#if SH_CSS_ISP_PARAMS_VERSION == 2
static void ctc_gradient(
	int *dydx, int *shift,
	int y1, int y0, int x1, int x0)
{
	int frc_bits = max(SH_CSS_CTC_COEF_SHIFT, 16);
	int dy = y1 - y0;
	int dx = x1 - x0;
	int dydx_int = dy / dx;
	int dydx_frc = ((dy - dydx_int * dx) << frc_bits) / dx;
	int sft;

	/* max_dydx = the maxinum gradient = the maximum y (gain) */
	int max_dydx = (1 << SH_CSS_CTC_COEF_SHIFT) - 1;

	assert(y0 >= 0 && y0 <= max_dydx);
	assert(y1 >= 0 && y1 <= max_dydx);
	assert(x0 < x1);
	assert(dydx != NULL);
	if (dydx == NULL)
		return;

	assert(shift != NULL);
	if (shift == NULL)
		return;

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "ctc_gradient() enter:\n");

	/* search "sft" which meets this condition:
		   (1 << (SH_CSS_CTC_COEF_SHIFT - 1))
		<= (((float)dy / (float)dx) * (1 << sft))
		<= ((1 << SH_CSS_CTC_COEF_SHIFT) - 1) */
	for (sft = 0; sft <= SH_CSS_CTC_COEF_SHIFT; sft++) {
		int tmp_dydx = (dydx_int << sft)
			     + (dydx_frc >> (frc_bits - sft));
		if (tmp_dydx <= max_dydx) {
			*dydx = tmp_dydx;
			*shift = sft;
		}
		if (tmp_dydx >= max_dydx)
			break;
	}

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "ctc_gradient() leave:\n");
}
#endif /* SH_CSS_ISP_PARAMS_VERSION == 2 */

static void
sh_css_process_ctc(void)
{
	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_process_ctc() enter:\n");

#if SH_CSS_ISP_PARAMS_VERSION == 2
	isp_parameters.ctc_y0 = ctc_config->y0;
	isp_parameters.ctc_y1 = ctc_config->y1;
	isp_parameters.ctc_y2 = ctc_config->y2;
	isp_parameters.ctc_y3 = ctc_config->y3;
	isp_parameters.ctc_y4 = ctc_config->y4;
	isp_parameters.ctc_y5 = ctc_config->y5;

	isp_parameters.ctc_ce_gain_exp = ctc_config->ce_gain_exp;

	isp_parameters.ctc_x1 = ctc_config->x1;
	isp_parameters.ctc_x2 = ctc_config->x2;
	isp_parameters.ctc_x3 = ctc_config->x3;
	isp_parameters.ctc_x4 = ctc_config->x4;

	ctc_gradient(&isp_parameters.ctc_dydx0,
		     &isp_parameters.ctc_dydx0_shift,
		     ctc_config->y1, ctc_config->y0,
		     ctc_config->x1, 0);

	ctc_gradient(&isp_parameters.ctc_dydx1,
		     &isp_parameters.ctc_dydx1_shift,
		     ctc_config->y2, ctc_config->y1,
		     ctc_config->x2, ctc_config->x1);

	ctc_gradient(&isp_parameters.ctc_dydx2,
		     &isp_parameters.ctc_dydx2_shift,
		     ctc_config->y3, ctc_config->y2,
		     ctc_config->x3, ctc_config->x2);

	ctc_gradient(&isp_parameters.ctc_dydx3,
		     &isp_parameters.ctc_dydx3_shift,
		     ctc_config->y4, ctc_config->y3,
		     ctc_config->x4, ctc_config->x3);

	ctc_gradient(&isp_parameters.ctc_dydx4,
		     &isp_parameters.ctc_dydx4_shift,
		     ctc_config->y5, ctc_config->y4,
		     SH_CSS_BAYER_MAXVAL, ctc_config->x4);
	isp_params_changed = true;
	ctc_config_changed = false;
#endif /* SH_CSS_ISP_PARAMS_VERSION == 2 */

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_process_ctc() leave:\n");
}

static void
sh_css_process_xnr(void)
{
	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_process_xnr() enter:\n");
	isp_parameters.xnr_threshold = xnr_config->threshold;
	isp_params_changed = true;
	xnr_config_changed = false;

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_process_xnr() leave:\n");
}


static void
sh_css_process_aa(void)
{
	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_process_aa() enter:\n");
/* ISP 1.0 has a decimation filter for large input images */
	isp_parameters.aa_scale = aa_config->scale;
	isp_params_changed = true;
	aa_config_changed = false;

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_process_aa() leave:\n");
}

static void
sh_css_process_yuv2rgb_cc(void)
{
	sh_css_dtrace(SH_DBG_TRACE_PRIVATE,
		"sh_css_process_yuv2rgb_cc() enter:\n");

#if SH_CSS_ISP_PARAMS_VERSION == 2
	isp_parameters.ycgco_to_rgb_00 = (int) yuv2rgb_cc_config->matrix[0];
	isp_parameters.ycgco_to_rgb_01 = (int) yuv2rgb_cc_config->matrix[1];
	isp_parameters.ycgco_to_rgb_02 = (int) yuv2rgb_cc_config->matrix[2];
	isp_parameters.ycgco_to_rgb_10 = (int) yuv2rgb_cc_config->matrix[3];
	isp_parameters.ycgco_to_rgb_11 = (int) yuv2rgb_cc_config->matrix[4];
	isp_parameters.ycgco_to_rgb_12 = (int) yuv2rgb_cc_config->matrix[5];
	isp_parameters.ycgco_to_rgb_20 = (int) yuv2rgb_cc_config->matrix[6];
	isp_parameters.ycgco_to_rgb_21 = (int) yuv2rgb_cc_config->matrix[7];
	isp_parameters.ycgco_to_rgb_22 = (int) yuv2rgb_cc_config->matrix[8];
	isp_params_changed = true;
	yuv2rgb_cc_config_changed = false;
#endif /* SH_CSS_ISP_PARAMS_VERSION == 2 */

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE,
		"sh_css_process_yuv2rgb_cc() leave:\n");
}

static void
sh_css_process_rgb2yuv_cc(void)
{
	sh_css_dtrace(SH_DBG_TRACE_PRIVATE,
		"sh_css_process_rgb2yuv_cc() enter:\n");

#if SH_CSS_ISP_PARAMS_VERSION == 2
	isp_parameters.rgb_to_yuv_00 = (int) rgb2yuv_cc_config->matrix[0];
	isp_parameters.rgb_to_yuv_01 = (int) rgb2yuv_cc_config->matrix[1];
	isp_parameters.rgb_to_yuv_02 = (int) rgb2yuv_cc_config->matrix[2];
	isp_parameters.rgb_to_yuv_10 = (int) rgb2yuv_cc_config->matrix[3];
	isp_parameters.rgb_to_yuv_11 = (int) rgb2yuv_cc_config->matrix[4];
	isp_parameters.rgb_to_yuv_12 = (int) rgb2yuv_cc_config->matrix[5];
	isp_parameters.rgb_to_yuv_20 = (int) rgb2yuv_cc_config->matrix[6];
	isp_parameters.rgb_to_yuv_21 = (int) rgb2yuv_cc_config->matrix[7];
	isp_parameters.rgb_to_yuv_22 = (int) rgb2yuv_cc_config->matrix[8];
	isp_params_changed = true;
	rgb2yuv_cc_config_changed = false;
#endif /* SH_CSS_ISP_PARAMS_VERSION == 2 */

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE,
		"sh_css_process_rgb2yuv_cc() leave:\n");
}

void
sh_css_set_gamma_table(const struct sh_css_gamma_table *table)
{
/* table can be NULL */
	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_set_gamma_table() enter: table=%p\n",table);

	gamma_table = table;
	gamma_table_changed = true;

	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_set_gamma_table() leave: return_void\n");
}

void
sh_css_get_gamma_table(const struct sh_css_gamma_table **table)
{
	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_get_gamma_table() enter: table=%p\n",table);

	assert(table != NULL);
	if (table == NULL)
		return;

	*table = gamma_table;

	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_get_gamma_table() leave: *table=%p\n",*table);
}

void
sh_css_set_ctc_table(const struct sh_css_ctc_table *table)
{
/* table can be NULL */
	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_set_ctc_table() enter: table=%p\n",table);

	ctc_table = table;
	ctc_table_changed = true;

	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_set_ctc_table() leave: return_void\n");
}

void
sh_css_get_ctc_table(const struct sh_css_ctc_table **table)
{
	assert(table != NULL);
	if(table == NULL)
		return;

	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_ctc_table() enter: "
		"table=%p\n",table);

	*table = ctc_table;

	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_ctc_table() leave: "
		"*table=%p\n",*table);
}

void
sh_css_set_xnr_table(const struct sh_css_xnr_table *table)
{
/* table can be NULL */
	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_set_xnr_table() enter: table=%p\n",table);

	xnr_table = table;
	xnr_table_changed = true;

	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_set_xnr_table() leave: return_void\n");
}

void
sh_css_get_xnr_table(const struct sh_css_xnr_table **table)
{
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_xnr_table() enter: "
		"table=%p\n",table);

	assert(table != NULL);
	if (table == NULL)
		return;

	*table = xnr_table;

	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_xnr_table() leave: "
		"*table=%p\n",*table);
}

void
sh_css_set_macc_table(const struct sh_css_macc_table *table)
{
/* table can be NULL */
	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_set_macc_table() enter: table=%p\n",table);

	macc_table = table;
	macc_table_changed = true;

	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_set_macc_table() leave: return_void\n");
}

void
sh_css_get_macc_table(const struct sh_css_macc_table **table)
{
	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_get_macc_table() enter: table=%p\n",table);

	assert(table != NULL);
	if (table == NULL)
		return;

	*table = macc_table;

	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_get_macc_table() leave: *table=%p\n",*table);
}

void sh_css_morph_table_free(
	struct sh_css_morph_table *me)
{
	unsigned int i;

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE,
		"sh_css_morph_table_free() enter:\n");

	if (me == NULL) {
/* Checkpatch patch */
		return;
	}

	for (i = 0; i < SH_CSS_MORPH_TABLE_NUM_PLANES; i++) {
		if (me->coordinates_x[i])
			sh_css_free(me->coordinates_x[i]);
		if (me->coordinates_y[i])
			sh_css_free(me->coordinates_y[i]);
	}

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE,
		"sh_css_morph_table_free() leave:\n");

	sh_css_free(me);
}

struct sh_css_morph_table *sh_css_morph_table_allocate(
	unsigned int width,
	unsigned int height)
{
	unsigned int i;
	struct sh_css_morph_table *me = sh_css_malloc(sizeof(*me));

	sh_css_dtrace(SH_DBG_TRACE, "sh_css_morph_table_allocate() enter:\n");

	if (me == NULL) {
/* Checkpatch patch */
		return me;
	}

	for (i = 0; i < SH_CSS_MORPH_TABLE_NUM_PLANES; i++) {
		me->coordinates_x[i] = NULL;
		me->coordinates_y[i] = NULL;
	}

	for (i = 0; i < SH_CSS_MORPH_TABLE_NUM_PLANES; i++) {
		me->coordinates_x[i] =
		    sh_css_malloc(height * width *
				  sizeof(*me->coordinates_x[i]));
		me->coordinates_y[i] =
		    sh_css_malloc(height * width *
				  sizeof(*me->coordinates_y[i]));

		if ((me->coordinates_x[i] == NULL) ||
			(me->coordinates_y[i] == NULL)) {
/*
 * MW: Potential memory leak, need to free all previous pointers
 *
			sh_css_free(me->coordinates_x[i]);
			sh_css_free(me->coordinates_y[i]);
 */
			sh_css_morph_table_free(me);
			me = NULL;
			return me;
		}
	}
	me->width = width;
	me->height = height;

	sh_css_dtrace(SH_DBG_TRACE, "sh_css_morph_table_allocate() leave:\n");

	return me;
}

/* This function adds phase shift (1/2 pixel) to the color components. 
 * This is required as we are also doing upscale&interpolation in the GDC. */
static enum sh_css_err sh_css_params_morph_table_shift_phase(
	const struct sh_css_morph_table *in_table,
	const struct sh_css_binary *binary,
	struct sh_css_morph_table **out_table)
{
	// TODO: Remove the hardcoded value. Currently, there is
	// no defined GDC MACRO to use for all the systems.
	short shift_val = (1<<4) / 2;
	short phase_shift_x[SH_CSS_MORPH_TABLE_NUM_PLANES]
				= { 0, shift_val, 0, shift_val, shift_val, 0 },
	      phase_shift_y[SH_CSS_MORPH_TABLE_NUM_PLANES]
				= { shift_val, shift_val, 0, 0, 0, shift_val };
	unsigned int i, j, k,
		     width,
		     height;
	struct sh_css_morph_table *tab;

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE,
		"sh_css_params_morph_table_shift_phase() enter:\n");

	assert(in_table != NULL);
	if (in_table == NULL)
		return sh_css_err_internal_error;

	assert(binary != NULL);
	if (binary == NULL)
		return sh_css_err_internal_error;

	width = binary->morph_tbl_width,
	height = binary->morph_tbl_height;

	tab = sh_css_morph_table_allocate(width, height);
	if (tab == NULL)
		return sh_css_err_cannot_allocate_memory;

	for (i = 0; i < SH_CSS_MORPH_TABLE_NUM_PLANES; i++) {
		for (j = 0; j < height; j++) {
			unsigned short *in_x_ptr, *in_y_ptr,
				       *out_x_ptr, *out_y_ptr;
			in_x_ptr = &in_table->coordinates_x[i][j * width];
			in_y_ptr = &in_table->coordinates_y[i][j * width];
			out_x_ptr = &tab->coordinates_x[i][j * width];
			out_y_ptr = &tab->coordinates_y[i][j * width];
			for (k = 0; k < width; k++, in_x_ptr++, in_y_ptr++,
						out_x_ptr++, out_y_ptr++) {
				*out_x_ptr = *in_x_ptr + phase_shift_x[i];
				*out_y_ptr = *in_y_ptr + phase_shift_y[i];
			}
		}
	}
	*out_table = tab;

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE,
		"sh_css_params_morph_table_shift_phase() leave:\n");

	return sh_css_success;
}
static enum sh_css_err sh_css_params_default_morph_table(
	struct sh_css_morph_table **table,
	const struct sh_css_binary *binary)
{
/* MW 2400 advanced requires different scaling */
	unsigned int i, j, k,
		     step = (ISP_VEC_NELEMS / 16) * 128,
		     width,
		     height;
	struct sh_css_morph_table *tab;

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE,
		"sh_css_params_default_morph_table() enter:\n");

	assert(table != NULL);
	if (table == NULL)
		return sh_css_err_internal_error;

	assert(binary != NULL);
	if (binary == NULL)
		return sh_css_err_internal_error;

	width = binary->morph_tbl_width,
	height = binary->morph_tbl_height;

	tab = sh_css_morph_table_allocate(width, height);
	if (tab == NULL) {

		return sh_css_err_cannot_allocate_memory;
	}

	for (i = 0; i < SH_CSS_MORPH_TABLE_NUM_PLANES; i++) {
		short val_y = 0;
		for (j = 0; j < height; j++) {
			short val_x = 0;
			unsigned short *x_ptr, *y_ptr;

			x_ptr = &tab->coordinates_x[i][j * width];
			y_ptr = &tab->coordinates_y[i][j * width];
			for (k = 0; k < width;
			     k++, x_ptr++, y_ptr++, val_x += step) {
				*x_ptr = val_x;
				*y_ptr = val_y;

				// TODO: We might need to ensure that
				// the last grid in x&y direction is within
				// input space.
				//if (k==width-1)
				//	*x_ptr -= 4 * (1<<4);
				//if (j==height-1)
				//	*y_ptr -= 4 * (1<<4);
			}
			val_y += step;
		}
	}
	*table = tab;

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE,
		"sh_css_params_default_morph_table() leave:\n");

	return sh_css_success;
}

void
sh_css_invalidate_morph_table(void)
{
	sh_css_dtrace(SH_DBG_TRACE_PRIVATE,
		"sh_css_invalidate_morph_table() enter:\n");

	morph_table_changed = true;

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE,
		"sh_css_invalidate_morph_table() leave:\n");
}

void
sh_css_set_morph_table(const struct sh_css_morph_table *table)
{
/* table can be NULL */
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_morph_table() enter: "
		"table=%p\n",table);

	morph_table = table;
	morph_table_changed = true;
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_morph_table() leave: "
		"return_void\n");
}

void
sh_css_get_morph_table(const struct sh_css_morph_table **table)
{
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_morph_table() enter: "
		"table=%p\n",table);

	assert(table != NULL);
	if (table == NULL)
		return;

	*table = morph_table;

	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_morph_table() leave: "
		"*table=%p\n",*table);

}

enum sh_css_err sh_css_get_3a_statistics(
	struct sh_css_3a_output *output,
	bool use_dmem,
	union sh_css_s3a_data *s3a_data)
{
	/* rvanimme: s3a_data is referenced in this function, so cannot be null */
	/* But there are test cases that calls this function with NULL */
	/* This is considered a BUG (see CR 2344). For now comment out assert */
	/* assert(s3a_data != NULL); */
	if(s3a_data == NULL)
		return sh_css_err_internal_error;
	assert(output != NULL);
	if(output == NULL)
		return sh_css_err_internal_error;

	if (current_3a_binary == NULL) {
		return sh_css_err_internal_error;
	}

	if (s3a_data == NULL) {
	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_get_3a_statistics() enter: "
		"s3a_data=%p\n",
		s3a_data);
	} else {
	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_get_3a_statistics() enter: "
		"use_dmem=%d, s3a_data.d=%x, "
		"s3a_data.v.hi=%x, s3a_data.v.lo=%x\n",
		use_dmem, s3a_data->dmem.s3a_tbl,
		s3a_data->vmem.s3a_tbl_hi,s3a_data->vmem.s3a_tbl_lo);
	}

	if (use_dmem) {
		get_3a_stats_from_dmem(output, s3a_data->dmem.s3a_tbl);
	} else {
		get_3a_stats_from_vmem(output, s3a_data->vmem.s3a_tbl_hi,
						s3a_data->vmem.s3a_tbl_lo);
	}

	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_get_3a_statistics() leave: return=%d\n",sh_css_success);

	return sh_css_success;
}

void sh_css_set_3a_config(
	const struct sh_css_3a_config *config)
{
	assert(config != NULL);
	if (config == NULL)
		return;

	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_3a_config() enter: "
		"config.ae_y_coef_r=%d, config.ae_y_coef_g=%d, "
		"config.ae_y_coef_b=%d, config.awb_lg_high_raw=%d, "
		"config.awb_lg_low=%d, config.awb_lg_high=%d\n",
		config->ae_y_coef_r, config->ae_y_coef_g,
		config->ae_y_coef_b, config->awb_lg_high_raw,
		config->awb_lg_low, config->awb_lg_high);


	s3a_config = config;
	s3a_config_changed = true;

	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_set_3a_config() leave: return_void\n");
}

void sh_css_get_3a_config(
	const struct sh_css_3a_config **config)
{
 	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_3a_config() enter: "
				"config=%p\n",config);

	assert(config != NULL);
	if (config == NULL)
		return;

	*config = s3a_config;

	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_3a_config() leave: "
		"config.ae_y_coef_r=%d, config.ae_y_coef_g=%d, "
		"config.ae_y_coef_b=%d, config.awb_lg_high_raw=%d, "
		"config.awb_lg_low=%d,  config.awb_lg_high=%d\n",
		(*config)->ae_y_coef_r, (*config)->ae_y_coef_g,
		(*config)->ae_y_coef_b, (*config)->awb_lg_high_raw,
		(*config)->awb_lg_low, (*config)->awb_lg_high);
}

void sh_css_set_wb_config(
	const struct sh_css_wb_config *config)
{
/* config can be NULL */

	if (config != NULL) {
/* Checkpatch patch */
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_wb_config() enter: "
		"config.integer_bits=%d, config.gr=%d, config.r=%d, "
		"config.b=%d, config.gb=%d\n",
		config->integer_bits,
		config->gr, config->r,
		config->b, config->gb);
		wb_config = config;
	} else {
/* Checkpatch patch */
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_wb_config() enter: "
		"config=%p\n",config);
		wb_config = &disabled_wb_config;
	}
	wb_config_changed = true;

	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_set_wb_config() leave: "
		"return_void\n");
}

void sh_css_get_wb_config(
	const struct sh_css_wb_config **config)
{
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_wb_config() enter: "
		"config=%p\n",config);

	assert(config != NULL);
	if (config == NULL)
		return;

	*config = wb_config;

	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_wb_config() leave: "
		"config.integer_bits=%d, "
		"config.gr=%d, config.r=%d, "
		"config.b=%d,  config.gb=%d\n",
		(*config)->integer_bits,
		(*config)->gr, (*config)->r,
		(*config)->b, (*config)->gb);
}

void sh_css_set_cc_config(
	const struct sh_css_cc_config *config)
{
/* config can be NULL */

	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_cc_config()\n");

	if (config != NULL) {
/* Checkpatch patch */
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_cc_config() enter: "
		"config.fraction_bits=%d, config.m[0]=%d, "
		"config.m[1]=%d, config.m[2]=%d, "
		"config.m[3]=%d, config.m[4]=%d, "
		"config.m[5]=%d, config.m[6]=%d, "
		"config.m[7]=%d, config.m[8]=%d\n",
		config->fraction_bits, config->matrix[0],
		config->matrix[1], config->matrix[2],
		config->matrix[3], config->matrix[4],
		config->matrix[5], config->matrix[6],
		config->matrix[7], config->matrix[8]);
		cc_config = config;
	} else {
/* Checkpatch patch */
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_cc_config() enter: "
		"config=%p\n",config);
		cc_config = &disabled_cc_config;
	}

	cc_config_changed = true;

	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_set_cc_config() leave: "
		"return_void\n");
}

void sh_css_get_cc_config(
	const struct sh_css_cc_config **config)
{
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_cc_config() enter: "
		"config=%p\n",config);

	assert(config != NULL);
	if (config == NULL)
		return;

	*config = cc_config;

	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_cc_config() leave: "
		"config.fraction_bits=%d, config.m[0]=%d, "
		"config.m[1]=%d, config.m[2]=%d, "
		"config.m[3]=%d, config.m[4]=%d, "
		"config.m[5]=%d, config.m[6]=%d, "
		"config.m[7]=%d, config.m[8]=%d\n",
		(*config)->fraction_bits, (*config)->matrix[0],
		(*config)->matrix[1], (*config)->matrix[2],
		(*config)->matrix[3], (*config)->matrix[4],
		(*config)->matrix[5], (*config)->matrix[6],
		(*config)->matrix[7], (*config)->matrix[8]);
}

void sh_css_set_tnr_config(
	const struct sh_css_tnr_config *config)
{
/* config can be NULL */

	if (config != NULL) {
/* Checkpatch patch */
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_tnr_config() enter: "
		"config.gain=%d, config.threshold_y=%d, "
		"config.threshold_uv=%d\n",
		config->gain,
		config->threshold_y, config->threshold_uv);
		tnr_config = config;
	} else {
/* Checkpatch patch */
	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_set_tnr_config() enter: config=%p\n",config);
		tnr_config = &disabled_tnr_config;
	}

	tnr_config_changed = true;

	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_set_tnr_config() leave: return_void\n");
}

void sh_css_get_tnr_config(
	const struct sh_css_tnr_config **config)
{
	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_get_tnr_config() enter: config=%p\n",config);

	assert(config != NULL);
	if (config == NULL)
		return;

	*config = tnr_config;

	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_get_tnr_config() leave: config.gain=%d, "
		"config.threshold_y=%d, config.threshold_uv=%d\n",
		(*config)->gain,
		(*config)->threshold_y,(*config)->threshold_uv);
}

void sh_css_set_ob_config(
	const struct sh_css_ob_config *config)
{
/* config can be NULL */

	if (config != NULL) {
/* Checkpatch patch */
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_ob_config() enter: "
		"config.mode=%d, config.level_gr=%d, config.level_r=%d, "
		"config.level_b=%d,  config.level_gb=%d, "
		"config.start_position=%d, config.end_position=%d\n",
		config->mode,
		config->level_gr, config->level_r,
		config->level_b, config->level_gb,
		config->start_position, config->end_position);

		ob_config = config;
	} else {
/* Checkpatch patch */
	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_set_ob_config() enter: config=%p\n",config);
		ob_config = &disabled_ob_config;
	}
	ob_config_changed = true;

	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_set_ob_config() leave: return_void\n");
}

void sh_css_get_ob_config(
	const struct sh_css_ob_config **config)
{
	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_get_ob_config() enter: config=%p\n",config);

	assert(config != NULL);
	if (config == NULL)
		return;

	*config = ob_config;

	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_ob_config() leave: "
		"config.mode=%d, config.level_gr=%d, config.level_r=%d, "
		"config.level_b=%d, config.level_gb=%d, "
		"config.start_position=%d, config.end_position=%d\n",
		(*config)->mode,
		(*config)->level_gr, (*config)->level_r,
		(*config)->level_b, (*config)->level_gb,
		(*config)->start_position,(*config)->end_position);
}

void sh_css_set_dp_config(const struct sh_css_dp_config *config)
{
/* config can be NULL */

	if (config != NULL) {
/* Checkpatch patch */
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_dp_config() enter: "
		"config.threshold=%d, config.gain=%d\n",
		config->threshold, config->gain);
		dp_config = config;
	} else {
/* Checkpatch patch */
	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_set_dp_config() enter: config=%p\n",config);
		dp_config = &disabled_dp_config;
	}
	dp_config_changed = true;

	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_set_ob_config() leave: return_void\n");
}

void sh_css_get_dp_config(
	const struct sh_css_dp_config **config)
{
	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_get_dp_config() enter: config=%p\n",config);

	assert(config != NULL);
	if (config == NULL)
		return;

	*config = dp_config;

	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_dp_config() enter: "
		"config.threshold=%d, config.gain=%d\n",
		(*config)->threshold, (*config)->gain);
}

void sh_css_set_nr_config(
	const struct sh_css_nr_config *config)
{
/* config can be NULL */

	if (config != NULL) {
/* Checkpatch patch */
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_nr_config() enter: "
		"config.direction=%d, "
		"config.bnr_gain=%d, config.ynr_gain=%d, "
		"config.threshold_cb=%d, config.threshold_cr=%d\n",
		config->direction,
		config->bnr_gain, config->ynr_gain,
		config->threshold_cb, config->threshold_cr);
		nr_config = config;
	} else {
/* Checkpatch patch */
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_nr_config() enter: "
		"config=%p\n",config);
		nr_config = &disabled_nr_config;
	}
	nr_config_changed = true;

	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_set_nr_config() leave: "
		"return_void\n");
}

void sh_css_get_nr_config(
	const struct sh_css_nr_config **config)
{
	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_get_nr_config() enter: config=%p\n",config);

	assert(config != NULL);
	if (config == NULL)
		return;

	*config = nr_config;

	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_get_nr_config() leave: config.direction=%d, "
		"config.bnr_gain=%d, config.ynr_gain=%d, "
		"config.threshold_cb=%d, config.threshold_cr=%d\n",
		(*config)->direction,
		(*config)->bnr_gain, (*config)->ynr_gain,
		(*config)->threshold_cb, (*config)->threshold_cr);
}

void sh_css_set_ee_config(
	const struct sh_css_ee_config *config)
{
/* config can be NULL */

	if (config != NULL) {
/* Checkpatch patch */
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_ee_config() enter: "
		"config.threshold=%d, "
		"config.gain=%d, config.detail_gain=%d\n",
		config->threshold,
		config->gain, config->detail_gain);
		ee_config = config;
	} else {
/* Checkpatch patch */
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_ee_config() enter: "
		"config=%p\n",config);
		ee_config = &disabled_ee_config;
	}
	ee_config_changed = true;

	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_set_ee_config() leave: "
		"return_void\n");
}

void sh_css_get_ee_config(
	const struct sh_css_ee_config **config)
{
	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_get_ee_config() enter: config=%p\n",config);

	assert(config != NULL);
	if (config == NULL)
		return;

	*config = ee_config;

	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_ee_config() enter: "
		"config.threshold=%d, config.gain=%d, config.detail_gain=%d\n",
		(*config)->threshold,
		(*config)->gain, (*config)->detail_gain);
}

void sh_css_set_de_config(
	const struct sh_css_de_config *config)
{
/* config can be NULL */

	if (config != NULL) {
/* Checkpatch patch */
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_de_config() enter: "
		"config.pixelnoise=%d, "
		"config.c1_coring_threshold=%d, config.c2_coring_threshold=%d\n",
		config->pixelnoise,
		config->c1_coring_threshold, config->c2_coring_threshold);
		de_config = config;
	} else {
/* Checkpatch patch */
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_de_config() enter: "
		"config=%p\n",config);
		de_config = &disabled_de_config;
	}
	de_config_changed = true;

	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_set_de_config() leave: "
		"return_void\n");
}

void sh_css_get_de_config(
	const struct sh_css_de_config **config)
{
	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_get_de_config() enter: config=%p\n",config);

	assert(config != NULL);
	if (config == NULL)
		return;

	*config = de_config;

	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_de_config() leave: "
		"config.pixelnoise=%d, config.c1_coring_threshold=%d, "
		"config.c2_coring_threshold=%d\n",
		(*config)->pixelnoise,
		(*config)->c1_coring_threshold, (*config)->c2_coring_threshold);
}

void sh_css_set_gc_config(const struct sh_css_gc_config *config)
{
/* config can be NULL */

	if (config != NULL) {
/* Checkpatch patch */
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_gc_config() enter: "
		"config.gain_k1=%d, config.gain_k2=%d\n",
		config->gain_k1, config->gain_k2);
		gc_config = config;
	} else {
/* Checkpatch patch */
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_gc_config() enter: "
		"config=%p\n",config);
		gc_config = &disabled_gc_config;
	}
	gc_config_changed = true;

	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_set_gc_config() leave: "
		"return_void\n");
}

void sh_css_get_gc_config(
	const struct sh_css_gc_config **config)
{
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_gc_config() enter: "
		"config=%p\n",config);

	assert(config != NULL);
	if (config == NULL)
		return;

	*config = gc_config;

	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_gc_config() leave: "
		"config.gain_k1=%d, config.gain_k2=%d\n",
		(*config)->gain_k1, (*config)->gain_k2);
}

void sh_css_set_anr_config(
	const struct sh_css_anr_config *config)
{
/* config can be NULL */

	if (config != NULL) {
/* Checkpatch patch */
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_anr_config() enter: "
		"config.threshold=%d\n",
		config->threshold);
		anr_config = config;
	} else {
/* Checkpatch patch */
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_anr_config() enter: "
		"config=%p\n",config);
		anr_config = &default_anr_config;
	}
	anr_config_changed = true;

	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_set_anr_config() leave: "
		"return_void\n");
}

void sh_css_get_anr_config(
	const struct sh_css_anr_config **config)
{
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_anr_config() enter: "
		"config=%p\n",config);

	assert(config != NULL);
	if (config == NULL)
		return;

	*config = anr_config;

	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_anr_config() leave: "
		"config.threshold=%d\n",
		(*config)->threshold);
}

void sh_css_set_ce_config(
	const struct sh_css_ce_config *config)
{
/* config can be NULL */

	if (config != NULL) {
/* Checkpatch patch */
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_ce_config() enter: "
		"config.uv_level_min=%d, config.uv_level_max=%d\n",
		config->uv_level_min, config->uv_level_max);
		ce_config = config;
	} else {
/* Checkpatch patch */
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_ce_config() enter: "
		"config=%p\n",config);
		ce_config = &default_ce_config;
	}
	ce_config_changed = true;

	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_set_ce_config() leave: "
		"return_void\n");
}

void sh_css_get_ce_config(
	const struct sh_css_ce_config **config)
{
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_ce_config() enter: "
		"config=%p\n",config);

	assert(config != NULL);
	if (config == NULL)
		return;

	*config = ce_config;

	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_ce_config() leave: "
		"config.uv_level_min=%d, config.uv_level_max=%d\n",
		(*config)->uv_level_min, (*config)->uv_level_max);
}


void sh_css_set_dvs_6axis_config(
	const struct sh_css_dvs_6axis_config *dvs_config)
{
/* config can be NULL */

	if (dvs_config != NULL) {
/* Structure to big to print its contents under a single line requirement */
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_dvs_config() enter: "
		"dvs_config=%p\n",dvs_config);
		dvs_6axis_config = dvs_config;
		dvs_6axis_config_changed = true;
	} else {
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_dvs_config() enter: "
		"dvs_config=%p\n",dvs_config);
	}

	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_set_dvs_6axis_config() leave: "
		"return_void\n");
}

void sh_css_get_dvs_6axis_config(
	const struct sh_css_dvs_6axis_config **dvs_config)
{

	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_dvs_6axis_config() enter: "
		"dvs_config=%p\n",dvs_config);

	assert(dvs_config != NULL);
	if (dvs_config == NULL)
		return;

	*dvs_config = dvs_6axis_config;

/* Structure to big to print its contents under a single line requirement */
	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_get_dvs_6axis_config() leave: "
		"return_void\n");
}

void sh_css_set_ecd_config(
	const struct sh_css_ecd_config *config)
{
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_ecd_config()\n");
	if (config != NULL) {
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_ynr_config() enter: "
		"config.ecd_zip_strength=%d, "
		"config.ecd_fc_strength=%d, config.ecd_fc_debias=%d\n",
		config->ecd_zip_strength,
		config->ecd_fc_strength, config->ecd_fc_debias);
		ecd_config = config;
	} else {
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_ecd_config() enter: "
		"config=%p\n",config);
		ecd_config = &default_ecd_config;
	}
	ecd_config_changed = true;

	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_ecd_config() leave: "
		"return_void\n");
return;
}

void sh_css_get_ecd_config(
	const struct sh_css_ecd_config **config)
{
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_ecd_config() enter: "
		"config=%p\n",config);

	assert(config != NULL);
	if (config == NULL)
		return;

	*config = ecd_config;

	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_ecd_config() enter: "
		"config.ecd_zip_strength=%d, "
		"config.ecd_fc_strength=%d, config.ecd_fc_debias=%d\n",
		(*config)->ecd_zip_strength,
		(*config)->ecd_fc_strength, (*config)->ecd_fc_debias);
return;
}

void sh_css_set_ynr_config(
	const struct sh_css_ynr_config *config)
{
/* config can be NULL */

	if (config != NULL) {
/* Checkpatch patch */
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_ynr_config() enter: "
		"config.edge_sense_gain_0=%d, config.edge_sense_gain_1=%d, "
		"config.corner_sense_gain_0=%d, config.corner_sense_gain_1=%d\n",
		config->edge_sense_gain_0, config->edge_sense_gain_1,
		config->corner_sense_gain_0, config->corner_sense_gain_1);
		ynr_config = config;
	} else {
/* Checkpatch patch */
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_ynr_config() enter: "
		"config=%p\n",config);
		ynr_config = &default_ynr_config;
	}
	ynr_config_changed = true;

	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_set_ynr_config() leave: "
		"return_void\n");
return;
}

void sh_css_get_ynr_config(
	const struct sh_css_ynr_config **config)
{
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_ynr_config() enter: "
		"config=%p\n",config);

	assert(config != NULL);
	if (config == NULL)
		return;

	*config = ynr_config;

	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_ynr_config() leave: "
		"config.edge_sense_gain_0=%d, config.edge_sense_gain_1=%d, "
		"config.corner_sense_gain_0=%d, config.corner_sense_gain_1=%d\n",
		(*config)->edge_sense_gain_0, (*config)->edge_sense_gain_1,
		(*config)->corner_sense_gain_0, (*config)->corner_sense_gain_1);
return;
}

void sh_css_set_fc_config(
	const struct sh_css_fc_config *config)
{
/* config can be NULL */

	if (config != NULL) {
/* Checkpatch patch */
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_fc_config() enter: "
		"config.gain_exp=%d, "
		"config.gain_pos_0=%d, config.gain_pos_1=%d, "
		"config.gain_neg_0=%d, config.gain_neg_1=%d, "
		"config.crop_pos_0=%d, config.crop_pos_1=%d, "
		"config.crop_neg_0=%d, config.crop_neg_1=%d\n",
		config->gain_exp,
		config->gain_pos_0, config->gain_pos_1,
		config->gain_neg_0, config->gain_neg_1,
		config->crop_pos_0, config->crop_pos_1,
		config->crop_neg_0, config->crop_neg_1);
		fc_config = config;
	} else {
/* Checkpatch patch */
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_fc_config() enter: "
		"config=%p\n",config);
		fc_config = &default_fc_config;
	}
	fc_config_changed = true;

	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_set_fc_config() leave: "
		"return_void\n");
return;
}

void sh_css_get_fc_config(
	const struct sh_css_fc_config **config)
{
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_fc_config() enter: "
		"config=%p\n",config);

	assert(config != NULL);
	if (config == NULL)
		return;

	*config = fc_config;

	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_fc_config() leave: "
		"config.gain_exp=%d, "
		"config.gain_pos_0=%d, config.gain_pos_1=%d, "
		"config.gain_neg_0=%d, config.gain_neg_1=%d, "
		"config.crop_pos_0=%d, config.crop_pos_1=%d, "
		"config.crop_neg_0=%d, config.crop_neg_1=%d\n",
		(*config)->gain_exp,
		(*config)->gain_pos_0, (*config)->gain_pos_1,
		(*config)->gain_neg_0, (*config)->gain_neg_1,
		(*config)->crop_pos_0, (*config)->crop_pos_1,
		(*config)->crop_neg_0, (*config)->crop_neg_1);
return;
}

void sh_css_set_cnr_config(
	const struct sh_css_cnr_config *config)
{
/* config can be NULL */

	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_cnr_config()\n");
	if (config != NULL) {
/* Checkpatch patch */
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_cnr_config() enter: "
		"config.coring_u=%d, config.coring_v=%d, "
		"config.sense_gain_vy=%d, config.sense_gain_hy=%d, "
		"config.sense_gain_vu=%d, config.sense_gain_hu=%d, "
		"config.sense_gain_vv=%d, config.sense_gain_hv=%d\n",
		config->coring_u, config->coring_v,
		config->sense_gain_vy, config->sense_gain_hy,
		config->sense_gain_vu, config->sense_gain_hu,
		config->sense_gain_vv, config->sense_gain_hv);
		cnr_config = config;
	} else {
/* Checkpatch patch */
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_cnr_config() enter: "
		"config=%p\n",config);
		cnr_config = &default_cnr_config;
	}
	cnr_config_changed = true;

	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_set_cnr_config() leave: "
		"return_void\n");
return;
}

void sh_css_get_cnr_config(
	const struct sh_css_cnr_config **config)
{
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_cnr_config() enter: "
		"config=%p\n",config);

	assert(config != NULL);
	if (config == NULL)
		return;

	*config = cnr_config;

	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_cnr_config() leave: "
		"config.coring_u=%d, config.coring_v=%d, "
		"config.sense_gain_vy=%d, config.sense_gain_hy=%d, "
		"config.sense_gain_vu=%d, config.sense_gain_hu=%d, "
		"config.sense_gain_vv=%d, config.sense_gain_hv=%d\n",
		(*config)->coring_u, (*config)->coring_v,
		(*config)->sense_gain_vy, (*config)->sense_gain_hy,
		(*config)->sense_gain_vu, (*config)->sense_gain_hu,
		(*config)->sense_gain_vv, (*config)->sense_gain_hv);
return;
}

void sh_css_set_macc_config(
	const struct sh_css_macc_config *config)
{
/* config can be NULL */

	if (config != NULL) {
/* Checkpatch patch */
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_macc_config() enter: "
		"config.exp=%d\n",
		config->exp);
		macc_config = config;
	} else {
/* Checkpatch patch */
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_macc_config() enter: "
		"config=%p\n",config);
		macc_config = &disabled_macc_config;
	}
	macc_config_changed = true;

	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_set_macc_config() leave: "
		"return_void\n");
return;
}

void sh_css_get_macc_config(
	const struct sh_css_macc_config **config)
{
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_macc_config() enter: "
		"config=%p\n",config);

	assert(config != NULL);
	if (config == NULL)
		return;

	*config = macc_config;

	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_macc_config() leave: "
		"config.exp=%d\n",
		(*config)->exp);
return;
}

void sh_css_set_ctc_config(
	const struct sh_css_ctc_config *config)
{
/* config can be NULL */

	if (config != NULL) {
/* Checkpatch patch */
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_ctc_config() enter: "
		"config.ce_gain_exp=%d, config.y0=%d, "
		"config.x1=%d, config.y1=%d, "
		"config.x2=%d, config.y2=%d, "
		"config.x3=%d, config.y3=%d, "
		"config.x4=%d, config.y4=%d\n",
		config->ce_gain_exp, config->y0,
		config->x1, config->y1,
		config->x2, config->y2,
		config->x3, config->y3,
		config->x4, config->y4);
		ctc_config = config;
	} else {
/* Checkpatch patch */
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_ctc_config() enter: "
		"config=%p\n",config);
		ctc_config = &default_ctc_config;
	}
	ctc_config_changed = true;

	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_set_ctc_config() leave: "
		"return_void\n");
return;
}

void sh_css_get_ctc_config(
	const struct sh_css_ctc_config **config)
{
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_ctc_config() enter: "
		"config=%p\n",config);

	assert(config != NULL);
	if (config == NULL)
		return;

	*config = ctc_config;

	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_ctc_config() leave: "
		"config.ce_gain_exp=%d, config.y0=%d, "
		"config.x1=%d, config.y1=%d, "
		"config.x2=%d, config.y2=%d, "
		"config.x3=%d, config.y3=%d, "
		"config.x4=%d, config.y4=%d\n",
		(*config)->ce_gain_exp, (*config)->y0,
		(*config)->x1, (*config)->y1,
		(*config)->x2, (*config)->y2,
		(*config)->x3, (*config)->y3,
		(*config)->x4, (*config)->y4);
return;
}

void
sh_css_set_xnr_config(const struct sh_css_xnr_config *config)
{
	if (xnr_config != NULL) {
		sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_xnr_config() enter: "
		"config.threshold=%d\n",
		config->threshold);
		xnr_config = config;
	} else {
		sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_xnr_config() enter: "
		"default_config.threshold=%d\n",
		default_xnr_config.threshold);
		xnr_config = &default_xnr_config;
	}

	xnr_config_changed = true;

	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_set_xnr_config() leave: "
		"return_void\n");
}

void
sh_css_get_xnr_config(const struct sh_css_xnr_config **config)
{
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_xnr_config() enter: "
		"config=%p\n",config);

	assert(config != NULL);
	if (config == NULL)
		return;

	*config = xnr_config;

	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_xnr_config() leave: "
		"config.threshold=%d\n",
		(*config)->threshold);
}


void sh_css_set_aa_config(
	const struct sh_css_aa_config *config)
{
/* config can be NULL */

	if (config != NULL) {
/* Checkpatch patch */
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_aa_config() enter: "
		"config.scale=%d\n",
		config->scale);
		aa_config = config;
	} else {
/* Checkpatch patch */
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_aa_config() enter: "
		"config=%p\n",config);
		aa_config = &default_aa_config;
	}
	aa_config_changed = true;

	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_set_aa_config() leave: "
		"return_void\n");
}

void sh_css_get_aa_config(
	const struct sh_css_aa_config **config)
{
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_aa_config() enter: "
		"config=%p\n",config);

	assert(config != NULL);
	if (config == NULL)
		return;

	*config = aa_config;

	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_aa_config() leave: "
		"config.scale=%d\n",
		(*config)->scale);
}

void sh_css_set_r_gamma_table(
	const struct sh_css_rgb_gamma_table *table)
{
/* table can be NULL */

	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_r_gamma_table() enter: "
		"table=%p\n",table);

	r_gamma_table = table;
	r_gamma_table_changed = true;

	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_set_r_gamma_table() leave: "
		"return_void\n");
}

void sh_css_get_r_gamma_table(
	const struct sh_css_rgb_gamma_table **table)
{
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_r_gamma_table() enter:\n");

	assert(table != NULL);
	if (table == NULL)
		return;

	*table = r_gamma_table;

	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_r_gamma_table() leave: "
		"*table=%p\n",*table);
}

void sh_css_set_g_gamma_table(
	const struct sh_css_rgb_gamma_table *table)
{
/* table can be NULL */

	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_g_gamma_table() enter: "
		"table=%p\n",table);

	g_gamma_table = table;
	g_gamma_table_changed = true;

	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_set_g_gamma_table() leave: "
		"return_void\n");
}

void sh_css_get_g_gamma_table(
	const struct sh_css_rgb_gamma_table **table)
{
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_g_gamma_table() enter:\n");

	assert(table != NULL);
	if (table == NULL)
		return;

	*table = g_gamma_table;

	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_g_gamma_table() leave: "
		"*table=%p\n",*table);
}

void sh_css_set_b_gamma_table(
	const struct sh_css_rgb_gamma_table *table)
{
/* table can be NULL */

	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_b_gamma_table() enter: "
		"table=%p\n",table);

	b_gamma_table = table;
	b_gamma_table_changed = true;

	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_set_b_gamma_table() leave: "
		"return_void\n");
}

void sh_css_get_b_gamma_table(
	const struct sh_css_rgb_gamma_table **table)
{
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_b_gamma_table() enter:\n");

	assert(table != NULL);
	if (table == NULL)
		return;

	*table = b_gamma_table;

	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_g_gamma_table() leave: "
		"*table=%p\n",*table);
}

void sh_css_set_yuv2rgb_cc_config(
	const struct sh_css_yuv2rgb_cc_config *config)
{
	if (config != NULL) {
/* Checkpatch patch */
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_yuv2rgb_cc_config() enter: "
		"config.m[0]=%d, "
		"config.m[1]=%d, config.m[2]=%d, "
		"config.m[3]=%d, config.m[4]=%d, "
		"config.m[5]=%d, config.m[6]=%d, "
		"config.m[7]=%d, config.m[8]=%d\n",
		config->matrix[0],
		config->matrix[1], config->matrix[2],
		config->matrix[3], config->matrix[4],
		config->matrix[5], config->matrix[6],
		config->matrix[7], config->matrix[8]);
		yuv2rgb_cc_config = config;
	} else {
/* Checkpatch patch */
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_yuv2rgb_cc_config() enter: "
		"config=%p\n",config);
		yuv2rgb_cc_config = &disabled_yuv2rgb_cc_config;
	}
	yuv2rgb_cc_config_changed = true;

	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_set_yuv2rgb_cc_config() leave: "
		"return_void\n");
}

void sh_css_get_yuv2rgb_cc_config(
	const struct sh_css_yuv2rgb_cc_config **config)
{
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_yuv2rgb_cc_config() enter:\n");

	assert(config != NULL);
	if (config == NULL)
		return;

	*config = yuv2rgb_cc_config;

	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_yuv2rgb_cc_config() leave: "
		"config.m[0]=%d, "
		"config.m[1]=%d, config.m[2]=%d, "
		"config.m[3]=%d, config.m[4]=%d, "
		"config.m[5]=%d, config.m[6]=%d, "
		"config.m[7]=%d, config.m[8]=%d\n",
		(*config)->matrix[0],
		(*config)->matrix[1], (*config)->matrix[2],
		(*config)->matrix[3], (*config)->matrix[4],
		(*config)->matrix[5], (*config)->matrix[6],
		(*config)->matrix[7], (*config)->matrix[8]);
}

void sh_css_set_rgb2yuv_cc_config(
	const struct sh_css_rgb2yuv_cc_config *config)
{
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_rgb2yuv_cc_config()\n");

	assert(config != NULL);
	if (config == NULL)
		return;

	sh_css_dtrace(SH_DBG_TRACE, "sh_css_set_rgb2yuv_cc_config() enter: "
		"config.m[0]=%d, "
		"config.m[1]=%d, config.m[2]=%d, "
		"config.m[3]=%d, config.m[4]=%d, "
		"config.m[5]=%d, config.m[6]=%d, "
		"config.m[7]=%d, config.m[8]=%d\n",
		config->matrix[0],
		config->matrix[1], config->matrix[2],
		config->matrix[3], config->matrix[4],
		config->matrix[5], config->matrix[6],
		config->matrix[7], config->matrix[8]);

	rgb2yuv_cc_config_changed = true;

	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_set_rgb2yuv_cc_config() leave: return_void\n");
}

void sh_css_get_rgb2yuv_cc_config(
	const struct sh_css_rgb2yuv_cc_config **config)
{
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_rgb2yuv_cc_config() enter:\n");

	assert(config != NULL);
	if (config == NULL)
		return;

	*config = rgb2yuv_cc_config;

	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_rgb2yuv_cc_config() leave: "
		"config.m[0]=%d, "
		"config.m[1]=%d, config.m[2]=%d, "
		"config.m[3]=%d, config.m[4]=%d, "
		"config.m[5]=%d, config.m[6]=%d, "
		"config.m[7]=%d, config.m[8]=%d\n",
		(*config)->matrix[0],
		(*config)->matrix[1], (*config)->matrix[2],
		(*config)->matrix[3], (*config)->matrix[4],
		(*config)->matrix[5], (*config)->matrix[6],
		(*config)->matrix[7], (*config)->matrix[8]);
}

/* TODO: make a direct implementation and remove the partial ones */
/* TODO: use pipe id, currently only one set available */
void sh_css_set_isp_config(
	enum sh_css_pipe_id pipe,
	const struct sh_css_isp_config *config)
{
	NOT_USED(pipe);

	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_set_isp_config() enter: pipe=%d, config=%p\n",
		pipe, config);

	assert(config != NULL);
	if (config == NULL)
		return;

	sh_css_set_wb_config(&config->wb_config);
	sh_css_set_cc_config(&config->cc_config);
	sh_css_set_tnr_config(&config->tnr_config);
	sh_css_set_ob_config(&config->ob_config);
	sh_css_set_dp_config(&config->dp_config);
	sh_css_set_nr_config(&config->nr_config);
	sh_css_set_ee_config(&config->ee_config);
	sh_css_set_de_config(&config->de_config);
	sh_css_set_gc_config(&config->gc_config);
	sh_css_set_ecd_config(&config->ecd_config);
	sh_css_set_ynr_config(&config->ynr_config);
	sh_css_set_fc_config(&config->fc_config);
	sh_css_set_cnr_config(&config->cnr_config);
	sh_css_set_macc_config(&config->macc_config);
	sh_css_set_ctc_config(&config->ctc_config);
	sh_css_set_aa_config(&config->aa_config);
	sh_css_set_yuv2rgb_cc_config(&config->yuv2rgb_cc_config);
	sh_css_set_rgb2yuv_cc_config(&config->rgb2yuv_cc_config);
	sh_css_set_anr_config(&config->anr_config);
	sh_css_set_3a_config(&config->s3a_config);
	sh_css_set_xnr_config(&config->xnr_config);
	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_set_isp_config() leave: return_void\n");
return;
}

/* TODO: make a direct implementation and remove the partial ones */
/* TODO: use pipe id, currently only one set available */
void sh_css_get_isp_config(
	enum sh_css_pipe_id pipe,
	const struct sh_css_isp_config **config)
{
	const struct sh_css_wb_config  *wb_config;
	const struct sh_css_cc_config  *cc_config;
	const struct sh_css_tnr_config *tnr_config;
	const struct sh_css_ob_config  *ob_config;
	const struct sh_css_dp_config  *dp_config;
	const struct sh_css_nr_config  *nr_config;
	const struct sh_css_ee_config  *ee_config;
	const struct sh_css_de_config  *de_config;
	const struct sh_css_gc_config  *gc_config;
	const struct sh_css_anr_config *anr_config;
	const struct sh_css_3a_config  *s3a_config;
	const struct sh_css_ecd_config *ecd_config;
	const struct sh_css_ynr_config *ynr_config;
	const struct sh_css_fc_config  *fc_config;
	const struct sh_css_cnr_config *cnr_config;
	const struct sh_css_macc_config *macc_config;
	const struct sh_css_ctc_config *ctc_config;
	const struct sh_css_aa_config  *aa_config;
	const struct sh_css_yuv2rgb_cc_config  *yuv2rgb_cc_config;
	const struct sh_css_rgb2yuv_cc_config  *rgb2yuv_cc_config;
	const struct sh_css_xnr_config *xnr_config;
	NOT_USED(pipe);

	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_isp_config() enter: "
		"pipe=%d, config=%p\n",pipe, config);

	assert(config != NULL);
	if (config == NULL)
		return;

	assert(*config != NULL);
	if (*config == NULL)
		return;

	sh_css_get_wb_config(&wb_config);
	((struct sh_css_isp_config *)*config)->wb_config = *wb_config;
	sh_css_get_cc_config(&cc_config);
	((struct sh_css_isp_config *)*config)->cc_config = *cc_config;
	sh_css_get_tnr_config(&tnr_config);
	((struct sh_css_isp_config *)*config)->tnr_config = *tnr_config;
	sh_css_get_ob_config(&ob_config);
	((struct sh_css_isp_config *)*config)->ob_config = *ob_config;
	sh_css_get_dp_config(&dp_config);
	((struct sh_css_isp_config *)*config)->dp_config = *dp_config;
	sh_css_get_nr_config(&nr_config);
	((struct sh_css_isp_config *)*config)->nr_config = *nr_config;
	sh_css_get_ee_config(&ee_config);
	((struct sh_css_isp_config *)*config)->ee_config = *ee_config;
	sh_css_get_de_config(&de_config);
	((struct sh_css_isp_config *)*config)->de_config = *de_config;
	sh_css_get_gc_config(&gc_config);
	((struct sh_css_isp_config *)*config)->gc_config = *gc_config;
	sh_css_get_anr_config(&anr_config);
	((struct sh_css_isp_config *)*config)->anr_config = *anr_config;
	sh_css_get_3a_config(&s3a_config);
	((struct sh_css_isp_config *)*config)->s3a_config = *s3a_config;
	sh_css_get_ecd_config(&ecd_config);
	((struct sh_css_isp_config *)*config)->ecd_config = *ecd_config;
	sh_css_get_ynr_config(&ynr_config);
	((struct sh_css_isp_config *)*config)->ynr_config = *ynr_config;
	sh_css_get_fc_config(&fc_config);
	((struct sh_css_isp_config *)*config)->fc_config = *fc_config;
	sh_css_get_cnr_config(&cnr_config);
	((struct sh_css_isp_config *)*config)->cnr_config = *cnr_config;
	sh_css_get_macc_config(&macc_config);
	((struct sh_css_isp_config *)*config)->macc_config = *macc_config;
	sh_css_get_ctc_config(&ctc_config);
	((struct sh_css_isp_config *)*config)->ctc_config = *ctc_config;
	sh_css_get_aa_config(&aa_config);
	((struct sh_css_isp_config *)*config)->aa_config = *aa_config;
	sh_css_get_yuv2rgb_cc_config(&yuv2rgb_cc_config);
	((struct sh_css_isp_config *)*config)->yuv2rgb_cc_config
		= *yuv2rgb_cc_config;
	sh_css_get_rgb2yuv_cc_config(&rgb2yuv_cc_config);
	((struct sh_css_isp_config *)*config)->rgb2yuv_cc_config
		= *rgb2yuv_cc_config;

	sh_css_get_xnr_config(&xnr_config);
	((struct sh_css_isp_config *)*config)->xnr_config = *xnr_config;

/* The struct pointers have no information, the functions themselves will print their parameters */
	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_get_isp_config() leave: "
		"return_void\n");
return;
}

void sh_css_set_zoom_factor(
	unsigned int dx,
	unsigned int dy)
{
	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_set_zoom_factor() enter: dx=%d, dy=%d\n", dx, dy);

	assert(dx <= HRT_GDC_N);
	assert(dy <= HRT_GDC_N);

	zoom_config = (struct sh_css_zoom){dx, dy};
	zoom_config_changed = true;
	isp_params_changed = true;

	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_set_zoom_factor() leave: "
		"return_void\n");
}

void sh_css_get_zoom_factor(
	unsigned int *dx,
	unsigned int *dy)
{
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_zoom_factor() enter:\n");

	assert(dx != NULL);
	if (dx == NULL)
		return;
	assert(dy != NULL);
	if (dy == NULL)
		return;

	*dx = zoom_config.dx;
	*dy = zoom_config.dy;

	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_get_zoom_factor() leave: dx=%d, dy=%d\n", *dx, *dy);
}

void sh_css_get_zoom(
	struct sh_css_zoom *zoom)
{
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_zoom() enter:\n");

	assert(zoom != NULL);
	if (zoom == NULL)
		return;

	*zoom = zoom_config;

	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_get_zoom() leave: dx=%d, dy=%d\n",
		zoom->dx, zoom->dy);
}

void sh_css_video_set_dis_vector(
	int x,
	int y)
{
	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_video_set_dis_vector() enter: x=%d, y=%d\n",
		x, y);

	motion_config.x = x;
	motion_config.y = y;

	motion_config_changed = true;
	isp_params_changed = true;

	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_video_set_dis_vector() leave: "
		"return_void\n");
}

void sh_css_get_dis_motion(
	struct sh_css_vector *motion)
{
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_get_dis_motion() enter\n");

	assert(motion != NULL);
	if (motion == NULL)
		return;

	*motion = motion_config;

	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_get_dis_motion() leave: x=%d, y=%d\n",
		motion->x, motion->y);
}

/*
 * coding style says the return of "mmgr_NULL" is the error signal
 *
 * Deprecated: Implement mmgr_realloc()
 */
static bool realloc_isp_css_mm_buf(
/* STORAGE_CLASS_INLINE bool realloc_isp_css_mm_buf( */
	hrt_vaddress *curr_buf, size_t *curr_size,
	size_t needed_size, bool force, enum sh_css_err *err,
	uint16_t	mmgr_attribute)
{
	int32_t id;
	*err = sh_css_success;
	/* Possible optimization: add a function sh_css_isp_css_mm_realloc()
	 * and implement on top of hmm. */

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "realloc_isp_css_mm_buf() enter:\n");

	if (!force && *curr_size >= needed_size) {
	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "realloc_isp_css_mm_buf() leave:\n");
		return false;
	}
	/* don't reallocate if single ref to buffer and same size */
	if (*curr_size == needed_size && sh_css_refcount_is_single(*curr_buf)) {
	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "realloc_isp_css_mm_buf() leave:\n");
		return false;
	}

	id = PARAM_BUFFER;//sh_css_refcount_get_id(*curr_buf);
	sh_css_refcount_release(id, *curr_buf);
	*curr_buf = sh_css_refcount_alloc(id, needed_size, mmgr_attribute);

	if (!*curr_buf) {
		*err = sh_css_err_cannot_allocate_memory;
		*curr_size = 0;
	} else {
		*curr_size = needed_size;
	}
	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "realloc_isp_css_mm_buf() leave:\n");
	return true;
}

static bool reallocate_buffer(
/* STORAGE_CLASS_INLINE bool reallocate_buffer( */
	hrt_vaddress *curr_buf,
	size_t *curr_size,
	size_t needed_size,
	bool force,
	enum sh_css_err *err)
{
	bool ret;
	uint16_t	mmgr_attribute = MMGR_ATTRIBUTE_DEFAULT;

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "reallocate_buffer() enter:\n");

	ret = realloc_isp_css_mm_buf(curr_buf,
		curr_size, needed_size, force, err, mmgr_attribute);

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "reallocate_buffer() leave:\n");
	return ret;
}

#if 0
static bool reallocate_cached_buffer(
/* STORAGE_CLASS_INLINE bool reallocate_cached_buffer( */
	hrt_vaddress *curr_buf,
	size_t *curr_size,
	size_t needed_size,
	enum sh_css_err *err)
{
	bool ret;
	uint16_t	mmgr_attribute = MMGR_ATTRIBUTE_DEFAULT |
		MMGR_ATTRIBUTE_CACHED;

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "reallocate_cached_buffer() enter:\n");

	ret = realloc_isp_css_mm_buf(curr_buf,
		curr_size, needed_size, false, err, mmgr_attribute);

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "reallocate_cached_buffer() leave:\n");

	return ret;
}
#endif

/* allocate 3A and DIS buffers */
enum sh_css_err sh_css_allocate_stat_buffers_from_info(
	union sh_css_s3a_data *s3a_ptr,
	struct sh_css_dis_data *dvs_ptr,
	const struct sh_css_grid_info *grid)
{
	enum sh_css_err err = sh_css_success;
	size_t s3a_table_size, dvs_hor_proj_size, dvs_ver_proj_size;
	const struct sh_css_3a_grid_info *s3a_grid;
	const struct sh_css_dvs_grid_info *dvs_grid;

	assert(grid != NULL);
	if (grid == NULL)
		return sh_css_err_internal_error;

	assert(s3a_ptr != NULL);
	if (s3a_ptr == NULL)
		return sh_css_err_internal_error;

	assert(dvs_ptr != NULL);
	if (dvs_ptr == NULL)
		return sh_css_err_internal_error;

	s3a_grid = &grid->s3a_grid;
	dvs_grid = &grid->dvs_grid;

	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_allocate_stat_buffers_from_info() "
		"enter: s3a_ptr=%p, dvs_ptr=%p, "
		"grid.isp_in_width=%d grid.isp_in_height=%d, "
		"grid.dvs_hor_coef_num=%d grid.dvs_ver_coef_num=%d\n",
		s3a_ptr, dvs_ptr,
		grid->isp_in_width, grid->isp_in_height,
		grid->dvs_hor_coef_num, grid->dvs_ver_coef_num);

	if (s3a_grid->enable && s3a_grid->use_dmem) {
		s3a_table_size =
			sizeof(struct sh_css_3a_output)
			  * s3a_grid->aligned_width
			  * s3a_grid->aligned_height;
			s3a_ptr->dmem.s3a_tbl = mmgr_malloc(s3a_table_size);
			if (!s3a_ptr->dmem.s3a_tbl) {
				err = sh_css_err_cannot_allocate_memory;
				return err;
			}
	}
	if (s3a_grid->enable && !s3a_grid->use_dmem) {
		s3a_table_size =
			ISP_S3ATBL_HI_LO_STRIDE_BYTES * s3a_grid->aligned_height;
		s3a_ptr->vmem.s3a_tbl_hi = mmgr_malloc(s3a_table_size);
		if (!s3a_ptr->vmem.s3a_tbl_hi) {
			err = sh_css_err_cannot_allocate_memory;
			return err;
		}
		s3a_ptr->vmem.s3a_tbl_lo = mmgr_malloc(s3a_table_size);
		if (!s3a_ptr->vmem.s3a_tbl_lo) {
			err = sh_css_err_cannot_allocate_memory;
			return err;
		}
	}
	if (dvs_grid->enable) {
		dvs_hor_proj_size =
			sizeof(int) * SH_CSS_DIS_NUM_COEF_TYPES
			* dvs_grid->aligned_height;
		dvs_ver_proj_size =
			sizeof(int) * SH_CSS_DIS_NUM_COEF_TYPES
			* dvs_grid->aligned_width;
		dvs_ptr->sdis_hor_proj = mmgr_malloc(dvs_hor_proj_size);
		if (!dvs_ptr->sdis_hor_proj) {
			err = sh_css_err_cannot_allocate_memory;
			return err;
		}
		dvs_ptr->sdis_ver_proj = mmgr_malloc(dvs_ver_proj_size);
		if (!dvs_ptr->sdis_hor_proj) {
/* MW: Memory leak */
			err = sh_css_err_cannot_allocate_memory;
			return err;
		}
	}

	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_allocate_stat_buffers_from_info() leave: "
		"return_err=%d\n",err);

	return err;
}

void sh_css_free_stat_buffers(
	union sh_css_s3a_data *s3a_ptr,
	struct sh_css_dis_data *dvs_ptr)
{
	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_free_stat_buffers() "
		"enter: s3a_ptr=%p, dvs_ptr=%p\n", s3a_ptr, dvs_ptr);

	if (s3a_ptr) {
		if (s3a_ptr->vmem.s3a_tbl_hi) {
			mmgr_free(s3a_ptr->vmem.s3a_tbl_hi);
		}
		if (s3a_ptr->vmem.s3a_tbl_lo) {
			mmgr_free(s3a_ptr->vmem.s3a_tbl_lo);
		}
	}
	if (dvs_ptr) {
		if (dvs_ptr->sdis_hor_proj) {
			mmgr_free(dvs_ptr->sdis_hor_proj);
		}
		if (dvs_ptr->sdis_ver_proj) {
			mmgr_free(dvs_ptr->sdis_ver_proj);
		}
	}

	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_free_stat_buffers() leave: "
		"return_void\n");
}

enum sh_css_err sh_css_params_init(void)
{
	bool succ = true;
	unsigned i, p;

	sh_css_dtrace(SH_DBG_TRACE, "sh_css_params_init() enter: void\n");

	for (i = 0; i < SH_CSS_NR_OF_PIPELINES; i++) {
		memset(&pipe_ddr_ptrs[i], 0,
			sizeof(pipe_ddr_ptrs[i]));
		memset(&pipe_ddr_ptrs_size[i], 0,
			sizeof(pipe_ddr_ptrs_size[i]));
	}

	memset(&ddr_ptrs, 0, sizeof(ddr_ptrs));
	memset(&ddr_ptrs_size, 0, sizeof(ddr_ptrs_size));

	ddr_ptrs_size.isp_param = sizeof(struct sh_css_isp_params);
	ddr_ptrs.isp_param = sh_css_refcount_alloc(PARAM_BUFFER,
				sizeof(struct sh_css_isp_params),
				MMGR_ATTRIBUTE_DEFAULT);
	succ &= (ddr_ptrs.isp_param != mmgr_NULL);

	ddr_ptrs_size.ctc_tbl = sizeof(struct sh_css_ctc_table);
	ddr_ptrs.ctc_tbl =  sh_css_refcount_alloc(PARAM_BUFFER,
				sizeof(struct sh_css_ctc_table),
				MMGR_ATTRIBUTE_DEFAULT);
	succ &= (ddr_ptrs.ctc_tbl != mmgr_NULL);

	ddr_ptrs_size.gamma_tbl = sizeof(struct sh_css_gamma_table);
	ddr_ptrs.gamma_tbl =  sh_css_refcount_alloc(PARAM_BUFFER,
				sizeof(struct sh_css_gamma_table),
				MMGR_ATTRIBUTE_DEFAULT);
	succ &= (ddr_ptrs.gamma_tbl != mmgr_NULL);

	ddr_ptrs_size.xnr_tbl = sizeof(struct sh_css_xnr_table);
	ddr_ptrs.xnr_tbl =  sh_css_refcount_alloc(PARAM_BUFFER,
				sizeof(struct sh_css_xnr_table),
				MMGR_ATTRIBUTE_DEFAULT);
	succ &= (ddr_ptrs.xnr_tbl != mmgr_NULL);

	ddr_ptrs_size.macc_tbl = sizeof(struct sh_css_macc_table);
	ddr_ptrs.macc_tbl = sh_css_refcount_alloc(PARAM_BUFFER,
				sizeof(struct sh_css_macc_table),
				MMGR_ATTRIBUTE_DEFAULT);
	succ &= (ddr_ptrs.macc_tbl != mmgr_NULL);

	ddr_ptrs_size.r_gamma_tbl = sizeof(struct sh_css_rgb_gamma_table);
	ddr_ptrs.r_gamma_tbl = sh_css_refcount_alloc(PARAM_BUFFER,
			sizeof(struct sh_css_rgb_gamma_table),
			MMGR_ATTRIBUTE_DEFAULT);
	succ &= (ddr_ptrs.r_gamma_tbl != mmgr_NULL);

	ddr_ptrs_size.g_gamma_tbl = sizeof(struct sh_css_rgb_gamma_table);
	ddr_ptrs.g_gamma_tbl = sh_css_refcount_alloc(PARAM_BUFFER,
			sizeof(struct sh_css_rgb_gamma_table),
			MMGR_ATTRIBUTE_DEFAULT);
	succ &= (ddr_ptrs.g_gamma_tbl != mmgr_NULL);

	ddr_ptrs_size.b_gamma_tbl = sizeof(struct sh_css_rgb_gamma_table);
	ddr_ptrs.b_gamma_tbl = sh_css_refcount_alloc(PARAM_BUFFER,
			sizeof(struct sh_css_rgb_gamma_table),
			MMGR_ATTRIBUTE_DEFAULT);
	succ &= (ddr_ptrs.b_gamma_tbl != mmgr_NULL);

	sp_ddr_ptrs = sh_css_refcount_alloc(-1,
			CEIL_MUL(sizeof(ddr_ptrs), HIVE_ISP_DDR_WORD_BYTES),
			MMGR_ATTRIBUTE_CLEARED);
	xmem_sp_group_ptrs = sh_css_refcount_alloc(-1,
					sizeof(struct sh_css_sp_group),
					MMGR_ATTRIBUTE_CLEARED);

	for (p = 0; p < SH_CSS_NR_OF_PIPELINES; p++) {
		for (i = 0; i < SH_CSS_MAX_STAGES; i++) {
			xmem_sp_stage_ptrs[p][i] =
					sh_css_refcount_alloc(-1,
					    sizeof(struct sh_css_sp_stage),
					    MMGR_ATTRIBUTE_CLEARED);
/* MW: memory leak, if you don't want a nice object_free(), then assert */
			if (xmem_sp_stage_ptrs[p][i] == mmgr_NULL)
				return sh_css_err_cannot_allocate_memory;
			xmem_isp_stage_ptrs[p][i] =
					sh_css_refcount_alloc(-1,
						sizeof(struct sh_css_isp_stage),
						MMGR_ATTRIBUTE_CLEARED);
/* MW: memory leak, if you don't want a nice object_free(), then assert */
			if (xmem_isp_stage_ptrs[p][i] == mmgr_NULL)
				return sh_css_err_cannot_allocate_memory;
		}
	}

	if (!succ || (sp_ddr_ptrs == mmgr_NULL) ||
		(xmem_sp_group_ptrs == mmgr_NULL)) {
		sh_css_uninit();
		return sh_css_err_cannot_allocate_memory;
	}
	sh_css_set_dvs_6axis_config(&default_dvs_6axis_config);
	sh_css_set_3a_config(&default_3a_config);
	sh_css_set_wb_config(&default_wb_config);
	sh_css_set_cc_config(&default_cc_config);
	sh_css_set_tnr_config(&default_tnr_config);
	sh_css_set_ob_config(&default_ob_config);
	sh_css_set_dp_config(&default_dp_config);
	sh_css_set_nr_config(&default_nr_config);
	sh_css_set_ee_config(&default_ee_config);
	sh_css_set_de_config(&default_de_config);
	sh_css_set_gc_config(&default_gc_config);
	sh_css_set_anr_config(&default_anr_config);
	sh_css_set_ce_config(&default_ce_config);
	sh_css_set_macc_table(&default_macc_table);
	sh_css_set_gamma_table(&default_gamma_table);
	sh_css_set_ctc_table(&default_ctc_table);
	sh_css_set_xnr_table(&default_xnr_table);
	sh_css_set_ecd_config(&default_ecd_config);
	sh_css_set_ynr_config(&default_ynr_config);
	sh_css_set_fc_config(&default_fc_config);
	sh_css_set_cnr_config(&default_cnr_config);
	sh_css_set_macc_config(&default_macc_config);
	sh_css_set_ctc_config(&default_ctc_config);
	sh_css_set_aa_config(&default_aa_config);
	sh_css_set_xnr_config(&default_xnr_config);
	sh_css_set_r_gamma_table(&default_r_gamma_table);
	sh_css_set_g_gamma_table(&default_g_gamma_table);
	sh_css_set_b_gamma_table(&default_b_gamma_table);
	sh_css_set_yuv2rgb_cc_config(&default_yuv2rgb_cc_config);
	sh_css_set_rgb2yuv_cc_config(&default_rgb2yuv_cc_config);
	gdc_lut_store(GDC0_ID, zoom_table);
	{
		unsigned i;
		for (i = 0; i < N_GDC_ID; i++)
			gdc_lut_store(i, zoom_table);
	}
	fpn_table_changed = true;
	isp_parameters.fpn_enabled = 0;
	morph_table = NULL;
	morph_table_changed = true;

	sh_css_param_shading_table_init();

	zoom_config = default_zoom_config;
	zoom_config_changed = true;
	motion_config = default_motion_config;
	motion_config_changed = true;

	/* now commit to ddr */
	sh_css_param_update_isp_params(false);

	/* create per pipe reference to general ddr_ptrs */
	for (i = 0; i < SH_CSS_NR_OF_PIPELINES; i++) {
		ref_sh_css_ddr_address_map(&ddr_ptrs, &pipe_ddr_ptrs[i]);
		pipe_ddr_ptrs_size[i] = ddr_ptrs_size;
	}

	sh_css_dtrace(SH_DBG_TRACE,
		"sh_css_params_init() leave: "
		"return_err=%d\n",sh_css_success);

	return sh_css_success;
}

void sh_css_params_reconfigure_gdc_lut(void)
{
	unsigned i;

	sh_css_dtrace(SH_DBG_TRACE, "sh_css_params_reconfigure_gdc_lut() enter: void\n");

	for (i = 0; i < N_GDC_ID; i++)
		gdc_lut_store(GDC0_ID, zoom_table);

	sh_css_dtrace(SH_DBG_TRACE, "sh_css_params_reconfigure_gdc_lut() leave: return_void\n");
}

static void free_map_callback(
	hrt_vaddress ptr)
{
	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "free_map_callback() enter:\n");

	free_sh_css_ddr_address_map(ptr);

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "free_map_callback() leave:\n");
}

static void free_buffer_callback(
	hrt_vaddress ptr)
{
	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "free_buffer_callback() enter:\n");

	mmgr_free(ptr);

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "free_buffer_callback() leave:\n");
}

void
sh_css_param_clear_param_sets(void)
{
	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_param_clear_param_sets() enter:\n");

	/* hmm_free all param_sets (and buffers) and the free-buffer cache */
	sh_css_refcount_clear(PARAM_SET_POOL, &free_map_callback);
	sh_css_refcount_clear(FREE_BUF_CACHE, NULL);

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_param_clear_param_sets() leave:\n");
}

/*
 * MW: we can define mmgr_free() to return a NULL
 * then you can write ptr = mmgr_free(ptr);
 */
#define safe_free(id, x)      \
	do {                  \
		sh_css_refcount_release(id, x);     \
		(x) = mmgr_NULL;  \
	} while (0)

static void free_map(struct sh_css_ddr_address_map *map)
{
	unsigned int i;

	hrt_vaddress *addrs = (hrt_vaddress *)map;

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "free_map() enter:\n");

	/* free buffers */
	for (i = 0; i < (sizeof(struct sh_css_ddr_address_map_size)/
						sizeof(size_t)); i++) {
		if (addrs[i] == mmgr_NULL)
			continue;
		safe_free(PARAM_BUFFER, addrs[i]);
	}

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "free_map() leave:\n");
}

void
sh_css_params_uninit(void)
{
	unsigned p, i;

	sh_css_dtrace(SH_DBG_TRACE, "sh_css_params_uninit() enter:\n");

	/* free existing ddr_ptr maps */
	for (i = 0; i < SH_CSS_NR_OF_PIPELINES; i++)
		free_map(&pipe_ddr_ptrs[i]);
	free_map(&ddr_ptrs);

	safe_free(-1, sp_ddr_ptrs);
	safe_free(-1, xmem_sp_group_ptrs);

	for (p = 0; p < SH_CSS_NR_OF_PIPELINES; p++)
		for (i = 0; i < SH_CSS_MAX_STAGES; i++) {
			safe_free(-1, xmem_sp_stage_ptrs[p][i]);
			safe_free(-1, xmem_isp_stage_ptrs[p][i]);
		}

	if (fpn_table.data)
		sh_css_free(fpn_table.data);

	/* go through the pools to clear references */
	sh_css_refcount_clear(PARAM_SET_POOL, &free_map_callback);
	sh_css_refcount_clear(PARAM_BUFFER, &free_buffer_callback);
	sh_css_refcount_clear(-1, &free_buffer_callback);
	sh_css_refcount_clear(FREE_BUF_CACHE, NULL);

	sh_css_dtrace(SH_DBG_TRACE, "sh_css_params_uninit() leave: return_void\n");
}

static void write_morph_plane(
	unsigned short *data,
	unsigned int width,
	unsigned int height,
	hrt_vaddress dest,
	unsigned int aligned_width)
{
	unsigned int i, padding, w;

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "write_morph_plane() enter:\n");

	/* currently we don't have morph table interpolation yet,
	 * so we allow a wider table to be used. This will be removed
	 * in the future. */
	if (width > aligned_width) {
		padding = 0;
		w = aligned_width;
	} else {
		padding = aligned_width - width;
		w = width;
	}

	for (i = 0; i < height; i++) {
		mmgr_store(dest, data, w * sizeof(short));
		dest += w * sizeof(short);
		mmgr_clear(dest, padding * sizeof(short));
		dest += padding * sizeof(short);
		data += width;
	}

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "write_morph_plane() leave:\n");
}

/* Store the DIS coefficients from the 3A library to DDR where the ISP
   will read them from. The ISP works on a grid that can be larger than
   that of the 3a library. If that is the case, we padd the difference
   with zeroes. */
static void store_dis_coefficients(
	const struct sh_css_binary *binary,
	hrt_vaddress ddr_addr_hor,
	hrt_vaddress ddr_addr_ver)
{
	unsigned int hor_num_isp,
		     ver_num_isp,
		     hor_num_3a,
		     ver_num_3a,
		     hor_padding,
		     ver_padding,
		     i;
	const short *hor_ptr_3a = dis_hor_coef_tbl,
		*ver_ptr_3a = dis_ver_coef_tbl;
	hrt_vaddress hor_ptr_isp = ddr_addr_hor,
		ver_ptr_isp = ddr_addr_ver;


	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "store_dis_coefficients() enter:\n");

	assert(binary != NULL);
	if (binary == NULL)
		return;
	assert(ddr_addr_hor != mmgr_NULL);
	assert(ddr_addr_ver != mmgr_NULL);

	hor_num_isp = binary->dis_hor_coef_num_isp;
	ver_num_isp = binary->dis_ver_coef_num_isp;
	hor_num_3a  = binary->dis_hor_coef_num_3a;
	ver_num_3a  = binary->dis_ver_coef_num_3a;
	hor_padding = hor_num_isp - hor_num_3a;
	ver_padding = ver_num_isp - ver_num_3a;

	for (i = 0; i < SH_CSS_DIS_NUM_COEF_TYPES; i++) {
		if (dis_hor_coef_tbl != NULL) {
			mmgr_store(hor_ptr_isp,
				hor_ptr_3a, hor_num_3a * sizeof(*hor_ptr_3a));
			hor_ptr_3a  += hor_num_3a;
		} else {
			mmgr_clear(hor_ptr_isp,
				hor_num_3a * sizeof(*hor_ptr_3a));
		}
		hor_ptr_isp += hor_num_3a * sizeof(short);
		mmgr_clear(hor_ptr_isp, hor_padding * sizeof(short));
		hor_ptr_isp += hor_padding * sizeof(short);
	}
	for (i = 0; i < SH_CSS_DIS_VER_NUM_COEF_TYPES(binary); i++) {
		if (dis_ver_coef_tbl != NULL) {
			mmgr_store(ver_ptr_isp,
				ver_ptr_3a, ver_num_3a * sizeof(*ver_ptr_3a));
			ver_ptr_3a  += ver_num_3a;
		} else {
			mmgr_clear(ver_ptr_isp,
				ver_num_3a * sizeof(*ver_ptr_3a));
		}
		ver_ptr_isp += ver_num_3a * sizeof(short);
		mmgr_clear(ver_ptr_isp, ver_padding * sizeof(short));
		ver_ptr_isp += ver_padding * sizeof(short);
	}

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "store_dis_coefficients() leave:\n");
}

void sh_css_update_isp_params_to_ddr(
	hrt_vaddress ddr_ptr)
{
	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_update_isp_params_to_ddr() enter:\n");

#if SH_CSS_PREVENT_UNINIT_READS
	{
		/* ispparm struct is read with DMA which reads
		 * multiples of the DDR word with (32 bytes):
		 * So we pad with zeroes to prevent warnings in csim.
		 */
		unsigned int aligned_width, padding_bytes;
		hrt_vaddress pad_ptr;

		aligned_width = CEIL_MUL(
				  sizeof(struct sh_css_isp_params),
				  HIVE_ISP_DDR_WORD_BYTES);
		padding_bytes = aligned_width -
				sizeof(struct sh_css_isp_params);
		pad_ptr = ddr_ptr +
				sizeof(struct sh_css_isp_params);
		mmgr_clear(pad_ptr, padding_bytes);
	}
#endif
	mmgr_store(ddr_ptr,
	     &isp_parameters,
	     sizeof(struct sh_css_isp_params));

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_update_isp_params_to_ddr() leave:\n");
}

static void sh_css_dequeue_param_buffers(void)
{
	hrt_vaddress cpy;

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_dequeue_param_buffers() enter\n");

	/* clean-up old copy */
	while (sp2host_dequeue_buffer(0, 0,
				sh_css_param_buffer_queue,
				&cpy)) {
		/*
		 * Tell the SP which queues are not full,
		 * by sending the software event.
		 */
		sh_css_sp_snd_event(SP_SW_EVENT_ID_2,
				0,
				sh_css_param_buffer_queue,
				0);

		sh_css_dtrace(SH_DBG_TRACE_PRIVATE,
			"sh_css_dequeue_param_buffers: "
			"dequeued param set %x from %d\n",
			cpy, 0);
		sh_css_dtrace(SH_DBG_TRACE_PRIVATE,
				"sh_css_dequeue_param_buffers: "
				"release ref on param set %x\n",
				cpy);
		free_sh_css_ddr_address_map(cpy);
	}

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_dequeue_param_buffers() leave\n");
}
/**
 * Function is called from:
 * - s3a when changes to 3a parameters have been applied
 * - after the pipes are created
 * - as a last step in the commit function
 */

void sh_css_update_isp_params(void)
{
	sh_css_dtrace(SH_DBG_TRACE, "sh_css_update_isp_params() enter: void\n");

	sh_css_param_update_isp_params(true);

	sh_css_dtrace(SH_DBG_TRACE, "sh_css_update_isp_params() leave: return_void\n");
}
void

sh_css_param_update_isp_params(bool commit)
{
	enum sh_css_err err = sh_css_success;
	hrt_vaddress cpy;
	unsigned i, num_pipes;

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_param_update_isp_params() enter:\n");

	if (s3a_config && s3a_config_changed)
		sh_css_process_3a();
	if (wb_config && wb_config_changed)
		sh_css_process_wb();
	if (cc_config && cc_config_changed)
		sh_css_process_cc();
	if (tnr_config && tnr_config_changed)
		sh_css_process_tnr();
	if (ob_config && ob_config_changed)
		sh_css_process_ob();
	if (dp_config && dp_config_changed)
		sh_css_process_dp();
	if (nr_config && ee_config && (nr_config_changed || ee_config_changed))
		sh_css_process_nr_ee();
	if (de_config && de_config_changed)
		sh_css_process_de();
	if (gc_config && gc_config_changed)
		sh_css_process_gc();
	if (anr_config && anr_config_changed)
		sh_css_process_anr();
	if (ce_config && ce_config_changed)
		sh_css_process_ce();
	if (ecd_config && ecd_config_changed)
		sh_css_process_ecd();
	if (ynr_config && ynr_config_changed)
		sh_css_process_ynr();
	if (fc_config && fc_config_changed)
		sh_css_process_fc();
	if (cnr_config && cnr_config_changed)
		sh_css_process_cnr();
	if (macc_config && macc_config_changed)
		sh_css_process_macc();
	if (ctc_config && ctc_config_changed)
		sh_css_process_ctc();
	if (xnr_config && xnr_config_changed)
		sh_css_process_xnr();
	if (aa_config && aa_config_changed)
		sh_css_process_aa();
	if (yuv2rgb_cc_config && yuv2rgb_cc_config_changed)
		sh_css_process_yuv2rgb_cc();
	if (rgb2yuv_cc_config && rgb2yuv_cc_config_changed)
		sh_css_process_rgb2yuv_cc();

	/* now make the map available to the sp */
	if (!commit) {
	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_param_update_isp_params() leave:\n");
		return;
	}
	/* enqueue a copies of the mem_map to
	   the designated pipelines */
	sh_css_pipeline_stream_get_num_pipelines(&num_pipes);
	for (i = 0; i < num_pipes; i++) {
		struct sh_css_ddr_address_map *cur_map;
		struct sh_css_ddr_address_map_size *cur_map_size;
		struct sh_css_ddr_address_map tmp_map;
		struct sh_css_pipeline *pipeline;
		struct sh_css_pipeline_stage *stage;
		unsigned int thread_id;

		sh_css_pipeline_stream_get_pipeline(i, &pipeline);
		sh_css_query_sp_thread_id(pipeline->pipe_id,
					  &thread_id);

		cur_map = &pipe_ddr_ptrs[pipeline->pipe_id];
		cur_map_size = &pipe_ddr_ptrs_size[pipeline->pipe_id];

		/* TODO: Normally, zoom and motion parameters shouldn't
		 * be part of "isp_params" as it is resolution/pipe dependant
		 * Therefore, move the zoom config elsewhere (e.g. shading
		 * table can be taken as an example! @GC
		 * */
		if (isp_params_changed || zoom_config_changed ||
				motion_config_changed) {
			/* we have to do this per pipeline because */
			/* the processing is a.o. resolution dependent */
			sh_css_process_zoom_and_motion(pipeline->pipe_id,
							pipeline->stages);
		}
		/* update the other buffers to the pipe specific copies */
		for (stage = pipeline->stages; stage;
			stage = stage->next) {
			if (stage && stage->binary) {
				err =
				  sh_css_params_write_to_ddr_internal(
							stage->binary,
							cur_map,
							cur_map_size);
				if (err != sh_css_success)
					break;
			}
		}

		/* update isp_params to pipe specific copies */
		if (isp_params_changed) {
			reallocate_buffer(&cur_map->isp_param,
				  &cur_map_size->isp_param,
				  cur_map_size->isp_param,
				  true,
				  &err);
			sh_css_update_isp_params_to_ddr(cur_map->isp_param);
		}

		/* last make referenced copy */
		err = ref_sh_css_ddr_address_map(
					cur_map,
					&tmp_map);
		/* now write the copy to ddr */
		write_sh_css_address_map_to_ddr(&tmp_map, &cpy);

		/* [PITBULL] disable for now */
		/* pqiao: you can disable it forever */
		//sh_css_enable_sp_invalidate_tlb();
		/* enqueue the set to sp */
		if (err == sh_css_success) {
			bool rc;
			sh_css_dtrace(SH_DBG_TRACE,
				"sh_css_param_update_isp_params: "
				"queue param set %x to %d\n",
				cpy, thread_id);

			rc = host2sp_enqueue_buffer(thread_id, 0,
				sh_css_param_buffer_queue,
				cpy);
			if (!rc) {
				free_sh_css_ddr_address_map(cpy);
			}
			else {
#if 0
				uint32_t tmp[2];
				uint32_t sw_event;

				/* encode the thread ID and the queue ID into the event*/
				tmp[0] = thread_id;
				tmp[1] = sh_css_param_buffer_queue;
				encode_sw_event(tmp, 2, &sw_event);

				/* queue the software event (busy-waiting) */
				while (!host2sp_enqueue_sp_event(sw_event))
					hrt_sleep();
#else
				/*
				 * Tell the SP which queues are not empty,
				 * by sending the software event.
				 */
				sh_css_sp_snd_event(SP_SW_EVENT_ID_1,
						thread_id,
						sh_css_param_buffer_queue,
						0);
#endif

			}
		}
		/* clean-up old copy */
		sh_css_dequeue_param_buffers();
	} /* end for each 'active' pipeline */
	/* clear the changed flags after all params
	   for all pipelines have been updated */
	/* only clear the table flag here, other flag is cleared in _process_XXX() function */
	isp_params_changed = false;
	fpn_table_changed = false;

	sh_css_param_shading_table_changed_set(false);

	ctc_table_changed = false;
	xnr_table_changed = false;
	gamma_table_changed = false;
	macc_table_changed = false;
	dis_coef_table_changed = false;
	morph_table_changed = false;
	r_gamma_table_changed = false;
	g_gamma_table_changed = false;
	b_gamma_table_changed = false;
	dvs_6axis_config_changed = false;

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_param_update_isp_params() leave:\n");
}

static enum sh_css_err sh_css_params_write_to_ddr_internal(
	const struct sh_css_binary *binary,
	struct sh_css_ddr_address_map *ddr_map,
	struct sh_css_ddr_address_map_size *ddr_map_size)
{
	enum sh_css_err err;
	bool buff_realloced;

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_params_write_to_ddr_internal() enter:\n");

	assert(binary != NULL);
	if (binary == NULL)
		return sh_css_err_internal_error;
	assert(ddr_map != NULL);
	if (ddr_map == NULL)
		return sh_css_err_internal_error;
	assert(ddr_map_size != NULL);
	if (ddr_map_size == NULL)
		return sh_css_err_internal_error;


	if (binary->info->enable.fpnr) {
		buff_realloced = reallocate_buffer(&ddr_map->fpn_tbl,
			&ddr_map_size->fpn_tbl,
			(size_t)(FPNTBL_BYTES(binary)),
			fpn_table_changed,
			&err);
		if (err != sh_css_success)
			return err;
		if (fpn_table_changed || buff_realloced) {
			if (isp_parameters.fpn_enabled) {
				store_fpntbl(ddr_map->fpn_tbl);
			}
#if SH_CSS_PREVENT_UNINIT_READS
			else {
				hrt_vaddress ptr =
					(hrt_vaddress)ddr_map->fpn_tbl;
				/* prevent warnings when reading fpn table
				 * in csim.*/
				/* Actual values are not used when fpn is
				 * disabled. */
				/* MW: fpn_tbl_size*sizeof(whatever)? */
				mmgr_clear(ptr, ddr_map_size->fpn_tbl);
			}
#endif
		}
	}
	if (binary->info->enable.sc) {
		bool sc_table_changed = sh_css_param_shading_table_changed_get();
		buff_realloced = reallocate_buffer(&ddr_map->sc_tbl,
			&ddr_map_size->sc_tbl,
			(size_t)(SCTBL_BYTES(binary)),
			sc_table_changed,
			&err);
		if (err != sh_css_success)
			return err;
		if (sc_table_changed || buff_realloced) {
			isp_params_changed =
				sh_css_param_shading_table_store(
					ddr_map->sc_tbl,
				sensor_binning,
				raw_binning,
				binary);
			isp_parameters.sc_gain_shift =
				sh_css_param_shading_table_fraction_bits_get();
			isp_params_changed = true;
		}
	}

	if (ctc_table && ctc_table_changed) {
		reallocate_buffer(&ddr_map->ctc_tbl,
				  &ddr_map_size->ctc_tbl,
				  ddr_map_size->ctc_tbl,
				  true,
				  &err);
		if (err != sh_css_success)
			return err;
		mmgr_store(ddr_map->ctc_tbl,
				     ctc_table->data,
				     sizeof(ctc_table->data));
	}
	if (gamma_table && gamma_table_changed) {
		reallocate_buffer(&ddr_map->gamma_tbl,
				  &ddr_map_size->gamma_tbl,
				  ddr_map_size->gamma_tbl,
				  true,
				  &err);
		if (err != sh_css_success)
			return err;
		mmgr_store(ddr_map->gamma_tbl,
				     gamma_table->data,
				     sizeof(gamma_table->data));
	}
	if (xnr_table && xnr_table_changed) {
		reallocate_buffer(&ddr_map->xnr_tbl,
				  &ddr_map_size->xnr_tbl,
				  ddr_map_size->xnr_tbl,
				  true,
				  &err);
		if (err != sh_css_success)
			return err;
		mmgr_store(ddr_map->xnr_tbl,
				     xnr_table->data,
				     sizeof(xnr_table->data));
	}
	if (macc_table && macc_table_changed) {
		unsigned int i, j, idx;
		unsigned int idx_map[] = {
			0, 1, 3, 2, 6, 7, 5, 4, 12, 13, 15, 14, 10, 11, 9, 8};

		for (i = 0; i < SH_CSS_MACC_NUM_AXES; i++) {
			idx = 4*idx_map[i];
			j   = 4*i;

			converted_macc_table.data[idx] =
			    sDIGIT_FITTING(macc_table->data[j], 13,
			    SH_CSS_MACC_COEF_SHIFT-isp_parameters.exp);
			converted_macc_table.data[idx+1] =
			    sDIGIT_FITTING(macc_table->data[j+1], 13,
			    SH_CSS_MACC_COEF_SHIFT-isp_parameters.exp);
			converted_macc_table.data[idx+2] =
			    sDIGIT_FITTING(macc_table->data[j+2], 13,
			    SH_CSS_MACC_COEF_SHIFT-isp_parameters.exp);
			converted_macc_table.data[idx+3] =
			    sDIGIT_FITTING(macc_table->data[j+3], 13,
			    SH_CSS_MACC_COEF_SHIFT-isp_parameters.exp);
		}
		reallocate_buffer(&ddr_map->macc_tbl,
				  &ddr_map_size->macc_tbl,
				  ddr_map_size->macc_tbl,
				  true,
				  &err);
		if (err != sh_css_success)
			return err;
		mmgr_store(ddr_map->macc_tbl,
				     converted_macc_table.data,
				     sizeof(converted_macc_table.data));
	}
	if (binary->info->enable.dvs_6axis) {
		buff_realloced = reallocate_buffer(
				&ddr_map->dvs_6axis_params_y,
				&ddr_map_size->dvs_6axis_params_y,
				(size_t)((DVS_6AXIS_BYTES(binary) * 3) / 2), // times 1.5 because UV is packed into the Y plane
				dvs_6axis_config_changed,
				&err);
		if (err != sh_css_success)
			return err;
		if (dvs_6axis_config_changed || buff_realloced) {
			store_dvs_6axis_config(binary,
				ddr_map->dvs_6axis_params_y);
		}
	}

	if (binary->info->enable.dis) {
		buff_realloced = reallocate_buffer(&ddr_map->sdis_hor_coef,
				  &ddr_map_size->sdis_hor_coef,
				  (size_t)(SDIS_HOR_COEF_TBL_BYTES(binary)),
				  dis_coef_table_changed,
				  &err);
		if (err != sh_css_success)
			return err;
		buff_realloced |= reallocate_buffer(&ddr_map->sdis_ver_coef,
				  &ddr_map_size->sdis_ver_coef,
				  (size_t)(SDIS_VER_COEF_TBL_BYTES(binary)),
				  dis_coef_table_changed,
				  &err);
		if (err != sh_css_success)
			return err;
		if (dis_coef_table_changed || buff_realloced) {
			store_dis_coefficients(binary,
				ddr_map->sdis_hor_coef, ddr_map->sdis_ver_coef);
		}
	}

	if (binary->info->enable.ca_gdc) {
		unsigned int i;
		hrt_vaddress *virt_addr_tetra_x[
			SH_CSS_MORPH_TABLE_NUM_PLANES] = {
			&ddr_map->tetra_r_x,
			&ddr_map->tetra_gr_x,
			&ddr_map->tetra_gb_x,
			&ddr_map->tetra_b_x,
			&ddr_map->tetra_ratb_x,
			&ddr_map->tetra_batr_x
		};
		size_t *virt_size_tetra_x[
			SH_CSS_MORPH_TABLE_NUM_PLANES] = {
			&ddr_map_size->tetra_r_x,
			&ddr_map_size->tetra_gr_x,
			&ddr_map_size->tetra_gb_x,
			&ddr_map_size->tetra_b_x,
			&ddr_map_size->tetra_ratb_x,
			&ddr_map_size->tetra_batr_x
		};
		hrt_vaddress *virt_addr_tetra_y[
			SH_CSS_MORPH_TABLE_NUM_PLANES] = {
			&ddr_map->tetra_r_y,
			&ddr_map->tetra_gr_y,
			&ddr_map->tetra_gb_y,
			&ddr_map->tetra_b_y,
			&ddr_map->tetra_ratb_y,
			&ddr_map->tetra_batr_y
		};
		size_t *virt_size_tetra_y[
			SH_CSS_MORPH_TABLE_NUM_PLANES] = {
			&ddr_map_size->tetra_r_y,
			&ddr_map_size->tetra_gr_y,
			&ddr_map_size->tetra_gb_y,
			&ddr_map_size->tetra_b_y,
			&ddr_map_size->tetra_ratb_y,
			&ddr_map_size->tetra_batr_y
		};
		buff_realloced = false;
		for (i = 0; i < SH_CSS_MORPH_TABLE_NUM_PLANES; i++) {
			buff_realloced |=
					reallocate_buffer(virt_addr_tetra_x[i],
						virt_size_tetra_x[i],
						(size_t)
						  (MORPH_PLANE_BYTES(binary)),
						morph_table_changed,
						&err);
			if (err != sh_css_success)
				return err;
			buff_realloced |=
					reallocate_buffer(virt_addr_tetra_y[i],
						virt_size_tetra_y[i],
						(size_t)
						  (MORPH_PLANE_BYTES(binary)),
						morph_table_changed,
						&err);
			if (err != sh_css_success)
				return err;
		}
		if (morph_table_changed || buff_realloced) {
			const struct sh_css_morph_table *table = morph_table;
			struct sh_css_morph_table *default_table = NULL;
			struct sh_css_morph_table *modified_table = NULL;
			/* 
			 * @GC: We expect to receive a morph table with the
			 * size that the binary expects
			 */
			if (table != NULL) {
				assert(table->width == binary->morph_tbl_width &&
					table->height == binary->morph_tbl_height);
			} else {
				sh_css_params_default_morph_table(
						&default_table,
						binary);
				table = default_table;
			}
			sh_css_params_morph_table_shift_phase(table,
							binary,
							&modified_table);
			table = modified_table;

			for (i = 0; i < SH_CSS_MORPH_TABLE_NUM_PLANES; i++) {
				write_morph_plane(table->coordinates_x[i],
					table->width,
					table->height,
					*virt_addr_tetra_x[i],
					binary->morph_tbl_aligned_width);
				write_morph_plane(table->coordinates_y[i],
					table->width,
					table->height,
					*virt_addr_tetra_y[i],
					binary->morph_tbl_aligned_width);
			}
			if (default_table != NULL)
				sh_css_morph_table_free(default_table);
			if (modified_table != NULL)
				sh_css_morph_table_free(modified_table);
		}
	}
	if (r_gamma_table && r_gamma_table_changed) {
		reallocate_buffer(&ddr_map->r_gamma_tbl,
				  &ddr_map_size->r_gamma_tbl,
				  ddr_map_size->r_gamma_tbl,
				  true,
				  &err);
		if (err != sh_css_success)
			return err;
		mmgr_store(ddr_map->r_gamma_tbl,
				     r_gamma_table->data,
				     sizeof(r_gamma_table->data));
	}
	if (g_gamma_table && g_gamma_table_changed) {
		reallocate_buffer(&ddr_map->g_gamma_tbl,
				  &ddr_map_size->g_gamma_tbl,
				  ddr_map_size->g_gamma_tbl,
				  true,
				  &err);
		if (err != sh_css_success)
			return err;
		mmgr_store(ddr_map->g_gamma_tbl,
				     g_gamma_table->data,
				     sizeof(g_gamma_table->data));
	}
	if (b_gamma_table && b_gamma_table_changed) {
		reallocate_buffer(&ddr_map->b_gamma_tbl,
				  &ddr_map_size->b_gamma_tbl,
				  ddr_map_size->b_gamma_tbl,
				  true,
				  &err);
		if (err != sh_css_success)
			return err;
		mmgr_store(ddr_map->b_gamma_tbl,
				     b_gamma_table->data,
				     sizeof(b_gamma_table->data));
	}
	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_params_write_to_ddr_internal() leave:\n");

return sh_css_success;
}

/**
 * Currently this function is called from:
 *  - sh_css_commit_isp_config
 *    (loops through the stages in a pipe to reconfigure settings)
 */
enum sh_css_err sh_css_params_write_to_ddr(
	const struct sh_css_binary *binary)
{
	unsigned i;
	unsigned num_pipes;
	enum sh_css_err err = sh_css_success;
	struct sh_css_pipeline *pipeline;

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_params_write_to_ddr() enter:\n");

	assert(binary != NULL);
	if (binary == NULL)
		return sh_css_err_internal_error;

	sh_css_pipeline_stream_get_num_pipelines(&num_pipes);
	for (i = 0; i < num_pipes; i++) {
		sh_css_pipeline_stream_get_pipeline(i, &pipeline);
		err = sh_css_params_write_to_ddr_internal(
					binary,
					&pipe_ddr_ptrs[pipeline->pipe_id],
					&pipe_ddr_ptrs_size[pipeline->pipe_id]);
		if (err != sh_css_success)
			break;
	}

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_params_write_to_ddr() leave:\n");

return err;
}

void
sh_css_params_set_current_binary(const struct sh_css_binary *binary)
{
	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_params_set_current_binary() enter:\n");

	assert(binary != NULL);
	if (binary == NULL)
		return;

	if (binary->info->enable.s3a)
		current_3a_binary = binary;

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_params_set_current_binary() leave:\n");
return;
}

const struct sh_css_fpn_table *sh_css_get_fpn_table(void)
{
	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_get_fpn_table() enter & leave:\n");
	return &fpn_table;
}

const struct sh_css_isp_params *sh_css_get_isp_params(void)
{
	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_get_isp_params() enter & leave:\n");
	return &isp_parameters;
}

const struct sh_css_binary *sh_css_get_3a_binary(void)
{
	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_get_3a_binary() enter & leave:\n");
	return current_3a_binary;
}

void sh_css_get_isp_dis_coefficients(
	short *horizontal_coefficients,
	short *vertical_coefficients)
{
	unsigned int hor_num_isp, ver_num_isp, i;
	short *hor_ptr     = horizontal_coefficients,
		*ver_ptr     = vertical_coefficients;
	hrt_vaddress hor_ptr_isp;
	hrt_vaddress ver_ptr_isp;

	struct sh_css_pipeline *pipeline;
	unsigned num_pipe;

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_get_isp_dis_coefficients() enter\n");

	/* TODO: change implementation so it can handle
		 situation where there are more active
		 pipes */
	sh_css_pipeline_stream_get_num_pipelines(&num_pipe);
	sh_css_pipeline_stream_get_pipeline(0, &pipeline);

	hor_ptr_isp = pipe_ddr_ptrs[pipeline->pipe_id].sdis_hor_coef;
	ver_ptr_isp = pipe_ddr_ptrs[pipeline->pipe_id].sdis_ver_coef;

/* currently only one pipe supported, update interface if
   multiple are needed */
	assert(num_pipe == 1);

	assert(horizontal_coefficients != NULL);
	if (horizontal_coefficients == NULL)
		return;

	assert(vertical_coefficients != NULL);
	if (vertical_coefficients == NULL)
		return;

	if (current_3a_binary == NULL)
		return;

	hor_num_isp = current_3a_binary->dis_hor_coef_num_isp;
	ver_num_isp = current_3a_binary->dis_ver_coef_num_isp;

	for (i = 0; i < SH_CSS_DIS_NUM_COEF_TYPES; i++) {
		mmgr_load(hor_ptr_isp,
			hor_ptr, hor_num_isp * sizeof(short));
		hor_ptr_isp += hor_num_isp * sizeof(short);
		hor_ptr     += hor_num_isp;
	}
	for (i = 0; i < SH_CSS_DIS_VER_NUM_COEF_TYPES(current_3a_binary); i++) {
		mmgr_load(ver_ptr_isp,
			ver_ptr, ver_num_isp * sizeof(short));
		ver_ptr_isp += ver_num_isp * sizeof(short);
		ver_ptr     += ver_num_isp;
	}

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_get_isp_dis_coefficients() leave\n");
	return;
}

struct sh_css_shading_table *
sh_css_get_shading_table(void)
{
	struct sh_css_shading_table *shading_table;
	sh_css_dtrace(SH_DBG_TRACE_PRIVATE,
		"sh_css_get_shading_table() enter:\n");

	shading_table = sh_css_param_shading_table_get(sensor_binning, raw_binning);

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE,
		"sh_css_get_shading_table() leave: shading_table=%p\n",
		shading_table);

	return shading_table;
}

bool
sh_css_params_set_shading_table(
	const struct sh_css_shading_table *table)
{
	return sh_css_param_shading_table_set(table);
}

/* pqiao: this function seems to be not used anywhere,
	comment it out temporarily */
#if 0
void sh_css_get_isp_dis_projections(
	int *horizontal_projections,
	int *vertical_projections)
{
	unsigned int hor_num_isp, ver_num_isp, i;
	int *hor_ptr     = horizontal_projections,
	    *ver_ptr     = vertical_projections;
	hrt_vaddress hor_ptr_isp = dis_hor_projections[curr_valid_buffer],
		ver_ptr_isp = dis_ver_projections[curr_valid_buffer];

assert(horizontal_projections != NULL);
assert(vertical_projections != NULL);
	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_get_isp_dis_projections() enter\n");

	if (current_3a_binary == NULL)
		return;

	hor_num_isp = current_3a_binary->dis_hor_proj_num_isp;
	ver_num_isp = current_3a_binary->dis_ver_proj_num_isp;

	for (i = 0; i < SH_CSS_DIS_NUM_COEF_TYPES; i++) {
		mmgr_load(hor_ptr_isp,
			hor_ptr, hor_num_isp * sizeof(int));
		hor_ptr_isp += hor_num_isp * sizeof(int);
		hor_ptr     += hor_num_isp;

		mmgr_load(ver_ptr_isp,
			ver_ptr, ver_num_isp * sizeof(int));
		ver_ptr_isp += ver_num_isp * sizeof(int);
		ver_ptr     += ver_num_isp;
	}
	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_get_isp_dis_projections() leave\n");
return;
}
#endif

hrt_vaddress sh_css_store_sp_group_to_ddr(void)
{
	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_store_sp_group_to_ddr() enter & leave:\n");
	mmgr_store(xmem_sp_group_ptrs,
			     &sh_css_sp_group,
			     sizeof(struct sh_css_sp_group));
	return xmem_sp_group_ptrs;
}

hrt_vaddress sh_css_store_sp_stage_to_ddr(
	unsigned pipe,
	unsigned stage)
{
	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_store_sp_stage_to_ddr() enter & leave:\n");
	mmgr_store(xmem_sp_stage_ptrs[pipe][stage],
			     &sh_css_sp_stage,
			     sizeof(struct sh_css_sp_stage));
	return xmem_sp_stage_ptrs[pipe][stage];
}

hrt_vaddress sh_css_store_isp_stage_to_ddr(
	unsigned pipe,
	unsigned stage)
{
	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_store_isp_stage_to_ddr() enter & leave:\n");
	mmgr_store(xmem_isp_stage_ptrs[pipe][stage],
			     &sh_css_isp_stage,
			     sizeof(struct sh_css_isp_stage));
	return xmem_isp_stage_ptrs[pipe][stage];
}

static enum sh_css_err ref_sh_css_ddr_address_map(
	struct sh_css_ddr_address_map *map,
	struct sh_css_ddr_address_map *out)
{
	enum sh_css_err err = sh_css_success;
	unsigned int i;

	hrt_vaddress *in_addrs = (hrt_vaddress *)map;
	hrt_vaddress *to_addrs = (hrt_vaddress *)out;

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "ref_sh_css_ddr_address_map() enter:\n");

	if (map == NULL)
		return sh_css_err_internal_error;

	if (out == NULL)
		return sh_css_err_internal_error;

	/* copy map using size info */
	for (i = 0; i < (sizeof(struct sh_css_ddr_address_map_size)/
						sizeof(size_t)); i++) {
		to_addrs[i] = mmgr_NULL;
		if (in_addrs[i] == mmgr_NULL)
			continue;

		to_addrs[i] = sh_css_refcount_retain(PARAM_BUFFER, in_addrs[i]);
	}

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "ref_sh_css_ddr_address_map() leave:\n");

	return err;
}

static enum sh_css_err write_sh_css_address_map_to_ddr(
	struct sh_css_ddr_address_map *me,
	hrt_vaddress *out)
{
	enum sh_css_err err = sh_css_success;
	bool succ;

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "write_sh_css_address_map_to_ddr() enter:\n");

	assert(me != NULL);
	if (me == NULL)
		return sh_css_err_internal_error;

	assert(out != NULL);
	if (out == NULL)
		return sh_css_err_internal_error;

	*out = sh_css_refcount_alloc(PARAM_SET_POOL,
		sizeof(struct sh_css_ddr_address_map), MMGR_ATTRIBUTE_DEFAULT);
	succ = (*out != mmgr_NULL);
	if (succ)
		mmgr_store(*out,
			me, sizeof(struct sh_css_ddr_address_map));
	else
		err = sh_css_err_cannot_allocate_memory;

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "write_sh_css_address_map_to_ddr() leave:\n");

	return err;
}

static enum sh_css_err free_sh_css_ddr_address_map(
	hrt_vaddress ptr)
{
	enum sh_css_err err = sh_css_success;
	struct sh_css_ddr_address_map map;
	unsigned int i;
	hrt_vaddress *addrs = (hrt_vaddress *)&map;

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "free_sh_css_ddr_address_map() enter:\n");

	mmgr_load(ptr, &map, sizeof(struct sh_css_ddr_address_map));
	/* copy map using size info */
	for (i = 0; i < (sizeof(struct sh_css_ddr_address_map_size)/
						sizeof(size_t)); i++) {
		if (addrs[i] == mmgr_NULL)
			continue;
		sh_css_refcount_release(PARAM_BUFFER, addrs[i]);
	}
	sh_css_refcount_release(PARAM_SET_POOL, ptr);

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "free_sh_css_ddr_address_map() leave:\n");

	return err;
}

/* Mark all parameters as changed to force recomputing the derived ISP parameters */
void sh_css_invalidate_params(void)
{
	sh_css_dtrace(SH_DBG_TRACE_PRIVATE,
		"sh_css_invalidate_params() enter:\n");

	isp_params_changed = true;
	fpn_table_changed = true;
	dis_coef_table_changed = true;
	morph_table_changed = true;

	sh_css_param_shading_table_changed_set(true);

	macc_table_changed = true;
	gamma_table_changed = true;
	ctc_table_changed = true;
	xnr_table_changed = true;
	s3a_config_changed = true;
	wb_config_changed = true;
	cc_config_changed = true;
	tnr_config_changed = true;
	ob_config_changed = true;
	dp_config_changed = true;
	nr_config_changed = true;
	ee_config_changed = true;
	de_config_changed = true;
	gc_config_changed = true;
	anr_config_changed = true;
	ce_config_changed = true;
	zoom_config_changed = true;
	motion_config_changed = true;
	dvs_6axis_config_changed = true;
	fpn_table_changed = true;
	dis_coef_table_changed = true;
	morph_table_changed = true;
	ecd_config_changed = true;
	ynr_config_changed = true;
	fc_config_changed = true;
	cnr_config_changed = true;
	macc_config_changed = true;
	ctc_config_changed = true;
	xnr_config_changed = true;
	aa_config_changed = true;
	r_gamma_table_changed = true;
	g_gamma_table_changed = true;
	b_gamma_table_changed = true;
	yuv2rgb_cc_config_changed = true;
	rgb2yuv_cc_config_changed = true;

	sh_css_dtrace(SH_DBG_TRACE_PRIVATE,
		"sh_css_invalidate_params() leave:\n");
}

void sh_css_update_uds_and_crop_info(
	const struct sh_css_binary_info *info,
	const struct sh_css_frame_info *in_frame_info,
	const struct sh_css_frame_info *out_frame_info,
	const struct sh_css_dvs_envelope *dvs_env,
	bool preview_mode,
	const struct sh_css_zoom *zoom,
	const struct sh_css_vector *motion_vector,
	struct sh_css_uds_info *uds,		/* out */
	struct sh_css_crop_pos *sp_out_crop_pos)/* out */
{
	sh_css_dtrace(SH_DBG_TRACE_PRIVATE,
		"sh_css_update_uds_and_crop_info() enter:\n");

	assert(info != NULL);
	if (info == NULL)
		return;

	assert(in_frame_info != NULL);
	if (in_frame_info == NULL)
		return;

	assert(out_frame_info != NULL);
	if (out_frame_info == NULL)
		return;

	assert(dvs_env != NULL);
	if (dvs_env == NULL)
		return;

	assert(zoom != NULL);
	if (zoom == NULL)
		return;

	assert(motion_vector != NULL);
	if (motion_vector == NULL)
		return;

	assert(uds != NULL);
	if (uds == NULL)
		return;

	assert(sp_out_crop_pos != NULL);
	if (sp_out_crop_pos == NULL)
		return;

	if (info->mode == SH_CSS_BINARY_MODE_VF_PP && !preview_mode) {
		/* in non-preview modes, VF_PP does not do
		   the zooming, capture_pp or video do. */
		uds->curr_dx = HRT_GDC_N;
		uds->curr_dy = HRT_GDC_N;
	} else {
		uds->curr_dx   = zoom->dx;
		uds->curr_dy   = zoom->dy;
	}

	if (info->enable.dvs_envelope) {
		unsigned int crop_x = 0,
			     crop_y = 0,
			     uds_xc = 0,
			     uds_yc = 0,
			     env_width, env_height;
		int half_env_x, half_env_y;
		int motion_x = motion_vector->x;
		int motion_y = motion_vector->y;
		bool upscale_x = in_frame_info->width < out_frame_info->width;
		bool upscale_y = in_frame_info->height < out_frame_info->height;

		if (info->enable.uds && !info->enable.ds) {
			/**
			 * we calculate with the envelope that we can actually
			 * use, the min dvs envelope is for the filter
			 * initialization.
			 */
			env_width  = dvs_env->width -
					SH_CSS_MIN_DVS_ENVELOPE;
			env_height = dvs_env->height -
					SH_CSS_MIN_DVS_ENVELOPE;
			half_env_x = env_width / 2;
			half_env_y = env_height / 2;
			/**
			 * for digital zoom, we use the dvs envelope and make
			 * sure that we don't include the 8 leftmost pixels or
			 * 8 topmost rows.
			 */
			if (upscale_x) {
				uds_xc = (in_frame_info->width
					+ env_width
					+ SH_CSS_MIN_DVS_ENVELOPE) / 2;
			} else {
				uds_xc = (out_frame_info->width
							+ env_width) / 2
					+ SH_CSS_MIN_DVS_ENVELOPE;
			}
			if (upscale_y) {
				uds_yc = (in_frame_info->height
					+ env_height
					+ SH_CSS_MIN_DVS_ENVELOPE) / 2;
			} else {
				uds_yc = (out_frame_info->height
							+ env_height) / 2
					+ SH_CSS_MIN_DVS_ENVELOPE;
			}
			/* clip the motion vector to +/- half the envelope */
			motion_x = clamp(motion_x, -half_env_x, half_env_x);
			motion_y = clamp(motion_y, -half_env_y, half_env_y);
			uds_xc += motion_x;
			uds_yc += motion_y;
			/* uds can be pipelined, remove top lines */
			crop_y = 2;
		} else if (info->enable.ds) {
			env_width  = dvs_env->width;
			env_height = dvs_env->height;
			half_env_x = env_width / 2;
			half_env_y = env_height / 2;
			/* clip the motion vector to +/- half the envelope */
			motion_x = clamp(motion_x, -half_env_x, half_env_x);
			motion_y = clamp(motion_y, -half_env_y, half_env_y);
			/* for video with downscaling, the envelope is included
			    in the input resolution. */
			uds_xc = in_frame_info->width/2 + motion_x;
			uds_yc = in_frame_info->height/2 + motion_y;
			crop_x = info->left_cropping;
			/* ds == 2 (yuv_ds) can be pipelined, remove top
			   lines */
			if (info->enable.ds & 1)
				crop_y = info->top_cropping;
			else
				crop_y = 2;
		} else {
			/* video nodz: here we can only crop. We make sure we
			   crop at least the first 8x8 pixels away. */
			env_width  = dvs_env->width -
					SH_CSS_MIN_DVS_ENVELOPE;
			env_height = dvs_env->height -
					SH_CSS_MIN_DVS_ENVELOPE;
			half_env_x = env_width / 2;
			half_env_y = env_height / 2;
			motion_x = clamp(motion_x, -half_env_x, half_env_x);
			motion_y = clamp(motion_y, -half_env_y, half_env_y);
			crop_x = SH_CSS_MIN_DVS_ENVELOPE
						+ half_env_x + motion_x;
			crop_y = SH_CSS_MIN_DVS_ENVELOPE
						+ half_env_y + motion_y;
		}

		/* Must enforce that the crop position is even */
		crop_x = EVEN_FLOOR(crop_x);
		crop_y = EVEN_FLOOR(crop_y);
		uds_xc = EVEN_FLOOR(uds_xc);
		uds_yc = EVEN_FLOOR(uds_yc);

		uds->xc = uds_xc;
		uds->yc = uds_yc;
		sp_out_crop_pos->x = crop_x;
		sp_out_crop_pos->y = crop_y;
	}
	else {
		/* for down scaling, we always use the center of the image */
		uds->xc = in_frame_info->width / 2;
		uds->yc = in_frame_info->height / 2;
		sp_out_crop_pos->x = info->left_cropping;
		sp_out_crop_pos->y = info->top_cropping;
	}
	sh_css_dtrace(SH_DBG_TRACE_PRIVATE, "sh_css_update_uds_and_crop_info() leave:\n");
return;
}

